/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.util.XmlConversionHelper;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XLSHandler
extends DefaultHandler {
    private StringBuffer textBuffer;
    private Map<Integer, String> values;
    private Map<Integer, FieldMetaData> fields;
    private File file;
    private int nbCols;
    private boolean definition;
    private List<String> fielddescription = new ArrayList<String>();
    private int lines;
    private Integer fieldName;
    private boolean exportHeading;
    private Workbook workbook;
    private Sheet sheet;
    private XmlConversionHelper xmlConv = XmlConversionHelper.getXMLConverter();

    public XLSHandler(File file, boolean exportHeading) {
        this.file = file;
        this.exportHeading = exportHeading;
        this.definition = false;
        this.lines = 0;
    }

    @Override
    public void startDocument() throws SAXException {
        this.values = new HashMap<Integer, String>();
        this.fields = new HashMap<Integer, FieldMetaData>();
        this.workbook = this.file.getName().endsWith(".xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
        this.sheet = this.workbook.createSheet();
    }

    @Override
    public void endDocument() throws SAXException {
        this.values.clear();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.file);
            this.workbook.write((OutputStream)fos);
            this.workbook = null;
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.textBuffer = null;
        if (this.isElement(namespaceURI, sName, qName, "table")) {
            String tmp = this.getValue(attrs, namespaceURI, "nbcols");
            try {
                this.nbCols = Integer.parseInt(tmp);
            }
            catch (Exception e) {
                throw new SAXException("nbcols attribute missing");
            }
        }
        if (this.isElement(namespaceURI, sName, qName, "record")) {
            this.values.clear();
        } else if (this.isElement(namespaceURI, sName, qName, "definition")) {
            this.fields.clear();
            this.definition = true;
        } else if (this.isElement(namespaceURI, sName, qName, "fielddefinition")) {
            if (this.definition) {
                DataType dataType;
                String col = this.getValue(attrs, namespaceURI, "col");
                String name = this.getValue(attrs, namespaceURI, "name");
                String description = this.getValue(attrs, namespaceURI, "description");
                this.fielddescription.add(description);
                String tmp = this.getValue(attrs, namespaceURI, "datatype");
                try {
                    dataType = DataType.valueOf((int)Integer.parseInt(tmp));
                }
                catch (Exception e) {
                    throw new SAXException("datatype attribute missing");
                }
                if (DataType.isNumeric((DataType)dataType)) {
                    int fieldPrecision;
                    int fieldScale;
                    tmp = this.getValue(attrs, namespaceURI, "fieldscale");
                    try {
                        fieldScale = new Integer(tmp);
                    }
                    catch (Exception e) {
                        fieldScale = 10;
                    }
                    tmp = this.getValue(attrs, namespaceURI, "fieldprecision");
                    try {
                        fieldPrecision = new Integer(tmp);
                    }
                    catch (Exception e) {
                        fieldPrecision = 2;
                    }
                    this.fields.put(Integer.valueOf(col), new FieldMetaData(0, name, description, dataType, fieldPrecision, fieldScale));
                } else if (DataType.isChar((DataType)dataType)) {
                    int fieldSize;
                    tmp = this.getValue(attrs, namespaceURI, "fieldsize");
                    try {
                        fieldSize = new Integer(tmp);
                    }
                    catch (Exception e) {
                        throw new SAXException("fieldsize attribute missing");
                    }
                    this.fields.put(Integer.valueOf(col), new FieldMetaData(0, name, description, dataType, fieldSize));
                }
            }
        } else if (this.isElement(namespaceURI, sName, qName, "field")) {
            String col = this.getValue(attrs, namespaceURI, "col");
            this.fieldName = Integer.valueOf(col);
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        Cell cell;
        int i;
        Row row;
        if (this.isElement(namespaceURI, sName, qName, "definition")) {
            if (this.nbCols == 0) {
                throw new SAXException("No Column Found");
            }
            this.definition = false;
            if (this.exportHeading) {
                try {
                    row = this.sheet.createRow(0);
                    for (i = 0; i < this.nbCols; ++i) {
                        cell = row.createCell(i);
                        cell.setCellType(1);
                        cell.setCellValue(this.fielddescription.get(i));
                    }
                }
                catch (Exception e) {
                    throw new SAXException(e.getMessage());
                }
            }
        }
        if (!this.definition) {
            if (this.isElement(namespaceURI, sName, qName, "field")) {
                if (this.textBuffer != null) {
                    this.values.put(this.fieldName, this.textBuffer.toString());
                }
                this.fieldName = null;
            } else if (this.isElement(namespaceURI, sName, qName, "record")) {
                try {
                    row = this.sheet.createRow(this.lines);
                    for (i = 0; i < this.nbCols; ++i) {
                        cell = row.createCell(i);
                        Integer col = i + 1;
                        FieldMetaData fmd = this.fields.get(col);
                        Object value = this.xmlConv.parse(fmd.getDataType(), this.values.get(col));
                        if (DataType.isNumeric((DataType)fmd.getDataType())) {
                            if (!(value instanceof Number)) continue;
                            cell.setCellType(0);
                            cell.setCellValue(((Number)value).doubleValue());
                            continue;
                        }
                        if (DataType.isDate((DataType)fmd.getDataType())) {
                            if (!(value instanceof Date)) continue;
                            cell.setCellType(0);
                            cell.setCellValue((Date)value);
                            continue;
                        }
                        if (!DataType.isChar((DataType)fmd.getDataType()) || !(value instanceof String)) continue;
                        cell.setCellType(1);
                        cell.setCellValue((String)value);
                    }
                    ++this.lines;
                }
                catch (Exception e) {
                    throw new SAXException(e.getMessage());
                }
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuffer(s);
        } else {
            this.textBuffer.append(s);
        }
    }

    public int getLines() {
        return this.lines;
    }

    private String getValue(Attributes attrs, String uri, String name) {
        String value = attrs.getValue(name);
        if (value != null) {
            return value;
        }
        return attrs.getValue(uri, name);
    }

    private boolean isElement(String namespaceURI, String sName, String qName, String elt) {
        return sName.equals(elt) || qName.equals(elt);
    }
}

