/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task;

import com.prelytis.dashboard.util.XmlConversionHelper;
import com.prelytis.jdbc.msexcel.ExcelSheet;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class XLSReader
implements XMLReader {
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private static final char[] carriageReturn = "\n".toCharArray();
    private String nameSpaceURI = "";
    private String prefix = "";
    private boolean fNamespaces = false;
    private boolean fNamespacePrefixes = false;

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        int firstRow;
        AttributesImpl attributes = new AttributesImpl();
        ContentHandler contentHandler = this.contentHandler;
        String prefix = this.prefix;
        String nameSpaceURI = this.nameSpaceURI;
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)input.getByteStream());
        }
        catch (InvalidFormatException ife) {
            throw new SAXException((Exception)((Object)ife));
        }
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        Sheet s = workbook.getSheetAt(0);
        ExcelSheet sheet = new ExcelSheet.Builder(evaluator, s, -1).build();
        attributes.clear();
        contentHandler.startDocument();
        contentHandler.startPrefixMapping(prefix, "http://www.prelytis.com/schemas/livedasboard/4.6/datamart.xsd");
        attributes.addAttribute(nameSpaceURI, "nbcols", "nbcols", "CDATA", Integer.valueOf(sheet.getNbCols()).toString());
        contentHandler.startElement(nameSpaceURI, "table", prefix + "table", attributes);
        attributes.clear();
        contentHandler.startElement(nameSpaceURI, "definition", prefix + "definition", attributes);
        String[] cols = sheet.getCols();
        for (int i = 0; i < sheet.getNbCols(); ++i) {
            String eltName = "fielddefinition";
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "col", "col", "CDATA", String.valueOf(i + 1));
            attributes.addAttribute(nameSpaceURI, "name", "name", "CDATA", cols[i]);
            attributes.addAttribute(nameSpaceURI, "description", "description", "CDATA", cols[i]);
            int datatype = sheet.getDataType(i);
            attributes.addAttribute(nameSpaceURI, "datatype", "datatype", "CDATA", String.valueOf(datatype));
            switch (datatype) {
                case 12: {
                    attributes.addAttribute(nameSpaceURI, "fieldsize", "fieldsize", "CDATA", String.valueOf(sheet.getSize(i)));
                    break;
                }
                case 2: {
                    attributes.addAttribute(nameSpaceURI, "fieldprecision", "fieldprecision", "CDATA", String.valueOf(sheet.getPrecision(i)));
                    attributes.addAttribute(nameSpaceURI, "fieldscale", "fieldscale", "CDATA", String.valueOf(sheet.getScale(i)));
                }
            }
            contentHandler.startElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition", attributes);
            contentHandler.endElement(nameSpaceURI, "fielddefinition", prefix + "fielddefinition");
        }
        contentHandler.endElement(nameSpaceURI, "definition", prefix + "definition");
        XmlConversionHelper helper = XmlConversionHelper.getXMLConverter();
        ArrayList<CellRangeAddress> ranges = new ArrayList<CellRangeAddress>();
        for (int i = 0; i < s.getNumMergedRegions(); ++i) {
            ranges.add(s.getMergedRegion(i));
        }
        int numRow = 0;
        for (int r = firstRow = sheet.isFirstRowTitle() ? sheet.getFirstRow() + 1 : sheet.getFirstRow(); r <= sheet.getLastRow(); ++r) {
            Row row = s.getRow(r);
            if (row == null) continue;
            contentHandler.ignorableWhitespace(carriageReturn, 0, carriageReturn.length);
            attributes.clear();
            attributes.addAttribute(nameSpaceURI, "row", "row", "CDATA", String.valueOf(++numRow));
            contentHandler.startElement(nameSpaceURI, "record", prefix + "record", attributes);
            for (int col = sheet.getFirstCol(); col <= sheet.getLastCol(); ++col) {
                Cell cell = row.getCell(col);
                for (CellRangeAddress range : ranges) {
                    Row rr;
                    if (col < range.getFirstColumn() || col > range.getLastColumn() || r < range.getFirstRow() || r > range.getLastRow() || (rr = r == range.getFirstRow() ? row : s.getRow(range.getFirstRow())) == null) continue;
                    cell = rr.getCell(range.getFirstColumn());
                    break;
                }
                if (cell == null) {
                    cell = row.getCell(col);
                }
                if (cell != null) {
                    try {
                        evaluator.evaluateInCell(cell);
                    }
                    catch (Exception e) {
                        cell = null;
                    }
                }
                attributes.clear();
                attributes.addAttribute(nameSpaceURI, "col", "col", "CDATA", String.valueOf(col - sheet.getFirstCol() + 1));
                String value = null;
                if (cell != null) {
                    switch (cell.getCellType()) {
                        case 3: {
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 4: {
                            value = Boolean.toString(cell.getBooleanCellValue());
                            break;
                        }
                        case 0: {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                value = helper.format((Object)new Date(cell.getDateCellValue().getTime()));
                                break;
                            }
                            value = BigDecimal.valueOf(cell.getNumericCellValue()).toString();
                            break;
                        }
                        case 1: {
                            value = cell.getRichStringCellValue().getString();
                        }
                    }
                }
                if (value != null) {
                    char[] data = value.toCharArray();
                    contentHandler.startElement(nameSpaceURI, "field", prefix + "field", attributes);
                    contentHandler.characters(data, 0, data.length);
                    contentHandler.endElement(nameSpaceURI, "field", prefix + "field");
                    continue;
                }
                attributes.addAttribute(nameSpaceURI, "isnull", "isnull", "CDATA", Boolean.toString(true));
                contentHandler.startElement(nameSpaceURI, "field", prefix + "field", attributes);
                contentHandler.endElement(nameSpaceURI, "field", prefix + "field");
            }
            contentHandler.endElement(nameSpaceURI, "record", prefix + "record");
        }
        contentHandler.endElement(nameSpaceURI, "table", prefix + "table");
        contentHandler.endPrefixMapping(prefix);
        contentHandler.endDocument();
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public void setFeature(String name, boolean value) {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            this.fNamespaces = value;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this.fNamespacePrefixes = value;
        }
        if (this.fNamespacePrefixes && this.fNamespaces) {
            this.nameSpaceURI = "http://www.prelytis.com/schemas/livedasboard/4.6/datamart.xsd";
            this.prefix = "dm:";
        } else {
            this.nameSpaceURI = "";
            this.prefix = "";
        }
    }

    @Override
    public boolean getFeature(String name) {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return this.fNamespaces;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.fNamespacePrefixes;
        }
        return false;
    }
}

