/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.FolderDao;
import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.persistence.Configuration;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.datamart.TaskDataMartElement;
import com.prelytis.dashboard.task.datamart.TaskDataMartResultBuffer;
import com.prelytis.dashboard.task.datamart.TaskDataMartResultBufferJPEGProcessor;
import com.prelytis.dashboard.task.datamart.TaskDataMartResultBufferPNGProcessor;
import com.prelytis.dashboard.task.datamart.TaskDataMartResultCSVFile;
import com.prelytis.dashboard.task.datamart.TaskDataMartResultPDFFile;
import com.prelytis.dashboard.task.datamart.TaskDataMartResultParam;
import com.prelytis.dashboard.task.datamart.TaskDataMartResultSVGFile;
import com.prelytis.dashboard.task.datamart.TaskDataMartResultTable;
import com.prelytis.dashboard.task.datamart.TaskDataMartResultXLSFile;
import com.prelytis.dashboard.task.datamart.TaskDataMartResultXMLFile;
import com.prelytis.dashboard.value.data.BeanFile;
import com.prelytis.dashboard.value.data.BeanTaskDataMart;
import com.prelytis.dashboard.value.util.ExecutionMessage;
import com.prelytis.dashboard.value.util.ExecutionMessageI18n;
import com.prelytis.dashboard.value.util.ExecutionMessageStd;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

abstract class AbstractTaskDataMartResult
implements TaskDataMartElement {
    protected MessageListener messageListener;
    protected static final Logger log = LogManager.getLogger(AbstractTaskDataMartResult.class);

    public AbstractTaskDataMartResult(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    @Override
    public void postProcess(ExpressionEvaluationData data) throws TaskExecutionException {
    }

    protected void addMessage(int severity, String msgKey, String param) {
        this.messageListener.log((ExecutionMessage)new ExecutionMessageI18n(severity, msgKey, param));
    }

    protected void addMessage(int severity, String message) {
        this.messageListener.log((ExecutionMessage)new ExecutionMessageStd(severity, message));
    }

    public static final AbstractTaskDataMartResult getInstance(DaoFactory daoFactory, MessageListener messageListener, BeanTaskDataMart task) throws TaskExecutionException {
        AbstractTaskDataMartResult result;
        switch (task.getDestinationType()) {
            case TABLE: {
                result = new TaskDataMartResultTable(daoFactory, messageListener, task.getDestinationWorldOid(), task.getDestinationTable(), task.getDestinationClearFirst(), task.getDestinationCreateTable(), task.getInsertType(), task.getDeleteType(), task.getDestinationCatalog(), task.getDestinationSchema(), task.isDestinationCreatePrimaryKey(), task.getBatchExecution(), task.getBatchNbLine(), task.getCommitType(), task.getCommitNbLine());
                break;
            }
            case XML_FILE: {
                result = new TaskDataMartResultXMLFile(messageListener, AbstractTaskDataMartResult.getFileHelper(daoFactory, task.getDestinationFolderOid(), task.getDestinationFile()));
                break;
            }
            case CSV_FILE: {
                result = new TaskDataMartResultCSVFile(messageListener, AbstractTaskDataMartResult.getFileHelper(daoFactory, task.getDestinationFolderOid(), task.getDestinationFile()), task.getDestinationEncoding(), task.getDestinationSeparatedBy().getSeparator(), task.getDestinationTextDelimiter(), task.isExportHeading());
                break;
            }
            case XLS_FILE: {
                result = new TaskDataMartResultXLSFile(messageListener, AbstractTaskDataMartResult.getFileHelper(daoFactory, task.getDestinationFolderOid(), task.getDestinationFile()), task.isExportHeading());
                break;
            }
            case PDF_FILE: {
                result = new TaskDataMartResultPDFFile(messageListener, AbstractTaskDataMartResult.getFileHelper(daoFactory, task.getDestinationFolderOid(), task.getDestinationFile()));
                break;
            }
            case PNG_FILE: {
                TaskDataMartResultBufferPNGProcessor processor = new TaskDataMartResultBufferPNGProcessor(messageListener, AbstractTaskDataMartResult.getFileHelper(daoFactory, task.getDestinationFolderOid(), task.getDestinationFile()));
                result = new TaskDataMartResultBuffer(messageListener, processor);
                break;
            }
            case JPG_FILE: {
                TaskDataMartResultBufferJPEGProcessor processor = new TaskDataMartResultBufferJPEGProcessor(messageListener, AbstractTaskDataMartResult.getFileHelper(daoFactory, task.getDestinationFolderOid(), task.getDestinationFile()));
                result = new TaskDataMartResultBuffer(messageListener, processor);
                break;
            }
            case SVG_FILE: {
                result = new TaskDataMartResultSVGFile(messageListener, AbstractTaskDataMartResult.getFileHelper(daoFactory, task.getDestinationFolderOid(), task.getDestinationFile()));
                break;
            }
            case PARAM: {
                Configuration configuration = Configuration.getInstance();
                result = new TaskDataMartResultParam(daoFactory, configuration.getDefaultLocale(), messageListener);
                break;
            }
            default: {
                messageListener.log((ExecutionMessage)new ExecutionMessageI18n(3, "taskMsg.destNoSupported"));
                throw new TaskExecutionException("Destination not supported", 2, true);
            }
        }
        return result;
    }

    private static FileHelper getFileHelper(DaoFactory daoFactory, int fileOID, String fileName) throws TaskExecutionException {
        BeanFile folder = null;
        try {
            FolderDao folderDao = daoFactory.getFolderDao();
            folder = (BeanFile)folderDao.getDefinition(fileOID);
            return FileHelper.getInstance(folder, fileName);
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, true);
        }
    }
}

