/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.model.helper.ParameterHelper;
import com.prelytis.dashboard.value.data.Bean;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.xml.stax.XMLEventCache;
import com.prelytis.dashboard.xml.stax.XmlHelper;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventConsumer;

class ParamEventWriter
implements XMLEventConsumer {
    private final XmlHelper xmlHelper = XmlHelper.getInstance();
    private final DaoFactory daoFactory;
    private final ExpressionEvaluationData data;
    private XMLEventCache cache = new XMLEventCache();

    ParamEventWriter(DaoFactory daoFactory, ExpressionEvaluationData data) {
        this.daoFactory = daoFactory;
        this.data = data;
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        if (event instanceof Characters && event.asCharacters() != null) {
            this.cache.add(event);
        }
        if (event.isStartElement()) {
            String startTagName = event.asStartElement().getName().getLocalPart();
            if ("prelytis".equals(startTagName)) {
                return;
            }
            this.cache.add(event);
        } else if (event.isEndElement()) {
            String endTagName = event.asEndElement().getName().getLocalPart();
            if (!"prelytis".equals(endTagName)) {
                this.cache.add(event);
            }
            if (endTagName.equals(this.cache.peek().asStartElement().getName().getLocalPart())) {
                Bean bean = this.xmlHelper.read((XMLEventReader)this.cache);
                try {
                    ParameterHelper.save(this.daoFactory, bean, this.data, true);
                }
                catch (DashboardException e) {
                    throw new XMLStreamException(e);
                }
                this.cache.clearCache();
            }
        }
    }
}

