/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.task.CSVHandler;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.datamart.AbstractTaskDataMartResult;
import com.prelytis.dashboard.task.datamart.TaskDataMartContainer;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.transform.sax.SAXResult;

class TaskDataMartResultCSVFile
extends AbstractTaskDataMartResult {
    private final FileHelper fileHelper;
    private final String encoding;
    private final String separator;
    private final String textDelimiter;
    private final boolean exportHeading;

    TaskDataMartResultCSVFile(MessageListener messageListener, FileHelper fileHelper, String encoding, String separator, String textdelimiter, boolean exportHeading) throws TaskExecutionException {
        super(messageListener);
        this.fileHelper = fileHelper;
        this.encoding = encoding;
        this.separator = separator;
        this.textDelimiter = textdelimiter;
        this.exportHeading = exportHeading;
    }

    @Override
    public void setup(TaskDataMartContainer container, ExpressionEvaluationData data) throws TaskExecutionException {
        File file = null;
        try {
            file = this.fileHelper.getFile(data);
        }
        catch (Exception e) {
            this.addMessage(3, "taskMsg.fileNotFound", "?");
            throw new TaskExecutionException(e, true);
        }
        if (file == null) {
            this.addMessage(3, "taskMsg.fileNotFound", "");
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        this.addMessage(1, "taskMsg.outPutFile", file.toString());
        try {
            BufferedWriter writer = this.encoding == null ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding));
            container.push(writer);
            CSVHandler handler = new CSVHandler(writer, this.separator, this.textDelimiter, this.exportHeading);
            container.setResult(new SAXResult(handler));
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, false);
        }
    }

    public boolean isExportHeading() {
        return this.exportHeading;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getTextDelimiter() {
        return this.textDelimiter;
    }
}

