/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.datamart.AbstractTaskDataMartResult;
import com.prelytis.dashboard.task.datamart.TaskDataMartContainer;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;

class TaskDataMartResultPDFFile
extends AbstractTaskDataMartResult {
    private FileHelper fileHelper;

    TaskDataMartResultPDFFile(MessageListener messageListener, FileHelper fileHelper) throws TaskExecutionException {
        super(messageListener);
        this.fileHelper = fileHelper;
    }

    @Override
    public void setup(TaskDataMartContainer container, ExpressionEvaluationData data) throws TaskExecutionException {
        File file = null;
        try {
            file = this.fileHelper.getFile(data);
        }
        catch (Exception e) {
            this.addMessage(3, "taskMsg.fileNotFound", "?");
            throw new TaskExecutionException(e, true);
        }
        if (file == null) {
            this.addMessage(3, "taskMsg.fileNotFound", "");
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        this.addMessage(1, "taskMsg.outPutFile", file.toString());
        try {
            FileOutputStream out = new FileOutputStream(file);
            container.push(out);
            FopFactory fopFactory = FopFactory.newInstance();
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            container.setResult(new SAXResult(fop.getDefaultHandler()));
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, false);
        }
    }
}

