/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.helper.FileHelper;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.task.CSVReader;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.datamart.AbstractTaskDataMartSource;
import com.prelytis.dashboard.task.datamart.TaskDataMartContainer;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;

class TaskDataMartSourceCSVFile
extends AbstractTaskDataMartSource {
    private final FileHelper fileHelper;
    private final String encoding;
    private final int importFileFrom;
    private final int importFromLine;
    private final int importFileTo;
    private final int importToLine;
    private final String separator;
    private final String textDelimiter;

    TaskDataMartSourceCSVFile(MessageListener messageListener, FileHelper fileHelper, String encoding, int importFileFrom, int importFromLine, int importFileTo, int importToLine, String separator, String textDelimiter) throws TaskExecutionException {
        super(messageListener);
        this.encoding = encoding;
        this.importFileFrom = importFileFrom;
        this.importFromLine = importFromLine;
        this.importFileTo = importFileTo;
        this.importToLine = importToLine;
        this.separator = separator;
        this.textDelimiter = textDelimiter;
        this.fileHelper = fileHelper;
    }

    @Override
    public void setup(TaskDataMartContainer container, ExpressionEvaluationData data) throws TaskExecutionException {
        File file = null;
        try {
            file = this.fileHelper.getFile(data);
        }
        catch (Exception e) {
            this.addMessage(3, "taskMsg.noInputFile", null);
            throw new TaskExecutionException(e, true);
        }
        if (file == null) {
            this.addMessage(3, "taskMsg.noInputFile", null);
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        if (!file.exists()) {
            this.addMessage(3, "taskMsg.fileNotFound", file.getName());
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        this.addMessage(1, "taskMsg.inputFile", file.getName());
        try {
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
            container.push(isr);
            CSVReader reader = new CSVReader();
            reader.setImportFileFrom(this.importFileFrom);
            reader.setImportFileTo(this.importFileTo);
            reader.setImportFromLine(this.importFromLine);
            reader.setImportToLine(this.importToLine);
            reader.setSeparator(this.separator);
            reader.setTextDelimiter(this.textDelimiter);
            container.setSource(new SAXSource(reader, new InputSource(isr)));
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, false);
        }
    }

    @Override
    public void postProcess(ExpressionEvaluationData data) throws TaskExecutionException {
        if (!this.getDeleteAfterProcess()) {
            return;
        }
        File file = null;
        try {
            file = this.fileHelper.getFile(data);
        }
        catch (Exception e) {
            this.addMessage(3, "taskMsg.fileNotFound", "?");
            throw new TaskExecutionException(e, true);
        }
        if (file == null) {
            this.addMessage(3, "taskMsg.noInputFile", null);
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        if (!file.exists()) {
            this.addMessage(3, "taskMsg.fileNotFound", file.getName());
            throw new TaskExecutionException(new FileNotFoundException(), true);
        }
        try {
            if (file.delete()) {
                this.addMessage(1, "taskMsg.fileDeleted", file.getName());
            }
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, false);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getImportFileFrom() {
        return this.importFileFrom;
    }

    public int getImportFileTo() {
        return this.importFileTo;
    }

    public int getImportFromLine() {
        return this.importFromLine;
    }

    public int getImportToLine() {
        return this.importToLine;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getTextDelimiter() {
        return this.textDelimiter;
    }
}

