/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.interfaces.SessionParameterType;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.datamart.AbstractTaskDataMartSource;
import com.prelytis.dashboard.task.datamart.ParamIterator;
import com.prelytis.dashboard.task.datamart.TaskDataMartContainer;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import com.prelytis.dashboard.xml.sax.XMLReaderAdapter;
import com.prelytis.dashboard.xml.stax.XMLEventAdapter;
import com.prelytis.dashboard.xml.stax.XMLEventProducer;
import com.prelytis.dashboard.xml.stax.v48.XmlParam48Producer;
import java.util.EnumSet;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

class TaskDataMartSourceParam
extends AbstractTaskDataMartSource {
    private DaoFactory daoFactory;
    private final EnumSet<SessionParameterType> sessionList;

    TaskDataMartSourceParam(DaoFactory daoFactory, MessageListener messageListener) {
        super(messageListener);
        this.daoFactory = daoFactory;
        EnumSet<SessionParameterType[]> toRemove = EnumSet.of(SessionParameterType.LOGOUT, new SessionParameterType[]{SessionParameterType.USER_MANAGEMENT, SessionParameterType.TASK_MANAGEMENT, SessionParameterType.DISPLAY_TYPE, SessionParameterType.EXPORT_XML, SessionParameterType.IMPORT_XML});
        this.sessionList = EnumSet.complementOf(toRemove);
    }

    @Override
    public void setup(TaskDataMartContainer container, ExpressionEvaluationData data) throws TaskExecutionException {
        try {
            ParamIterator iterator = new ParamIterator(this.daoFactory, this.sessionList.iterator());
            XmlParam48Producer producer = new XmlParam48Producer((Iterator)iterator);
            XMLEventAdapter eventReader = new XMLEventAdapter((XMLEventProducer)producer);
            XMLReaderAdapter reader = new XMLReaderAdapter((XMLEventReader)eventReader);
            container.setSource(new SAXSource((XMLReader)reader, new InputSource()));
        }
        catch (Exception e) {
            throw new TaskExecutionException(e, false);
        }
    }
}

