/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.dao.DaoFactory;
import com.prelytis.dashboard.dao.QueryDao;
import com.prelytis.dashboard.data.helper.EngineHelper;
import com.prelytis.dashboard.data.transformation.ResultsetDataReader;
import com.prelytis.dashboard.db.sql.Result;
import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.task.QueryReader;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.datamart.AbstractTaskDataMartSource;
import com.prelytis.dashboard.task.datamart.TaskDataMartContainer;
import com.prelytis.dashboard.util.xml.PrelytisResolver;
import com.prelytis.dashboard.value.data.BeanQuerySQL;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

class TaskDataMartSourceQuery
extends AbstractTaskDataMartSource {
    private final DaoFactory daoFactory;
    private BeanQuerySQL query;

    TaskDataMartSourceQuery(DaoFactory daoFactory, MessageListener messageListener, int queryOID) throws TaskExecutionException {
        super(messageListener);
        this.daoFactory = daoFactory;
        try {
            QueryDao queryDao = this.daoFactory.getQueryDao();
            this.query = (BeanQuerySQL)queryDao.getDefinition(queryOID);
        }
        catch (Exception e) {
            this.addMessage(3, "taskMsg.queryNotFound", String.valueOf(queryOID));
            throw new TaskExecutionException(e, true);
        }
    }

    @Override
    public void setup(TaskDataMartContainer container, ExpressionEvaluationData data) throws TaskExecutionException {
        try {
            EngineHelper engineHelper = EngineHelper.getInstance(this.daoFactory);
            Result result = engineHelper.getResult(this.query, data, null, true, this.query.getMaxLines());
            container.push(result);
            QueryReader qr = new QueryReader(new ResultsetDataReader(result));
            qr.setEntityResolver((EntityResolver)new PrelytisResolver());
            container.setSource(new SAXSource(qr, new InputSource()));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }
}

