/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.datamart;

import com.prelytis.dashboard.helper.MessageListener;
import com.prelytis.dashboard.task.PrelytisErrorListener;
import com.prelytis.dashboard.task.TaskExecutionException;
import com.prelytis.dashboard.task.datamart.AbstractTaskDataMartTransformer;
import com.prelytis.dashboard.task.datamart.TaskDataMartContainer;
import com.prelytis.dashboard.task.datamart.TaskDataMartElement;
import com.prelytis.dashboard.util.xml.PrelytisErrorHandler;
import com.prelytis.dashboard.value.util.ExpressionEvaluationData;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.XMLReader;

class TaskDataMartTransformerXML
extends AbstractTaskDataMartTransformer {
    private TaskDataMartElement datamartSource;
    private TaskDataMartElement datamartResult;
    private TaskDataMartElement datamartTransformation;

    TaskDataMartTransformerXML(MessageListener messageListener, TaskDataMartElement source, TaskDataMartElement transformation, TaskDataMartElement result) {
        super(messageListener);
        this.datamartSource = source;
        this.datamartTransformation = transformation;
        this.datamartResult = result;
    }

    @Override
    public int transform(ExpressionEvaluationData data) throws TaskExecutionException {
        try (TaskDataMartContainer container = new TaskDataMartContainer();){
            this.datamartSource.setup(container, data);
            this.datamartTransformation.setup(container, data);
            this.datamartResult.setup(container, data);
            TransformerHandler handler = container.getHandler();
            Source source = container.getSource();
            handler.setResult(container.getResult());
            handler.getTransformer().setErrorListener(new PrelytisErrorListener());
            if (source instanceof SAXSource) {
                SAXSource s = (SAXSource)source;
                XMLReader reader = s.getXMLReader();
                reader.setContentHandler(handler);
                reader.setErrorHandler((ErrorHandler)new PrelytisErrorHandler());
                reader.parse(s.getInputSource());
            } else if (source instanceof StAXSource) {
                StAXSource stAXSource = (StAXSource)source;
            }
            this.datamartSource.postProcess(data);
            this.datamartTransformation.postProcess(data);
            this.datamartResult.postProcess(data);
            int n = 0;
            return n;
        }
    }
}

