/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.execution;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.task.execution.TableExecutionInsert;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.util.sql.SQLTableHelper;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.util.ArrayList;
import java.util.List;

public class TableExecutionBatchInsert
extends TableExecutionInsert {
    private int nbBatchRows;
    private int cpt;
    private final List<String[]> cache = new ArrayList<String[]>();

    public TableExecutionBatchInsert(SQLTableHelper sqlTableHelper, SQLTable sqlTable, ConversionHelper conversionHelper) throws DashboardException {
        super(sqlTableHelper, sqlTable, conversionHelper);
    }

    @Override
    public void start() throws DashboardException {
        super.start();
        this.cpt = 0;
    }

    @Override
    public void insert(String[] values) throws DashboardException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > BatchInsert > insert > addBatch");
            }
            int col = 1;
            for (int i = 0; i < values.length; ++i) {
                FieldMetaData fmd = this.getFieldMetaData(i);
                if (fmd.isAutoIncrement()) continue;
                this.setField(col++, fmd, values[i]);
            }
            this.statement.addBatch();
            this.cache.add(this.copyTable(values));
            ++this.cpt;
            if (this.cpt >= this.nbBatchRows && this.nbBatchRows != -1) {
                this.executeBatch();
                this.cpt = 0;
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public void end() throws DashboardException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > BatchInsert > end");
            }
            if (this.cpt > 0 || this.nbBatchRows == -1) {
                this.executeBatch();
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        super.end();
    }

    public int getNbBatchRows() {
        return this.nbBatchRows;
    }

    public void setNbBatchRows(int nbBatchRows) {
        this.nbBatchRows = nbBatchRows;
    }

    private void executeBatch() throws DashboardException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > BatchInsert > executeBatch");
            }
            int[] resu = this.statement.executeBatch();
            for (int i = 0; i < resu.length; ++i) {
                if (resu[i] == 0) {
                    this.listener.lineIgnored(this.cache.get(i));
                    continue;
                }
                this.listener.lineInserted(this.cache.get(i));
            }
            this.cache.clear();
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }
}

