/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.execution;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.task.execution.TableExecutionReplace;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.util.sql.SQLTableHelper;
import com.prelytis.dashboard.value.util.FieldMetaData;

public class TableExecutionBatchReplace
extends TableExecutionReplace {
    private int nbBatchRows;
    private int cpt;

    public TableExecutionBatchReplace(SQLTableHelper sqlTableHelper, SQLTable sqlTable, ConversionHelper conversionHelper) throws DashboardException {
        super(sqlTableHelper, sqlTable, conversionHelper);
    }

    @Override
    public void start() throws DashboardException {
        super.start();
        this.cpt = 0;
    }

    @Override
    public void insert(String[] values) throws DashboardException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > BatchReplace > insert > addBatch");
            }
            this.statement.clearParameters();
            int col = 1;
            for (int i = 0; i < values.length; ++i) {
                FieldMetaData fmd = this.getFieldMetaData(i);
                if (fmd.isAutoIncrement()) continue;
                this.setField(col++, fmd, values[i]);
            }
            this.statement.addBatch();
            ++this.cpt;
            if (this.cpt >= this.nbBatchRows && this.nbBatchRows != -1) {
                this.executeBatch();
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    @Override
    public void end() throws DashboardException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > BatchReplace > end");
            }
            if (this.cpt > 0 || this.nbBatchRows == -1) {
                this.executeBatch();
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
        super.end();
    }

    public int getNbBatchRows() {
        return this.nbBatchRows;
    }

    public void setNbBatchRows(int nbBatchRows) {
        this.nbBatchRows = nbBatchRows;
    }

    private void executeBatch() throws DashboardException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"TableExecution > BatchReplace > executeBatch");
            }
            int[] resu = this.statement.executeBatch();
            this.statement.clearBatch();
            this.cpt = 0;
            for (int j = 0; j < resu.length; ++j) {
                if (resu[j] == 1) {
                    this.listener.lineInserted(null);
                    continue;
                }
                if (resu[j] != 2) continue;
                this.listener.lineUpdated(null);
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }
}

