/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.execution;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.interfaces.DashboardRuntimeException;
import com.prelytis.dashboard.interfaces.ErrorCode;
import com.prelytis.dashboard.task.execution.TableExecutionDataSource;
import com.prelytis.dashboard.task.execution.TableExecutionListener;
import com.prelytis.dashboard.util.ConversionHelper;
import com.prelytis.dashboard.util.sql.SQLTable;
import com.prelytis.dashboard.util.sql.SQLTableHelper;
import com.prelytis.dashboard.value.util.DataType;
import com.prelytis.dashboard.value.util.FieldMetaData;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class TableExecutionDatabase
implements TableExecutionDataSource {
    protected static final Logger log = LogManager.getLogger(TableExecutionDatabase.class);
    private final SQLTable sqlTable;
    private final SQLTableHelper sqlTableHelper;
    private final ConversionHelper conversionHelper;
    protected Connection connection;
    protected PreparedStatement statement;
    protected String request;
    protected TableExecutionListener listener;
    private boolean truncate = true;

    protected TableExecutionDatabase(SQLTableHelper sqlTableHelper, SQLTable sqlTable, ConversionHelper conversionHelper) throws DashboardException {
        this.sqlTableHelper = sqlTableHelper;
        this.sqlTable = sqlTable;
        this.conversionHelper = conversionHelper;
    }

    @Override
    public DataSource getDataSource() {
        return this.sqlTableHelper.getDataSource();
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void end() throws DashboardException {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        this.statement = null;
    }

    @Override
    public void start() throws DashboardException {
        try {
            this.statement = this.connection.prepareStatement(this.request);
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    protected final FieldMetaData getFieldMetaData(int fieldId) {
        return (FieldMetaData)this.sqlTable.getFieldList().get(fieldId);
    }

    protected final void setField(int id, FieldMetaData fmd, String value) throws DashboardException {
        try {
            String stringValue = value;
            if ("".equals(stringValue)) {
                stringValue = null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)new StringBuffer().append("P").append(id).append(", ").append(fmd.getName()).append(", ").append(value).toString());
            }
            DataType dataType = fmd.getDataType();
            switch (dataType) {
                case CHAR: 
                case VARCHAR: 
                case LONGVARCHAR: {
                    if (stringValue == null) {
                        if (fmd.isNullable()) {
                            this.statement.setNull(id, dataType.getSqlType());
                            break;
                        }
                        this.statement.setString(id, "");
                        break;
                    }
                    if (this.truncate && stringValue.length() > fmd.getFieldSize()) {
                        this.statement.setString(id, stringValue.substring(0, fmd.getFieldSize()));
                        break;
                    }
                    this.statement.setString(id, stringValue);
                    break;
                }
                case NUMERIC: 
                case DECIMAL: {
                    if (stringValue == null) {
                        if (fmd.isNullable()) {
                            this.statement.setNull(id, dataType.getSqlType());
                            break;
                        }
                        this.statement.setBigDecimal(id, BigDecimal.ZERO);
                        break;
                    }
                    try {
                        BigDecimal bd = new BigDecimal(stringValue);
                        if (this.truncate) {
                            bd = bd.setScale(fmd.getFieldScale(), RoundingMode.HALF_EVEN);
                        }
                        this.statement.setBigDecimal(id, bd);
                        break;
                    }
                    catch (Exception e) {
                        throw new DashboardRuntimeException(ErrorCode.CONVERSION_ERROR, "Impossible to convert '" + stringValue + "' to a big numeric value.");
                    }
                }
                case BIT: {
                    if (stringValue == null) {
                        if (fmd.isNullable()) {
                            this.statement.setNull(id, dataType.getSqlType());
                            break;
                        }
                        this.statement.setBoolean(id, false);
                        break;
                    }
                    this.statement.setBoolean(id, "1".equals(stringValue) || "T".equals(stringValue) || "true".equalsIgnoreCase(stringValue));
                    break;
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: {
                    if (stringValue == null) {
                        if (fmd.isNullable()) {
                            this.statement.setNull(id, dataType.getSqlType());
                            break;
                        }
                        this.statement.setInt(id, 0);
                        break;
                    }
                    try {
                        this.statement.setInt(id, Integer.parseInt(stringValue));
                        break;
                    }
                    catch (Exception e) {
                        throw new DashboardRuntimeException(ErrorCode.CONVERSION_ERROR, "Impossible to convert '" + stringValue + "' to an integer value");
                    }
                }
                case BIGINT: {
                    if (stringValue == null) {
                        if (fmd.isNullable()) {
                            this.statement.setNull(id, dataType.getSqlType());
                            break;
                        }
                        this.statement.setLong(id, 0L);
                        break;
                    }
                    try {
                        this.statement.setLong(id, Long.parseLong(stringValue));
                        break;
                    }
                    catch (Exception e) {
                        throw new DashboardRuntimeException(ErrorCode.CONVERSION_ERROR, "Impossible to convert '" + stringValue + "' to a long value");
                    }
                }
                case REAL: {
                    if (stringValue == null) {
                        if (fmd.isNullable()) {
                            this.statement.setNull(id, dataType.getSqlType());
                            break;
                        }
                        this.statement.setFloat(id, 0.0f);
                        break;
                    }
                    try {
                        this.statement.setFloat(id, Float.parseFloat(stringValue));
                        break;
                    }
                    catch (Exception e) {
                        throw new DashboardRuntimeException(ErrorCode.CONVERSION_ERROR, "Impossible to convert '" + stringValue + "' to a float value");
                    }
                }
                case FLOAT: 
                case DOUBLE: {
                    if (stringValue == null) {
                        if (fmd.isNullable()) {
                            this.statement.setNull(id, dataType.getSqlType());
                            break;
                        }
                        this.statement.setDouble(id, 0.0);
                        break;
                    }
                    try {
                        this.statement.setDouble(id, Double.parseDouble(stringValue));
                        break;
                    }
                    catch (Exception e) {
                        throw new DashboardRuntimeException(ErrorCode.CONVERSION_ERROR, "Impossible to convert '" + stringValue + "' to a double value");
                    }
                }
                case DATE: {
                    if (stringValue == null) {
                        this.statement.setNull(id, dataType.getSqlType());
                        break;
                    }
                    java.util.Date date = (java.util.Date)this.conversionHelper.parse(dataType, stringValue);
                    if (date == null) {
                        this.statement.setNull(id, dataType.getSqlType());
                        break;
                    }
                    if (date instanceof Date) {
                        this.statement.setDate(id, (Date)date);
                        break;
                    }
                    this.statement.setDate(id, new Date(date.getTime()));
                    break;
                }
                case TIME: {
                    if (stringValue == null) {
                        this.statement.setNull(id, dataType.getSqlType());
                        break;
                    }
                    java.util.Date date = (java.util.Date)this.conversionHelper.parse(dataType, stringValue);
                    if (date == null) {
                        this.statement.setNull(id, dataType.getSqlType());
                        break;
                    }
                    if (date instanceof Time) {
                        this.statement.setTime(id, (Time)date);
                        break;
                    }
                    this.statement.setTime(id, new Time(date.getTime()));
                    break;
                }
                case TIMESTAMP: {
                    if (stringValue == null) {
                        this.statement.setNull(id, dataType.getSqlType());
                        break;
                    }
                    java.util.Date date = (java.util.Date)this.conversionHelper.parse(dataType, stringValue);
                    if (date == null) {
                        this.statement.setNull(id, dataType.getSqlType());
                        break;
                    }
                    if (date instanceof Timestamp) {
                        this.statement.setTimestamp(id, (Timestamp)date);
                        break;
                    }
                    this.statement.setTimestamp(id, new Timestamp(date.getTime()));
                    break;
                }
                default: {
                    this.statement.setObject(id, (Object)stringValue, dataType.getSqlType());
                }
            }
        }
        catch (Exception e) {
            throw this.getException(e);
        }
    }

    protected DashboardException getException(Exception e) {
        if (e instanceof DashboardException) {
            return (DashboardException)((Object)e);
        }
        return new DashboardException((Throwable)e);
    }

    public SQLTable getSQLTable() {
        return this.sqlTable;
    }

    @Override
    public void error(DashboardException de) {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        this.statement = null;
    }

    @Override
    public TableExecutionListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(TableExecutionListener listener) {
        this.listener = listener;
    }

    protected String[] copyTable(String[] values) {
        if (values == null) {
            return null;
        }
        String[] resu = new String[values.length];
        for (int i = 0; i < resu.length; ++i) {
            resu[i] = values[i];
        }
        return resu;
    }
}

