/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.task.execution;

import com.prelytis.dashboard.interfaces.DashboardException;
import com.prelytis.dashboard.task.execution.TableExecutionDataSource;
import com.prelytis.dashboard.task.execution.TableExecutionInsert;
import com.prelytis.dashboard.task.execution.TableExecutionListener;
import com.prelytis.dashboard.task.execution.TableExecutionUpdate;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TableExecutionUpdateInsert
implements TableExecutionDataSource,
TableExecutionListener {
    protected static final Logger log = LogManager.getLogger(TableExecutionUpdateInsert.class);
    private int nbMax = 100;
    private TableExecutionUpdate update;
    private TableExecutionInsert insert;
    private Map<TableExecutionUpdate.Key, String[]> cache;

    public TableExecutionUpdateInsert(TableExecutionUpdate update, TableExecutionInsert insert) throws DashboardException {
        this.update = update;
        this.insert = insert;
        update.setListener(this);
        this.cache = new HashMap<TableExecutionUpdate.Key, String[]>();
    }

    @Override
    public void error(DashboardException de) {
        this.update.error(de);
        this.insert.error(de);
    }

    @Override
    public void end() throws DashboardException {
        this.update.end();
        this.insertFromCache();
    }

    @Override
    public void insert(String[] values) throws DashboardException {
        if (this.cache.size() > this.nbMax) {
            this.update.end();
            this.insertFromCache();
            this.update.start();
        }
        this.update.insert(values);
    }

    @Override
    public void start() throws DashboardException {
        this.cache.clear();
        this.update.start();
    }

    @Override
    public void lineIgnored(String[] data) {
        String[] prevData = this.cache.put(this.update.getKey(data), data);
        if (prevData != null) {
            this.getListener().lineIgnored(prevData);
        }
    }

    @Override
    public void lineInserted(String[] data) {
    }

    @Override
    public void lineUpdated(String[] data) {
        this.getListener().lineUpdated(data);
    }

    private void insertFromCache() throws DashboardException {
        if (this.cache.size() > 0) {
            this.insert.start();
            for (String[] values : this.cache.values()) {
                this.insert.insert(values);
            }
            this.insert.end();
            this.cache.clear();
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.update.getDataSource();
    }

    @Override
    public void setConnection(Connection connection) {
        this.update.setConnection(connection);
        this.insert.setConnection(connection);
    }

    @Override
    public TableExecutionListener getListener() {
        return this.insert.getListener();
    }

    @Override
    public void setListener(TableExecutionListener listener) {
        this.insert.setListener(listener);
    }
}

