/*
 * Decompiled with CFR 0.152.
 */
package com.prelytis.dashboard.web.system.imports;

import com.axway.common.core.connection.UserAccess;
import com.axway.sentinel.upgrade.utils.ArchivingUtils;
import com.axway.sentinel.upgrade.utils.FileUtils;
import com.axway.sentinel.upgrade.utils.XMLPatcher;
import com.axway.sentinel.upgrade.web.UpdateException;
import com.prelytis.dashboard.util.PRP;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class SentinelWorldPreparator {
    private static final String WORLD_XPATH = "/prelytis/world";
    private static final Logger LOG = Logger.getLogger(SentinelWorldPreparator.class);
    private final Properties properties = new Properties();
    private File propertiesFile;
    private String errorMessage = null;

    public SentinelWorldPreparator(File dbProperties) {
        this.propertiesFile = dbProperties;
    }

    protected void loadPropertiesFile() throws IOException {
        FileInputStream in = null;
        if (this.propertiesFile == null) {
            throw new IOException("Property file given is null");
        }
        try {
            in = new FileInputStream(this.propertiesFile);
            this.properties.load(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private void updateWorldXml(String xmlFilePath) throws UpdateException {
        XMLPatcher.addAttribute((String)xmlFilePath, (String)WORLD_XPATH, (String)DD_XML_PROPERTY.DATABASE_URL.toString(), (String)this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_URL.toString()));
        XMLPatcher.addAttribute((String)xmlFilePath, (String)WORLD_XPATH, (String)DD_XML_PROPERTY.DATABASE_DRIVER_NAME.toString(), (String)this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_DRIVER_NAME.toString()));
        XMLPatcher.addAttribute((String)xmlFilePath, (String)WORLD_XPATH, (String)DD_XML_PROPERTY.DATABASE_USER_NAME.toString(), (String)this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_USER_NAME.toString()));
        XMLPatcher.addAttribute((String)xmlFilePath, (String)WORLD_XPATH, (String)DD_XML_PROPERTY.DATABASE_PASSWORD.toString(), (String)this.updatePassword(this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_PASSWORD.toString())));
        Map<DD_XML_PROPERTY, String> map = this.generateSecurePropertiesMap();
        this.removeSecureTags(xmlFilePath, map);
        if (this.isDBSecure()) {
            this.patchSecureTags(xmlFilePath, WORLD_XPATH, map);
        }
    }

    private void removeSecureTags(String xmlFile, Map<DD_XML_PROPERTY, String> map) {
        if (StringUtils.isEmpty((String)xmlFile)) {
            return;
        }
        for (Map.Entry<DD_XML_PROPERTY, String> entry : map.entrySet()) {
            DD_XML_PROPERTY property = entry.getKey();
            String xpathProperty = DD_XML_PROPERTY.generateXPath(property);
            Node node = XMLPatcher.getNode((String)xmlFile, (String)xpathProperty);
            if (node == null) continue;
            XMLPatcher.removeNode((File)new File(xmlFile), (String)xpathProperty);
        }
    }

    private boolean isDBSecure() {
        return "true".equalsIgnoreCase(this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_SECURE_CONNECTION.toString()));
    }

    private Map<DD_XML_PROPERTY, String> generateSecurePropertiesMap() {
        HashMap<DD_XML_PROPERTY, String> map = new HashMap<DD_XML_PROPERTY, String>();
        String trustStore = this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_TRUSTSTORE.toString());
        String trustStoreType = this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_TRUSTSTORE_TYPE.toString());
        String trustStorePass = this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_TRUSTSTORE_PASS.toString());
        switch (DATABASE_DRIVER.toDD(this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_DRIVER_NAME.toString()))) {
            case MYSQL: {
                map.put(DD_XML_PROPERTY.MYSQL_TRUST_STORE, trustStore);
                map.put(DD_XML_PROPERTY.MYSQL_TRUST_STORE_TYPE, trustStoreType);
                map.put(DD_XML_PROPERTY.MYSQL_TRUST_STORE_PASS, trustStorePass);
                map.put(DD_XML_PROPERTY.MYSQL_USE_SSL, "true");
                map.put(DD_XML_PROPERTY.MYSQL_REQUIRE_SSL, "true");
                break;
            }
            case ORACLE_THIN: {
                map.put(DD_XML_PROPERTY.ORACLE_DB2_TRUST_STORE, trustStore);
                map.put(DD_XML_PROPERTY.ORACLE_DB2_TRUST_STORE_TYPE, trustStoreType);
                map.put(DD_XML_PROPERTY.ORACLE_DB2_TRUST_STORE_PASS, trustStorePass);
                map.put(DD_XML_PROPERTY.ORACLE_PROTOCOL, "TCPS");
                break;
            }
            case DB2: {
                map.put(DD_XML_PROPERTY.ORACLE_DB2_TRUST_STORE, trustStore);
                map.put(DD_XML_PROPERTY.ORACLE_DB2_TRUST_STORE_TYPE, trustStoreType);
                map.put(DD_XML_PROPERTY.ORACLE_DB2_TRUST_STORE_PASS, trustStorePass);
                map.put(DD_XML_PROPERTY.DB2_SSL_CONNECTION, "true");
                break;
            }
            case MSSQLSERVER: {
                map.put(DD_XML_PROPERTY.MSSQL_TRUST_STORE, trustStore);
                map.put(DD_XML_PROPERTY.MSSQL_TRUST_STORE_CERTIFICATE, "false");
                map.put(DD_XML_PROPERTY.MSSQL_TRUST_STORE_PASS, trustStorePass);
                map.put(DD_XML_PROPERTY.MSSQL_ENCRYPT, "true");
            }
        }
        return map;
    }

    private void patchSecureTags(String file, String xpath, Map<DD_XML_PROPERTY, String> map) throws UpdateException {
        if (StringUtils.isEmpty((String)file) || StringUtils.isEmpty((String)xpath) || map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<DD_XML_PROPERTY, String> entry : map.entrySet()) {
            DD_XML_PROPERTY property = entry.getKey();
            String value = entry.getValue();
            if (DD_XML_PROPERTY.isPasswordType(property)) {
                value = this.updatePassword(value);
            }
            if (DD_XML_PROPERTY.isURLType(property)) {
                try {
                    value = new File(value).toURI().toURL().toString();
                }
                catch (MalformedURLException ex) {
                    LOG.debug((Object)ex.getMessage(), (Throwable)ex);
                    throw new UpdateException((Exception)ex);
                }
            }
            XMLPatcher.patchWithNewTag((String)file, (String)xpath, (String)DD_XML_PROPERTY.generateTag(property, value));
        }
    }

    private String updatePassword(String criptedPassword) {
        String encriptionDirValue = this.properties.getProperty(DD_KEY_PROPERTY.ENCRIPTION_DIR.toString());
        String pass = encriptionDirValue == null ? UserAccess.uncryptPwd((String)criptedPassword, (String[])new String[]{"SENTINEL_ENCRYPT"}) : UserAccess.uncryptPwdUsingADSFAlgorithm((String)criptedPassword, (String)encriptionDirValue);
        pass = PRP.encrypt((String)pass);
        return pass;
    }

    private void checkMandatoryProperties() throws MissingResourceException, UpdateException {
        for (DD_KEY_PROPERTY key : DD_KEY_PROPERTY.getMandatoryKeys()) {
            if (this.properties.get(key.toString()) != null) continue;
            throw new MissingResourceException("Mandatory property not found ", SentinelWorldPreparator.class.getSimpleName(), key.toString());
        }
        if (!DATABASE_DRIVER.isDBSupported(this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_DRIVER_NAME.toString()))) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unsuported database driver name. Supported database drivers are: ");
            sb.append(Arrays.asList(DATABASE_DRIVER.values()).toString());
            throw new UpdateException(sb.toString());
        }
        if (this.isDBSecure()) {
            for (DD_KEY_PROPERTY key : DD_KEY_PROPERTY.getSecureMandatoryKeys()) {
                if (this.properties.get(key.toString()) != null) continue;
                throw new MissingResourceException("Secure Mandatory property not found ", SentinelWorldPreparator.class.getSimpleName(), key.toString());
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean updatePrepackagedWorld(File importDirectory) {
        this.errorMessage = null;
        if (importDirectory.exists() && importDirectory.isDirectory()) {
            File prepackagedZip = new File(importDirectory, "prepackagedWorld.zip");
            if (prepackagedZip.exists()) {
                String tmpFolder = new File(importDirectory, "prepackagedWorldTMP").getAbsolutePath();
                try {
                    this.loadPropertiesFile();
                }
                catch (IOException e) {
                    LOG.warn((Object)e);
                    this.errorMessage = e.getMessage();
                    return false;
                }
                try {
                    this.checkMandatoryProperties();
                }
                catch (MissingResourceException e) {
                    LOG.warn((Object)e);
                    this.errorMessage = e.getMessage() + e.getKey();
                    return false;
                }
                catch (UpdateException e) {
                    LOG.warn((Object)e);
                    this.errorMessage = e.getMessage();
                    return false;
                }
                try {
                    this.checkPasswordProperties();
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)e);
                    this.errorMessage = e.getMessage();
                    return false;
                }
                ArchivingUtils.executeUnarchive((String)(importDirectory + File.separator + "prepackagedWorld.zip"), (String)tmpFolder, (ArchivingUtils.ArchiveType)ArchivingUtils.ArchiveType.UNZIP);
                try {
                    this.updateWorldXml(tmpFolder + File.separator + "data.xml");
                }
                catch (UpdateException e) {
                    LOG.warn((Object)e);
                    this.errorMessage = e.getMessage();
                    return false;
                }
                ArchivingUtils.createZip((String)tmpFolder, (String)(importDirectory + File.separator + "prepackagedWorld.zip"));
                FileUtils.deleteFile((String)this.propertiesFile.getAbsolutePath());
                FileUtils.deleteDirIfExists((String)tmpFolder);
                return true;
            }
            this.errorMessage = String.format("Prepackaged archive not found %s", prepackagedZip.getAbsolutePath());
            return false;
        }
        this.errorMessage = String.format("Import directory not found %s", importDirectory.getAbsolutePath());
        return false;
    }

    private void checkPasswordProperties() {
        this.updatePassword(this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_PASSWORD.toString()));
        if (this.isDBSecure()) {
            this.updatePassword(this.properties.getProperty(DD_KEY_PROPERTY.DATABASE_TRUSTSTORE_PASS.toString()));
        }
    }

    static enum DD_KEY_PROPERTY {
        DATABASE_URL("world.database.url"),
        DATABASE_DRIVER_NAME("world.database.driverName"),
        DATABASE_USER_NAME("world.database.username"),
        DATABASE_PASSWORD("world.database.password"),
        DATABASE_SECURE_CONNECTION("world.database.secure.connection"),
        ENCRIPTION_DIR("axway.sentinel.key.encryption.dir"),
        DATABASE_TRUSTSTORE("javax.net.ssl.trustStore"),
        DATABASE_TRUSTSTORE_TYPE("javax.net.ssl.trustStoreType"),
        DATABASE_TRUSTSTORE_PASS("javax.net.ssl.trustStorePassword"),
        UNKNOWN("unknown");

        private final String keyProperty;

        private DD_KEY_PROPERTY(String keyProperty) {
            this.keyProperty = keyProperty;
        }

        public String toString() {
            return this.keyProperty;
        }

        static DD_KEY_PROPERTY[] getMandatoryKeys() {
            return new DD_KEY_PROPERTY[]{DATABASE_URL, DATABASE_DRIVER_NAME, DATABASE_USER_NAME, DATABASE_PASSWORD};
        }

        static DD_KEY_PROPERTY[] getSecureMandatoryKeys() {
            return new DD_KEY_PROPERTY[]{DATABASE_TRUSTSTORE, DATABASE_TRUSTSTORE_TYPE, DATABASE_TRUSTSTORE_PASS, DATABASE_SECURE_CONNECTION};
        }
    }

    static enum DD_XML_PROPERTY {
        DATABASE_URL("url"),
        DATABASE_DRIVER_NAME("driverName"),
        DATABASE_USER_NAME("user"),
        DATABASE_PASSWORD("password"),
        MYSQL_TRUST_STORE("trustCertificateKeyStoreUrl"),
        MYSQL_TRUST_STORE_TYPE("trustCertificateKeyStoreType"),
        MYSQL_TRUST_STORE_PASS("trustCertificateKeyStorePassword"),
        MYSQL_REQUIRE_SSL("requireSSL"),
        MYSQL_USE_SSL("useSSL"),
        ORACLE_DB2_TRUST_STORE("javax.net.ssl.trustStore"),
        ORACLE_DB2_TRUST_STORE_TYPE("javax.net.ssl.trustStoreType"),
        ORACLE_DB2_TRUST_STORE_PASS("javax.net.ssl.trustStorePassword"),
        ORACLE_PROTOCOL("protocol"),
        DB2_SSL_CONNECTION("sslConnection"),
        MSSQL_TRUST_STORE("trustStore"),
        MSSQL_TRUST_STORE_CERTIFICATE("trustServerCertificate"),
        MSSQL_TRUST_STORE_PASS("trustStorePassword"),
        MSSQL_ENCRYPT("encrypt"),
        UNKNOWN("unknown");

        private final String xmlProperty;

        private DD_XML_PROPERTY(String xmlProperty) {
            this.xmlProperty = xmlProperty;
        }

        public String toString() {
            return this.xmlProperty;
        }

        static String generateTag(DD_XML_PROPERTY property, String value) {
            if (property == null || StringUtils.isEmpty((String)value)) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("<p:driverProp name='");
            stringBuffer.append(property.toString());
            stringBuffer.append("' value='");
            stringBuffer.append(value);
            stringBuffer.append("'/>");
            return stringBuffer.toString();
        }

        static String generateXPath(DD_XML_PROPERTY property) {
            if (property == null) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("/prelytis/world/driverProp[@name='");
            stringBuffer.append(property.toString());
            stringBuffer.append("']");
            return stringBuffer.toString();
        }

        static boolean isPasswordType(DD_XML_PROPERTY property) {
            switch (property) {
                case ORACLE_DB2_TRUST_STORE_PASS: 
                case MYSQL_TRUST_STORE_PASS: 
                case MSSQL_TRUST_STORE_PASS: {
                    return true;
                }
            }
            return false;
        }

        static boolean isURLType(DD_XML_PROPERTY property) {
            switch (property) {
                case MYSQL_TRUST_STORE: {
                    return true;
                }
            }
            return false;
        }
    }

    static enum DATABASE_DRIVER {
        MYSQL("MySQL"),
        ORACLE_THIN("Oracle-Thin"),
        DB2("IBM-DB2"),
        MSSQLSERVER("MSSQLServer"),
        UNKNOWN("unknown");

        private final String driverName;

        private DATABASE_DRIVER(String driverName) {
            this.driverName = driverName;
        }

        public String toString() {
            return this.driverName;
        }

        static DATABASE_DRIVER toDD(String dbName) {
            for (DATABASE_DRIVER driver : DATABASE_DRIVER.values()) {
                if (!StringUtils.equalsIgnoreCase((String)dbName, (String)driver.toString())) continue;
                return driver;
            }
            return UNKNOWN;
        }

        static boolean isDBSupported(String dbName) {
            return !DATABASE_DRIVER.toDD(dbName).equals((Object)UNKNOWN);
        }
    }
}

