<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:fo="http://www.w3.org/1999/XSL/Format"
        xmlns:fox="http://xml.apache.org/fop/extensions"
                version="1.0">

<xsl:output method="xml" indent="yes"/>
<xsl:variable name="pagewidth" select="21"/>
<xsl:variable name="bodywidth" select="19"/>
<xsl:variable name="languageoid" select="/prelytis/prpinfo/@languageoid"/>
<xsl:variable name="product" select="/prelytis/prpinfo/@description"/>
<xsl:variable name="release" select="/prelytis/prpinfo/@release"/>
<xsl:variable name="data" select="/prelytis/language[@objectid=$languageoid]/data"/>

<xsl:template match="prelytis">
<fo:root>

<fo:layout-master-set>
  <fo:simple-page-master page-width="21cm" page-height="29.7cm" master-name="A4">
    <fo:region-body margin-bottom="15mm" margin-right="1cm" margin-left="1cm" margin-top="1cm"/>
    <fo:region-before extent="1cm"/>
    <fo:region-after extent="1cm"/>
  </fo:simple-page-master>

  <fo:simple-page-master page-width="21cm" page-height="29.7cm" master-name="A4First">
    <fo:region-body margin-bottom="2cm" margin-right="2cm" margin-left="2cm" margin-top="7cm"/>
    <fo:region-after extent="15mm"/>
  </fo:simple-page-master>
</fo:layout-master-set>

  <fox:outline internal-destination="title">
    <fox:label><xsl:value-of select="$data[@descriptionkey='session.dashBoard']/@description"/></fox:label>
  </fox:outline>

  <xsl:if test="world">
  <xsl:variable name="firstworld" select="world[position()=1]/@objectid"/>
  <fox:outline internal-destination="world{$firstworld}">
    <fox:label><xsl:value-of select="$data[@descriptionkey='session.world']/@description"/></fox:label>
    <xsl:for-each select="world">
      <xsl:sort select="@name"/>
      <xsl:variable name="desc" select="@descriptionkey"/>
      <fox:outline internal-destination="world{@objectid}">
        <fox:label><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fox:label>
      </fox:outline>
    </xsl:for-each>
  </fox:outline>
  </xsl:if>

  <xsl:if test="entity">
  <xsl:variable name="firstentity" select="entity[position()=1]/@objectid"/>
  <fox:outline internal-destination="entity{$firstentity}">
    <fox:label><xsl:value-of select="$data[@descriptionkey='session.entity']/@description"/></fox:label>
    <xsl:for-each select="entity">
      <xsl:sort select="@name"/>
      <xsl:variable name="entityoid" select="@objectid"/>
      <xsl:variable name="desc" select="@descriptionkey"/>
      <fox:outline internal-destination="entity{@objectid}">
        <fox:label><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fox:label>
        <xsl:for-each select="/prelytis/user[@entityoid=$entityoid]">
          <xsl:sort select="@name"/>
	      <xsl:variable name="desc" select="@descriptionkey"/>
          <fox:outline internal-destination="user{@objectid}">
            <fox:label><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fox:label>
          </fox:outline>
        </xsl:for-each>
      </fox:outline>
    </xsl:for-each>
  </fox:outline>
  </xsl:if>

  <xsl:if test="user">
  <xsl:variable name="firstuser" select="user[position()=1]/@objectid"/>
  <fox:outline internal-destination="user{$firstuser}">
    <fox:label><xsl:value-of select="$data[@descriptionkey='P_S13_O1']/@description"/></fox:label>
    <xsl:for-each select="user">
      <xsl:sort select="@name"/>
	  <xsl:variable name="desc" select="@descriptionkey"/>
	  <fox:outline internal-destination="user{@objectid}">
      	 <fox:label><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fox:label>
      </fox:outline>
    </xsl:for-each>
  </fox:outline>
  </xsl:if>

  <xsl:if test="workspace">
  <xsl:variable name="firstworkspace" select="workspace[position()=1]/@objectid"/>
  <fox:outline internal-destination="workspace{$firstworkspace}">
    <fox:label><xsl:value-of select="$data[@descriptionkey='session.workspace']/@description"/></fox:label>
    <xsl:for-each select="workspace">
      <xsl:sort select="@name"/>
      <xsl:variable name="workspaceoid" select="@objectid"/>
	  <xsl:variable name="desc" select="@descriptionkey"/>
      <fox:outline internal-destination="workspace{@objectid}">
        <fox:label><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fox:label>
        <xsl:for-each select="/prelytis/user[@workspaceoid=$workspaceoid]">
          <xsl:sort select="@name"/>
	 	  <xsl:variable name="desc" select="@descriptionkey"/>
          <fox:outline internal-destination="user{@objectid}">
            <fox:label><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fox:label>
          </fox:outline>
        </xsl:for-each>
      </fox:outline>
    </xsl:for-each>
  </fox:outline>
  </xsl:if>

  <xsl:if test="query">
  <xsl:variable name="firstquery" select="query[position()=1]/@objectid"/>
  <fox:outline internal-destination="query{$firstquery}">
    <fox:label><xsl:value-of select="$data[@descriptionkey='session.query']/@description"/></fox:label>
    <xsl:for-each select="query">
      <xsl:sort select="@name"/>
      <xsl:variable name="queryoid" select="@objectid"/>
	  <xsl:variable name="desc" select="@descriptionkey"/>
      <fox:outline internal-destination="query{@objectid}">
        <fox:label><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fox:label>
        <xsl:if test="/prelytis/report[@queryoid=$queryoid]">
          <fox:outline internal-destination="query{@objectid}">
          <fox:label><xsl:value-of select="$data[@descriptionkey='session.report']/@description" /></fox:label>
          <xsl:for-each select="/prelytis/report[@queryoid=$queryoid]">
            <xsl:sort select="@name"/>
		    <xsl:variable name="desc" select="@descriptionkey"/>
            <fox:outline internal-destination="report{@objectid}">
              <fox:label><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fox:label>
            </fox:outline>
          </xsl:for-each>
          </fox:outline>
        </xsl:if>
        <xsl:if test="/prelytis/task/taskcontrol[@queryoid=$queryoid]">
          <fox:outline internal-destination="query{@objectid}">
          <fox:label><xsl:value-of select="$data[@descriptionkey='session.taskDescription']/@description" /></fox:label>
          <xsl:for-each select="/prelytis/task/taskcontrol[@queryoid=$queryoid]">
            <xsl:sort select="../@name"/>
        	<xsl:variable name="desc" select="@descriptionkey"/>
            <fox:outline internal-destination="task{../@objectid}">
              <fox:label><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fox:label>
            </fox:outline>
          </xsl:for-each>
          </fox:outline>
        </xsl:if>
      </fox:outline>
    </xsl:for-each>
  </fox:outline>
  </xsl:if>

  <xsl:if test="report">
  <xsl:variable name="firstreport" select="report[position()=1]/@objectid"/>
  <fox:outline internal-destination="report{$firstreport}">
    <fox:label><xsl:value-of select="$data[@descriptionkey='session.report']/@description"/></fox:label>
    <xsl:for-each select="report">
      <xsl:sort select="@name"/>
	  <xsl:variable name="desc" select="@descriptionkey"/>
      <fox:outline internal-destination="report{@objectid}">
        <fox:label><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fox:label>
      </fox:outline>
    </xsl:for-each>
  </fox:outline>
  </xsl:if>

  <fox:outline internal-destination="task">
    <fox:label><xsl:value-of select="$data[@descriptionkey='P_S13_O19']/@description"/></fox:label>
    <xsl:for-each select="task">
      <xsl:sort select="@name"/>
	  <xsl:variable name="desc" select="@descriptionkey"/>
      <xsl:variable name="taskoid" select="@objectid"/>
      <fox:outline internal-destination="task{@objectid}">
        <fox:label><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fox:label>
      </fox:outline>
    </xsl:for-each>
  </fox:outline>

  <fo:page-sequence master-reference="A4First" initial-page-number="1">
  <fo:flow flow-name="xsl-region-body">
    <fo:block>
      <fo:instream-foreign-object>
		<svg xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" version="1.0" width="330" height="220" id="svg2">
		  <defs id="defs4" />
		  <g transform="translate(-113.7448,-304.05)" id="layer1">
		    <path d="M 347.32045,450.81619 L 387.94991,450.81619 C 393.55207,450.81619 398.06211,455.94347 398.06211,462.31233 L 398.06211,503.22898 C 398.06211,509.59784 393.55207,514.72512 387.94991,514.72512 L 347.32045,514.72512 C 341.71829,514.72512 337.20825,509.59784 337.20825,503.22898 L 337.20825,462.31233 C 337.20825,455.94347 341.71829,450.81619 347.32045,450.81619 z " style="fill:#f79910;fill-opacity:1;stroke:#f79910;stroke-width:3.71876121;stroke-linejoin:round;stroke-miterlimit:4;stroke-opacity:1" id="rect3057" />
		    <path d="M -485.93085,322.43972 L -489.91778,322.43972 L -489.91778,324.01265 L -486.36777,324.01265 C -485.85803,324.01266 -485.51214,324.10732 -485.33008,324.29665 C -485.14803,324.48599 -485.05701,324.83553 -485.057,325.34527 L -485.057,325.97881 C -485.05701,326.49584 -485.14803,326.84902 -485.33008,327.03835 C -485.51214,327.22041 -485.85803,327.31143 -486.36777,327.31143 L -489.65563,327.31143 C -490.16538,327.31143 -490.51492,327.22041 -490.70425,327.03835 C -490.8863,326.84902 -490.97733,326.49584 -490.97733,325.97881 L -490.97733,325.82589 L -490.10348,325.61835 L -490.10348,326.52497 L -485.909,326.52497 L -485.909,324.83189 L -489.44809,324.83189 C -489.95056,324.83189 -490.29645,324.74086 -490.48579,324.55881 C -490.66784,324.36948 -490.75886,324.0163 -490.75886,323.49927 L -490.75886,323.00773 C -490.75886,322.48342 -490.66784,322.13024 -490.48579,321.94818 C -490.29645,321.76614 -489.95056,321.67511 -489.44809,321.67511 L -486.44423,321.67511 C -485.96362,321.67511 -485.62501,321.7625 -485.42838,321.93726 C -485.22449,322.11204 -485.12254,322.43609 -485.12254,322.90942 L -485.12254,323.02957 L -485.93085,323.25896 L -485.93085,322.43972 M -482.37401,327.31143 L -482.37401,321.67511 L -476.94522,321.67511 L -476.94522,322.4288 L -481.43462,322.4288 L -481.43462,324.00173 L -478.69292,324.00173 L -478.69292,324.7445 L -481.43462,324.7445 L -481.43462,326.53589 L -476.90153,326.53589 L -476.90153,327.31143 L -482.37401,327.31143 M -474.8217,327.31143 L -474.8217,321.67511 L -470.27769,321.67511 C -469.86262,321.67511 -469.56041,321.7625 -469.37107,321.93726 C -469.18174,322.10475 -469.08707,322.38147 -469.08707,322.76742 L -469.08707,324.02358 C -469.08707,324.40953 -469.18174,324.68989 -469.37107,324.86465 C -469.56041,325.03214 -469.86262,325.11589 -470.27769,325.11589 L -471.10784,325.11589 L -468.52999,327.31143 L -469.92815,327.31143 L -472.222,325.11589 L -473.88231,325.11589 L -473.88231,327.31143 L -474.8217,327.31143 M -470.64907,322.40695 L -473.88231,322.40695 L -473.88231,324.38404 L -470.64907,324.38404 C -470.42333,324.38404 -470.26677,324.34399 -470.17938,324.26388 C -470.08472,324.18378 -470.03738,324.03086 -470.03738,323.80511 L -470.03738,322.98588 C -470.03738,322.76742 -470.08472,322.61814 -470.17938,322.53803 C -470.26677,322.45065 -470.42333,322.40696 -470.64907,322.40695 M -466.6507,327.31143 L -466.6507,321.67511 L -465.71131,321.67511 L -465.71131,327.31143 L -466.6507,327.31143 M -462.87455,327.31143 L -462.87455,321.67511 L -457.44576,321.67511 L -457.44576,322.4288 L -461.93516,322.4288 L -461.93516,324.00173 L -459.19346,324.00173 L -459.19346,324.7445 L -461.93516,324.7445 L -461.93516,326.53589 L -457.40207,326.53589 L -457.40207,327.31143 L -462.87455,327.31143" transform="matrix(-8.255721e-4,-0.983106,1.017182,-1.939262e-3,0,0)" style="font-size:10.92311192px;font-style:normal;font-variant:normal;font-weight:300;font-stretch:normal;writing-mode:lr-tb;text-anchor:start;fill:#f79910;fill-opacity:1;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;font-family:Bank Gothic" id="text3932" />
		    <path d="M 214.10368,401.32968 L 214.10368,384.17146 L 216.96338,384.17146 L 216.96338,398.93551 L 229.96506,398.93551 L 229.96506,401.32968 L 214.10368,401.32968 M 236.73763,401.32968 L 234.07744,401.32968 L 234.07744,387.26393 L 236.73763,387.26393 L 236.73763,401.32968 M 248.563,401.32968 L 240.44942,387.23068 L 243.30913,387.23068 L 249.62708,398.56973 L 255.67901,387.23068 L 258.30594,387.23068 L 250.5914,401.32968 L 248.563,401.32968 M 261.94085,401.32968 L 261.94085,387.23068 L 276.13961,387.23068 L 276.13961,389.32558 L 264.60104,389.32558 L 264.60104,392.95008 L 271.55078,392.95008 L 271.55078,395.04498 L 264.60104,395.04498 L 264.60104,399.26803 L 276.27262,399.26803 L 276.27262,401.32968 L 261.94085,401.32968 M 291.4809,384.17146 C 294.49576,384.17148 296.69041,384.61484 298.06486,385.50155 C 299.17326,386.21095 300.03782,387.19744 300.65855,388.46101 C 301.30141,389.72462 301.62284,391.12121 301.62287,392.65081 C 301.62284,395.99822 300.43684,398.44781 298.06486,399.99959 C 296.71258,400.88632 294.51793,401.32968 291.4809,401.32968 L 282.03722,401.32968 L 282.03722,384.17146 L 291.4809,384.17146 M 291.08187,386.49912 L 284.89693,386.49912 L 284.89693,398.93551 L 291.08187,398.93551 C 293.74204,398.93551 295.64851,398.49215 296.80127,397.60542 C 298.06484,396.65219 298.69664,395.00065 298.69666,392.65081 C 298.69664,390.38966 298.06484,388.78247 296.80127,387.82922 C 295.62634,386.9425 293.71987,386.49914 291.08187,386.49912 M 310.43527,396.0093 L 317.91705,396.0093 L 314.15953,389.29232 L 310.43527,396.0093 M 304.84887,401.32968 L 312.9957,387.23068 L 315.42312,387.23068 L 323.76947,401.32968 L 320.87651,401.32968 L 319.04763,398.0377 L 309.30469,398.0377 L 307.50906,401.32968 L 304.84887,401.32968 M 340.03767,389.32558 L 330.16172,389.32558 L 330.16172,392.98334 L 339.20636,392.98334 C 340.53644,392.98335 341.43425,393.21611 341.8998,393.68164 C 342.38749,394.14718 342.63134,395.02282 342.63136,396.30857 L 342.63136,398.00444 C 342.63134,399.2902 342.38749,400.16585 341.8998,400.63138 C 341.43425,401.09692 340.53644,401.32968 339.20636,401.32968 L 330.62725,401.32968 C 329.27498,401.32968 328.355,401.09692 327.8673,400.63138 C 327.40177,400.16585 327.169,399.2902 327.169,398.00444 L 327.169,397.60542 L 329.59643,397.10663 L 329.59643,399.20153 L 340.23718,399.20153 L 340.23718,395.2445 L 331.15929,395.2445 C 329.82919,395.2445 328.92029,395.01174 328.43259,394.5462 C 327.96706,394.08067 327.73429,393.20503 327.73429,391.91926 L 327.73429,390.58917 C 327.73429,389.28125 327.96706,388.39452 328.43259,387.92898 C 328.92029,387.46346 329.82919,387.23069 331.15929,387.23068 L 339.00685,387.23068 C 340.27042,387.23069 341.15715,387.45237 341.66704,387.89572 C 342.19906,388.3391 342.46508,389.14824 342.46509,390.32315 L 342.46509,390.65567 L 340.03767,391.18771 L 340.03767,389.32558 M 348.38401,401.32968 L 348.38401,387.26393 L 351.0442,387.26393 L 351.0442,392.91683 L 362.2835,392.91683 L 362.2835,387.26393 L 364.94369,387.26393 L 364.94369,401.32968 L 362.2835,401.32968 L 362.2835,395.04498 L 351.0442,395.04498 L 351.0442,401.32968 L 348.38401,401.32968 M 372.18232,401.32968 L 372.18232,384.17146 L 386.0153,384.17146 C 387.27887,384.17148 388.19886,384.43749 388.77525,384.96952 C 389.3516,385.4794 389.63979,386.32179 389.63981,387.4967 L 389.63981,389.49184 C 389.63979,391.1988 388.68656,392.1742 386.78011,392.41805 C 388.75306,392.66191 389.73955,393.7814 389.73957,395.77654 L 389.73957,397.97119 C 389.73955,400.21019 388.15452,401.32968 384.98448,401.32968 L 372.18232,401.32968 M 386.7136,389.69135 L 386.7136,387.96223 C 386.71359,387.3637 386.56949,386.96467 386.28132,386.76514 C 386.01529,386.56564 385.57192,386.46589 384.95123,386.46587 L 375.04202,386.46587 L 375.04202,391.22096 L 384.95123,391.22096 C 386.12613,391.22097 386.71359,390.7111 386.7136,389.69135 M 386.84661,396.94037 L 386.84661,395.51052 C 386.84659,394.71247 386.7025,394.16935 386.41433,393.88115 C 386.1483,393.59297 385.66059,393.44888 384.95123,393.44887 L 375.04202,393.44887 L 375.04202,398.96876 L 384.95123,398.96876 C 385.66059,398.96877 386.1483,398.82467 386.41433,398.53648 C 386.7025,398.2483 386.84659,397.71626 386.84661,396.94037 M 395.59198,390.58917 C 395.59198,389.30342 395.83583,388.42778 396.32353,387.96223 C 396.81123,387.47454 397.72013,387.23069 399.05023,387.23068 L 409.22545,387.23068 C 410.55553,387.23069 411.46443,387.47454 411.95215,387.96223 C 412.43983,388.42778 412.68368,389.30342 412.6837,390.58917 L 412.6837,398.00444 C 412.68368,399.2902 412.43983,400.16585 411.95215,400.63138 C 411.46443,401.09692 410.55553,401.32968 409.22545,401.32968 L 399.05023,401.32968 C 397.69796,401.32968 396.77798,401.108 396.29028,400.66463 C 395.82474,400.1991 395.59198,399.31237 395.59198,398.00444 L 395.59198,390.58917 M 398.25217,399.20153 L 410.02351,399.20153 L 410.02351,389.32558 L 398.25217,389.32558 L 398.25217,399.20153 M 421.68782,396.0093 L 429.1696,396.0093 L 425.41208,389.29232 L 421.68782,396.0093 M 416.10142,401.32968 L 424.24825,387.23068 L 426.67567,387.23068 L 435.02202,401.32968 L 432.12906,401.32968 L 430.30018,398.0377 L 420.55724,398.0377 L 418.76161,401.32968 L 416.10142,401.32968 M 438.85384,401.32968 L 438.85384,387.23068 L 450.1929,387.23068 C 452.16586,387.23069 453.15234,388.13959 453.15236,389.95737 L 453.15236,393.11635 C 453.15234,394.91198 452.16586,395.80979 450.1929,395.80979 L 448.33077,395.80979 L 454.54896,401.32968 L 450.99095,401.32968 L 445.3713,395.80979 L 441.51403,395.80979 L 441.51403,401.32968 L 438.85384,401.32968 M 449.02907,389.29232 L 441.51403,389.29232 L 441.51403,393.8479 L 449.02907,393.8479 C 449.73843,393.84791 450.1818,393.68164 450.35916,393.34911 C 450.46999,393.14961 450.52541,392.83925 450.52542,392.41805 L 450.52542,390.72218 C 450.52541,389.76895 450.02662,389.29234 449.02907,389.29232 M 468.06812,387.23068 C 470.68396,387.23069 472.56826,387.59647 473.72102,388.32801 C 475.76048,389.61378 476.78022,391.58675 476.78024,394.24693 C 476.78022,398.96877 473.87618,401.32968 468.06812,401.32968 L 459.95454,401.32968 L 459.95454,387.23068 L 468.06812,387.23068 M 467.76885,389.32558 L 462.61473,389.32558 L 462.61473,399.20153 L 467.76885,399.20153 C 469.98566,399.20153 471.59285,398.83576 472.59044,398.1042 C 473.61016,397.37265 474.12003,396.07581 474.12005,394.21367 C 474.12003,392.41806 473.58799,391.14338 472.52394,390.38965 C 471.54852,389.68028 469.96349,389.32559 467.76885,389.32558" transform="scale(0.901371,1.109421)" style="font-size:33.25236893px;font-style:normal;font-variant:normal;font-weight:300;font-stretch:normal;writing-mode:lr-tb;text-anchor:start;fill:#f79910;fill-opacity:1;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;font-family:Bank Gothic" id="text1307" />
		    <path d="M 338.25958,451.86752 L 377.71793,451.86752 L 377.71793,495.05278 L 338.25958,495.05278 L 338.25958,451.86752 z " style="fill:#f79910;fill-opacity:1;stroke:#f79910;stroke-width:5.8213954;stroke-linejoin:miter;stroke-miterlimit:4;stroke-opacity:1" id="rect11804" />
		    <path d="M 426.41403,445.72632 L 426.41403,434.60428 L 391.05861,434.60428 L 391.05861,428.8172 L 424.696,398.52547 L 433.55746,398.52547 L 433.55746,428.8172 L 444.22738,428.8172 L 444.22738,434.60428 L 433.55746,434.60428 L 433.55746,445.72632 L 426.41403,445.72632 M 426.41403,428.8172 L 426.41403,404.1317 L 399.28711,428.8172 L 426.41403,428.8172" transform="scale(0.876869,1.140422)" style="font-size:90.42308807px;font-style:normal;font-variant:normal;font-weight:300;font-stretch:normal;writing-mode:lr-tb;text-anchor:start;fill:#ffffff;fill-opacity:1;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;font-family:Bank Gothic" id="text11806" />
		    <g transform="translate(670.9818,437.9475)" id="g1381">
		      <g transform="matrix(1.864673e-2,0,0,1.864673e-2,-504.7776,-36.15898)" style="font-size:12px" id="g821">
		        <path d="M 67.1643,-40.804 C 67.1643,-32.8947 58.338,-26.4758 47.4627,-26.4758 C 36.5874,-26.4758 27.7612,-32.8947 27.7612,-40.804 C 27.7612,-48.7133 36.5874,-55.1325 47.4627,-55.1325 C 58.338,-55.1325 67.1643,-48.7133 67.1643,-40.804 z M 86.8658,-29.1622 C 86.8658,-21.2529 78.0395,-14.834 67.1642,-14.834 C 56.2889,-14.834 47.4627,-21.2529 47.4627,-29.1622 C 47.4627,-37.0715 56.2889,-43.4907 67.1642,-43.4907 C 78.0395,-43.4907 86.8658,-37.0715 86.8658,-29.1622 z " transform="matrix(-27.4306,0,0,25.54985,2704.775,1636.257)" style="fill:#c2c6f8;fill-rule:evenodd;stroke-width:1" id="path825" />
		        <g transform="matrix(1.018,0,0,0.331136,-253.0746,605.278)" style="fill:#0b335b"  id="g826">
		          <path d="M 1974,600 L 1974,501 L 1974,402 L 1974,303 L 1974,204 L 1925,204 L 1877,204 L 1829,204 L 1780,204 L 1780,303 L 1780,402 L 1780,501 L 1780,600 L 1828,600 L 1876,600 L 1925,600 L 1974,600 z M 2052,607 L 2051,620 L 2048,632 L 2043,643 L 2036,652 L 2026,659 L 2015,665 L 2003,669 L 1990,671 L 1938,671 L 1885,671 L 1833,671 L 1780,671 L 1780,758 L 1780,846 L 1780,935 L 1780,1024 L 1761,1024 L 1742,1024 L 1721,1024 L 1701,1024 L 1701,801 L 1701,578 L 1701,356 L 1701,133 L 1773,133 L 1845,133 L 1917,133 L 1990,133 L 2003,134 L 2015,138 L 2026,143 L 2036,152 L 2043,161 L 2048,172 L 2051,184 L 2052,198 L 2052,300 L 2052,402 L 2052,505 L 2052,607 z " id="path827" />
		          <polygon points="2556,1024 2535,1024 2514,1024 2493,1024 2472,1024 2430,904 2389,785 2347,666 2306,548 2309,543 2312,539 2314,534 2318,530 2352,530 2387,530 2421,530 2457,530 2457,448 2457,367 2457,285 2457,204 2406,204 2356,204 2305,204 2255,204 2255,408 2255,613 2255,818 2255,1024 2235,1024 2216,1024 2196,1024 2177,1024 2177,801 2177,578 2177,356 2177,133 2251,133 2325,133 2399,133 2473,133 2486,134 2498,138 2508,143 2517,152 2524,161 2530,172 2535,184 2537,198 2537,282 2537,366 2537,450 2537,535 2531,563 2515,583 2488,595 2450,599 2445,599 2439,599 2432,599 2424,599 2416,598 2409,598 2405,597 2401,597 2439,702 2477,809 2516,915 2556,1024 " id="polygon828" />
		          <polygon points="2964,1024 2891,1024 2818,1024 2745,1024 2673,1024 2673,801 2673,578 2673,356 2673,133 2744,133 2816,133 2888,133 2961,133 2961,150 2961,167 2961,185 2961,204 2908,204 2855,204 2803,204 2752,204 2752,286 2752,368 2752,451 2752,535 2798,535 2846,535 2893,535 2941,535 2941,553 2941,571 2941,589 2941,607 2894,607 2846,607 2798,607 2752,607 2752,693 2752,779 2752,865 2752,951 2805,951 2858,951 2910,951 2964,951 2964,969 2964,987 2964,1005 2964,1024 " id="polygon829" />
		          <polygon points="3368,1024 3298,1024 3227,1024 3157,1024 3086,1024 3086,801 3086,578 3086,356 3086,133 3104,133 3124,133 3144,133 3165,133 3165,337 3165,542 3165,746 3165,951 3215,951 3266,951 3317,951 3368,951 3368,969 3368,987 3368,1005 3368,1024 " id="polygon830" />
		          <polygon points="3833,140 3806,229 3779,319 3751,408 3724,498 3712,529 3700,570 3686,620 3671,680 3671,765 3671,851 3671,937 3671,1024 3651,1024 3631,1024 3611,1024 3591,1024 3591,937 3591,851 3591,765 3591,680 3587,657 3581,634 3574,610 3568,586 3555,550 3546,524 3540,506 3538,498 3510,409 3483,319 3456,229 3429,140 3429,138 3429,137 3429,135 3429,133 3448,133 3469,133 3490,133 3510,133 3540,244 3570,356 3600,467 3632,579 3661,467 3690,356 3720,245 3752,133 3771,133 3792,133 3812,133 3833,133 3833,135 3833,137 3833,138 3833,140 " id="polygon831" />
		          <polygon points="4234,204 4199,204 4165,204 4131,204 4096,204 4096,408 4096,613 4096,818 4096,1024 4076,1024 4057,1024 4037,1024 4017,1024 4017,818 4017,613 4017,408 4017,204 3982,204 3948,204 3913,204 3879,204 3879,186 3879,169 3879,151 3879,133 3966,133 4055,133 4144,133 4234,133 4234,150 4234,167 4234,185 4234,204 " id="polygon832" />
		          <polygon points="4410,1024 4390,1024 4370,1024 4350,1024 4331,1024 4331,801 4331,578 4331,356 4331,133 4350,133 4369,133 4389,133 4410,133 4410,356 4410,578 4410,801 4410,1024 " id="polygon833" />
		          <polygon points="4904,959 4902,972 4899,985 4893,996 4885,1006 4875,1013 4865,1019 4854,1022 4841,1024 4785,1024 4729,1024 4673,1024 4617,1024 4603,1022 4591,1019 4580,1013 4571,1006 4563,996 4558,985 4555,972 4555,959 4555,902 4555,846 4555,790 4555,733 4573,733 4593,733 4612,733 4631,733 4631,787 4631,841 4631,895 4631,951 4679,951 4728,951 4776,951 4825,951 4825,898 4825,846 4825,793 4825,740 4764,666 4703,592 4642,518 4581,445 4568,428 4560,412 4556,395 4555,378 4555,333 4555,288 4555,243 4555,198 4555,184 4558,172 4563,161 4571,152 4580,144 4591,138 4603,134 4617,133 4673,133 4729,133 4785,133 4841,133 4854,134 4866,138 4877,143 4885,152 4891,161 4897,172 4902,184 4904,198 4904,249 4904,300 4904,351 4904,403 4884,403 4864,403 4844,403 4825,403 4825,353 4825,303 4825,253 4825,204 4776,204 4728,204 4679,204 4631,204 4631,251 4631,298 4631,344 4631,392 4692,465 4754,538 4816,612 4878,687 4888,702 4897,719 4902,735 4904,754 4904,805 4904,856 4904,907 4904,959 " id="polygon834" />
		        </g>
		      </g>
		      <g transform="translate(721.8904,-265.7991)" id="g1478" />
		    </g>
		  </g>
		</svg>
      </fo:instream-foreign-object>
    </fo:block>
    <fo:block id="title" font-size="24pt" text-align="center" space-before="10pt"><xsl:value-of select="$data[@descriptionkey='session.dashBoard']/@description"/></fo:block>
  </fo:flow>
  </fo:page-sequence>


  <fo:page-sequence master-reference="A4" initial-page-number="1">
  <fo:static-content flow-name="xsl-region-after" font-size="8pt">
    <fo:table table-layout="fixed">
    <fo:table-column column-width="15mm"/>
    <fo:table-column column-width="17cm"/>
    <fo:table-column column-width="15mm"/>
    <fo:table-body>
    <fo:table-row>
    <fo:table-cell><fo:block text-align="right" font-size="6pt"></fo:block></fo:table-cell>
    <fo:table-cell><fo:block text-align="center" font-size="6pt"><xsl:value-of select="$product"/>&#xA0;<xsl:value-of select="$release"/></fo:block></fo:table-cell>
    <fo:table-cell><fo:block text-align="right" font-size="6pt"><fo:page-number/>/<fo:page-number-citation ref-id="theEnd" /></fo:block></fo:table-cell>
    </fo:table-row>
    </fo:table-body>
    </fo:table>
  </fo:static-content>
  <fo:flow flow-name="xsl-region-body" font-size="8pt">
    <fo:block id="toc" break-before="page">
      <fo:table table-layout="fixed">
      <fo:table-column column-width="5mm"/>
      <fo:table-column column-width="18cm"/>
      <fo:table-column column-width="5mm" text-align="right"/>
      <fo:table-body>
      <fo:table-row>
      <fo:table-cell font-size="10pt" number-columns-spanned="2"><fo:block><fo:basic-link internal-destination="user"><xsl:value-of select="$data[@context=2 and @num=1]/@description"/></fo:basic-link></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><fo:page-number-citation ref-id="user" /></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:if test="workspace">
        <fo:table-row>
        <xsl:variable name="firstworkspace" select="workspace[position()=1]/@objectid"/>
        <fo:table-cell font-size="10pt" number-columns-spanned="3" space-before="5pt"><fo:block><fo:basic-link internal-destination="workspace{$firstworkspace}"><xsl:value-of select="$data[@descriptionkey='session.workspace']/@description"/></fo:basic-link></fo:block></fo:table-cell>
        </fo:table-row>
        <xsl:for-each select="workspace">
          <xsl:sort select="@name"/>
	  	  <xsl:variable name="desc" select="@descriptionkey"/>
          <fo:table-row>
          <fo:table-cell><fo:block/></fo:table-cell>
          <fo:table-cell><fo:block padding-left="1cm"><fo:basic-link internal-destination="workspace{@objectid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fo:basic-link></fo:block></fo:table-cell>
          <fo:table-cell><fo:block><fo:page-number-citation ref-id="workspace{@objectid}" /></fo:block></fo:table-cell>
          </fo:table-row>
        </xsl:for-each>
      </xsl:if>
      <xsl:if test="query">
        <fo:table-row>
        <xsl:variable name="firstquery" select="query[position()=1]/@objectid"/>
        <fo:table-cell font-size="10pt" number-columns-spanned="3" space-before="5pt"><fo:block><fo:basic-link internal-destination="query{$firstquery}"><xsl:value-of select="$data[@descriptionkey='session.query']/@description"/></fo:basic-link></fo:block></fo:table-cell>
        </fo:table-row>
        <xsl:for-each select="query">
          <xsl:sort select="@name"/>
	  	  <xsl:variable name="desc" select="@descriptionkey"/>
          <fo:table-row>
          <fo:table-cell><fo:block/></fo:table-cell>
          <fo:table-cell><fo:block padding-left="1cm"><fo:basic-link internal-destination="query{@objectid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fo:basic-link></fo:block></fo:table-cell>
          <fo:table-cell><fo:block><fo:page-number-citation ref-id="query{@objectid}" /></fo:block></fo:table-cell>
          </fo:table-row>
        </xsl:for-each>
      </xsl:if>
      <fo:table-row>
      <fo:table-cell font-size="10pt" number-columns-spanned="2" space-before="5pt"><fo:block><fo:basic-link internal-destination="task"><xsl:value-of select="$data[@descriptionkey='session.taskDescription']/@description"/></fo:basic-link></fo:block></fo:table-cell>
      <fo:table-cell><fo:block><fo:page-number-citation ref-id="task" /></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="task">
        <xsl:sort select="@name"/>
	  	  <xsl:variable name="desc" select="@descriptionkey"/>
        <fo:table-row>
        <fo:table-cell><fo:block/></fo:table-cell>
        <fo:table-cell><fo:block padding-left="1cm"><fo:basic-link internal-destination="task{@objectid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description" /></fo:basic-link></fo:block></fo:table-cell>
        <fo:table-cell><fo:block><fo:page-number-citation ref-id="task{@objectid}" /></fo:block></fo:table-cell>
        </fo:table-row>
      </xsl:for-each>
      </fo:table-body>
      </fo:table>
    </fo:block>


    <fo:block id="world"/>
    <xsl:apply-templates select="world">
      <xsl:sort select="@descriptionkey"/>
    </xsl:apply-templates>

    <fo:block id="entity"/>
    <xsl:apply-templates select="entity">
      <xsl:sort select="@descriptionkey"/>
    </xsl:apply-templates>

    <fo:block id="user"/>
    <xsl:apply-templates select="user">
      <xsl:sort select="@descriptionkey"/>
    </xsl:apply-templates>

    <fo:block id="workspace"/>
    <xsl:apply-templates select="workspace">
      <xsl:sort select="@descriptionkey"/>
    </xsl:apply-templates>

    <fo:block id="query"/>
    <xsl:apply-templates select="query">
      <xsl:sort select="@descriptionkey"/>
    </xsl:apply-templates>

    <fo:block id="report"/>
    <xsl:apply-templates select="report">
      <xsl:sort select="@descriptionkey"/>
    </xsl:apply-templates>

    <fo:block id="task" font-size="24pt" break-before="page" space-after="10pt"><xsl:value-of select="$data[@descriptionkey='session.taskGroup']/@description"/></fo:block>
    <xsl:for-each select="taskgroup">
    <xsl:sort select="@name"/>
    <xsl:variable name="taskgroupoid" select="@objectid"/>
	<xsl:variable name="desc" select="@descriptionkey"/>
    <xsl:if test="/prelytis/task[@taskgrpoid=$taskgroupoid and @parenttaskoid=0]">
      <fo:block id="taskgroup{@objectid}" font-size="16pt" space-before="10pt">
      	<xsl:value-of select="$data[@descriptionkey=$desc]/@description"/>
      </fo:block>

      <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse">
      <fo:table-column column-width="4cm"/>
      <fo:table-column column-width="6cm"/>
      <fo:table-column column-width="3cm"/>
      <fo:table-column column-width="3cm"/>
      <fo:table-column column-width="2cm"/>
      <fo:table-body>
      <fo:table-row border="0.5pt solid black" background-color="#EEEEEE">
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.name']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.startDate']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.endDate']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.frequency']/@description"/></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="/prelytis/task[@taskgrpoid=$taskgroupoid and @parenttaskoid=0]">
        <xsl:sort select="@name"/>
        <fo:table-row border="0.5pt solid black">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="task{@objectid}"><xsl:value-of select="@name"/></fo:basic-link></fo:block></fo:table-cell>
        <xsl:variable name="desc" select="@descriptionkey"/>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="task{@objectid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@startdate"/></fo:block></fo:table-cell>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@enddate"/></fo:block></fo:table-cell>
	    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@freq"/>&#xA0;
	    <xsl:variable name="timeunitoid" select="@frequnitoid"/>
	  	<xsl:for-each select="/prelytis/timeunit[@objectid=$timeunitoid]">
	  	  <xsl:variable name="desc" select="@descriptionkey"/><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/>
	   </xsl:for-each>
	   </fo:block></fo:table-cell>
       </fo:table-row>	  
        <xsl:variable name="parenttaskoid" select="@objectid"/>
        <xsl:call-template name="treetask">
          <xsl:with-param name="taskoid" select="$parenttaskoid"/>
          <xsl:with-param name="level" select="1"/>
        </xsl:call-template>
      </xsl:for-each>
      </fo:table-body>
      </fo:table>
    </xsl:if>
    </xsl:for-each>

    <xsl:apply-templates select="task">
      <xsl:sort select="@name"/>
    </xsl:apply-templates>

    <fo:block id="theEnd"/>
  </fo:flow>
  </fo:page-sequence>
</fo:root>
</xsl:template>



<!--   WORLD    -->
<xsl:template match="world">
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:block id="world{@objectid}" font-size="24pt" break-before="page" space-after="10pt"><xsl:value-of select="$data[@descriptionkey='session.world']/@description"/> - <xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block>
  <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse">
  <fo:table-column column-width="40mm"/>
  <fo:table-column column-width="50mm"/>
  <fo:table-body>
  <xsl:variable name="driveroid" select="@driveroid"/>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.name']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@name"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="/prelytis/jdbcdriver[@objectid=$driveroid]">
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.driverJDBC']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@driverclass"/></fo:block></fo:table-cell>
    </fo:table-row>
  </xsl:for-each>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.url']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@url"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.useOtherConnection']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@usedcnt"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.catalog']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@catalog"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.schema']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@schema"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.limitToCatSch']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@limittocatalogschema"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.userName']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@user"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.password']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@password"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.password']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@contpassword"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.readOnly']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@readonly"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.useDefaultParam']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@usedefault"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.resultsetType']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@resultsettype"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.resultsetConcurrency']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@resultsetconcurrency"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.fetchSize']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@fetchsize"/></fo:block></fo:table-cell>
  </fo:table-row>
  </fo:table-body>
  </fo:table>
</xsl:template>


<!--   WORKSPACE    -->
<xsl:template match="workspace">
  <xsl:variable name="workspaceoid" select="@objectid"/>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:block id="workspace{@objectid}" font-size="24pt" break-before="page" space-after="10pt"><xsl:value-of select="$data[@descriptionkey='session.workspace']/@description"/> - <xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block>
  <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse">
  <fo:table-column column-width="30mm" background-color="#EEEEEE"/>
  <fo:table-column column-width="50mm"/>
  <fo:table-body>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.name']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="@name"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>  
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.profile']/@description"/></fo:block></fo:table-cell>
  <xsl:choose>
    <xsl:when test='@profile=1'>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='profil.user']/@description"/></fo:block></fo:table-cell>
    </xsl:when>
    <xsl:when test='@profile=2'>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='profil.admin']/@description"/></fo:block></fo:table-cell>
    </xsl:when>
    <xsl:when test='@profile=3'>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='profil.superadmin']/@description"/></fo:block></fo:table-cell>
    </xsl:when>
  </xsl:choose>
  </fo:table-row>
  </fo:table-body>
  </fo:table>

  <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse" space-before="10pt">
  <fo:table-column column-width="30mm"/>
  <fo:table-column column-width="80mm"/>
  <fo:table-column column-width="18mm"/>
  <fo:table-body>
  <fo:table-row background-color="#EEEEEE">
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.type']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.level']/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="sessiongroup[@objectid!=0]">
    <xsl:variable name="sessiongrpoid" select="@objectid"/>
    <xsl:variable name="desc" select="@descriptionkey"/>
    <xsl:if test="session[@accesslevel!=0]">
      <fo:table-row background-color="#DDDDDD">
        <fo:table-cell number-columns-spanned="3" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="session[@accesslevel!=0]">
        <xsl:variable name="sessionoid" select="@sessionoid"/>
    	<xsl:variable name="desc" select="@sessionname"/>
        <fo:table-row>
        <xsl:choose>
          <xsl:when test='@sessiontype=1'>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"></fo:block></fo:table-cell>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
          </xsl:when>
          <xsl:when test='@sessiontype=2'>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:external-graphic src="file:img/doc-default.png" width="16px" height="16px"/></fo:block></fo:table-cell>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
          </xsl:when>
          <xsl:when test='@sessiontype=3'>
            <xsl:variable name="queryoid" select="@sessionoid"/>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:external-graphic src="file:img/tab-view.png" width="16px" height="16px"/></fo:block></fo:table-cell>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="query{$queryoid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
          </xsl:when>
          <xsl:when test='@sessiontype=4'>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:external-graphic src="file:img/doc-extern.png" width="16px" height="16px"/></fo:block></fo:table-cell>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
          </xsl:when>
          <xsl:when test='@sessiontype=5'>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:external-graphic src="file:img/doc-dashboard.png" width="16px" height="16px"/></fo:block></fo:table-cell>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
          </xsl:when>
          <xsl:when test='@sessiontype=6'>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:external-graphic src="file:img/doc-treetable.png" width="16px" height="16px"/></fo:block></fo:table-cell>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
          </xsl:when>
          <xsl:when test='@sessiontype=7'>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:external-graphic src="file:img/top-folder-open.png" width="16px" height="16px"/></fo:block></fo:table-cell>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
          </xsl:when>
          <xsl:when test='@sessiontype=8'>
            <xsl:variable name="queryoid" select="@sessionoid"/>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:external-graphic src="file:img/doc-default.png" width="16px" height="16px"/></fo:block></fo:table-cell>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="query{$queryoid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
          </xsl:when>
          <xsl:when test='@sessiontype=11'>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:external-graphic src="file:img/doc-treetable.png" width="16px" height="16px"/></fo:block></fo:table-cell>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
          </xsl:when>
          <xsl:when test='@sessiontype=12'>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:external-graphic src="file:img/doc-strategy-map.png" width="16px" height="16px"/></fo:block></fo:table-cell>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
          </xsl:when>
          <xsl:otherwise>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="@sessiontype"/></fo:block></fo:table-cell>
            <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
          </xsl:otherwise>
        </xsl:choose>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>
        <xsl:choose>
          <xsl:when test='@accesslevel=0'>
            <xsl:value-of select="$data[@descriptionkey='workspace.none']/@description"/>
          </xsl:when>
          <xsl:when test='@accesslevel=1'>
            <xsl:value-of select="$data[@descriptionkey='workspace.readOnly']/@description"/>
          </xsl:when>
          <xsl:when test='@accesslevel=2'>
            <xsl:value-of select="$data[@descriptionkey='workspace.all']/@description"/>
          </xsl:when>
        </xsl:choose>
        </fo:block></fo:table-cell>
        </fo:table-row>
      </xsl:for-each>
    </xsl:if>
  </xsl:for-each>
  </fo:table-body>
  </fo:table>

  <xsl:if test="perspective[@objectid!=0]">
  <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse" space-before="10pt">
  <fo:table-column column-width="50mm"/>
  <fo:table-column column-width="12mm"/>
  <fo:table-body>
  <fo:table-row background-color="#EEEEEE">
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.level']/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="perspective[@objectid!=0]">
  	<xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-row background-color="#CCCCCC">
      <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:for-each select="strategicobjective[@objectid!=0]">
      <xsl:if test="metric">
	  <xsl:variable name="desc" select="@descriptionkey"/>
      <fo:table-row background-color="#DDDDDD">
        <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block margin-left="5mm"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="metric">
        <xsl:variable name="taskoid" select="@objectid"/>
  	    <xsl:variable name="desc" select="@descriptionkey"/>
        <fo:table-row>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block margin-left="10mm"><fo:basic-link internal-destination="task{$taskoid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>
        <xsl:choose>
          <xsl:when test='@accesslevel=0'>
            <xsl:value-of select="$data[@descriptionkey='workspace.none']/@description"/>
          </xsl:when>
          <xsl:when test='@accesslevel=1'>
            <xsl:value-of select="$data[@descriptionkey='workspace.readOnly']/@description"/>
          </xsl:when>
          <xsl:when test='@accesslevel=2'>
            <xsl:value-of select="$data[@descriptionkey='workspace.all']/@description"/>
          </xsl:when>
        </xsl:choose>
        </fo:block></fo:table-cell>
        </fo:table-row>
      </xsl:for-each>
      </xsl:if>
    </xsl:for-each>
  </xsl:for-each>
  </fo:table-body>
  </fo:table>
  </xsl:if>

  <xsl:if test="persfieldvalue">
    <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse" space-before="10pt">
    <fo:table-column column-width="50mm"/>
    <fo:table-column column-width="30mm"/>
    <fo:table-column column-width="30mm"/>
    <fo:table-body>
    <fo:table-row background-color="#EEEEEE">
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.dataType']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.valueList']/@description"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:for-each select="persfieldvalue">
    <xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
    <xsl:choose>
      <xsl:when test="@datatype=12">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=-12">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String (Raw)</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=-24">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String (Crypted)</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=91">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Date</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=92">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Time</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=93">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>DateTime</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=2">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Numeric</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:otherwise>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>?????</fo:block></fo:table-cell>
      </xsl:otherwise>
    </xsl:choose>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@value"/></fo:block></fo:table-cell>
    </fo:table-row>
    </xsl:for-each>

    </fo:table-body>
    </fo:table>
  </xsl:if>
</xsl:template>


<!--   QUERY    -->
<xsl:template match="query">
  <xsl:param name="worldoid" select="@worldoid"/>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:block id="query{@objectid}" font-size="24pt" break-before="page" space-after="10pt"><xsl:value-of select="$data[@descriptionkey='session.query']/@description"/> - <xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block>
  <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse">
  <fo:table-column column-width="15mm" background-color="#EEEEEE"/>
  <fo:table-column column-width="20mm" background-color="#EEEEEE"/>
  <fo:table-column column-width="155mm"/>
  <fo:table-body>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.name']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="@name"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="/prelytis/world[@objectid=$worldoid]">
  	<fo:table-row> 
  	<xsl:variable name="desc" select="@descriptionkey"/>
  	<fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.world']/@description"/></fo:block></fo:table-cell>
  	<fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  	</fo:table-row>
  </xsl:for-each>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.type']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>
    <xsl:choose>
      <xsl:when test="@querytype=1">
        <xsl:value-of select="$data[@descriptionkey='session.querySQL']/@description"/>
      </xsl:when>
      <xsl:when test="@querytype=2">
        <xsl:value-of select="$data[@descriptionkey='session.queryDS']/@description"/>
      </xsl:when>
    </xsl:choose>
  </fo:block></fo:table-cell>
  </fo:table-row>
	
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.maxlines']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@maxlines"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.usePrpStatement']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@useprepstmt"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <xsl:variable name="comment" select="@comment"/>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='style.comment']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block font-family="monospace" white-space-collapse="false"><xsl:value-of select="$data[@descriptionkey=$comment]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>

  <xsl:for-each select="sql">
	  <xsl:if test="request">
	    <fo:table-row>
	    <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='query.sqlQuery']/@description"/></fo:block></fo:table-cell>
	    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block font-family="monospace" white-space-collapse="false"><xsl:value-of select="request/text()"/></fo:block></fo:table-cell>
	    </fo:table-row>
	  </xsl:if>
  </xsl:for-each>
  </fo:table-body>
  </fo:table>

  <xsl:for-each select="sql">
  <xsl:if test="field">
    <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse" space-before="10pt">
    <fo:table-column column-width="110mm"/>
    <fo:table-column column-width="40mm"/>
    <fo:table-column column-width="20mm"/>
    <fo:table-body>
    <fo:table-row background-color="#EEEEEE">
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.fieldName']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block font-family="monospace" white-space-collapse="false"><xsl:value-of select="$data[@descriptionkey='session.type']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.dataType']/@description"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:for-each select="field">
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@sqlcaption"/></fo:block></fo:table-cell>
    <xsl:variable name="desc" select="@headercaption"/>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
    <xsl:choose>
      <xsl:when test="@datatype=-5">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>BigInt</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=-7">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Bit</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=16">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Boolean</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=1">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Char</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=91">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Date</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=3">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Decimal</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=8">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Double</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=6">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Float</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=4">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Integer</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=0">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Null</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=2">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Numeric</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=7">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Real</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=5">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>SmallInt</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=92">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Time</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=93">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>DateTime</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=-6">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>TinyInt</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=12">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:otherwise>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>??????</fo:block></fo:table-cell>
      </xsl:otherwise>
    </xsl:choose>
    </fo:table-row>
    </xsl:for-each>

    </fo:table-body>
    </fo:table>
  </xsl:if>

  <xsl:if test="filter">
    <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse" space-before="10pt">
    <fo:table-column column-width="30mm"/>
    <fo:table-column column-width="20mm"/>
    <fo:table-column column-width="20mm"/>
    <fo:table-column column-width="30mm"/>
    <fo:table-column column-width="30mm"/>
    <fo:table-body>
    <fo:table-row background-color="#EEEEEE">
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.name']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.dataType']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.defaultValue']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.valueList']/@description"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:for-each select="filter">
    <xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@name"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
    <xsl:choose>
      <xsl:when test="@datatype=12">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=91">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Date</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=92">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Time</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=93">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>DateTime</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=2">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Numeric</fo:block></fo:table-cell>
      </xsl:when>
    </xsl:choose>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@defaultvalue"/></fo:block></fo:table-cell>
    <xsl:choose>
      <xsl:when test="@parameter='49'">
        <xsl:variable name="valuelist" select="@valuelist"/>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="query{$valuelist}"><xsl:value-of select="/prelytis/query[@objectid=$valuelist]/@description"/></fo:basic-link></fo:block></fo:table-cell>
      </xsl:when>
      <xsl:otherwise>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block></fo:block></fo:table-cell>
      </xsl:otherwise>
    </xsl:choose>
    </fo:table-row>
    </xsl:for-each>

    </fo:table-body>
    </fo:table>
  </xsl:if>
  </xsl:for-each>
</xsl:template>


<!--   REPORT    -->
<xsl:template match="report">
  <xsl:param name="queryoid" select="@queryoid"/>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:block id="report{@objectid}" font-size="24pt" break-before="page" space-after="10pt"><xsl:value-of select="$data[@descriptionkey='session.report']/@description"/> - <xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block>
  <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse">
  <fo:table-column column-width="15mm" background-color="#EEEEEE"/>
  <fo:table-column column-width="20mm" background-color="#EEEEEE"/>
  <fo:table-column column-width="155mm"/>
  <fo:table-body>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.name']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="@name"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:variable name="queryoid" select="@queryoid"/>
  <xsl:for-each select="/prelytis/query[@objectid=$queryoid]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.query']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="query{$queryoid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  <xsl:variable name="displaytypeoid" select="@displaytypeoid"/>
  <xsl:for-each select="/prelytis/displaytype[@objectid=$displaytypeoid]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='report.showView']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='filter.reportType']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>
    <xsl:choose>
      <xsl:when test="@reporttype=0">
        <xsl:value-of select="$data[@descriptionkey='session.standard']/@description"/>
      </xsl:when>
      <xsl:when test="@reporttype=2">
        <xsl:value-of select="$data[@descriptionkey='filter.crossTable']/@description"/>
      </xsl:when>
    </xsl:choose>
  </fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='report.toggleColsRows']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@colrowinversion"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='report.showFilterFirst']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@showfilterfirst"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='report.rowsPerPage']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@rowsperpage"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='report.toggleComment']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@showcomment"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='report.showRanking']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@rankactive"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='report.palmares']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@ranknblines"/></fo:block></fo:table-cell>
  </fo:table-row>
  
  <xsl:variable name="styleoid" select="@styleoid"/>
  <xsl:for-each select="/prelytis/style[@objectid=$styleoid]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='style.style']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  
  <xsl:variable name="pagelayoutoid" select="@pagelayoutoid"/>
  <xsl:for-each select="/prelytis/pagelayout[@objectid=$pagelayoutoid]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='report.pageLayout']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
   
  <xsl:variable name="colorlistoid" select="@colorlistoid"/>
  <xsl:for-each select="/prelytis/colorlist[@objectid=$colorlistoid]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='report.defaultColorList']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  
  <xsl:variable name="stylepersfieldoid" select="@stylepersfieldoid"/>
  <xsl:for-each select="/prelytis/stylepersfield[@objectid=$stylepersfieldoid]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.stylepersfield']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  
  <fo:table-row>
  <xsl:variable name="comment" select="@comment"/>
  <fo:table-cell number-columns-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='style.comment']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$comment]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </fo:table-body>
  </fo:table>

  <xsl:if test="filter">
    <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse" space-before="10pt">
    <fo:table-column column-width="30mm"/>
    <fo:table-column column-width="20mm"/>
    <fo:table-column column-width="20mm"/>
    <fo:table-column column-width="30mm"/>
    <fo:table-body>
    <fo:table-row background-color="#EEEEEE">
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.dataType']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.defaultValue']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.valueList']/@description"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:for-each select="filter">
    <fo:table-row>
    <xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
    <xsl:choose>
      <xsl:when test="@datatype=12">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=91">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Date</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=92">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Time</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=93">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>DateTime</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=2">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Numeric</fo:block></fo:table-cell>
      </xsl:when>
    </xsl:choose>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@defaultvalue"/></fo:block></fo:table-cell>
    <xsl:choose>
      <xsl:when test="@parameter='1'">
        <xsl:variable name="valuelist" select="@valuelist"/>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="query{$valuelist}"><xsl:value-of select="/prelytis/query[@objectid=$valuelist]/@description"/></fo:basic-link></fo:block></fo:table-cell>
      </xsl:when>
      <xsl:otherwise>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block></fo:block></fo:table-cell>
      </xsl:otherwise>
    </xsl:choose>
    </fo:table-row>
    </xsl:for-each>

    </fo:table-body>
    </fo:table>
  </xsl:if>

</xsl:template>

<!--   ENTITY   -->
<xsl:template match="entity">
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:block id="entity{@objectid}" font-size="24pt" break-before="page" space-after="10pt"><xsl:value-of select="$data[@descriptionkey='session.entity']/@description"/> - <xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block>
  <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse">
  <fo:table-column column-width="6cm" background-color="#EEEEEE"/>
  <fo:table-column column-width="10cm"/>
  <fo:table-body>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.name']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="@name"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </fo:table-body>
  </fo:table>

  <xsl:if test="persfieldvalue">
    <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse" space-before="10pt">
    <fo:table-column column-width="30mm"/>
    <fo:table-column column-width="30mm"/>
    <fo:table-column column-width="20mm"/>
    <fo:table-column column-width="30mm"/>
    <fo:table-body>
    <fo:table-row background-color="#EEEEEE">
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.name']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.dataType']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.defaultValue']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.valueList']/@description"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:for-each select="persfieldvalue">
 	<xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@name"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
    <xsl:choose>
      <xsl:when test="@datatype=12">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=-12">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String (Raw)</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=-24">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String (Crypted)</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=91">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Date</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=92">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Time</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=93">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>DateTime</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=2">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Numeric</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:otherwise>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>??????</fo:block></fo:table-cell>
      </xsl:otherwise>
    </xsl:choose>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@defvalue"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@value"/></fo:block></fo:table-cell>
    </fo:table-row>
    </xsl:for-each>

    </fo:table-body>
    </fo:table>
  </xsl:if>
</xsl:template>



<!--   USER    -->
<xsl:template match="user">
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:block id="user{@objectid}" font-size="24pt" break-before="page" space-after="10pt"><xsl:value-of select="$data[@descriptionkey='P_S13_O1']/@description"/> - <xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block>
  <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse">
  <fo:table-column column-width="6cm" background-color="#EEEEEE"/>
  <fo:table-column column-width="10cm"/>
  <fo:table-body>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.name']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="@name"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.actif']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@active"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.startDate']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@startdate"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.endDate']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@enddate"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.stddAccess']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@standardaccess"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.msgAccess']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@msgaccess"/></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:variable name="tmp" select="@accesspointoid"/>
  <xsl:for-each select="/prelytis/accesspoint[@objectid=$tmp]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.mobileAccess']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  <xsl:variable name="tmp" select="@workspaceoid"/>
  <xsl:for-each select="/prelytis/workspace[@objectid=$tmp]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.workspace']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="workspace{$tmp}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  <xsl:variable name="tmp" select="@entityoid"/>
  <xsl:for-each select="/prelytis/entity[@objectid=$tmp]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.entity']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="entity{$tmp}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  <xsl:variable name="tmp" select="@languageoid"/>
  <xsl:for-each select="/prelytis/language[@objectid=$tmp]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.language']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  <xsl:variable name="tmp" select="@dashboardoid"/>
  <xsl:for-each select="/prelytis/dashboard[@objectid=$tmp]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.dashBoard']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  <xsl:variable name="tmp" select="@themeoid"/>
  <xsl:for-each select="/prelytis/theme[@objectid=$tmp]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.theme']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.chartType']/@description"/></fo:block></fo:table-cell>
  <xsl:choose>
    <xsl:when test='@charttype=1'>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='chartType.applet']/@description"/></fo:block></fo:table-cell>
    </xsl:when>
    <xsl:when test='@charttype=2'>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='chartType.png']/@description"/></fo:block></fo:table-cell>
    </xsl:when>
    <xsl:when test='@charttype=3'>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='chartType.gif']/@description"/></fo:block></fo:table-cell>
    </xsl:when>
    <xsl:when test='@charttype=4'>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='chartType.jpeg']/@description"/></fo:block></fo:table-cell>
    </xsl:when>
    <xsl:when test='@charttype=5'>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='chartType.svg']/@description"/></fo:block></fo:table-cell>
    </xsl:when>
  </xsl:choose>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.profile']/@description"/></fo:block></fo:table-cell>
  <xsl:choose>
    <xsl:when test='@profile=1'>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='profil.user']/@description"/></fo:block></fo:table-cell>
    </xsl:when>
    <xsl:when test='@profile=2'>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='profil.admin']/@description"/></fo:block></fo:table-cell>
    </xsl:when>
    <xsl:when test='@profile=3'>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='profil.superadmin']/@description"/></fo:block></fo:table-cell>
    </xsl:when>
  </xsl:choose>
  </fo:table-row>
  </fo:table-body>
  </fo:table>

  <xsl:if test="persfieldvalue">
    <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse" space-before="10pt">
    <fo:table-column column-width="30mm"/>
    <fo:table-column column-width="30mm"/>
    <fo:table-column column-width="20mm"/>
    <fo:table-column column-width="30mm"/>
    <fo:table-body>
    <fo:table-row background-color="#EEEEEE">
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.name']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.dataType']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.valueList']/@description"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:for-each select="persfieldvalue">
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@name"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@description"/></fo:block></fo:table-cell>
    <xsl:choose>
      <xsl:when test="@datatype=12">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=-12">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String (Raw)</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=-24">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>String (Crypted)</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=91">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Date</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=92">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Time</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=93">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>DateTime</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@datatype=2">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Numeric</fo:block></fo:table-cell>
      </xsl:when>
      <xsl:otherwise>
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>??????</fo:block></fo:table-cell>
      </xsl:otherwise>
    </xsl:choose>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@value"/></fo:block></fo:table-cell>
    </fo:table-row>
    </xsl:for-each>

    </fo:table-body>
    </fo:table>
  </xsl:if>
</xsl:template>


<!--   TASK    -->
<xsl:template match="task">
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:block id="task{@objectid}" font-size="24pt" break-before="page" space-after="10pt"><xsl:value-of select="$data[@descriptionkey='P_S13_O19']/@description"/> - <xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block>
  <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse">
  <fo:table-column column-width="2.2cm" background-color="#EEEEEE"/>
  <fo:table-column column-width="2.8cm" background-color="#EEEEEE"/>
  <fo:table-column column-width="5cm"/>
  <fo:table-body>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.name']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="@name"/></fo:block></fo:table-cell>
  </fo:table-row>
  <fo:table-row>
  <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.description']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:variable name="tmp" select="@tasktypeoid"/>
  <xsl:for-each select="/prelytis/tasktype[@objectid=$tmp]">
  <fo:table-row>
  <xsl:variable name="desc" select="@descriptionkey"/>
  <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.taskType']/@description"/></fo:block></fo:table-cell>
  <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
  </fo:table-row>
  </xsl:for-each>
  <xsl:if test="@parenttaskoid=0">
    <xsl:variable name="tmp" select="@taskgrpoid"/>
  	<xsl:for-each select="/prelytis/taskgroup[@objectid=$tmp]">
    <fo:table-row>
  	<xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.taskGroup']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="taskgroup{$tmp}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
    </fo:table-row>
    </xsl:for-each>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.startDate']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@startdate"/></fo:block></fo:table-cell>
    </fo:table-row>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.endDate']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@enddate"/></fo:block></fo:table-cell>
    </fo:table-row>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.frequency']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@freq"/>
    <xsl:variable name="timeunitoid" select="@frequnitoid"/>
  	<xsl:for-each select="/prelytis/timeunit[@objectid=$timeunitoid]">
  	  <xsl:variable name="desc" select="@descriptionkey"/>&#xA0;<xsl:value-of select="$data[@descriptionkey=$desc]/@description"/>
    </xsl:for-each>
    </fo:block></fo:table-cell>
    </fo:table-row>
  	<xsl:variable name="comment" select="@commentkey"/>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='style.comment']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$comment]/@description"/></fo:block></fo:table-cell>
    </fo:table-row>
  </xsl:if>
  
  <xsl:if test="taskdatamart">
  <xsl:for-each select="taskdatamart">
  <xsl:choose>
    <xsl:when test="@sourcetype='1' or @sourcetype='2'">
      <fo:table-row>
      <fo:table-cell number-rows-spanned="4" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.source']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.type']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>XML File</fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:variable name="fileoid" select="@sourceoid"/>
  	  <xsl:for-each select="/prelytis/file[@objectid=$fileoid]">
      <fo:table-row>
  	  <xsl:variable name="desc" select="@descriptionkey"/>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.directory']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/> (<xsl:value-of select="$data[@descriptionkey=$desc]/@directory"/>)</fo:block></fo:table-cell>
      </fo:table-row>
      </xsl:for-each>
      <fo:table-row>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.file']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@deletesourceafter"/></fo:block></fo:table-cell>
      </fo:table-row>
      <fo:table-row>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.delete']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@sourcefile"/></fo:block></fo:table-cell>
      </fo:table-row>
    </xsl:when>
    <xsl:when test="@sourcetype='3'">
      <fo:table-row>
      <fo:table-cell number-rows-spanned="2" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.source']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.type']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Query</fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:variable name="queryoid" select="@sourceoid"/>
  	  <xsl:for-each select="/prelytis/query[@objectid=$queryoid]">
      <fo:table-row>
  	  <xsl:variable name="desc" select="@descriptionkey"/>
      <xsl:variable name="queryoid" select="@sourceoid"/>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.query']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="query{$queryoid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
      </fo:table-row>
      </xsl:for-each>
    </xsl:when>
  </xsl:choose>
  
  
  <xsl:choose>
    <xsl:when test="@transformationtype='2'">
      <fo:table-row>
      <fo:table-cell number-rows-spanned="3" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.transformation']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.type']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>XSL</fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:variable name="fileoid" select="@transformationoid"/>
  	  <xsl:for-each select="/prelytis/file[@objectid=$fileoid]">
      <fo:table-row>
  	  <xsl:variable name="desc" select="@descriptionkey"/>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.directory']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/> (<xsl:value-of select="$data[@descriptionkey=$desc]/@directory"/>)</fo:block></fo:table-cell>
      </fo:table-row>
      </xsl:for-each>
      <fo:table-row>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.fileXSL']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@transformationfile"/></fo:block></fo:table-cell>
      </fo:table-row>
    </xsl:when>
    <xsl:when test="@transformationtype='1'">
      <fo:table-row>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.transformation']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.type']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.none']/@description"/></fo:block></fo:table-cell>
      </fo:table-row>
    </xsl:when>
  </xsl:choose>

  <xsl:choose>
    <xsl:when test="@destinationtype='1'">
      <fo:table-row>
      <fo:table-cell number-rows-spanned="4" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.destination']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.type']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>Table</fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:variable name="worldoid" select="@destinationoid"/>
  	  <xsl:for-each select="/prelytis/world[@objectid=$worldoid]">
      <fo:table-row>
  	  <xsl:variable name="desc" select="@descriptionkey"/>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.world']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
      </fo:table-row>
      </xsl:for-each>
      <fo:table-row>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='task.table']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@destination"/></fo:block></fo:table-cell>
      </fo:table-row>
      <fo:table-row>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='task.clearFirst']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@destinationclearfirst"/></fo:block></fo:table-cell>
      </fo:table-row>
    </xsl:when>
    <xsl:when test="@destinationtype='2' or @destinationtype='3' or @destinationtype='4' or @destinationtype='5' or @destinationtype='6' or @destinationtype='7' or @destinationtype='8'">
      <fo:table-row>
      <fo:table-cell number-rows-spanned="3" border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey='session.destination']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.type']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block>File</fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:variable name="destoid" select="@destinationoid"/>
  	  <xsl:for-each select="/prelytis/file[@objectid=$destoid]">
      <fo:table-row>
  	  <xsl:variable name="desc" select="@descriptionkey"/>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.directory']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
      </fo:table-row>
      </xsl:for-each>
      <fo:table-row>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.file']/@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:value-of select="@destination"/></fo:block></fo:table-cell>
      </fo:table-row>
    </xsl:when>
  </xsl:choose>
  </xsl:for-each>
  </xsl:if>

  <xsl:if test="taskmetric">
  <xsl:for-each select="taskmetric">
  	<xsl:variable name="reportoid" select="@reportoid"/>
  	<xsl:variable name="fieldname" select="@fieldname"/>
    <xsl:for-each select="/prelytis/report[@objectid=$reportoid]">
    <fo:table-row>
  	<xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.report']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:basic-link internal-destination="report{$reportoid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
    </fo:table-row>
    </xsl:for-each>
    <xsl:for-each select="/prelytis/report[@objectid=$reportoid]/avlfield[@name=$fieldname]">
    <xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.fieldName']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
    </fo:table-row>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-rows-spanned="2"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.threshold']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:external-graphic src="file:img/theme2/Warn.png" width="16px" height="16px"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/>&#xA0;<xsl:value-of select="@operator"/>&#xA0;<xsl:value-of select="@threshold1"/></fo:block></fo:table-cell>
    </fo:table-row>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:external-graphic src="file:img/theme2/Error.png" width="16px" height="16px"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/>&#xA0;<xsl:value-of select="@operator"/>&#xA0;<xsl:value-of select="@threshold2"/></fo:block></fo:table-cell>
    </fo:table-row>
    </xsl:for-each>
  </xsl:for-each>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.sendMessage']/@description"/></fo:block></fo:table-cell>
    <xsl:choose>
      <xsl:when test="@sendmail=3">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.usersHavingAccess']/@description"/>&#xA0;and&#xA0;<xsl:value-of select="$data[@descriptionkey='session.additionalUsers']/@description"/></fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@sendmail=2">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.additionalUsers']/@description"/></fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@sendmail=1">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.usersHavingAccess']/@description"/>&#xA0;<xsl:value-of select="@email"/></fo:block></fo:table-cell>
      </xsl:when>
      <xsl:otherwise>
       <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle">no mail</fo:block></fo:table-cell>
      </xsl:otherwise>
    </xsl:choose>
    </fo:table-row>
  </xsl:if>

  <xsl:if test="taskcontrol">
  <xsl:for-each select="taskcontrol">
    <xsl:variable name="reportoid" select="@reportoid"/>
  	<xsl:variable name="fieldname" select="@queryheadercaption"/>
    <xsl:for-each select="/prelytis/report[@objectid=$reportoid]">
    <fo:table-row>
  	<xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.report']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:basic-link internal-destination="report{$reportoid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
    </fo:table-row>
    </xsl:for-each>
    <xsl:for-each select="/prelytis/report[@objectid=$reportoid]/avlfield[@name=$fieldname]">
    <xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.fieldName']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
    </fo:table-row>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-rows-spanned="2"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.threshold']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:external-graphic src="file:img/theme2/Warn.png" width="16px" height="16px"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/>&#xA0;<xsl:value-of select="@operator"/>&#xA0;<xsl:value-of select="@threshold1"/></fo:block></fo:table-cell>
    </fo:table-row>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:external-graphic src="file:img/theme2/Error.png" width="16px" height="16px"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/>&#xA0;<xsl:value-of select="@operator"/>&#xA0;<xsl:value-of select="@threshold2"/></fo:block></fo:table-cell>
    </fo:table-row>
    </xsl:for-each>
  </xsl:for-each>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.sendMessage']/@description"/></fo:block></fo:table-cell>
    <xsl:choose>
      <xsl:when test="@sendmail=3">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.usersHavingAccess']/@description"/>&#xA0;and&#xA0;<xsl:value-of select="$data[@descriptionkey='session.additionalUsers']/@description"/></fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@sendmail=2">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.additionalUsers']/@description"/></fo:block></fo:table-cell>
      </xsl:when>
      <xsl:when test="@sendmail=1">
        <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey='session.usersHavingAccess']/@description"/>&#xA0;<xsl:value-of select="@email"/></fo:block></fo:table-cell>
      </xsl:when>
      <xsl:otherwise>
       <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle">no mail</fo:block></fo:table-cell>
      </xsl:otherwise>
    </xsl:choose>
    </fo:table-row>
  </xsl:if>

  <xsl:if test="taskscript">
  <xsl:for-each select="taskscript">
    <xsl:variable name="fileoid" select="@fileoid"/>
    <xsl:for-each select="/prelytis/file[@objectid=$fileoid]">
    <fo:table-row>
  	<xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.directory']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:block></fo:table-cell>
    </fo:table-row>
    </xsl:for-each>
    <fo:table-row>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.file']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><xsl:value-of select="@filename"/></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:variable name="worldoid" select="@worldoid"/>
    <xsl:for-each select="/prelytis/world[@objectid=$worldoid]">
    <fo:table-row>
  	<xsl:variable name="desc" select="@descriptionkey"/>
    <fo:table-cell border="0.5pt solid black" padding="2pt" number-columns-spanned="2"><fo:block><xsl:value-of select="$data[@descriptionkey='session.world']/@description"/></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block vertical-align="middle"><fo:basic-link internal-destination="world{$worldoid}"><xsl:value-of select="$data[@descriptionkey=$desc]/@description"/></fo:basic-link></fo:block></fo:table-cell>
    </fo:table-row>
    </xsl:for-each>
  </xsl:for-each>
  </xsl:if>

  </fo:table-body>
  </fo:table>

</xsl:template>

<xsl:template name="treetask">
  <xsl:param name="taskoid"/>
  <xsl:param name="level"/>

  <xsl:for-each select="/prelytis/task[@parenttaskoid=$taskoid]">
    <fo:table-row border="0.5pt solid black">
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><xsl:attribute name="text-indent"><xsl:value-of select="$level * 15"/>pt</xsl:attribute>
    <xsl:choose>
      <xsl:when test="@exectype=1">
        <fo:external-graphic src="file:img/theme2/execonok.png"/>
      </xsl:when>
      <xsl:when test="@exectype=2">
        <fo:external-graphic src="file:img/theme2/execonko.png"/>
      </xsl:when>
    </xsl:choose>
    <fo:basic-link internal-destination="task{@objectid}"><xsl:value-of select="@name"/></fo:basic-link></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block><fo:basic-link internal-destination="task{@objectid}"><xsl:value-of select="@description"/></fo:basic-link></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border="0.5pt solid black" padding="2pt"><fo:block></fo:block></fo:table-cell>
    </fo:table-row>
    <xsl:call-template name="treetask">
      <xsl:with-param name="taskoid" select="@objectid"/>
      <xsl:with-param name="level" select="$level + 1"/>
    </xsl:call-template>
  </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
