<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="xml" indent="yes"/>
<xsl:template match="table">
<table nbcols="3">
  <definition>
    <fielddefinition col="1" name="Col1" description="Column 1" datatype="4" fieldsize="0"/>
    <fielddefinition col="2" name="Col2" description="Column 2" datatype="12" fieldsize="30"/>
    <fielddefinition col="3" name="Col3" description="Column 3" datatype="4" fieldsize="0"/>
  </definition>
  <xsl:apply-templates select="record"/>
</table>
</xsl:template>

<xsl:template match="record">
  <record>
    <field col="1"><xsl:value-of select="field[@col=1]"/></field>
    <field col="2"><xsl:value-of select="field[@col=2]"/></field>
    <field col="3"><xsl:value-of select="field[@col=3]*2"/></field>
  </record>
</xsl:template>
</xsl:stylesheet>

<!--
Datatype uses
BIGINT 	-5
BINARY 	-2
BIT 	-7
BOOLEAN 	16
CHAR 	1
DATE 	91
DECIMAL 	3
DOUBLE 	8
FLOAT 	6
INTEGER 	4
LONGVARBINARY 	-4
LONGVARCHAR 	-1
NUMERIC 	2
REAL 	7
SMALLINT 	5
TIME 	92
TIMESTAMP 	93
TINYINT 	-6
VARBINARY 	-3
VARCHAR 	12
-->
