<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:fo="http://www.w3.org/1999/XSL/Format"
        xmlns:fox="http://xml.apache.org/fop/extensions"
                version="1.0">

<xsl:output method="xml" indent="yes"/>
<xsl:template match="/docquery">
<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <fo:layout-master-set>
    <fo:simple-page-master master-name="first">
      <xsl:attribute name="margin-right"><xsl:value-of select="pagelayout/margin/@right"/></xsl:attribute>
      <xsl:attribute name="margin-bottom"><xsl:value-of select="pagelayout/margin/@bottom"/></xsl:attribute>
      <xsl:attribute name="margin-top"><xsl:value-of select="pagelayout/margin/@top"/></xsl:attribute>
      <xsl:attribute name="margin-left"><xsl:value-of select="pagelayout/margin/@left"/></xsl:attribute>
      <xsl:attribute name="page-width"><xsl:value-of select="pagelayout/pagesize/@width"/></xsl:attribute>
      <xsl:attribute name="page-height"><xsl:value-of select="pagelayout/pagesize/@height"/></xsl:attribute>
      <fo:region-before>
        <xsl:attribute name="extent"><xsl:value-of select="pagelayout/header/@height"/></xsl:attribute>
      </fo:region-before>
      <fo:region-body>
        <xsl:attribute name="margin-top"><xsl:value-of select="pagelayout/header/@height"/></xsl:attribute>
        <xsl:attribute name="margin-bottom"><xsl:value-of select="pagelayout/footer/@height"/></xsl:attribute>
      </fo:region-body>
      <fo:region-after>
        <xsl:attribute name="extent"><xsl:value-of select="pagelayout/footer/@height"/></xsl:attribute>
      </fo:region-after>
    </fo:simple-page-master>
  </fo:layout-master-set>

  <fo:page-sequence master-reference="first">
    <fo:static-content flow-name="xsl-region-before">
      <fo:table border="0pt" table-layout="fixed" border-collapse="collapse">
        <xsl:for-each select="pagelayout/header/cell">
          <fo:table-column><xsl:if test="@width!='auto'"><xsl:attribute name="column-width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if></fo:table-column>
        </xsl:for-each>
        <fo:table-body>
        <fo:table-row>
          <xsl:for-each select="pagelayout/header/cell">
          <fo:table-cell border="0pt" padding="2pt"><fo:block>
            <xsl:if test="@backcolor"><xsl:attribute name="background-color"><xsl:value-of select="@backcolor"/></xsl:attribute></xsl:if>
            <xsl:if test="@forecolor"><xsl:attribute name="color"><xsl:value-of select="@forecolor"/></xsl:attribute></xsl:if>
            <xsl:if test="@font-family"><xsl:attribute name="font-family"><xsl:value-of select="@font-family"/></xsl:attribute></xsl:if>
            <xsl:if test="@font-size"><xsl:attribute name="font-size">
            <xsl:variable name="font-size" select="@font-size"/>
            <xsl:choose>
              <xsl:when test="$font-size='xx-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-small"/></xsl:when>
              <xsl:when test="$font-size='x-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-small"/></xsl:when>
              <xsl:when test="$font-size='small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@small"/></xsl:when>
              <xsl:when test="$font-size='medium'"><xsl:value-of select="/docquery/pagelayout/fontsize/@medium"/></xsl:when>
              <xsl:when test="$font-size='large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@large"/></xsl:when>
              <xsl:when test="$font-size='x-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-large"/></xsl:when>
              <xsl:when test="$font-size='xx-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-large"/></xsl:when>
            </xsl:choose>
            </xsl:attribute></xsl:if>
            <xsl:if test="@font-style"><xsl:attribute name="font-style"><xsl:value-of select="@font-style"/></xsl:attribute></xsl:if>
            <xsl:if test="@font-weight"><xsl:attribute name="font-weight"><xsl:value-of select="@font-weight"/></xsl:attribute></xsl:if>
            <xsl:if test="@text-align"><xsl:attribute name="text-align"><xsl:value-of select="@text-align"/></xsl:attribute></xsl:if>
            <xsl:choose>
              <xsl:when test="@content-type=-1"><xsl:value-of select="@content"/></xsl:when>
              <xsl:when test="@content-type=0"></xsl:when>
              <xsl:when test="@content-type=1"><fo:page-number/>/<fo:page-number-citation ref-id="theEnd"/></xsl:when>
              <xsl:when test="@content-type=2"><fo:page-number/></xsl:when>
              <xsl:when test="@content-type=3"><xsl:value-of select="/docquery/@date"/></xsl:when>
              <xsl:when test="@content-type=4"><xsl:value-of select="/docquery/@datetime"/></xsl:when>
              <xsl:when test="@content-type=5"><xsl:value-of select="/docquery/@time"/></xsl:when>
              <xsl:when test="@content-type=6"><xsl:value-of select="/docquery/dbinfo/@description"/>&#xA0;<xsl:value-of select="/docquery/dbinfo/@release"/></xsl:when>
            </xsl:choose>
          </fo:block></fo:table-cell>
          </xsl:for-each>
        </fo:table-row>
        </fo:table-body>
      </fo:table>
    </fo:static-content>

    <fo:static-content flow-name="xsl-region-after">
      <fo:table border="0pt" table-layout="fixed" border-collapse="collapse" space-before="10pt">
        <xsl:for-each select="pagelayout/footer/cell">
          <fo:table-column><xsl:if test="@width!='auto'"><xsl:attribute name="column-width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if></fo:table-column>
        </xsl:for-each>
        <fo:table-body>
        <fo:table-row>
          <xsl:for-each select="pagelayout/footer/cell">
          <fo:table-cell border="0pt" padding="2pt"><fo:block>
          <xsl:if test="@backcolor"><xsl:attribute name="background-color"><xsl:value-of select="@backcolor"/></xsl:attribute></xsl:if>
          <xsl:if test="@forecolor"><xsl:attribute name="color"><xsl:value-of select="@forecolor"/></xsl:attribute></xsl:if>
          <xsl:if test="@font-family"><xsl:attribute name="font-family"><xsl:value-of select="@font-family"/></xsl:attribute></xsl:if>
          <xsl:if test="@font-size"><xsl:attribute name="font-size">
          <xsl:variable name="font-size" select="@font-size"/>
          <xsl:choose>
            <xsl:when test="$font-size='xx-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-small"/></xsl:when>
            <xsl:when test="$font-size='x-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-small"/></xsl:when>
            <xsl:when test="$font-size='small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@small"/></xsl:when>
            <xsl:when test="$font-size='medium'"><xsl:value-of select="/docquery/pagelayout/fontsize/@medium"/></xsl:when>
            <xsl:when test="$font-size='large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@large"/></xsl:when>
            <xsl:when test="$font-size='x-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-large"/></xsl:when>
            <xsl:when test="$font-size='xx-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-large"/></xsl:when>
          </xsl:choose>
          </xsl:attribute></xsl:if>
          <xsl:if test="@font-style"><xsl:attribute name="font-style"><xsl:value-of select="@font-style"/></xsl:attribute></xsl:if>
          <xsl:if test="@font-weight"><xsl:attribute name="font-weight"><xsl:value-of select="@font-weight"/></xsl:attribute></xsl:if>
          <xsl:if test="@text-align"><xsl:attribute name="text-align"><xsl:value-of select="@text-align"/></xsl:attribute></xsl:if>
            <xsl:choose>
              <xsl:when test="@content-type=-1"><xsl:value-of select="@content"/></xsl:when>
              <xsl:when test="@content-type=0"></xsl:when>
              <xsl:when test="@content-type=1"><fo:page-number/>/<fo:page-number-citation ref-id="theEnd"/></xsl:when>
              <xsl:when test="@content-type=2"><fo:page-number/></xsl:when>
              <xsl:when test="@content-type=3"><xsl:value-of select="/docquery/@date"/></xsl:when>
              <xsl:when test="@content-type=4"><xsl:value-of select="/docquery/@datetime"/></xsl:when>
              <xsl:when test="@content-type=5"><xsl:value-of select="/docquery/@time"/></xsl:when>
              <xsl:when test="@content-type=6"><xsl:value-of select="/docquery/dbinfo/@description"/>&#xA0;<xsl:value-of select="/docquery/dbinfo/@release"/></xsl:when>
            </xsl:choose>
          </fo:block></fo:table-cell>
          </xsl:for-each>
        </fo:table-row>
        </fo:table-body>
      </fo:table>
    </fo:static-content>

    <fo:flow flow-name="xsl-region-body">
      <fo:block space-before.optimum="3pt" font-size="10pt" space-after.optimum="20pt">
        <xsl:apply-templates select="table"/>
        <xsl:apply-templates select="query"/>
      </fo:block>
      <fo:block id="theEnd"/>
    </fo:flow>
  </fo:page-sequence>
</fo:root>
</xsl:template>


<xsl:template match="table">
<fo:block font-size="14pt" space-after="10pt"><xsl:value-of select="/docquery/query/@description"/></fo:block>
  <fo:table border="0.5pt solid black" table-layout="fixed" border-collapse="collapse">
  <xsl:for-each select="style">
    <fo:table-column><xsl:if test="@width!='auto'"><xsl:attribute name="column-width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if></fo:table-column>
  </xsl:for-each>
  <xsl:for-each select="row[position()=1]">
    <fo:table-header>
    <fo:table-row>
    <xsl:for-each select="cell">
      <xsl:variable name="numfield" select="@numfield"/>
      <fo:table-cell border="0.5pt solid black" padding="2pt">
        <fo:block>
        <xsl:variable name="style" select="/docquery/table/style[@numfield=$numfield]/header"/>
        <xsl:if test="$style/@backcolor"><xsl:attribute name="background-color"><xsl:value-of select="$style/@backcolor"/></xsl:attribute></xsl:if>
        <xsl:if test="$style/@forecolor"><xsl:attribute name="color"><xsl:value-of select="$style/@forecolor"/></xsl:attribute></xsl:if>
        <xsl:if test="$style/@font-family"><xsl:attribute name="font-family"><xsl:value-of select="$style/@font-family"/></xsl:attribute></xsl:if>
        <xsl:if test="$style/@font-size"><xsl:attribute name="font-size">
        <xsl:variable name="font-size" select="$style/@font-size"/>
        <xsl:choose>
          <xsl:when test="$font-size='xx-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-small"/></xsl:when>
          <xsl:when test="$font-size='x-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-small"/></xsl:when>
          <xsl:when test="$font-size='small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@small"/></xsl:when>
          <xsl:when test="$font-size='medium'"><xsl:value-of select="/docquery/pagelayout/fontsize/@medium"/></xsl:when>
          <xsl:when test="$font-size='large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@large"/></xsl:when>
          <xsl:when test="$font-size='x-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-large"/></xsl:when>
          <xsl:when test="$font-size='xx-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-large"/></xsl:when>
        </xsl:choose>
        </xsl:attribute></xsl:if>
        <xsl:if test="$style/@font-style"><xsl:attribute name="font-style"><xsl:value-of select="$style/@font-style"/></xsl:attribute></xsl:if>
        <xsl:if test="$style/@font-weight"><xsl:attribute name="font-weight"><xsl:value-of select="$style/@font-weight"/></xsl:attribute></xsl:if>
        <xsl:if test="$style/@text-align"><xsl:attribute name="text-align"><xsl:value-of select="$style/@text-align"/></xsl:attribute></xsl:if>
        <xsl:value-of select="@value"/>
        </fo:block>
      </fo:table-cell>
    </xsl:for-each>
    </fo:table-row>
    </fo:table-header>
  </xsl:for-each>

  <fo:table-body>
  <xsl:for-each select="row[position()>1]">
    <xsl:if test="@calculationtype=0">
      <fo:table-row>
      <xsl:for-each select="cell">
        <xsl:variable name="numfield" select="@numfield"/>
        <fo:table-cell border="0.5pt solid black" padding="2pt">
          <xsl:variable name="style" select="/docquery/table/style[@numfield=$numfield]/body"/>
          <fo:block>
          <xsl:if test="$style/@backcolor"><xsl:attribute name="background-color"><xsl:value-of select="$style/@backcolor"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@forecolor"><xsl:attribute name="color"><xsl:value-of select="$style/@forecolor"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-family"><xsl:attribute name="font-family"><xsl:value-of select="$style/@font-family"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-size"><xsl:attribute name="font-size">
          <xsl:variable name="font-size" select="$style/@font-size"/>
          <xsl:choose>
            <xsl:when test="$font-size='xx-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-small"/></xsl:when>
            <xsl:when test="$font-size='x-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-small"/></xsl:when>
            <xsl:when test="$font-size='small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@small"/></xsl:when>
            <xsl:when test="$font-size='medium'"><xsl:value-of select="/docquery/pagelayout/fontsize/@medium"/></xsl:when>
            <xsl:when test="$font-size='large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@large"/></xsl:when>
            <xsl:when test="$font-size='x-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-large"/></xsl:when>
            <xsl:when test="$font-size='xx-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-large"/></xsl:when>
          </xsl:choose>
          </xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-style"><xsl:attribute name="font-style"><xsl:value-of select="$style/@font-style"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-weight"><xsl:attribute name="font-weight"><xsl:value-of select="$style/@font-weight"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@text-align"><xsl:attribute name="text-align"><xsl:value-of select="$style/@text-align"/></xsl:attribute></xsl:if>
          <xsl:value-of select="@value"/>
          </fo:block>
        </fo:table-cell>
      </xsl:for-each>
      </fo:table-row>
    </xsl:if>
    <xsl:if test="@calculationtype=1">
      <fo:table-row>
      <xsl:for-each select="cell">
        <xsl:variable name="numfield" select="@numfield"/>
        <fo:table-cell border="0.5pt solid black" padding="2pt">
          <xsl:variable name="style" select="/docquery/table/style[@numfield=$numfield]/subtotal"/>
          <fo:block>
          <xsl:if test="$style/@backcolor"><xsl:attribute name="background-color"><xsl:value-of select="$style/@backcolor"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@forecolor"><xsl:attribute name="color"><xsl:value-of select="$style/@forecolor"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-family"><xsl:attribute name="font-family"><xsl:value-of select="$style/@font-family"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-size"><xsl:attribute name="font-size">
          <xsl:variable name="font-size" select="$style/@font-size"/>
          <xsl:choose>
            <xsl:when test="$font-size='xx-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-small"/></xsl:when>
            <xsl:when test="$font-size='x-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-small"/></xsl:when>
            <xsl:when test="$font-size='small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@small"/></xsl:when>
            <xsl:when test="$font-size='medium'"><xsl:value-of select="/docquery/pagelayout/fontsize/@medium"/></xsl:when>
            <xsl:when test="$font-size='large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@large"/></xsl:when>
            <xsl:when test="$font-size='x-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-large"/></xsl:when>
            <xsl:when test="$font-size='xx-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-large"/></xsl:when>
          </xsl:choose>
          </xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-style"><xsl:attribute name="font-style"><xsl:value-of select="$style/@font-style"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-weight"><xsl:attribute name="font-weight"><xsl:value-of select="$style/@font-weight"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@text-align"><xsl:attribute name="text-align"><xsl:value-of select="$style/@text-align"/></xsl:attribute></xsl:if>
          <xsl:value-of select="@value"/>
          </fo:block>
        </fo:table-cell>
      </xsl:for-each>
      </fo:table-row>
    </xsl:if>
    <xsl:if test="@calculationtype=2">
      <fo:table-row>
      <xsl:for-each select="cell">
        <xsl:variable name="numfield" select="@numfield"/>
        <fo:table-cell border="0.5pt solid black" padding="2pt">
          <xsl:variable name="style" select="/docquery/table/style[@numfield=$numfield]/total"/>
          <fo:block>
          <xsl:if test="$style/@backcolor"><xsl:attribute name="background-color"><xsl:value-of select="$style/@backcolor"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@forecolor"><xsl:attribute name="color"><xsl:value-of select="$style/@forecolor"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-family"><xsl:attribute name="font-family"><xsl:value-of select="$style/@font-family"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-size"><xsl:attribute name="font-size">
          <xsl:variable name="font-size" select="$style/@font-size"/>
          <xsl:choose>
            <xsl:when test="$font-size='xx-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-small"/></xsl:when>
            <xsl:when test="$font-size='x-small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-small"/></xsl:when>
            <xsl:when test="$font-size='small'"><xsl:value-of select="/docquery/pagelayout/fontsize/@small"/></xsl:when>
            <xsl:when test="$font-size='medium'"><xsl:value-of select="/docquery/pagelayout/fontsize/@medium"/></xsl:when>
            <xsl:when test="$font-size='large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@large"/></xsl:when>
            <xsl:when test="$font-size='x-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@x-large"/></xsl:when>
            <xsl:when test="$font-size='xx-large'"><xsl:value-of select="/docquery/pagelayout/fontsize/@xx-large"/></xsl:when>
          </xsl:choose>
          </xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-style"><xsl:attribute name="font-style"><xsl:value-of select="$style/@font-style"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@font-weight"><xsl:attribute name="font-weight"><xsl:value-of select="$style/@font-weight"/></xsl:attribute></xsl:if>
          <xsl:if test="$style/@text-align"><xsl:attribute name="text-align"><xsl:value-of select="$style/@text-align"/></xsl:attribute></xsl:if>
          <xsl:value-of select="@value"/>
          </fo:block>
        </fo:table-cell>
      </xsl:for-each>
      </fo:table-row>
    </xsl:if>
  </xsl:for-each>
  </fo:table-body>
  </fo:table>
</xsl:template>

<xsl:template match="query">
  <xsl:if test="comment[@num=1]">
    <fo:block font-size="14pt" space-before="20pt" space-after="5pt">Commentaire fonctionnel</fo:block>
    <fo:block white-space-collapse="false"><xsl:value-of select="comment[@num=1]"/></fo:block>
  </xsl:if>

  <xsl:if test="qryvalue">
  <fo:block font-size="14pt" space-before="20pt" space-after="5pt">Filtre</fo:block>
  <fo:table border="none" table-layout="fixed" border-collapse="collapse">
  <fo:table-column column-width="5cm"/>
  <fo:table-column column-width="10cm"/>
  <xsl:for-each select="qryvalue">
  <fo:table-body>
    <fo:table-row>
      <fo:table-cell border="none" padding="2pt"><fo:block><xsl:value-of select="@description"/></fo:block></fo:table-cell>
      <fo:table-cell border="none" padding="2pt"><fo:block><xsl:value-of select="@defvalue"/></fo:block></fo:table-cell>
    </fo:table-row>
  </fo:table-body>
  </xsl:for-each>
  </fo:table>
  </xsl:if>
</xsl:template>
</xsl:stylesheet>
