#!/usr/bin/perl

use v5.6;
use strict;
use warnings;
use File::Basename;

our $a = "";
our $Header = "";
our $Version = "$Header: /home/businesscontent/actis/bom/global/bin/sp_count_index_archiv.pl,v 1.4 2013-05-27 06:07:39 hs Exp $a";
$Version =~ /.*:.*,v ([0-9]*\.[0-9]*).([0-9]*.[0-9]*.[0-9]*) /;
$Version = "$1 vom $2";


#-----------------------------------------------------------------------------
# DECLARATIONS
#-----------------------------------------------------------------------------

our $hashMark  = "\043";
our $HochKomma = "\042";
our $Datasep   = "\054";
our ($InFile,$OutFile);

our $program = basename($0);


#-----------------------------------------------------------------------------
# SUBROUTINES
#-----------------------------------------------------------------------------

sub usage {
	my $ErrorMessage = <<Funktionsbeschreibung;
Attention -- ERROR by using $program --
usage:  $program  source  destination
version: $Version

the processor $program numbers from REFERENCE_NO until next
REFERENCE_NO all indices with for each of this goup increased number.
The begin of numbering is 1.
Funktionsbeschreibung

print "$ErrorMessage";
}

if ($#ARGV < 1){
  # Wenn nicht zwei Parameter uebergeben wurden, dann USAGE und Abbruch
  usage;
  exit 1;
}
else  {
        print "\n\tProgramm: $program Version: $Version\n";
}

#evtl. Record-Separatoren einstellen
#Hochkomma fuer edifact.
#$/="\047";
#$\="\047";

($InFile,$OutFile, @ARGV) = @ARGV;

open (InFile, "<$InFile")
	or die "kann File <$InFile> nicht oeffnen! $!\n";
binmode(InFile , ":bytes");

open (OutFile, ">$OutFile")
	or die "kann File <$OutFile> nicht zum schreiben oeffnen! $!\n";
binmode(OutFile, ":bytes");

my ($TRUE, $FALSE) = (1,0);
my $printDirectToOutfile = $TRUE;
my $counter = 0;

while (<InFile>) {
	if (/REFERENCE_NO/) {
		$printDirectToOutfile = $FALSE;
		$counter ++;
	}

	if ($printDirectToOutfile == $FALSE) {
		my ($Name, $Value) = $_ =~ /([^=]*)=(.*)/;

		# Sonderbehandlung von Datumsfeldern ide nicht SQL konform sind #
		# 1. Datum = 0000 wird entfernt
		# 2. Datum = ohne Jahrhundert und ohne Uhrzeit wird korrigiert
		# 3. Datum = 1999201204 bei ungültigen wird abgebrochen (z.B. Monat 20) 
		#
        if ( $Name =~ /DATE/ ) { 
			my $OrigValue = $Value;
			if ($Value =~  /^0*$/) {$Value = " ";}
			if ( $Value =~ /\s/ ) { $Value = "";}
			elsif ( $Value =~ /^\d{6}$/ ) {
				$Value = 20 . $Value ; 
			}
			elsif ( $Value =~ /^\d{10}$/ ) {
				$Value = 20 . $Value . "00" ; 
			}
			elsif ( ($Value =~ /^\d{12}$/) && ($Value =~ /^\d{2}(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])/) ) {
				$Value = 20 . $Value ; 
			}
			elsif ( $Value =~ /^\d{12}$/ ) {
				$Value .= "00" ; 
			}
			$Value .= "000000" if $Value =~ /^\d{8}$/ ; 

			if ( $Value && $Value !~ /^[12]\d{3}(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])/) {
				print "ERROR ** $Name:  $OrigValue' in Line $. is corrupted\n" ; 
				exit 1;
			} 
		}
	
		print OutFile "$Name" . "_$counter=$Value\n";
		next;
	}
	print OutFile $_;
}
print OutFile "pos_count=$counter\n";

close(InFile);
close(OutFile);
