#TITLE=MessageBuilderCore
; EditPlus cliptext file v1.0 written by Mohib Miah.
; This file is provided as a default cliptext file for MessageBuilder.

#T=ANTINOLOG
ANTINOLOG ^!statement-block
#T=ARGUMENT
ARGUMENT(^!number)
#T=ARGUMENTCOUNT
ARGUMENTCOUNT()
#T=ARRAY DELETE
ARRAY DELETE ^!array FROM from [COUNT count];
#T=ARRAY INSERT
ARRAY INSERT ^!array FROM from [COUNT count];
#T=ARRAYDIM
ARRAYDIM(^!array)
#T=ARRAYSIZE
ARRAYSIZE(^!array)
#T=BLOCK
BLOCK 
{

}
#T=BOUNDED
BOUNDED LOOP ^!loopid-list [REPEAT [count]] statement-block
#T=BREAK
BREAK;
#T=CALL
CALL ^!command [EXIT exit-value];
#T=CASE
CASE selector
	WHEN const-expression-list-1 { statement-block-1 }
	WHEN const-expression-list-n { statement-block-n }
	[WHEN OTHERS { statement-block-others } ]
#T=CHARACTER
CHARACTER(code)
#T=CLOSE
CLOSE {^!INPUT | OUTPUT [SYNCHRONIZE]};
#T=CODE
CODE(character)
#T=Comment
/* this is a comment */
#T=COMPOSITE
COMPOSITE ^![STRING] statement-block
#T=CONTINUE
CONTINUE;
#T=COROUTINE
COROUTINE(^!selector)
#T=COROUTINE KILL
COROUTINE KILL ^!id;
#T=COROUTINE LOCK
COROUTINE LOCK ^!statement-block
#T=COROUTINE NEW
COROUTINE NEW ^!id [COUNT count] CALL statement;
#T=COROUTINE RESUME
COROUTINE RESUME ^!id;
#T=COROUTINE TERMINATE
COROUTINE TERMINATE ^!id;
#T=CURRENTDATE
CURRENTDATE()
#T=DATABASE CLOSE
DATABASE CLOSE [DBID dbid]^!;
#T=DATABASE EXECUTE
DATABASE EXECUTE ^!database-command [DBID dbid];
#T=DATABASE OPEN
DATABASE OPEN ^!specification [TYPE type] [DBID dbid];
#T=DATE
DATE(^!operand, format)
#T=DEBUG
DEBUG ^!{EDI | EXCEPTION | SQL | TRACE} {ON | OFF};
#T=DECLARE EXTERNAL FUNCTION
DECLARE [PUBLIC] EXTERNAL FUNCTION ^!name ( argument-list ) [ret-type];
#T=DECLARE EXTERNAL STATEMENT
DECLARE [PUBLIC] EXTERNAL STATEMENT ^!name parameter-list;
#T=DECLARE FUNCTION
DECLARE [PUBLIC] FUNCTION ^!name (argument-list) [ret-type] statement-block
#T=DECLARE MODULE
DECLARE [PUBLIC] MODULE [INTERFACE] ^!name declarations
#T=DECLARE RECORD
DECLARE [PUBLIC] RECORD ^!name declarations
#T=DECLARE STATEMENT
DECLARE [PUBLIC] STATEMENT ^!name parameter-list statement-block
#T=DECLARE VARIABLE
DECLARE [PUBLIC] [VARIABLE] ^!decl-var [= const-expression] [CONSTANT | ONCE] type;
#T=DUMP BACKTRACE
DUMP BACKTRACE [filename];
#T=DUMP COROUTINES
DUMP COROUTINES [filename];
#T=DUMP PROFILE
DUMP PROFILE [information];
#T=DUMP VARIABLES
DUMP VARIABLES [filename];
#T=ESCAPE
ESCAPE(^!string[, escch[, escape]])
#T=EXEC SQL ALTER TABLE
EXEC SQL [DBID dbid] ALTER TABLE ^!base-table-name ADD column-identifier data-type;
#T=EXEC SQL BEGIN WORK
EXEC SQL [DBID dbid]^! BEGIN WORK;
#T=EXEC SQL COMMIT WORK
EXEC SQL [DBID dbid]^! COMMIT WORK;
#T=EXEC SQL CREATE
EXEC SQL [DBID dbid] CREATE [UNIQUE] INDEX ^!index-name ON base-table-name
	(column-identifier [ASC | DESC] [, column-identifier [ASC | DESC]] ... );
#T=EXEC SQL CREATE TABLE
EXEC SQL [DBID dbid] CREATE TABLE ^!base-table-name (column-identifier data-type [NOT NULL]
	[, column-identifier data-type [NOT NULL]] ... );
#T=EXEC SQL CREATE VIEW
EXEC SQL [DBID dbid] CREATE VIEW ^!viewed-table-name [(column-identifier [, column-identifier] ... )]
	AS query-specification [WITH CHECK OPTION];
#T=EXEC SQL  DELETE FROM
EXEC SQL [DBID dbid] DELETE FROM ^!table-name [WHERE search-condition];
#T=EXEC SQL DROP INDEX
EXEC SQL [DBID dbid] DROP INDEX ^!index-name;
#T=EXEC SQL DROP TABLE
EXEC SQL [DBID dbid] DROP TABLE ^!base-table-name [CASCADE | RESTRICT];
#T=EXEC SQL DROP VIEW
EXEC SQL [DBID dbid] DROP VIEW ^!viewed-table-name [CASCADE | RESTRICT];
#T=EXEC SQL GRANT
EXEC SQL [DBID dbid] GRANT ^!{ALL [PRIVILEGES] | grant-privilege [, grant-privilege] ... }
	ON table-name TO {PUBLIC | user-name [, user-name] ... } [WITH GRANT OPTION];
#T=EXEC SQL INSERT
EXEC SQL [DBID dbid] INSERT INTO table-name [(column-identifier [, column-identifier] ...)]
	{query-specification | VALUES (insert-value [, insert-value] ...)};
#T=EXEC SQL REVOKE
EXEC SQL [DBID dbid] REVOKE ^!{ALL [PRIVILEGES] | revoke-privilege [, revoke-privilege] ... }
	ON table-name FROM {PUBLIC | user-name [, user-name] ... } [CASCADE | RESTRICT];
#T=EXEC SQL ROLLBACK WORK
EXEC SQL [DBID dbid]^! ROLLBACK WORK;
#T=EXEC SQL SELECT
EXEC SQL [DBID dbid] SELECT ^![ALL | DISTINCT] select-list
	INTO variable-list
	FROM table-list
	[WHERE sql-search]
	[GROUP BY group-list]
	[HAVING sql-search]
	[ORDER BY order-by-list]
	statement-block
#T=EXEC SQL UPDATE
EXEC SQL [DBID dbid] UPDATE ^!table-name
	SET column-identifier = update-value [, column-identifier = update-value] ...
	WHERE search-condition;
#T=EXECUTE
EXECUTE ^!program-name ARGUMENTS arguments;
#T=EXIT
EXIT [value [FORCE]];
#T=EXPORT
EXPORT ^!value AS environ-var;
#T=FIDENT
FIDENT(identifier)
#T=FILE APPEND
FILE APPEND ^!srcname TO dstname;
#T=FILE COPY
FILE COPY ^!srcname TO dstname;
#T=FILE DELETE
FILE DELETE ^!filename;
#T=FILE MOVE
FILE MOVE ^!oldname TO newname;
#T=FOR
FOR ^!loop-var = start {TO | DOWNTO} end [STEP step] statement-block
#T=FORMAT
FORMAT(^!format [, argument, ...])
#T=FROM_ISO8859
FROM_ISO8859(^!string)
#T=GETDATE
GETDATE(^!date, field-selector)
#T=IF
IF ^!
	ELSE IF 
	ELSE  
#T=IMPORT
IMPORT ^!environ-var INTO destination;
#T=INCLUDE
INCLUDE ^!filename [ONCE];
#T=INTERP_VERSION
INTERP_VERSION()
#T=IOSET
IOSET()
#T=IOSET CREATE
IOSET CREATE ^!id;
#T=IOSET DELETE
IOSET DELETE ^!id;
#T=IOSET SWITCH
IOSET SWITCH [id]^!;
#T=LOADPGM
LOADPGM ^!program-name [ID id];
#T=LOG
LOG message TYPE ^!type;
#T=NOLOG
NOLOG ^!statement-block
#T=OPEN
OPEN ^!{FILE | STRING} {INPUT | OUTPUT | APPEND} parameter
	[START start] [SIZE size] [TEXT | BINARY];
#T=PIPE CLOSE
PIPE CLOSE;
#T=PIPE OPEN
PIPE OPEN ^! [TEXT | BINARY];
#T=PIPE READ
PIPE READ ^!destination [COUNT length] [UNTIL separator];
#T=PIPE WRITE
PIPE WRITE ^!data;
#T=PRAGMA EXPORT
PRAGMA EXPORT ^!{FUNCTION | STATEMENT} name;
#T=PRINT
PRINT ^!data;
#T=PRINTERR
PRINTERR ^!data;
#T=PROGRAMINFO
PROGRAMINFO([selector])
#T=READ
READ ^!destination [COUNT length] [UNTIL separator];
#T=REGEXP
REGEXP ^!regexp STRING string [START start] [END end];
#T=RELATION
RELATION ^!element-list {; | statement-block}
#T=RELEASE
RELEASE ^![environ-var];
#T=REPEAT
REPEAT ^!statement-block WHILE test-expression;
#T=RETURN
RETURN [value];
#T=SCAN
SCAN ^!{SEGMENT | TEXT | COUNT} operand;
#T=SEGMENT
SEGMENT ^!name-list [REPEAT [count]] statement-block
#T=SEGMENT GROUP
SEGMENT GROUP ^!name-list [REPEAT [count]] statement-block
#T=SERIALIZE
SERIALIZE ^!value INTO dest;
#T=SETDATE
SETDATE ^!date FIELD field-selector VALUE new-field;
#T=SIDENT
SIDENT(^!identifier)
#T=SLEEP
SLEEP ^!time;
#T=SOURCEFILE
SOURCEFILE()
#T=SOURCELINE
SOURCELINE()
#T=SOURCEMODULE
SOURCEMODULE()
#T=SOURCEPROCEDURE
SOURCEPROCEDURE()
#T=SPLIT CLOSE
SPLIT CLOSE;
#T=SPLIT INTO
SPLIT INTO ^!outfile [{ON SEGMENT | AFTER | BEFORE} operands [SET index]];
#T=SPLIT
SPLIT OPEN^! inputfile;
#T=STRBACKWARD
STRBACKWARD(^!string, search[, start])
#T=STRFORWARD
STRFORWARD(^!string, search[, start])
#T=STRLEN
STRLEN(^!operand)
#T=STRREPEAT
STRREPEAT(^!string, count)
#T=STRMID
^!string[from, to]
#T=SUSPEND
SUSPEND ^![code];
#T=SWITCH
SWITCH ^!filename;
#T=SYSTEM
SYSTEM()
#T=THROW
THROW ^![exception];
#T=TO_ISO8859
TO_ISO8859(^!string)
#T=TRIMLEFT
TRIMLEFT(^!string[, pad])
#T=TRIMRIGHT
TRIMRIGHT(^!string[, pad])
#T=TRUNCATE
TRUNCATE(^!string)
#T=TRUNCATE
TRUNCATE ^!{ON | OFF};
#T=TRY
TRY 
{ 
	^!
}
CATCH $exception 
WHEN OTHERS 
{ 

}
#T=UNBOUNDED LOOP
UNBOUNDED LOOP ^!name-list [REPEAT [count]] statement-block
#T=UNLOADPGM
UNLOADPGM ^!program-name [ID id];
#T=UNSERIALIZE
UNSERIALIZE ^!string INTO dest;
#T=USE
USE ^!{FUNCTION | STATEMENT} external-name [FROM program-name] [ID id] AS name;
#T=WHILE
WHILE ^!test-condition 
{ 


}
#T=WITH
WITH ^!aliases statement-block


