/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.EdiComp;
import de.axway.aim.controller.lib.Event;
import de.axway.aim.controller.lib.Value;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.CtrlJobStep;
import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.JoseAppl;
import de.axway.aim.controller.master.LogProtApp;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.lib.logprot.LogProtData;
import de.axway.lib.logprot.LogProtRecvPort;
import de.axway.lib.message.Message;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnwBoss
implements LogProtData {
    private Log log = LogFactory.getLog((String)"master.AnwBoss");
    private CtrlDispAppl dispatcher;

    public AnwBoss(CtrlDispAppl dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Message handleApplConnect(LogProtRecvPort lprp, Message msg) {
        Message answer = new Message("ConnectMasterAnswer");
        String applName = null;
        int sockPort = 0;
        String sockHost = null;
        LogProtApp appl = null;
        ILogbook logbook = Logbook.getLogbook();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start: " + msg));
        }
        applName = (String)msg.get("applic");
        sockPort = (Integer)msg.get("listenSocketPort");
        sockHost = (String)msg.get("listenSocketHost");
        answer.set("protType", (Object)69);
        answer.set("answer", (Object)1);
        answer.set("applId", (Object)0);
        answer.set("autoUpdateOn", (Object)0);
        answer.set("userRights", (Object)0);
        if (this.dispatcher.isDerby()) {
            answer.set("whichDB", (Object)1);
        } else {
            answer.set("whichDB", (Object)4);
        }
        answer.set("letLineOpen", (Object)0);
        logbook.info("Application connect: '" + applName + "' from " + lprp.getPortName());
        try {
            if (applName.equals("JOSE")) {
                appl = new JoseAppl(this.dispatcher, lprp.getCallingSocket(), applName);
                answer.set("answer", (Object)0);
                answer.set("applId", (Object)((int)appl.getId()));
                answer.set("autoUpdateOn", (Object)0);
                if (lprp != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("send connect answer: " + answer));
                    }
                    lprp.send(answer);
                }
                this.dispatcher.newAppl(appl);
                answer.set("letLineOpen", (Object)1);
                ((JoseAppl)appl).start();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("JOSE started. id: " + appl.getId()));
                }
            } else {
                appl = new LogProtApp(this.dispatcher, sockPort, sockHost, applName);
                this.dispatcher.newAppl(appl);
                answer.set("answer", (Object)0);
                answer.set("applId", (Object)((int)appl.getId()));
            }
        }
        catch (Exception e) {
            answer.set("letLineOpen", (Object)0);
            answer.set("answer", (Object)1);
            this.log.error((Object)"error: ", (Throwable)e);
            this.dispatcher.removeAppl(appl.getId());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("end answer: " + answer));
        }
        return answer;
    }

    public Message handleApplDisconnect(LogProtRecvPort lprp, Message msg) {
        Message answer = new Message("DisconnectMasterAnswer");
        int applId = 0;
        ILogbook logbook = Logbook.getLogbook();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start: " + msg));
        }
        applId = (Integer)msg.get("applId");
        answer.set("protType", (Object)70);
        answer.set("answer", (Object)1);
        logbook.info("Application disconnect: '" + applId + "' from " + lprp.getPortName());
        try {
            this.dispatcher.removeAppl(applId);
            answer.set("answer", (Object)0);
        }
        catch (Exception e) {
            answer.set("answer", (Object)1);
            this.log.error((Object)"error: ", (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("end answer: " + answer));
        }
        return answer;
    }

    public Message handleJobInfoProtocol(LogProtRecvPort lprp, Message msg) {
        Message answer = new Message("JobDataAnswer");
        int applId = 0;
        int jobId = 0;
        int what = 0;
        CtrlJob cJob = null;
        CtrlJobStep cStep = null;
        Integer[] seqs = null;
        Integer[] retries = null;
        int jsInstNo = 0;
        ILogbook logbook = Logbook.getLogbook();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start: Port: " + lprp + ", msg: " + msg));
        }
        applId = (Integer)msg.get("applId");
        jobId = (Integer)msg.get("jobId");
        seqs = (Integer[])msg.get("sequenceNo");
        retries = (Integer[])msg.get("retryCounter");
        if (seqs != null && retries != null) {
            jsInstNo = seqs.length;
        }
        answer.set("protType", (Object)90);
        answer.set("answer", (Object)1);
        answer.set("what", (Object)what);
        logbook.info("Application '" + applId + "' requests job details for jobId '" + jobId + "'");
        try {
            cJob = CtrlJob.getJob(jobId, this.dispatcher);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Job info data of job: " + cJob));
            }
            if (jsInstNo == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Request info for step instance no: " + jsInstNo));
                }
                this.addEdiObjData(answer, cJob);
                if (this.addJobData(answer, cJob)) {
                    what |= 2;
                }
                if (this.addEventData(answer, cJob)) {
                    what |= 8;
                }
                answer.set("answer", (Object)0);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Request info for step: " + jobId + "/" + seqs[0] + "/" + (retries[0] + 1)));
                }
                if ((cStep = CtrlJobStep.getJobStep(jobId, seqs[0], retries[0] + 1, -1, this.dispatcher)) != null) {
                    what = 4;
                    Message[] jobSteps = new Message[]{this.getJobStepData(cStep, seqs[0].intValue() == cJob.getActiveStep())};
                    answer.set("jobSteps", (Object)jobSteps);
                    answer.set("answer", (Object)0);
                }
            }
            answer.set("what", (Object)what);
        }
        catch (Exception e) {
            answer.set("answer", (Object)1);
            this.log.error((Object)"error: ", (Throwable)e);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("end answer: " + answer));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("end answer: " + answer.getSignal() + ", answer: " + answer.get("answer")));
        }
        return answer;
    }

    private boolean addEdiObjData(Message answer, CtrlJob cJob) throws SQLException {
        Message ediObj = null;
        ediObj = this.getEdiObjData(cJob);
        if (ediObj != null) {
            answer.set("ediObjects", (Object)ediObj);
            return true;
        }
        return false;
    }

    private Message getEdiObjData(CtrlJob cJob) throws SQLException {
        if (cJob == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"end: <null>");
            }
            return null;
        }
        Message ediObj = new Message("EdiObject");
        Message[] components = null;
        Event event = cJob.getEvt();
        Iterator<Object> it = null;
        EdiComp comp2 = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start:" + cJob));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start:" + cJob.getId()));
        }
        ediObj.set("objectId", (Object)((int)event.getId()));
        ediObj.set("objectClass", (Object)this.getValOrEmptyStr(event.getAttr("OBJ_CLASS")));
        ediObj.set("sender", (Object)this.getValOrEmptyStr(event.getAttr("SENDER")));
        ediObj.set("receiver", (Object)this.getValOrEmptyStr(event.getAttr("RECEIVER")));
        ediObj.set("jobName", (Object)cJob.getName());
        ediObj.set("referenzNo", (Object)event.getRefNo());
        if (cJob.getCompSlave() != null) {
            ediObj.set("slaveName", (Object)cJob.getCompSlave().getName());
            ediObj.set("slavePort", (Object)cJob.getCompSlave().getPort());
            ediObj.set("slaveHost", (Object)cJob.getCompSlave().getHostname());
        }
        ediObj.set("objectStatus", (Object)cJob.getObjectStatus());
        ediObj.set("jobId", (Object)((int)cJob.getId()));
        if (cJob.getComps() != null && cJob.getComps().size() > 0) {
            ediObj.set("noOfComp", (Object)cJob.getCompSize());
            ediObj.set("jsName", (Object)cJob.getCurrentStepName());
            components = new Message[cJob.getCompSize()];
            TreeSet<EdiComp> sortedComps = new TreeSet<EdiComp>();
            it = cJob.getComps().iterator();
            while (it.hasNext()) {
                sortedComps.add(it.next());
            }
            int i = 0;
            for (EdiComp comp2 : sortedComps) {
                components[i] = new Message("Component");
                components[i].set("name", (Object)comp2.getName());
                components[i].set("path", (Object)comp2.getFileName());
                components[i].set("size", (Object)((int)comp2.getSize()));
                components[i].set("creationDate", (Object)new Date((long)comp2.getCreationDate() * 1000L));
                components[i].set("modificationDate", (Object)new Date((long)comp2.getModificationDate() * 1000L));
                components[i].set("compNumber", (Object)i);
                ++i;
            }
            ediObj.set("components", (Object)components);
        }
        return ediObj;
    }

    private boolean addJobData(Message answer, CtrlJob cJob) throws SQLException {
        Message job = null;
        job = this.getJobData(cJob);
        if (job != null) {
            answer.set("job", (Object)job);
            return true;
        }
        return false;
    }

    private Message getJobData(CtrlJob cJob) throws SQLException {
        String k;
        Message job = new Message("Job");
        Message[] jobSteps = null;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start:" + cJob));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start:" + (cJob == null ? "" : Long.valueOf(cJob.getId()))));
        }
        if (cJob == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"end: <null>");
            }
            return null;
        }
        job.set("jobId", (Object)((int)cJob.getId()));
        job.set("jobName", (Object)cJob.getName());
        job.set("eventId", (Object)((int)cJob.getEvt().getId()));
        job.set("jobPrevId", (Object)0);
        job.set("jobNextId", (Object)0);
        if (cJob.getTimeWindow() != null && (k = cJob.getTimeWindow().getName()) != null) {
            job.set("timewName", (Object)k);
        } else {
            job.set("timewName", (Object)"");
        }
        if (cJob.varCount() > 0 || cJob.getConst() != null && cJob.getConst().size() > 0 || cJob.getPar() != null && cJob.getPar().size() > 0) {
            Enumeration keys = cJob.getVarKeys();
            while (keys.hasMoreElements()) {
                k = keys.nextElement();
                names.add(k);
                Value val = cJob.getVar(k);
                if (val == null || val.get() == null) {
                    values.add("");
                    continue;
                }
                values.add(val.get());
            }
            keys = cJob.getConst().keys();
            while (keys.hasMoreElements()) {
                k = keys.nextElement();
                names.add(k);
                k = (String)cJob.getConst().get(k).get();
                if (k != null) {
                    values.add(k);
                    continue;
                }
                values.add("<null>");
            }
            keys = cJob.getPar().keys();
            while (keys.hasMoreElements()) {
                k = (String)keys.nextElement();
                names.add(k);
                k = (String)cJob.getPar().get(k);
                if (k != null) {
                    values.add(k);
                    continue;
                }
                values.add("<null>");
            }
            job.set("jobVarLeft", (Object)names.toArray(new String[names.size()]));
            job.set("jobVarRight", (Object)values.toArray(new String[values.size()]));
        }
        job.set("noOfJs", (Object)cJob.getStepCount());
        job.set("jobState", (Object)cJob.getOldStatus());
        CtrlJobStep iJobStep = cJob.getCurrentStep();
        if (iJobStep != null) {
            job.set("nextJobTime", (Object)new Date(((IJobStep)iJobStep).getNextExecTime()));
        } else {
            job.set("nextJobTime", (Object)new Date(0L));
        }
        job.set("jobPrio", (Object)cJob.getPrio());
        if (cJob.isSeq()) {
            job.set("jobSeq", (Object)1);
        } else {
            job.set("jobSeq", (Object)0);
        }
        jobSteps = this.getJobSteps(cJob);
        if (jobSteps != null) {
            job.set("jobSteps", (Object)jobSteps);
        }
        return job;
    }

    private Message[] getJobSteps(CtrlJob cJob) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start: " + cJob));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start: " + (cJob == null ? "" : Long.valueOf(cJob.getId()))));
        }
        if (cJob == null || cJob.getStepCount() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"end: <null>");
            }
            return null;
        }
        Object[] steps = new Message[cJob.getStepCount()];
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get " + steps.length + " job steps"));
        }
        for (int i = 0; i < steps.length; ++i) {
            CtrlJobStep step = (CtrlJobStep)cJob.getStep(i + 1);
            if (step == null) {
                this.log.error((Object)("Step " + i + " is null."));
                continue;
            }
            if (cJob.getCurrentStep() == null) {
                this.log.error((Object)("currentStep " + i + " is null."));
            }
            steps[i] = this.getJobStepData(step, i + 1 == cJob.getActiveStep());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("end: " + Arrays.toString(steps)));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"end: ");
        }
        return steps;
    }

    private Message getEventData(CtrlJob job) {
        int i;
        String[] strArr1;
        if (job == null || job.getEvt() == null) {
            this.log.debug((Object)"end: <null>");
            return null;
        }
        Event cevent = job.getEvt();
        Message event = null;
        List attr = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start: " + job));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start: " + job.getId()));
        }
        event = new Message("Event");
        event.set("eventId", (Object)((int)cevent.getId()));
        event.set("objectId", (Object)((int)cevent.getId()));
        event.set("eventType", (Object)cevent.getType());
        if (cevent.isSyncEvent()) {
            event.set("EventSyncFlag", (Object)1);
        } else {
            event.set("EventSyncFlag", (Object)0);
        }
        event.set("initiator", (Object)cevent.getInitiator());
        event.set("coreFunctionId", (Object)"");
        event.set("hostName", (Object)this.getValOrEmptyStr(cevent.getInitiatorHost()));
        attr = cevent.getAttrList();
        if (attr != null) {
            strArr1 = new String[attr.size()];
            for (i = 0; i < strArr1.length; ++i) {
                strArr1[i] = ((Attribute)attr.get(i)).toString();
                if (strArr1[i] != null) continue;
                this.log.error((Object)("event attribute " + i + " of job " + job.getId() + " is null"));
                strArr1[i] = "";
            }
            event.set("attributes", (Object)strArr1);
        }
        if ((attr = cevent.getParamList()) != null) {
            strArr1 = new String[attr.size()];
            String[] strArr2 = new String[attr.size()];
            for (i = 0; i < strArr1.length; ++i) {
                strArr1[i] = ((Attribute)attr.get(i)).getName();
                strArr2[i] = (String)((Attribute)attr.get(i)).get();
                if (strArr2[i] != null) continue;
                strArr2[i] = "";
            }
            event.set("eventParamLeft", (Object)strArr1);
            event.set("eventParamRight", (Object)strArr2);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("end: " + event));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"end:");
        }
        return event;
    }

    private boolean addEventData(Message answer, CtrlJob job) {
        Message event = null;
        event = this.getEventData(job);
        if (event != null) {
            answer.set("event", (Object)event);
            return true;
        }
        return false;
    }

    private Message getJobStepData(CtrlJobStep cStep, boolean isActiveStep) {
        Message step = null;
        Message functionCall = null;
        CtrlFunctionCall fc = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("start: isActiveStep: " + isActiveStep + "\n" + (Object)((Object)cStep)));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start: isActiveStep: " + isActiveStep + ", " + (cStep == null ? "" : cStep.getJobId() + "." + cStep.getStepNo())));
        }
        if (cStep == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"end:  <null>");
            }
            return null;
        }
        fc = cStep.getLastFc();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("fc: " + (Object)((Object)fc)));
        }
        step = new Message("JobStep");
        step.set("jobId", (Object)((int)cStep.getJobId()));
        step.set("sequenceNo", (Object)cStep.getStepNo());
        step.set("jsPrevId", (Object)0);
        step.set("jsNextId", (Object)0);
        if (null != cStep.getTimeWindow() && null != cStep.getTimeWindow().getName()) {
            step.set("jsTimewName", (Object)cStep.getTimeWindow().getName());
        }
        step.set("maxRetry", (Object)cStep.getMaxRetry());
        step.set("retryDelay", (Object)cStep.getRetryDelay());
        step.set("jsBgrExec", (Object)Boolean.FALSE);
        step.set("jsBox3selMark", (Object)Boolean.FALSE);
        step.set("applMessage", (Object)LogProtData.ApplMsgCond.bits((LogProtData.ApplMsgCond[])new LogProtData.ApplMsgCond[]{LogProtData.ApplMsgCond.AMSG_OBRW_YES, LogProtData.ApplMsgCond.AMSG_JSBRW_YES}));
        if (cStep.isSeq()) {
            step.set("sequenceFlag", (Object)Boolean.TRUE);
        } else {
            step.set("sequenceFlag", (Object)Boolean.FALSE);
        }
        step.set("timeDelay", (Object)cStep.getDelay());
        step.set("wakeupTime", (Object)new Date(0L));
        step.set("functionClassName", (Object)cStep.getName());
        step.set("jsStatus", (Object)cStep.getStatus());
        functionCall = this.getFunctionCall(cStep, fc);
        if (functionCall != null) {
            step.set("functionCall", (Object)functionCall);
        }
        step.set("nextJsTime", (Object)new Date(0L));
        step.set("jsFcMaxRuntime", (Object)cStep.getMaxExecTime());
        step.set("jsAssignMode", (Object)0);
        step.set("jsErrclass", (Object)"");
        if (fc != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Job step's FunctionCall object set, Job step already tried.");
            }
            step.set("retryCounter", (Object)(cStep.getRetry() - 1));
            if (cStep.getRetry() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Job step retry == 0, access CtrlJobStep object's data.");
                }
                step.set("jsStartTime", (Object)new Date(fc.getCreationDate()));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Only one FunctionCall retry done.");
                    this.log.debug((Object)("FunctionCall start time: " + step.get("jsStartTime")));
                }
            } else {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Job step retry > 1, read first CtrlJobStep object's data.");
                        this.log.debug((Object)("CtrlJobStep.getJobStep(" + cStep.getJobId() + ", " + cStep.getStepNo() + ", 1)"));
                    }
                    CtrlJobStep cst = CtrlJobStep.getJobStep(cStep.getJobId(), cStep.getStepNo(), 1, -1, this.dispatcher);
                    step.set("jsStartTime", (Object)new Date(cst.getLastFc().getCreationDate()));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("FunctionCall start time: " + step.get("jsStartTime")));
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)"Cannot access FC retry  1!", (Throwable)e);
                    step.set("jsStartTime", (Object)new Date(0L));
                }
            }
            if (cStep.getStatus() == 16) {
                step.set("jsEndTime", (Object)new Date(fc.getReadyDate()));
            }
            step.set("jsExitCode", (Object)fc.getRc());
        } else {
            step.set("retryCounter", (Object)0);
            if (isActiveStep) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("FunctionCall not yet executed. Access nearest valid execution time: " + step.get("jsStartTime")));
                }
                step.set("jsStartTime", (Object)new Date(cStep.getNextExecTime()));
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"FunctionCall is future step. Set ZERO date.");
                }
                step.set("jsStartTime", (Object)new Date(0L));
            }
            step.set("jsEndTime", (Object)new Date(0L));
            step.set("jsExitCode", (Object)0);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("end: " + step));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"end:");
        }
        return step;
    }

    private Message getFunctionCall(CtrlJobStep step, CtrlFunctionCall fc) {
        Message fCall = null;
        CtrlSlave slave = null;
        String str = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start: " + (Object)((Object)step) + ", " + (Object)((Object)fc)));
        }
        if (step == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"end: <null>");
            }
            return null;
        }
        fCall = new Message("FunctionCall");
        fCall.set("jobId", (Object)((int)step.getJobId()));
        fCall.set("jsSequenceNo", (Object)step.getStepNo());
        fCall.set("fctnCallLevel", (Object)0);
        fCall.set("maxSlaveLoad", (Object)0);
        fCall.set("nicePrio", (Object)0);
        fCall.set("fcMaxRetry", (Object)0);
        fCall.set("createsResult", (Object)0);
        fCall.set("curPidFh", (Object)0);
        fCall.set("curPidCf", (Object)0);
        this.setGroupNameAndMaxCall(step, fCall);
        try {
            str = step.getCmdLine();
            if (str == null) {
                fCall.set("functionCall", (Object)">>> undefined <<");
            } else {
                fCall.set("functionCall", (Object)str);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"getCmdLine", (Throwable)e);
            fCall.set("functionCall", (Object)">>> undefined <<");
        }
        if (fc == null) {
            fCall.set("jsCurrRetry", (Object)0);
            fCall.set("fcSequenceNo", (Object)0);
            fCall.set("fcCurrRetry", (Object)0);
            fCall.set("slaveName", (Object)"");
            fCall.set("realFunctionCall", fCall.get("functionCall"));
            try {
                if (step.getSlaves().size() > 0) {
                    slave = step.getSlaves().get(0).getSlave();
                }
            }
            catch (CfgException e) {
                this.log.error((Object)("getSlaves(" + step.getJobId() + "): " + e.getMessage()));
            }
            this.addResultData(fCall, step, null);
        } else {
            fCall.set("jsCurrRetry", (Object)(step.getRetry() - 1));
            fCall.set("fcSequenceNo", (Object)fc.getSeqNo());
            fCall.set("fcCurrRetry", (Object)fc.getSeqRetry());
            if (fc.getReal() != null) {
                fCall.set("realFunctionCall", (Object)fc.getReal());
            }
            fCall.set("currCalls", fCall.get("fcCurrRetry"));
            fCall.set("fcStartTime", (Object)new Date(fc.getCreationDate()));
            fCall.set("fcEndTime", (Object)new Date(fc.getReadyDate()));
            if (fc.getSlave() != null) {
                slave = this.dispatcher.getSlave(fc.getSlave());
            }
            this.addResultData(fCall, step, fc);
        }
        if (slave != null) {
            fCall.set("slaveName", (Object)slave.getName());
            fCall.set("slavePort", (Object)slave.getPort());
            fCall.set("slaveHost", (Object)slave.getHostname());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("end: " + fCall));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"end:");
        }
        return fCall;
    }

    private void setGroupNameAndMaxCall(CtrlJobStep step, Message fCall) {
        try {
            String groupName = this.getValOrEmptyStr(step.getGroupName());
            fCall.set("groupName", (Object)groupName);
            if (groupName == "") {
                fCall.set("maxCalls", (Object)0);
            } else {
                fCall.set("maxCalls", (Object)step.getMaxGroupCalls());
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.error((Object)"Ignoring error at group name access.", (Throwable)e);
            }
            fCall.set("maxCalls", (Object)0);
        }
    }

    private Message getResultData(CtrlJobStep step, CtrlFunctionCall fc) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start: " + (Object)((Object)step) + ", " + (Object)((Object)fc)));
        }
        if (step == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"end: <null>");
            }
            return null;
        }
        Message result = new Message("Result");
        result.set("identification", (Object)"");
        if (fc == null) {
            result.set("internal", (Object)0);
            result.set("isRc", (Object)0);
            result.set("rc", (Object)0);
        } else {
            result.set("internal", (Object)1);
            result.set("isRc", (Object)1);
            result.set("rc", (Object)fc.getRc());
        }
        result.set("isCfRc", (Object)0);
        result.set("cfRc", (Object)0);
        result.set("coreFunctionId", (Object)"");
        this.addAccountData(result, step, fc);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("end: " + result));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"end:");
        }
        return result;
    }

    private boolean addResultData(Message answer, CtrlJobStep step, CtrlFunctionCall fc) {
        Message result = null;
        result = this.getResultData(step, fc);
        if (result != null) {
            answer.set("result", (Object)result);
            return true;
        }
        return false;
    }

    private Message getAccountData(CtrlJobStep step, CtrlFunctionCall fc) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start: " + (Object)((Object)step) + ", " + (Object)((Object)fc)));
        }
        if (step == null || fc == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"end: <null>");
            }
            return null;
        }
        Message account = new Message("Account");
        account.set("startTime", (Object)new Date(0L));
        account.set("endTime", (Object)new Date(0L));
        account.set("cpuTime", (Object)0);
        account.set("runTime", (Object)0);
        account.set("inputSize", (Object)0);
        account.set("outputSize", (Object)0);
        account.set("sendLogfile", (Object)1);
        account.set("logFilename", (Object)step.getProtfileName());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("end: " + account));
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"end:");
        }
        return account;
    }

    private boolean addAccountData(Message answer, CtrlJobStep step, CtrlFunctionCall fc) {
        Message account = null;
        account = this.getAccountData(step, fc);
        if (account != null) {
            answer.set("account", (Object)account);
            return true;
        }
        return false;
    }

    private String getValOrEmptyStr(String val) {
        if (val == null) {
            return "";
        }
        return val;
    }
}

