/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.EdiComp;
import de.axway.aim.controller.lib.IdSortedJob;
import de.axway.aim.controller.lib.Job;
import de.axway.aim.controller.lib.JobStep;
import de.axway.aim.controller.lib.Result;
import de.axway.aim.controller.master.Appl;
import de.axway.aim.controller.master.ApplSequence;
import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.CtrlJobStep;
import de.axway.aim.controller.master.CtrlLockDaemon;
import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.DebPrepStmt;
import de.axway.aim.controller.master.EventSequence;
import de.axway.aim.controller.master.Globals;
import de.axway.aim.controller.master.HealthStatus;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.IRemovable;
import de.axway.aim.controller.master.IStarter;
import de.axway.aim.controller.master.JBpmJob;
import de.axway.aim.controller.master.JBpmJobStep;
import de.axway.aim.controller.master.JoseAppl;
import de.axway.aim.controller.master.JsSequence;
import de.axway.aim.controller.master.JslBuiltin;
import de.axway.aim.controller.master.JslSequence;
import de.axway.aim.controller.master.Loader;
import de.axway.aim.controller.master.LockJob;
import de.axway.aim.controller.master.LogProtApp;
import de.axway.aim.controller.master.LogProtMsgDaemon;
import de.axway.aim.controller.master.PingThreads;
import de.axway.aim.controller.master.Sequence;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.StarterThreads;
import de.axway.aim.controller.master.TreeSlave;
import de.axway.aim.controller.master.UnexpectedRuntimeException;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.aim.controller.master.WorkflowResultConnection;
import de.axway.aim.controller.master.account.DbAccounting;
import de.axway.aim.controller.master.account.IAccounting;
import de.axway.aim.controller.master.account.RcbAccount;
import de.axway.aim.controller.master.account.StdAccount;
import de.axway.aim.controller.master.account.Tsim2Sentinel;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgFctn;
import de.axway.aim.controller.master.cfg.CfgFctnEntry;
import de.axway.aim.controller.master.cfg.CfgJSelect;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.CfgJobEntry;
import de.axway.aim.controller.master.cfg.CfgRc;
import de.axway.aim.controller.master.cfg.CfgSlave;
import de.axway.aim.controller.master.cfg.CfgSlaveEntry;
import de.axway.aim.controller.master.cfg.CfgTimeWindow;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.cfg.TextCfgFctn;
import de.axway.aim.controller.master.cfg.TextCfgJSelect;
import de.axway.aim.controller.master.cfg.TextCfgRc;
import de.axway.aim.controller.master.cfg.TextCfgSlave;
import de.axway.aim.controller.master.cfg.TextCfgTimeWindow;
import de.axway.aim.controller.master.cfg.TextEdiboss;
import de.axway.aim.controller.master.command.CmdSequence;
import de.axway.aim.controller.master.command.MatchSpec;
import de.axway.aim.controller.master.command.SetEvtStormWall;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.aim.controller.master.log.LogbookError;
import de.axway.aim.controller.master.queue.ActivateQueue;
import de.axway.aim.controller.master.queue.DumpableQueue;
import de.axway.aim.controller.master.queue.FcGroupQueue;
import de.axway.aim.controller.master.queue.FcKillQueue;
import de.axway.aim.controller.master.queue.JobSeqQueue;
import de.axway.aim.controller.master.queue.JobStepSeqQueue;
import de.axway.aim.controller.master.queue.RemoveQueue;
import de.axway.aim.controller.master.queue.RunQueue;
import de.axway.aim.controller.master.queue.SleepQueue;
import de.axway.aim.controller.master.tcontrol.CfgJSelectScheduler;
import de.axway.aim.controller.master.tcontrol.IDispatcher;
import de.axway.aim.controller.master.tcontrol.TimeEventEntry;
import de.axway.aim.controller.master.tcontrol.Timer;
import de.axway.common.api.IDBIPool;
import de.axway.common.api.ILicRc;
import de.axway.lib.license.LizCrypt;
import de.axway.lib.util.ActisFile;
import de.axway.lib.util.Logo;
import de.axway.lib.util.runner.ManagedRunnableImpl;
import de.axway.lockDaemon.LockDaemon;
import de.axway.lockDaemon.LockException;
import de.axway.lockDaemon.LockHandler;
import de.axway.lockDaemon.SyncObject;
import de.axway.lockDaemon.notify.EventType;
import de.axway.lockDaemon.notify.LockDaemonEventListener;
import de.axway.lockDaemon.notify.LockDaemonEventObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public final class CtrlDispAppl
implements LockHandler,
IDispatcher,
LockDaemonEventListener {
    private static final String VERSION = "$Id: CtrlDispAppl.java 236886 2019-09-23 08:11:20Z lvcraciun $";
    private static final String MASTER_LICENSE = "EDIMAN";
    private static final String DBIF_LICENSE = "DBIF";
    private static final String MT_LICENSE = "MULTITHREAD";
    private static final String LICENSE_COMPONENT_EDIMAN_VERSION = "v3901|3.9.1";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd-HH:mm:ss");
    public static final String SIGNAL_DB_ERROR_OBJECT_BROWSER = "ERROR: DataBase is down.";
    public static final int ID_SIGNAL_DB_ERROR_OBJECT_BROWSER = -15;
    public static final int MAX_RETRIES = 1800;
    private static Log log = LogFactory.getLog((String)"master.CtrlDispAppl");
    private static Log dbLog = LogFactory.getLog((String)"master.DB.CtrlDispAppl");
    private static Log logGrouping = LogFactory.getLog((String)"master.grouping");
    private static int nbOfDisconnectObjBwrSent = 0;
    private DataSource dataSource;
    private IDBIPool dbiPool;
    private TreeSlave slaves = new TreeSlave();
    private Map<Long, IJob> jobs = new Hashtable<Long, IJob>();
    private List<IJob> jobList = Collections.synchronizedList(new LinkedList());
    private Map<String, DumpableQueue> queues = new Hashtable<String, DumpableQueue>();
    private Map<Long, Appl> appl = new Hashtable<Long, Appl>();
    private CfgRc cfgRc = null;
    private CfgFctn cfgFctn = null;
    private CfgTimeWindow cfgTimeWindow = null;
    private LockDaemon lockDaemon;
    private RunQueue runQueue;
    private RemoveQueue jobRemoveQueue;
    private RemoveQueue eventRemoveQueue = null;
    private SleepQueue sleepQueue;
    private FcKillQueue fcKillQueue;
    private FcGroupQueue groupQueue;
    private JobSeqQueue jobSeqQueue;
    private JobStepSeqQueue jobStepSeqQueue;
    private ActivateQueue activateQueue;
    private Globals globals;
    private LogProtMsgDaemon lpmd = null;
    private Sequence eventSequence;
    private Sequence cmdSequence;
    private Sequence applSequence;
    private Sequence jslSequence;
    private Sequence jsSequence;
    private Timer<TimeEventEntry> cfgJSelectSchedulerTimer;
    private Object jslSync = new Object();
    private Ediboss ediboss = null;
    private IAccounting dbAccounting = null;
    private IAccounting fileAccounting = null;
    private RcbAccount rcbAccounting = null;
    private Tsim2Sentinel sentinelConn = null;
    private String version = "3.9-SNAPSHOT";
    private ThreadPoolExecutor threadPool;
    private ThreadPoolExecutor removeThreadPool;
    private HealthStatus healthStatus;
    private Status status = Status.STARTING;
    private ManagedRunnableImpl reconfigThread = null;
    private long lastReconfig = System.currentTimeMillis();
    private long statClearTime = 0L;
    private int maxJoeStatTime = 0;
    private boolean dontWriteStatMsg = false;
    private CfgJSelectScheduler cfgJSelectScheduler = null;
    private IStarter starter = null;
    private static final int JOE_STAT_TABLE_FC = 0;
    private static final int JOE_STAT_TABLE_BUSY = 1;
    private boolean isDerby = false;
    private boolean isMySQL = false;
    private static final String[] STAT_TABLES = new String[]{"CTRL_STAT_FC", "CTRL_STAT_BUSY"};
    private static final String[] STAT_RM_STMT = new String[]{"delete from " + STAT_TABLES[0] + " where REAL_TIME <?", "delete from " + STAT_TABLES[1] + " where REAL_TIME < ?"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtrlDispAppl(IDBIPool dbiPool, IStarter starter) throws Exception {
        this.dataSource = dbiPool.getDataSource();
        if (log.isDebugEnabled()) {
            log.debug((Object)("dataSource: " + this.dataSource));
        }
        this.dbiPool = dbiPool;
        this.starter = starter;
        try {
            this.lockDaemon = new CtrlLockDaemon(this.dataSource, this, 60);
            this.lockDaemon.addListener((LockDaemonEventListener)this);
            this.healthStatus = new HealthStatus(this);
            try (Connection con = this.getConnection();){
                this.eventSequence = new EventSequence(this.lockDaemon, con);
                this.cmdSequence = new CmdSequence(this.lockDaemon, con);
                this.applSequence = new ApplSequence(this.lockDaemon, con);
                this.jslSequence = new JslSequence(this.lockDaemon, con);
                this.jsSequence = new JsSequence(this.lockDaemon, con);
                con.commit();
            }
            this.globals = new Globals(this.lockDaemon);
            JBpmJobStep.setDispatcher(this);
            this.startUp(true, false);
            SetEvtStormWall.setDispatcher(this);
        }
        catch (Throwable e) {
            log.fatal((Object)"Cannot startup Java Master!", e);
            try {
                Logbook.getLogbook().error("start failed: " + e.getMessage());
            }
            catch (LogbookError le) {
                System.out.println(le.getMessage());
            }
            this.shutdown(false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newAppl(Appl application) {
        try {
            application.setId();
        }
        catch (Exception e) {
            Logbook.getLogbook().error("start application failed: " + e);
            log.error((Object)"Appl.setId", (Throwable)e);
        }
        Map<Long, Appl> e = this.appl;
        synchronized (e) {
            this.appl.put(application.getId(), application);
        }
        if (application instanceof JoseAppl) {
            JoseAppl jose = (JoseAppl)application;
            List<IJob> list = this.jobList;
            synchronized (list) {
                TreeSet<IdSortedJob> j = new TreeSet<IdSortedJob>();
                for (IJob job : this.jobList) {
                    if (!(job instanceof CtrlJob)) continue;
                    j.add(new IdSortedJob((Job)job));
                }
                jose.newJob(j);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppl(long id) {
        JoseAppl app = null;
        Map<Long, Appl> map = this.appl;
        synchronized (map) {
            Appl application = this.appl.remove(id);
            if (application != null && application instanceof JoseAppl) {
                app = (JoseAppl)application;
            }
        }
        if (app != null) {
            app.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean jobChangePrio(long id, int prio, long initJobId, PrioChType type) throws InterruptedException, LockException, SQLException {
        boolean ret;
        block25: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("jobChangePrio start: Job: " + id + ", prio: " + prio + ", chType: " + (Object)((Object)type)));
            }
            IJob job = this.getJob(id);
            ret = true;
            LockJob lj = new LockJob(id);
            if (id != initJobId) {
                this.lockDaemon.globalLock((SyncObject)lj);
            }
            try {
                int newPrio = 0;
                if (job == null) break block25;
                switch (type) {
                    case SET: {
                        newPrio = prio;
                        break;
                    }
                    case INCREASE: {
                        newPrio = job.getPrio() + prio;
                        break;
                    }
                    case DECREASE: {
                        newPrio = job.getPrio() - prio;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknow type in change prio: " + (Object)((Object)type));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jobChangePrio: ID: " + job.getId() + ": " + job.getPrio() + " -> " + newPrio));
                }
                if (id != initJobId) {
                    try (Connection con = this.getConnection();){
                        boolean removedFromGroup = this.groupQueue.removeWaitingJob(job);
                        boolean removedFromRunqueue = this.runQueue.removeJob(job);
                        job.setPrio(newPrio);
                        job.update(con);
                        con.commit();
                        if (removedFromGroup) {
                            this.groupQueue.addWaitingJob(job);
                        }
                        if (removedFromRunqueue) {
                            this.runQueue.addJob(job);
                        }
                        break block25;
                    }
                }
                job.setPrio(newPrio);
            }
            finally {
                if (id != initJobId) {
                    try {
                        this.lockDaemon.globalUnLock((SyncObject)lj);
                    }
                    catch (LockException e) {
                        log.error((Object)("jobChangePrio: Unlock failed: ID:" + id), (Throwable)e);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("jobChangePrio end: " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean jobstepChangeSequ(long id, int step, boolean flag, long initJobId) throws InterruptedException, LockException {
        IJob job = this.getJob(id);
        boolean ret = true;
        LockJob lj = new LockJob(id);
        if (id != initJobId) {
            this.lockDaemon.globalLock((SyncObject)lj);
        }
        try {
            if (job != null) {
                // empty if block
            }
        }
        finally {
            if (id != initJobId) {
                try {
                    this.lockDaemon.globalUnLock((SyncObject)lj);
                }
                catch (LockException e) {
                    log.error((Object)"unlock", (Throwable)e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean jobChangeSequ(long id, boolean flag, long initJobId) throws InterruptedException, LockException, SQLException {
        boolean ret;
        block17: {
            IJob job = this.getJob(id);
            ret = true;
            LockJob lj = null;
            if (id != initJobId) {
                lj = new LockJob(id);
                this.lockDaemon.globalLock((SyncObject)lj);
            }
            try {
                if (job == null || (!flag || job.isSeq()) && (flag || !job.isSeq())) break block17;
                job.setSeq(flag);
                if (id != initJobId) {
                    try (Connection con = this.getConnection();){
                        job.update(con);
                        con.commit();
                        this.sendUpdateJob(job);
                    }
                }
                if (flag) {
                    this.jobSeqQueue.newJob(job);
                } else {
                    this.jobSeqQueue.jobDone(job);
                }
            }
            finally {
                if (lj != null) {
                    try {
                        this.lockDaemon.globalUnLock((SyncObject)lj);
                    }
                    catch (LockException e) {
                        log.error((Object)"unlock", (Throwable)e);
                    }
                }
            }
        }
        return ret;
    }

    public boolean workflowResult(long id, boolean close, int answer, Attributes attr, long initJobId, Connection con) throws InterruptedException {
        IJob job = this.getJob(id);
        if (job != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("start: id: " + id + ", close: " + close + ", answer: " + answer + ", initJobId: " + initJobId + ", con: " + con));
                if (attr != null) {
                    Iterator it = attr.get().iterator();
                    while (it.hasNext()) {
                        log.debug((Object)((Attribute)it.next()).toString());
                    }
                }
            }
            ((CtrlEvent)job.getEvt()).sendWorkflowResult(close, answer, attr);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No job with id " + id + " found!"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end: true");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assign(Connection con, long jobid, String name, String value, long initJobId) throws LockException, SQLException, InterruptedException {
        block13: {
            IJob job = this.getJob(jobid);
            LockJob lj = new LockJob(jobid);
            if (jobid != initJobId) {
                this.lockDaemon.globalLock((SyncObject)lj);
            }
            try {
                if (job == null) break block13;
                ((CtrlJob)job).setVar(con, name, value);
                if (jobid == initJobId) break block13;
                try {
                    job.update(con);
                    this.sendUpdateJob(job);
                }
                catch (SQLException e) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            finally {
                if (jobid != initJobId) {
                    try {
                        this.lockDaemon.globalUnLock((SyncObject)lj);
                    }
                    catch (LockException e) {
                        log.error((Object)"assign, unlock", (Throwable)e);
                    }
                }
            }
        }
        return true;
    }

    private HashSet<Long> intersection(HashSet<Long> set1, HashSet<Long> set2) {
        if (set1 == null) {
            if (set2 == null) {
                return null;
            }
            return (HashSet)set2.clone();
        }
        if (set2 == null) {
            return (HashSet)set1.clone();
        }
        if (set1.size() == 0) {
            return new HashSet<Long>();
        }
        if (set2.size() == 0) {
            return new HashSet<Long>();
        }
        HashSet<Long> resultSet = new HashSet<Long>();
        for (Long o : set1) {
            if (!set2.contains(o)) continue;
            resultSet.add(o);
        }
        return resultSet;
    }

    public Long[] executeMatch(MatchSpec matchSpecification) throws SQLException {
        HashSet<Long> jobIds = null;
        Object[] sortedJobIds = null;
        try (Connection con = this.getConnection();){
            jobIds = CtrlEvent.matchEvent(matchSpecification.getRefNoSpec(), con);
            if (jobIds == null || jobIds.size() > 0) {
                jobIds = this.intersection(jobIds, CtrlEvent.matchEventAttr(matchSpecification.getPartnerSpec(), matchSpecification.getSenderSpec(), matchSpecification.getReceiverSpec(), matchSpecification.getObjClassSpec(), con));
            }
            if (jobIds == null || jobIds.size() > 0) {
                jobIds = this.intersection(jobIds, CfgJSelectEntry.matchName(matchSpecification.getJobNameSpec(), con));
            }
            if (jobIds == null || jobIds.size() > 0) {
                jobIds = this.intersection(jobIds, CtrlJob.matchJob(matchSpecification.getJobIdSpec(), matchSpecification.getJobStatus(), matchSpecification.getFromDate(), matchSpecification.getToDate(), matchSpecification.getSuspended(), con));
            }
            if (jobIds != null) {
                sortedJobIds = jobIds.toArray(new Long[jobIds.size()]);
                Arrays.sort(sortedJobIds);
                Object[] objectArray = sortedJobIds;
                return objectArray;
            }
            Long[] longArray = new Long[]{};
            return longArray;
        }
    }

    public boolean newLogbook() {
        try {
            Logbook.archive();
        }
        catch (IOException e) {
            log.error((Object)"NEW_LOGBOOK", (Throwable)e);
            Logbook.getLogbook().error("NEW_LOGBOOK: " + e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkAllBusyFc() {
        int noOfReallyActive = 0;
        int total = 0;
        ArrayList<IJob> activeJobs = new ArrayList<IJob>();
        Map<Long, IJob> map = this.jobs;
        synchronized (map) {
            total = this.jobs.size();
            for (IJob job : this.jobs.values()) {
                if (job.getStatus() != 5) continue;
                activeJobs.add(job);
            }
        }
        Iterator it = activeJobs.iterator();
        while (it.hasNext()) {
            if (!this.checkBusyFc((IJob)it.next())) continue;
            ++noOfReallyActive;
        }
        int noOfZombies = activeJobs.size() - noOfReallyActive;
        Logbook.getLogbook().info("jobs active/zombie: " + noOfReallyActive + "/" + noOfZombies + ", total: " + total);
        return noOfReallyActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkBusyFc(IJob job) {
        LockJob lj = new LockJob(job.getId());
        Connection con = null;
        boolean isRunning = false;
        try {
            this.lockDaemon.globalLock((SyncObject)lj);
        }
        catch (LockException e) {
            Logbook.getLogbook().error("lock job " + (Object)((Object)e));
            return isRunning;
        }
        try {
            if (job.getStatus() != 5) return isRunning;
            Logbook.getLogbook().info("Check Fc " + job.getId());
            CtrlFunctionCall fc = (CtrlFunctionCall)job.getLastFc();
            SlaveHandler sh = this.getSlaveHandler(fc.getSlave());
            SlaveHandler.FcStat answer = sh.checkFc(fc);
            switch (answer) {
                case WAIT4RESULT: 
                case EMERGENCY: {
                    isRunning = true;
                    return isRunning;
                }
                case ZOMBIE: {
                    if (job instanceof CtrlJob) {
                        con = this.getConnection();
                        CtrlJob cJob = (CtrlJob)job;
                        this.unqueue(job, false);
                        cJob.setStatus(6);
                        cJob.update(con);
                        fc.setReadyDate(System.currentTimeMillis());
                        fc.setRc(-1);
                        fc.saveResult(con, this);
                        con.commit();
                        this.sendUpdateJob(cJob);
                        Logbook.getLogbook().error("Function call " + fc.getInstanceName() + " of job " + job.getName() + "/" + job.getId() + " not found by " + sh.getSlave().getName());
                        return isRunning;
                    } else {
                        log.debug((Object)"Job isn't CtrlJob, cannot work.");
                        return isRunning;
                    }
                }
                default: {
                    throw new IllegalArgumentException("unknown answer on checkfc: " + (Object)((Object)answer));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot check running job: " + job), (Throwable)e);
            Logbook.getLogbook().error("Cannot check running job: " + job.getName() + "/" + job.getId() + " " + e.toString());
            return isRunning;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"can not close db connection", (Throwable)e);
                }
            }
            try {
                this.lockDaemon.globalUnLock((SyncObject)lj);
            }
            catch (LockException e) {
                Logbook.getLogbook().error("lock job " + (Object)((Object)e));
                return isRunning;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProtfile(CtrlFunctionCall fc, long maxExecEndTime, int maxExecTime) {
        PrintWriter pw = null;
        CtrlJobStep step = null;
        String fn = null;
        try {
            step = (CtrlJobStep)fc.getJobStep();
            fn = step.getProtfileName();
            pw = new PrintWriter(new FileOutputStream(fn, true));
            pw.println("# === Instance: " + fc.getInstanceNameWOL());
            pw.println(String.format("|%1$tF %1$tT|Job \"%2$s\" is STOPPED|Instance of job step: %3$d.%4$d.%5$d", new Date(), step.getName(), step.getJobId(), step.getStepNo(), step.getRetry()));
            pw.println(String.format("  Max. duration of this %d seconds!", maxExecTime));
            pw.println(String.format("  Function call has to be finshed at %1$ta %1$tF %1$tT", new Date(maxExecEndTime)));
            pw.println("  Function call has been KILLED!\n");
        }
        catch (Exception e) {
            log.error((Object)("Cannot access print writer of file " + fn), (Throwable)e);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Exception shit) {
                    log.error((Object)("Cannot open print writer of file " + fn), (Throwable)shit);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void killBusyFc(IJob job, long maxExecEndTime, int maxExecTime) {
        LockJob lj = new LockJob(job.getId());
        Connection con = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("killBusyFc: job: " + job.getId()));
        }
        try {
            this.lockDaemon.globalLock((SyncObject)lj);
        }
        catch (LockException e) {
            Logbook.getLogbook().error("lock job " + (Object)((Object)e));
            return;
        }
        try {
            if (job.getStatus() != 5) return;
            CtrlFunctionCall fc = (CtrlFunctionCall)job.getLastFc();
            SlaveHandler sh = this.getSlaveHandler(fc.getSlave());
            switch (sh.killFc(fc)) {
                case KILLED: {
                    if (job instanceof CtrlJob) {
                        con = this.getConnection();
                        CtrlJob cJob = (CtrlJob)job;
                        this.unqueue(job, false);
                        cJob.setStatus(6);
                        cJob.update(con);
                        fc.setReadyDate(System.currentTimeMillis());
                        fc.setRc(-1);
                        fc.saveResult(con, this);
                        con.commit();
                        this.sendUpdateJob(cJob);
                        this.writeProtfile(fc, maxExecEndTime, maxExecTime);
                        Logbook.getLogbook().info("Function call " + fc.getInstanceName() + " of job " + job.getName() + "/" + job.getId() + " killed due to timeout: " + fc.getJobStep().getMaxExecTime() + " sec.");
                        this.dispatch(job);
                        return;
                    } else {
                        log.debug((Object)"Job isn't CtrlJob, cannot work.");
                        return;
                    }
                }
                default: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cannot kill function call after timeout: " + fc.getJobStep().getMaxExecTime() + " sec., FC: " + fc.getInstanceName()));
                    }
                    Logbook.getLogbook().info("Unable to kill Function call " + fc.getInstanceName() + " of job " + job.getName() + "/" + job.getId() + " after timeout has expired: " + fc.getJobStep().getMaxExecTime());
                    return;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot kill running job step: " + job), (Throwable)e);
            Logbook.getLogbook().error("Cannot kill running job step: " + job.getName() + "/" + job.getId() + " " + e.toString());
            return;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"can not close db connection", (Throwable)e);
                }
            }
            try {
                this.lockDaemon.globalUnLock((SyncObject)lj);
            }
            catch (LockException e) {
                Logbook.getLogbook().error("lock job " + (Object)((Object)e));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopJob(IExecutable job, Exception e) {
        Logbook.getLogbook().error("Cannot execute job " + job.getId() + ": " + e.getMessage());
        log.error((Object)("runjob " + job.getId()), (Throwable)e);
        if (job instanceof CtrlJob) {
            CtrlJob cjob = (CtrlJob)job;
            Connection con = null;
            try {
                con = this.getConnection();
                cjob.stopJob(con);
                cjob.update(con);
                this.sendUpdateJob(cjob);
                con.commit();
            }
            catch (Exception se) {
                Logbook.getLogbook().error("error: " + se.getMessage());
                log.error((Object)("stopJob " + job.getId()), (Throwable)se);
                if (con != null) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException ex) {
                        log.warn((Object)"can not close db connection", (Throwable)e);
                    }
                }
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException ex) {
                        log.warn((Object)"can not close db connection", (Throwable)e);
                    }
                }
            }
            this.dispatch(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopJob(long jobid, long initJobId, Connection con) throws InterruptedException, LockException, SQLException {
        CtrlJob job = (CtrlJob)this.getJob(jobid);
        LockJob lj = null;
        if (jobid != initJobId) {
            lj = new LockJob(jobid);
            this.lockDaemon.globalLock((SyncObject)lj);
        }
        try {
            if (job != null && job.getStatus() != 4) {
                if (jobid != initJobId) {
                    this.unqueue(job, false);
                }
                try {
                    job.stopJob(con);
                    job.update(con);
                    this.sendUpdateJob(job);
                }
                catch (SQLException e) {
                    con.rollback();
                    throw e;
                }
            }
            if (lj != null) {
                con.commit();
            }
        }
        finally {
            if (lj != null) {
                try {
                    this.lockDaemon.globalUnLock((SyncObject)lj);
                }
                catch (LockException e) {
                    log.error((Object)"jobExit, unlock", (Throwable)e);
                }
            }
        }
        if (job != null && jobid != initJobId) {
            this.dispatch(job);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean jobExit(String[] par, long initJobId, Connection con) throws InterruptedException, LockException, SQLException {
        long jobid = Long.parseLong(par[0]);
        LockJob lj = null;
        CtrlJob job = (CtrlJob)this.getJob(jobid);
        if (jobid != initJobId) {
            lj = new LockJob(jobid);
            this.lockDaemon.globalLock((SyncObject)lj);
        }
        try {
            if (job != null && job.getStatus() != 4) {
                if (jobid != initJobId) {
                    this.unqueue(job, false);
                }
                int exitCode = par.length > 1 ? Integer.parseInt(par[1]) : 0;
                try {
                    if (job.jobExit(exitCode, con)) {
                        job.update(con);
                        this.sendUpdateJob(job);
                    }
                }
                catch (SQLException e) {
                    if (lj != null) {
                        con.rollback();
                    }
                    throw e;
                }
            }
            if (lj != null) {
                con.commit();
            }
        }
        finally {
            if (lj != null) {
                try {
                    this.lockDaemon.globalUnLock((SyncObject)lj);
                }
                catch (LockException e) {
                    log.error((Object)"jobExit, unlock", (Throwable)e);
                }
            }
        }
        if (job != null && jobid != initJobId) {
            this.dispatch(job);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJsRetryFull(String[] par, long initJobId) throws SQLException, LockException, InterruptedException {
        long jobid = Long.parseLong(par[0]);
        LockJob lj = null;
        CtrlJob job = (CtrlJob)this.getJob(jobid);
        if (jobid != initJobId) {
            lj = new LockJob(jobid);
            this.lockDaemon.globalLock((SyncObject)lj);
        }
        try {
            if (job != null) {
                if (par.length > 1) {
                    for (int x = 1; x < par.length; ++x) {
                        int step = Integer.parseInt(par[x]);
                        if (!job.isJsRetryFull(step, this)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("IF_JS_RETRY_FULL: job " + jobid + "." + step + " is retry full"));
                        }
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    for (int x = 1; x <= job.getStepCount(); ++x) {
                        if (!job.isJsRetryFull(x, this)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("IF_JS_RETRY_FULL: job " + jobid + "." + x + " is retry full"));
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("IF_JS_RETRY_FULL: job " + jobid + " not found"));
            }
        }
        finally {
            if (lj != null) {
                this.lockDaemon.globalUnLock((SyncObject)lj);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean termJs(String[] par, long initJobId, Connection con) throws InterruptedException, LockException, SQLException {
        block14: {
            long jobid = Long.parseLong(par[0]);
            LockJob lj = null;
            CtrlJob job = (CtrlJob)this.getJob(jobid);
            if (jobid != initJobId) {
                lj = new LockJob(jobid);
                this.lockDaemon.globalLock((SyncObject)lj);
            }
            try {
                if (job == null) break block14;
                try {
                    for (int x = 1; x < par.length; ++x) {
                        job.termJs(Integer.parseInt(par[x]), con);
                    }
                    job.update(con);
                    this.sendUpdateJob(job);
                    if (lj != null) {
                        con.commit();
                    }
                }
                catch (SQLException e) {
                    if (lj != null) {
                        con.rollback();
                    }
                    throw e;
                }
            }
            finally {
                if (lj != null) {
                    try {
                        this.lockDaemon.globalUnLock((SyncObject)lj);
                    }
                    catch (LockException e) {
                        log.error((Object)"termjs, unlock", (Throwable)e);
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runAllJs(long initJobId, Connection con) throws InterruptedException, LockException, SQLException {
        long[] ids;
        Map<Long, IJob> map = this.jobs;
        synchronized (map) {
            ids = new long[this.jobs.size()];
            int x = 0;
            Iterator<IJob> it = this.jobs.values().iterator();
            while (it.hasNext()) {
                ids[x] = it.next().getId();
                ++x;
            }
        }
        for (int x = 0; x < ids.length; ++x) {
            this.runJs(ids[x], -1, initJobId, con);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runJs(long id, int stepno, long initJobId, Connection con) throws InterruptedException, LockException, SQLException {
        LockJob lj = null;
        IJob job = this.getJob(id);
        if (id != initJobId) {
            lj = new LockJob(id);
            this.lockDaemon.globalLock((SyncObject)lj);
        }
        boolean dispatch = false;
        try {
            if (job != null && (job.getStatus() != 5 || id == initJobId)) {
                if (id != initJobId) {
                    this.unqueue(job, false);
                }
                try {
                    if (((CtrlJob)job).runJs(stepno, con) && id != initJobId) {
                        dispatch = true;
                    }
                }
                catch (SQLException e) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            if (lj != null) {
                con.commit();
                this.sendUpdateJob(job);
            }
        }
        finally {
            if (lj != null) {
                try {
                    this.lockDaemon.globalUnLock((SyncObject)lj);
                }
                catch (LockException e) {
                    log.error((Object)"runjs, unlock", (Throwable)e);
                }
            }
        }
        if (dispatch) {
            try {
                CtrlJobStep processedStep = stepno < 1 ? (CtrlJobStep)job.getCurrentStep() : (CtrlJobStep)job.getStep(stepno);
                if (processedStep != null && processedStep.getGroupName() != null && processedStep.getGroupName().length() != 0) {
                    this.jobSeqQueue.runJob(job);
                } else {
                    this.runQueue.runJob(job);
                }
            }
            catch (CfgException e) {
                log.error((Object)("get group name exception, " + id), (Throwable)((Object)e));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateJob(Attributes<String> attr, long initJobId, Connection con) throws InterruptedException, LockException, SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("attr: " + attr.get(-1, ',') + ", initJiobId: " + initJobId));
        }
        HashMap<Long, Attributes<String>> id = new HashMap<Long, Attributes<String>>();
        Map<Long, IJob> map = this.jobs;
        synchronized (map) {
            for (IJob job : this.jobs.values()) {
                if (!job.isSuspended()) continue;
                boolean matched = true;
                Iterator ita = attr.get().iterator();
                while (ita.hasNext() && matched) {
                    if (job.matchActivateAttr((Attribute<String>)((Attribute)ita.next()))) continue;
                    matched = false;
                }
                if (!matched) continue;
                id.put(job.getId(), attr);
            }
        }
        for (Long jobid : id.keySet()) {
            this.activateJob(jobid, initJobId, con, "Selected by ACTIVATE_ATTR=" + ((Attributes)id.get(jobid)).get(-1, ' '));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateAllJobs(long initJobId, Connection con) throws InterruptedException, LockException, SQLException {
        long[] ids;
        Map<Long, IJob> map = this.jobs;
        synchronized (map) {
            ids = new long[this.jobs.size()];
            int x = 0;
            for (IJob job : this.jobs.values()) {
                if (job.isSuspended()) {
                    ids[x] = job.getId();
                }
                ++x;
            }
        }
        for (int x = 0; x < ids.length; ++x) {
            this.activateJob(ids[x], initJobId, con, "Selected by JOB_ID");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateJob(long id, long initJobId, Connection con, String selection) throws InterruptedException, LockException, SQLException {
        IJob job;
        block17: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Activate job ID: " + id + " from job ID: " + initJobId));
            }
            LockJob lj = null;
            job = this.getJob(id);
            if (id != initJobId) {
                lj = new LockJob(id);
                this.lockDaemon.globalLock((SyncObject)lj);
            }
            try {
                if (job == null || job.getStatus() == 4 || job.getStatus() == 2) break block17;
                JobStep js = job.getCurrentStep();
                Logbook.getLogbook().deSuspJob(job.getName(), job.getId(), js.getName(), js.getStepNo(), js.getRetry(), selection);
                try {
                    this.activateQueue.remove(id);
                    job.activate(con);
                    if (lj != null) {
                        con.commit();
                        this.sendUpdateJob(job);
                    }
                }
                catch (SQLException e) {
                    if (lj != null) {
                        con.rollback();
                    }
                    throw e;
                }
                if (job.getStatus() == 4) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("End job, ID: " + job.getId()));
                        log.debug((Object)("End job, getJsl: " + job.getJsl()));
                    }
                    this.accWriteEnd((CtrlJob)job, con);
                    Logbook.getLogbook().endJob(job.getName(), job.getId(), job.getEvt().getId(), job.getId(), ((CtrlJob)job).getLastRc());
                }
            }
            finally {
                if (lj != null) {
                    try {
                        this.lockDaemon.globalUnLock((SyncObject)lj);
                    }
                    catch (LockException e) {
                        log.error((Object)"activateJob, unlock", (Throwable)e);
                    }
                }
            }
        }
        if (job != null && id != initJobId) {
            this.dispatch(job);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspendAllJobs(Attributes<String> activateAttr, long time, long initJobId, Connection con) throws InterruptedException {
        long[] ids;
        Map<Long, IJob> map = this.jobs;
        synchronized (map) {
            ids = new long[this.jobs.size()];
            int x = 0;
            Iterator<IJob> it = this.jobs.values().iterator();
            while (it.hasNext()) {
                ids[x] = it.next().getId();
                ++x;
            }
        }
        for (int x = 0; x < ids.length; ++x) {
            this.suspendJob(ids[x], activateAttr, time, initJobId, con);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspendJob(long id, Attributes<String> activateAttr, long time, long initJobId, Connection con) throws InterruptedException {
        IJob job;
        block20: {
            LockJob lj = null;
            JobStep suspStep = null;
            job = this.getJob(id);
            if (id != initJobId) {
                lj = new LockJob(id);
                try {
                    this.lockDaemon.globalLock((SyncObject)lj);
                }
                catch (LockException e) {
                    log.error((Object)"suspendjob, lock", (Throwable)e);
                    Logbook.getLogbook().error("Cannot lock job " + id + ": " + e.getMessage());
                    return false;
                }
            }
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("suspend job " + id + " from job " + initJobId));
                }
                if (job == null) break block20;
                int status = job.getStatus();
                if (status == 1 || status == 3 || status == 5) {
                    try {
                        if (status != 5) {
                            this.unqueue(job, false);
                        }
                        job.suspend(time, activateAttr, con);
                        suspStep = job.getNextJs();
                        if (suspStep == null) {
                            suspStep = job.getCurrentStep();
                        }
                        if (job.getEvt().getAttr() == null && job.getEvt().getParams() == null && job.getEvt().getRefNo() == "") {
                            job.update(con);
                        }
                        Logbook.getLogbook().suspendJob(job.getName(), job.getId(), suspStep.getName(), job.getId() + "." + suspStep.getStepNo() + "." + suspStep.getRetry(), job.getActivateDate(), activateAttr);
                        if (lj != null) {
                            con.commit();
                            this.sendUpdateJob(job);
                        }
                        break block20;
                    }
                    catch (SQLException e) {
                        Logbook.getLogbook().error("suspend job " + id + " attributes: " + activateAttr.get(-1, ','));
                        log.error((Object)("suspend job " + id), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                job = null;
            }
            finally {
                if (lj != null) {
                    try {
                        this.lockDaemon.globalUnLock((SyncObject)lj);
                    }
                    catch (LockException e) {
                        log.error((Object)"suspendjob, unlock", (Throwable)e);
                    }
                }
            }
        }
        if (job != null && id != initJobId) {
            this.dispatch(job);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean killAllJobs(boolean kill, long initJobId) throws InterruptedException, SQLException, IOException {
        long[] ids;
        Map<Long, IJob> map = this.jobs;
        synchronized (map) {
            ids = new long[this.jobs.size()];
            int x = 0;
            Iterator<IJob> it = this.jobs.values().iterator();
            while (it.hasNext()) {
                ids[x] = it.next().getId();
                ++x;
            }
        }
        for (int x = 0; x < ids.length; ++x) {
            this.killJob(ids[x], kill, initJobId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean killJob(long id, boolean kill, long initJobId) throws InterruptedException, SQLException, IOException {
        log.trace((Object)("(" + initJobId + ") kill_job: " + id));
        LockJob lj = null;
        if (id != initJobId) {
            lj = new LockJob(id);
            try {
                this.lockDaemon.globalLock((SyncObject)lj);
            }
            catch (LockException e) {
                log.error((Object)"killjob, lock", (Throwable)e);
                Logbook.getLogbook().error("Cannot lock job " + id + ": " + e.getMessage());
                return false;
            }
        }
        IJob job = this.getJobWithRetry(id, 20);
        try {
            if (job != null && this.jobs.containsKey(id) && this.remove(job, false)) {
                this.unqueue(job, true);
                if (kill) {
                    IRemovable evt = (IRemovable)job.getEvt();
                    this.eventRemoveQueue.remove(id);
                    this.remove(evt, false);
                }
            } else if (job == null) {
                boolean evt = false;
                return evt;
            }
        }
        finally {
            if (lj != null) {
                try {
                    this.lockDaemon.globalUnLock((SyncObject)lj);
                }
                catch (LockException e) {
                    log.error((Object)"killjob, unlock", (Throwable)e);
                }
            }
        }
        return true;
    }

    protected void unqueue(IJob job, boolean kill) {
        boolean active = false;
        switch (job.getStatus()) {
            case 4: {
                this.jobRemoveQueue.remove(job.getId());
                break;
            }
            case 5: {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(">>> del job:" + job));
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)(">>> del job ID:" + job.getId()));
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("CtrlDispAppl:unqueue[job=" + job.getId() + ", slave=" + this.getSlave(job.getLastFc().getSlave()).getName() + "]: unlocked slave."));
                    }
                    this.getSlave(job.getLastFc().getSlave()).delRunningJob();
                }
                catch (LockException e) {
                    log.error((Object)"unlock slave", (Throwable)e);
                }
                active = true;
            }
            case 1: 
            case 2: 
            case 3: {
                if (kill) {
                    if (job.isSeq()) {
                        this.jobSeqQueue.jobDone(job);
                    }
                    Iterator it = job.getSeqSteps().iterator();
                    while (it.hasNext()) {
                        this.jobStepSeqQueue.jobStepDone((IJobStep)((Object)it.next()));
                    }
                }
                if (!active) {
                    this.sleepQueue.remove(job, kill);
                    this.runQueue.remove(job);
                    if (job.isSuspended()) {
                        this.activateQueue.remove(job.getId());
                    }
                }
            }
            default: {
                CtrlJobStep js;
                if (job.getVarTable() == null || !(js = (CtrlJobStep)job.getCurrentStep()).isGrouped()) break;
                this.groupQueue.removeJs(js);
            }
        }
    }

    public synchronized boolean reconfig() {
        if (this.status != Status.RUNNING || this.reconfigThread != null) {
            Logbook.getLogbook().error("reconfig: start already in progress");
            return false;
        }
        this.lastReconfig = System.currentTimeMillis();
        this.reconfigThread = new ManagedRunnableImpl(){

            public void doRun() {
                try {
                    this.setName("reconfig." + System.currentTimeMillis());
                    CtrlDispAppl.this.shutdown(true);
                    try {
                        CtrlDispAppl.this.startUp(CtrlDispAppl.this.ediboss.readRuntimeOnRcf(), true);
                    }
                    catch (Exception e) {
                        Logbook.getLogbook().error("Reconfig failed: " + e.getMessage());
                        log.error((Object)"Reconfig failed", (Throwable)e);
                        CtrlDispAppl.this.shutdown(false);
                    }
                }
                finally {
                    CtrlDispAppl.this.reconfigThread = null;
                }
            }
        };
        this.reconfigThread.start();
        nbOfDisconnectObjBwrSent = 0;
        return true;
    }

    public boolean shutdownThread() {
        new ManagedRunnableImpl(){

            public void doRun() {
                this.setName("shutdown." + System.currentTimeMillis());
                CtrlDispAppl.this.shutdown(false);
            }
        }.start();
        return true;
    }

    public boolean shutdown(boolean rcf) {
        log.info((Object)("Shutting down Java Master. Reconfig: " + rcf));
        Logbook.getLogbook().info("Shutting down Java Master. Reconfig: " + rcf);
        if (rcf) {
            this.lpmd.setStopped(true);
        } else {
            this.shutdownPort("Shutdown of CtrlDispAppl.");
        }
        if (this.fileAccounting != null) {
            log.info((Object)"Closing accounting file.");
            try {
                this.fileAccounting.close();
                this.fileAccounting = null;
            }
            catch (Exception e) {
                log.error((Object)"Cannot close accounting file: ", (Throwable)e);
                Logbook.getLogbook().error("Cannot close accounting file: " + e);
            }
        }
        if (this.dbAccounting != null) {
            log.info((Object)"Closing DB accounting.");
            try {
                this.dbAccounting.close();
                this.dbAccounting = null;
            }
            catch (Exception e) {
                log.error((Object)"Cannot close DB accounting : ", (Throwable)e);
                Logbook.getLogbook().error("Cannot close DB accounting : " + e);
            }
        }
        if (this.rcbAccounting != null) {
            log.info((Object)"Closing RCB accounting file.");
            try {
                this.rcbAccounting.close();
                this.rcbAccounting = null;
            }
            catch (Exception e) {
                log.error((Object)"Cannot close RCB accounting file: ", (Throwable)e);
                Logbook.getLogbook().error("Cannot close RCB accounting file: " + e);
            }
        }
        if (this.sentinelConn != null) {
            log.info((Object)"Closing Sentinel accounting connection.");
            try {
                this.sentinelConn.close();
                this.sentinelConn = null;
            }
            catch (Exception e) {
                log.error((Object)"Cannot close Sentinel accounting: ", (Throwable)e);
                Logbook.getLogbook().error("Cannot close Sentinel accounting: " + e);
            }
        }
        log.info((Object)"Shutting down Job Select time scheduler.");
        this.cfgJSelectSchedulerTimer.stop();
        this.runQueue.shutdown(this.slaves);
        log.info((Object)"Shutting down Slave handler.");
        this.slaves.shutdown();
        this.status = Status.STARTING;
        if (!rcf) {
            log.info((Object)"Shutting down Object Browser Applications.");
            this.shutdownJoseAppl();
        } else {
            this.pingLogprotAppl();
        }
        log.info((Object)"Shutting down queues.");
        this.groupQueue.shutdown();
        log.info((Object)"GroupQueue down");
        this.jobSeqQueue.shutdown();
        log.info((Object)"JobSeqQueue down");
        this.jobStepSeqQueue.shutdown();
        log.info((Object)"JobStepSeqQueue down");
        this.sleepQueue.shutdown();
        log.info((Object)"SleepQueue down");
        if (!rcf) {
            this.eventRemoveQueue.shutdown();
            log.info((Object)"EventRemoveQueue down");
            this.eventRemoveQueue = null;
        }
        this.jobRemoveQueue.shutdown();
        log.info((Object)"JobRemoveQueue down");
        this.activateQueue.shutdown();
        log.info((Object)"ActivateQueue down");
        this.fcKillQueue.shutdown();
        log.info((Object)"FcKillQueue down");
        log.info((Object)"Shutting down lock daemon.");
        if (this.lockDaemon.isRunning()) {
            this.lockDaemon.shutdown(rcf);
        }
        log.info((Object)"Shutting down Runtime thread pool.");
        this.threadPool.shutdownNow();
        log.info((Object)"Shutting down Remove_jobs thread pool.");
        this.removeThreadPool.shutdownNow();
        WorkerThread.cleanStat();
        log.info((Object)"Shutting down Java Master done.");
        if (log.isTraceEnabled()) {
            log.trace((Object)("Remaining locks: " + this.lockDaemon.getLockStacks()));
        }
        Logbook.getLogbook().info("Shutting down Java Master done.");
        if (!rcf) {
            this.status = Status.DOWN;
        }
        return true;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public ThreadPoolExecutor getRemoveThreadPool() {
        return this.removeThreadPool;
    }

    public CfgRc getCfgRc() {
        return this.cfgRc;
    }

    public CfgTimeWindow getCfgTimeWindow() {
        return this.cfgTimeWindow;
    }

    public long getNextApplId() throws SQLException, LockException {
        return this.applSequence.getNextId(this.dataSource);
    }

    @Override
    public long getNextEventId() throws SQLException, LockException {
        return this.eventSequence.getNextId(this.dataSource);
    }

    public long getNextCmdId() throws SQLException, LockException {
        return this.cmdSequence.getNextId(this.dataSource);
    }

    public Map<Long, IJob> getJobs() {
        return this.jobs;
    }

    public boolean eventExists(long id) throws InterruptedException {
        if (this.getJob(id) != null) {
            return true;
        }
        return this.eventRemoveQueue.contains(id);
    }

    public List<SlaveHandler> getSlaveList() {
        ArrayList<SlaveHandler> ret = new ArrayList<SlaveHandler>();
        Iterator it = this.slaves.iterator();
        while (it.hasNext()) {
            ret.add((SlaveHandler)it.next());
        }
        return ret;
    }

    public SlaveHandler getSlaveHandler(String name) {
        return name == null ? null : this.slaves.get(name);
    }

    public List<SlaveHandler> getBicSlaveHandler() {
        ArrayList<SlaveHandler> ret = new ArrayList<SlaveHandler>();
        for (SlaveHandler sh : this.slaves) {
            if (sh.getSlave().getConnectionType() != CtrlSlave.ConnectionType.BUILTIN) continue;
            ret.add(sh);
        }
        return ret;
    }

    public SlaveHandler getSlaveHandler(InetAddress inetAddr) {
        CtrlSlave slave = null;
        SlaveHandler slaveHandler2 = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getSlaveHandler start: " + inetAddr));
        }
        for (SlaveHandler slaveHandler2 : this.slaves) {
            slave = slaveHandler2.getSlave();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check slave: " + slave.getName()));
            }
            if (!slave.containsIp(inetAddr)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("getSlaveHandler end:" + slave));
            }
            return slaveHandler2;
        }
        log.trace((Object)"getSlaveHandler end: <null>");
        return null;
    }

    public CtrlSlave getSlave(String name) {
        SlaveHandler sh = this.getSlaveHandler(name);
        if (sh == null) {
            return null;
        }
        return sh.getSlave();
    }

    public CtrlSlave getSlave(InetAddress inetAddr) {
        SlaveHandler sh = this.getSlaveHandler(inetAddr);
        if (sh == null) {
            return null;
        }
        return sh.getSlave();
    }

    public Globals getGlobals() {
        return this.globals;
    }

    public void addMemStatus(StringBuilder stat) {
        MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        MemoryUsage heap = mem.getHeapMemoryUsage();
        MemoryUsage nonHeap = mem.getNonHeapMemoryUsage();
        stat.append("Heap (MByte):       ");
        this.addMemData(stat, heap);
        stat.append('\n');
        stat.append("non Heap (MByte):   ");
        this.addMemData(stat, nonHeap);
        stat.append('\n');
        stat.append("loaded classes:     ");
        stat.append(ManagementFactory.getClassLoadingMXBean().getLoadedClassCount());
        stat.append('\n');
    }

    public void addMemData(StringBuilder stat, MemoryUsage mem) {
        stat.append("used: ");
        stat.append(mem.getUsed() / 0x100000L);
        stat.append("/free: ");
        stat.append((mem.getCommitted() - mem.getUsed()) / 0x100000L);
        stat.append("/total: ");
        stat.append(mem.getCommitted() / 0x100000L);
        stat.append("/max: ");
        stat.append(mem.getMax() / 0x100000L);
    }

    public void addDBStatus(StringBuilder stat) {
        stat.append("DBIPool:            used: ");
        stat.append(this.dbiPool.getInUse());
        stat.append('\n');
    }

    public void addUptimeStatus(StringBuilder stat) {
        long uptime = ManagementFactory.getRuntimeMXBean().getUptime() / 1000L;
        stat.append("Uptime:             ");
        CtrlDispAppl.appendTimeString(stat, uptime);
        stat.append('\n');
        stat.append("Last Reconfig:      " + DATE_FORMAT.format(new Date(this.lastReconfig)));
        stat.append('\n');
    }

    public static void appendTimeString(StringBuilder stat, long time) {
        long uptimeS = time % 60L;
        long uptimeM = time / 60L % 60L;
        long uptimeH = time / 3600L % 24L;
        long uptimeD = time / 3600L / 24L;
        stat.append((uptimeD > 0L ? uptimeD + "d " : "") + (uptimeH > 9L ? Long.valueOf(uptimeH) : "0" + uptimeH) + ':' + (uptimeM > 9L ? Long.valueOf(uptimeM) : "0" + uptimeM) + ':' + (uptimeS > 9L ? Long.valueOf(uptimeS) : "0" + uptimeS));
    }

    public void addThreadsStatus(StringBuilder stat) {
        stat.append("Threads:            " + Thread.activeCount() + "/peak: " + ManagementFactory.getThreadMXBean().getPeakThreadCount() + '\n');
        stat.append("RuntimeThreadPool:         Complete: " + this.threadPool.getCompletedTaskCount() + ", CoreSize: " + this.threadPool.getCorePoolSize() + ", Size: " + this.threadPool.getPoolSize() + ", Active: " + this.threadPool.getActiveCount() + ", Queue: " + this.threadPool.getQueue().size() + "\n");
        stat.append("RemoveJobsThreadPool:         Complete: " + this.removeThreadPool.getCompletedTaskCount() + ", CoreSize: " + this.removeThreadPool.getCorePoolSize() + ", Size: " + this.removeThreadPool.getPoolSize() + ", Active: " + this.removeThreadPool.getActiveCount() + ", Queue: " + this.removeThreadPool.getQueue().size() + "\n");
        stat.append("WorkerThread:       " + WorkerThread.getStatus() + "\n");
    }

    public void addMasterPortStatus(StringBuilder stat) {
        stat.append("\nMaster Port Daemon: " + (this.lpmd != null ? this.lpmd.getStatus() : "-"));
        stat.append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationsStatus(StringBuilder stat) {
        stat.append("\nApplications:    " + this.appl.size() + '\n');
        Map<Long, Appl> map = this.appl;
        synchronized (map) {
            Iterator<Appl> it = this.appl.values().iterator();
            while (it.hasNext()) {
                stat.append("    " + it.next().getStatus() + '\n');
            }
        }
        stat.append("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownJoseAppl() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"shutdownJoseAppl start: ");
        }
        Map<Long, Appl> map = this.appl;
        synchronized (map) {
            for (Appl appl : this.appl.values()) {
                if (appl instanceof JoseAppl) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("shutdown: " + appl.getStatus()));
                    }
                    try {
                        appl.shutdown();
                    }
                    catch (Exception e) {
                        log.error((Object)("Cannot shutdown JoseAppl: " + appl.getStatus()), (Throwable)e);
                    }
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("ignore: " + appl.getStatus()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingLogprotAppl() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"shutdownJoseAppl start: ");
        }
        LinkedList<Appl> toRemove = new LinkedList<Appl>();
        PingThreads pt = new PingThreads(this, toRemove);
        Map<Long, Appl> map = this.appl;
        synchronized (map) {
            for (Appl appl : this.appl.values()) {
                if (appl instanceof JoseAppl || !(appl instanceof LogProtApp)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("shutdown: " + appl.getStatus()));
                }
                pt.newApp((LogProtApp)appl);
            }
        }
        pt.wait4ready();
        map = this.appl;
        synchronized (map) {
            Iterator<Appl> it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeAppl(it.next().getId());
            }
        }
    }

    public String getStatus() {
        return this.getStatus(false);
    }

    public String getStatus(boolean verbose) {
        StringBuilder stat = new StringBuilder("Jobs:               " + this.jobs.size() + "\n");
        this.addMemStatus(stat);
        this.addDBStatus(stat);
        this.addUptimeStatus(stat);
        this.addThreadsStatus(stat);
        if (this.status == Status.RUNNING) {
            stat.append("JobSeq queue:       " + this.jobSeqQueue.getStatus(verbose) + '\n');
            stat.append("JobStepSeq queue:   " + this.jobStepSeqQueue.getStatus(verbose) + '\n');
            stat.append("Sleeping queue:     " + this.sleepQueue.getStatus(verbose) + '\n');
            stat.append("FcGroup queue:      " + this.groupQueue.getStatus(verbose) + '\n');
            stat.append("Run queue:          " + this.runQueue.getStatus(verbose) + '\n');
            stat.append("Activate queue:     " + this.activateQueue.getStatus(verbose) + '\n');
            stat.append("Job Remove queue:   " + this.jobRemoveQueue.getStatus(verbose) + '\n');
            stat.append("Event Remove queue: " + this.eventRemoveQueue.getStatus(verbose) + '\n');
            stat.append("Fc Kill queue:      " + this.fcKillQueue.getStatus(verbose) + '\n');
        }
        this.addMasterPortStatus(stat);
        this.slaves.addSlavesStatus(stat);
        this.addApplicationsStatus(stat);
        stat.append(this.lockDaemon.getStatus());
        stat.append("\n\n");
        if (this.cfgJSelectScheduler != null) {
            stat.append(this.cfgJSelectScheduler.getStatus(verbose));
        }
        return stat.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUp(boolean readRuntime, final boolean reconfig) throws Exception {
        LizCrypt license = null;
        log.info((Object)" Master startUp begin");
        this.ediboss = new TextEdiboss();
        if (reconfig) {
            readRuntime = this.ediboss.readRuntimeOnRcf();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("ediboss:" + this.ediboss));
        }
        if (reconfig) {
            this.dbiPool = this.starter.reconfig(this.ediboss);
            this.dataSource = this.dbiPool.getDataSource();
            this.lockDaemon.reStart(this.dataSource);
        }
        this.globals.setParEdiboss(this.ediboss);
        CtrlJob.setProtfileDir(this.ediboss.getProtfileDir());
        log.info((Object)("\n****************************************************\n    " + Logo.getCRString((String)"Java Master", (String)VERSION) + "\n\n    Starting Java Master with configuration:\n    slaveDclCfg     : " + this.ediboss.getSlavePath() + "\n    timeWindowCfg   : " + this.ediboss.getTimeWindowPath() + "\n    rccPathCfg      : " + this.ediboss.getRccPath() + "\n    fctnDclCfg      : " + this.ediboss.getFctnPath() + "\n    jSelectCfg      : " + this.ediboss.getJslPath() + "\n    jobsDclCfg      : " + this.ediboss.getJobPath() + "\n    logfilePath     : " + this.ediboss.getLogfilePath() + "\n\n    accounting      : " + this.ediboss.getAccountingOn() + "\n    accounting_in_db: " + this.ediboss.getAccountingInDb() + "\n    rcbaccounting   : " + this.ediboss.getRcbAccountingOn() + "\n    trkapipath      : " + (null != this.ediboss.getTrkApiPath() && this.ediboss.getTrkApiPath().length() > 0) + "\n\n    masterServicePort: " + this.ediboss.getServerPort() + "\n"));
        log.info((Object)"\n****************************************************");
        Connection con = this.getConnection();
        Object object = null;
        try {
            Logbook.configure(new ActisFile(this.ediboss.getLogfilePath()).toString(), con, this.ediboss.getServerPort());
            Logbook.getLogbook().start(this.version);
            String jdbcDriver = con.getMetaData().getDriverName();
            if (jdbcDriver.toUpperCase().contains("DERBY")) {
                log.info((Object)("db is derby: " + jdbcDriver));
                this.isDerby = true;
            } else if (jdbcDriver.toUpperCase().contains("MYSQL")) {
                this.isMySQL = true;
                log.info((Object)("db is not embedded derby: " + jdbcDriver));
            } else {
                log.info((Object)("db is not embedded derby: " + jdbcDriver));
            }
        }
        catch (Throwable jdbcDriver) {
            object = jdbcDriver;
            throw jdbcDriver;
        }
        finally {
            if (con != null) {
                if (object != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable jdbcDriver) {
                        ((Throwable)object).addSuppressed(jdbcDriver);
                    }
                } else {
                    con.close();
                }
            }
        }
        license = new LizCrypt(new ActisFile(this.ediboss.getLicensePath(), 1).toString());
        Logbook.getLogbook().license(license.getEntries());
        if (this.ediboss.getRcbAccountingOn()) {
            this.rcbAccounting = new RcbAccount(Logbook.getLogbook(), this.ediboss.getRcbAccountingOn(), this.ediboss.getRcbAccountfilePath());
        }
        this.sentinelConn = this.ediboss.getTrkApiPath() != null ? new Tsim2Sentinel(Logbook.getLogbook(), this.ediboss.getTrkApiPath()) : null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("RcbAccount object: " + this.rcbAccounting));
            log.debug((Object)("Tsim2Sentinel object: " + this.sentinelConn));
        }
        this.checkLicense(license);
        if (!this.ediboss.hasMultiThread() && this.ediboss.getThreadPool() > 1) {
            log.info((Object)"no multithread license, set threadpool to 1");
            this.ediboss.setThreadPool(1);
            this.ediboss.setRemoveThreadPool(1);
        }
        this.jobList.clear();
        this.runQueue = new RunQueue(this.lockDaemon, this);
        this.groupQueue = new FcGroupQueue(this.runQueue, this);
        this.sleepQueue = new SleepQueue(this.groupQueue, this);
        this.jobStepSeqQueue = new JobStepSeqQueue(this.sleepQueue, this);
        this.jobSeqQueue = new JobSeqQueue(this.jobStepSeqQueue);
        this.jobRemoveQueue = new RemoveQueue(this, "jobRemoveQueue");
        if (readRuntime) {
            if (this.eventRemoveQueue != null) {
                this.eventRemoveQueue.shutdown();
            }
            this.eventRemoveQueue = new RemoveQueue(this, "eventRemoveQueue");
        }
        this.activateQueue = new ActivateQueue(this);
        this.fcKillQueue = new FcKillQueue(this);
        this.threadPool = new ThreadPoolExecutor(this.ediboss.getThreadPool(), this.ediboss.getThreadPool(), 10L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>());
        this.threadPool.allowCoreThreadTimeOut(true);
        this.removeThreadPool = new ThreadPoolExecutor(this.ediboss.getRemoveThreadPool(), this.ediboss.getRemoveThreadPool(), 10L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable arg0) {
                Thread t = Executors.defaultThreadFactory().newThread(arg0);
                t.setPriority(3);
                return t;
            }
        });
        this.removeThreadPool.allowCoreThreadTimeOut(true);
        this.queues.put("runQueue", this.runQueue);
        this.queues.put("fcGroupQueue", this.groupQueue);
        this.queues.put("sleepQueue", this.sleepQueue);
        this.queues.put("jobStepSeqQueue", this.jobStepSeqQueue);
        this.queues.put("jobSeqQueue", this.jobSeqQueue);
        this.queues.put("jobRemoveQueue", this.jobRemoveQueue);
        this.queues.put("eventRemoveQueue", this.eventRemoveQueue);
        this.queues.put("activateQueue", this.activateQueue);
        this.queues.put("fcKillQueue", this.fcKillQueue);
        this.createSlaveHandler(new TextCfgSlave(this.ediboss.getSlaveFile()));
        this.cfgTimeWindow = new TextCfgTimeWindow(this.ediboss.getTimeWindowFile());
        if (this.globals.getJSelect() != null && !readRuntime) {
            this.globals.getJSelect().updateTwCfg(this.cfgTimeWindow);
        }
        this.globals.setTimeWindow(this.cfgTimeWindow);
        this.cfgRc = new TextCfgRc(this.ediboss.getRccFile());
        try {
            Connection conLocal = this.getConnection();
            object = null;
            try {
                log.info((Object)"Executing 'select distinct x.id from ctrl_job j left join ctrl_cfgjsl x on x.id=j.jslid order by x.id' ...");
                ResultSet usedCfgjslResultSet = conLocal.prepareStatement("select distinct x.id from ctrl_job j left join ctrl_cfgjsl x on x.id=j.jslid order by x.id").executeQuery();
                log.info((Object)"SELECT execution finished.");
                LinkedList<Long> usedCfgjsl = new LinkedList<Long>();
                while (usedCfgjslResultSet.next()) {
                    usedCfgjsl.add(usedCfgjslResultSet.getLong(1));
                }
                log.info((Object)("Used cgfjsl: " + usedCfgjsl.size()));
                log.info((Object)"Executing 'select id from ctrl_cfgjsl' ...");
                ResultSet allCfgjslResultSet = conLocal.prepareStatement("select id from ctrl_cfgjsl").executeQuery();
                log.info((Object)"SELECT execution finished.");
                LinkedList<Long> unusedCfgjsl = new LinkedList<Long>();
                while (allCfgjslResultSet.next()) {
                    long l = allCfgjslResultSet.getLong(1);
                    if (usedCfgjsl.contains(l)) continue;
                    unusedCfgjsl.add(l);
                }
                log.info((Object)("Unused cgfjsl: " + unusedCfgjsl.size()));
                PreparedStatement deleteStmtsCfgjobpar = conLocal.prepareStatement("DELETE FROM ctrl_cfgjobpar WHERE jslid = ?");
                PreparedStatement deleteStmtsCfgjsl = conLocal.prepareStatement("DELETE FROM ctrl_cfgjsl WHERE id = ?");
                log.info((Object)"Start deleting olg cfgjsl.");
                for (int i = 0; i < unusedCfgjsl.size(); ++i) {
                    long l = (Long)unusedCfgjsl.get(i);
                    deleteStmtsCfgjobpar.setLong(1, l);
                    deleteStmtsCfgjobpar.addBatch();
                    deleteStmtsCfgjsl.setLong(1, l);
                    deleteStmtsCfgjsl.addBatch();
                    if ((i + 1) % 10000 != 0) continue;
                    log.info((Object)"removing one batch of 10000 old cfgjsl ");
                    deleteStmtsCfgjobpar.executeBatch();
                    deleteStmtsCfgjsl.executeBatch();
                    log.info((Object)"finished removing 10000 old cfgjsl ");
                }
                log.info((Object)"removing one batch of less than 10000 old cfgjsl ");
                deleteStmtsCfgjobpar.executeBatch();
                deleteStmtsCfgjsl.executeBatch();
                log.info((Object)"finished removing old cfgjsl ");
                log.info((Object)"End deleting olg cfgjsl.");
                log.info((Object)"Executing 'select distinct x.id from ctrl_cfgjsl j left join ctrl_cfgjob x on x.id=j.jsid order by x.id' ...");
                ResultSet usedCfgjobsResultSet = conLocal.prepareStatement("select distinct x.id from ctrl_cfgjsl j left join ctrl_cfgjob x on x.id=j.jsid order by x.id").executeQuery();
                log.info((Object)"SELECT execution finished.");
                LinkedList<Long> usedCfgjobs = new LinkedList<Long>();
                while (usedCfgjobsResultSet.next()) {
                    usedCfgjobs.add(usedCfgjobsResultSet.getLong(1));
                }
                log.info((Object)("Used cgfjobs: " + usedCfgjobs.size()));
                log.info((Object)"Executing 'select id from ctrl_cfgjob' ...");
                ResultSet allCfgjobsResultSet = conLocal.prepareStatement("select id from ctrl_cfgjob").executeQuery();
                log.info((Object)"SELECT execution finished.");
                LinkedList<Long> unusedCfgjobs = new LinkedList<Long>();
                while (allCfgjobsResultSet.next()) {
                    if (usedCfgjobs.contains(allCfgjobsResultSet.getLong(1))) continue;
                    unusedCfgjobs.add(allCfgjobsResultSet.getLong(1));
                }
                log.info((Object)("Unused cgfjobs " + unusedCfgjobs.size()));
                PreparedStatement deleteStmtsCfgjspar = conLocal.prepareStatement("DELETE FROM ctrl_cfgjspar WHERE jsid = ?");
                PreparedStatement deleteStmtsCfgjsassign = conLocal.prepareStatement("DELETE FROM ctrl_cfgjsassign WHERE jsid = ?");
                PreparedStatement deleteStmtsCfgjsrcreactionr = conLocal.prepareStatement("DELETE FROM ctrl_cfgjsrcreaction WHERE jsid = ?");
                PreparedStatement deleteStmtsCfgjs = conLocal.prepareStatement("DELETE FROM ctrl_cfgjs WHERE id = ?");
                PreparedStatement deleteStmtsCfgjob = conLocal.prepareStatement("DELETE FROM ctrl_cfgjob WHERE id = ?");
                log.info((Object)"Start deleting olg cfgjobs.");
                for (int i = 0; i < unusedCfgjobs.size(); ++i) {
                    long cfgjobId = (Long)unusedCfgjobs.get(i);
                    deleteStmtsCfgjspar.setLong(1, cfgjobId);
                    deleteStmtsCfgjspar.addBatch();
                    deleteStmtsCfgjsassign.setLong(1, cfgjobId);
                    deleteStmtsCfgjsassign.addBatch();
                    deleteStmtsCfgjsrcreactionr.setLong(1, cfgjobId);
                    deleteStmtsCfgjsrcreactionr.addBatch();
                    deleteStmtsCfgjs.setLong(1, cfgjobId);
                    deleteStmtsCfgjs.addBatch();
                    deleteStmtsCfgjob.setLong(1, cfgjobId);
                    deleteStmtsCfgjob.addBatch();
                    if ((i + 1) % 10000 != 0) continue;
                    log.info((Object)"removing one batch of 10000 old cfgjobs ");
                    deleteStmtsCfgjspar.executeBatch();
                    deleteStmtsCfgjsassign.executeBatch();
                    deleteStmtsCfgjsrcreactionr.executeBatch();
                    deleteStmtsCfgjs.executeBatch();
                    deleteStmtsCfgjob.executeBatch();
                    log.info((Object)"finished removing 10000 old cfgjobs ");
                }
                log.info((Object)"removing one batch of less than 10000 old cfgjobs ");
                deleteStmtsCfgjspar.executeBatch();
                deleteStmtsCfgjsassign.executeBatch();
                deleteStmtsCfgjsrcreactionr.executeBatch();
                deleteStmtsCfgjs.executeBatch();
                deleteStmtsCfgjob.executeBatch();
                log.info((Object)"finished removing old cfgjobs ");
                log.info((Object)"End deleting olg cfgjobs.");
                conLocal.commit();
            }
            catch (Throwable usedCfgjslResultSet) {
                object = usedCfgjslResultSet;
                throw usedCfgjslResultSet;
            }
            finally {
                if (conLocal != null) {
                    if (object != null) {
                        try {
                            conLocal.close();
                        }
                        catch (Throwable usedCfgjslResultSet) {
                            ((Throwable)object).addSuppressed(usedCfgjslResultSet);
                        }
                    } else {
                        conLocal.close();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"marking of old cfg jobs/jsl failed", (Throwable)e);
        }
        this.globals.setJSelect(new TextCfgJSelect(this.ediboss.getJslFile(), this.ediboss.getJobFile(), this.cfgTimeWindow, this.cfgRc, this.globals.isClassic(), this.ediboss, this.jslSequence, this.dataSource, this.jsSequence));
        this.cfgFctn = new TextCfgFctn(this.slaves, this.cfgRc, this.ediboss.getFctnFile());
        if (this.globals.startTimeEvents) {
            this.cfgJSelectScheduler = new CfgJSelectScheduler(this.globals.getJSelect(), this, new Date());
            this.cfgJSelectSchedulerTimer = new Timer<TimeEventEntry>(this.cfgJSelectScheduler);
        }
        this.startPort();
        if (readRuntime) {
            Logbook.getLogbook().info("startUp  | start read jobs");
            final Hashtable<Long, WorkflowResultConnection> oldWfrConn = new Hashtable<Long, WorkflowResultConnection>();
            object = this.jobs;
            synchronized (object) {
                Iterator<IJob> it = this.jobs.values().iterator();
                while (it.hasNext()) {
                    CtrlEvent event = (CtrlEvent)it.next().getEvt();
                    if (event == null || event.getWFRConnection() == null) continue;
                    oldWfrConn.put(event.getId(), event.getWFRConnection());
                }
            }
            log.info((Object)("old wfr connections: " + oldWfrConn.size()));
            this.jobs = new Hashtable<Long, IJob>(this.ediboss.getSizeJobHash());
            new ManagedRunnableImpl(){

                public void doRun() {
                    try {
                        this.setName("Job Loader");
                    }
                    catch (Exception e) {
                        log.warn((Object)"can not set threat name", (Throwable)e);
                    }
                    int jobCnt = 0;
                    try {
                        jobCnt = CtrlDispAppl.this.loadData(reconfig, oldWfrConn);
                        CtrlDispAppl.this.lpmd.setStopped(false);
                        CtrlDispAppl.this.cfgJSelectSchedulerTimer.start();
                        CtrlDispAppl.this.startSlaveHandler();
                        CtrlDispAppl.this.status = Status.RUNNING;
                    }
                    catch (Throwable e) {
                        Logbook.getLogbook().error("Loading data in startUp failed. : " + e);
                        log.error((Object)"Loading data in startUp failed!", e);
                        CtrlDispAppl.this.shutdown(false);
                        return;
                    }
                    Logbook.getLogbook().info("startUp  | end read jobs: " + jobCnt);
                }
            }.start();
        } else {
            Logbook.getLogbook().info("startUp  | set new config to jobs");
            boolean reconfigActiveFirst = Boolean.parseBoolean(System.getProperty("reconfig.active.first"));
            final Map<Long, IJob> oldJobs = this.jobs;
            this.jobs = new Hashtable<Long, IJob>(this.ediboss.getSizeJobHash());
            final StarterThreads st = new StarterThreads(this);
            Iterator<IJob> it = oldJobs.values().iterator();
            while (it.hasNext()) {
                IJob job = it.next();
                if (reconfigActiveFirst) {
                    if (job.getStatus() == 4) continue;
                    st.newJob(job);
                    it.remove();
                    continue;
                }
                st.newJob(job);
            }
            st.wait4ready();
            this.checkAllBusyFc();
            this.groupQueue.start();
            this.jobSeqQueue.start();
            this.jobStepSeqQueue.start();
            this.jobRemoveQueue.start();
            this.activateQueue.start();
            this.lpmd.setStopped(false);
            this.cfgJSelectSchedulerTimer.start();
            this.startSlaveHandler();
            this.status = Status.RUNNING;
            if (reconfigActiveFirst) {
                log.info((Object)"Start not active jobs");
                Thread addOldJobs = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (IJob job : oldJobs.values()) {
                                st.newJob(job);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                addOldJobs.start();
            }
        }
    }

    private void checkLicense(LizCrypt license) throws IllegalAccessException {
        ILicRc rcTmp;
        ILicRc licRc = null;
        licRc = license.lizViolation(new String[]{MASTER_LICENSE}, "" + this.ediboss.getServerPort(), LICENSE_COMPONENT_EDIMAN_VERSION, true, true, 0);
        if (licRc.getLicRc() == 0) {
            rcTmp = license.lizViolation(new String[]{MT_LICENSE}, null, null, true, true, 0);
            if (rcTmp.getLicRc() == 0) {
                this.ediboss.setMultiThread(true);
            } else {
                this.ediboss.setMultiThread(false);
            }
        }
        if (!(licRc.getLicRc() != 0 || (rcTmp = license.lizViolation(new String[]{DBIF_LICENSE}, null, null, true, true, 0)).getLicRc() != 0 && this.isDerby)) {
            licRc = rcTmp;
        }
        if (licRc.getLicRc() != 0) {
            log.error((Object)("License check failed with RC: " + licRc.getLicRc() + ", msg: " + licRc.getErrMsg()));
            Logbook.getLogbook().error("EDIMAN License problem: Stop|RC: " + licRc.getLicRc() + "|" + licRc.getErrMsg() + "|");
            throw new IllegalAccessException(licRc.getErrMsg());
        }
    }

    private void openDbAccounting() {
        try {
            if (this.ediboss.getAccountingInDb()) {
                this.dbAccounting = new DbAccounting(Logbook.getLogbook(), true, this.dataSource, this.ediboss);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Accounting object: " + this.fileAccounting));
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot open dbAccounting object!", (Throwable)e);
            Logbook.getLogbook().error("Cannot open dbAccounting object: " + e);
        }
    }

    private void openFileAccounting() {
        try {
            if (this.ediboss.getAccountingInFile()) {
                this.fileAccounting = new StdAccount(Logbook.getLogbook(), true, this.ediboss.getAccountfileDir(), VERSION);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Accounting object: " + this.fileAccounting));
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot open fileAccounting object!", (Throwable)e);
            Logbook.getLogbook().error("Cannot open fileAccounting object: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNewSlave(SlaveHandler sh) {
        log.info((Object)("new Slave " + sh.getSlave().getName()));
        Map<Long, Appl> map = this.appl;
        synchronized (map) {
            for (Appl ap : this.appl.values()) {
                if (!(ap instanceof JoseAppl)) continue;
                ((JoseAppl)ap).newSlave(sh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUpdateSlave(SlaveHandler sh) {
        log.info((Object)("update Slave " + sh.getSlave().getName()));
        Map<Long, Appl> map = this.appl;
        synchronized (map) {
            for (Appl ap : this.appl.values()) {
                if (!(ap instanceof JoseAppl)) continue;
                ((JoseAppl)ap).updateSlave(sh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRemoveSlave(SlaveHandler sh) {
        log.info((Object)("remove Slave " + sh.getSlave().getName()));
        Map<Long, Appl> map = this.appl;
        synchronized (map) {
            for (Appl ap : this.appl.values()) {
                if (!(ap instanceof JoseAppl)) continue;
                ((JoseAppl)ap).removeSlave(sh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSlaveHandler() {
        TreeSlave treeSlave = this.slaves;
        synchronized (treeSlave) {
            for (SlaveHandler sh : this.slaves) {
                try {
                    sh.restart(this.runQueue);
                }
                catch (Exception e) {
                    log.error((Object)"restartSlaveHandler", (Throwable)e);
                    Logbook.getLogbook().error("could not start Slavehandler " + sh.getName() + ": " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSlaveHandler(CfgSlave cfgSlave) throws InterruptedException {
        TreeSlave treeSlave = this.slaves;
        synchronized (treeSlave) {
            TreeSlave oldSlaves = this.slaves;
            log.info((Object)("start slavehandler, old slaves: " + oldSlaves.size()));
            TreeSlave treeSlave2 = this.slaves = new TreeSlave();
            synchronized (treeSlave2) {
                CfgFctnEntry.removeBics();
                for (CfgSlaveEntry cse : cfgSlave.getSlaves()) {
                    SlaveHandler sh = oldSlaves.get(cse.getName());
                    if (sh != null) {
                        try {
                            sh.getSlave().updateSlave(cse);
                            this.addSlaveHandler(sh);
                            oldSlaves.remove(cse.getName());
                            this.sendUpdateSlave(sh);
                        }
                        catch (UnknownHostException e) {
                            Logbook.getLogbook().error("unknown host <" + cse.getHost() + "> in slavedcl.cfg(" + cse.getName() + ')');
                        }
                        catch (Exception e) {
                            log.error((Object)"updateSlave", (Throwable)e);
                            Logbook.getLogbook().error("could not start Slavehandler " + cse.getName() + ": " + e);
                        }
                        continue;
                    }
                    try {
                        CtrlSlave slave = new CtrlSlave(cse, this.lockDaemon);
                        sh = SlaveHandler.createSlaveHandler(slave, this.runQueue, this);
                        this.addSlaveHandler(sh);
                        this.sendNewSlave(sh);
                    }
                    catch (UnknownHostException e) {
                        Logbook.getLogbook().error("unknown host <" + cse.getHost() + "> in slavedcl.cfg(" + cse.getName() + ')');
                    }
                }
                Iterator<CfgSlaveEntry> it = oldSlaves.iterator();
                while (it.hasNext()) {
                    this.sendRemoveSlave((SlaveHandler)((Object)it.next()));
                }
            }
        }
    }

    private void addSlaveHandler(SlaveHandler sh) throws InterruptedException {
        if (sh.getSlave().getConnectionType() == CtrlSlave.ConnectionType.BUILTIN) {
            CfgFctnEntry.addBic(sh);
        }
        this.slaves.add(sh);
    }

    public IJob getJob(long jobid) throws InterruptedException {
        return this.getJobWithRetry(jobid, 1800);
    }

    public IJob getJobWithRetry(long jobid, int nrOfRetries) throws InterruptedException {
        if (jobid == 0L) {
            log.info((Object)"jobid = 0, return null");
            return null;
        }
        IJob job = this.jobs.get(jobid);
        if (job != null && this.status == Status.RUNNING) {
            return job;
        }
        if (job == null) {
            for (int i = 0; job == null && i < nrOfRetries; ++i) {
                job = this.getJobById(jobid);
            }
            if (this.status == Status.DOWN) {
                throw new InterruptedException();
            }
            if (job == null) {
                log.warn((Object)("job " + jobid + " does not exist. Hint: could happened at master reconfig."));
            }
        }
        return job;
    }

    private IJob getJobById(long jobId) throws InterruptedException {
        IJob job = null;
        if (this.status != Status.RUNNING && this.status != Status.DOWN) {
            Thread.sleep(500L);
            job = this.jobs.get(jobId);
        }
        return job;
    }

    public LockDaemon getLockDaemon() {
        return this.lockDaemon;
    }

    private int loadData(boolean reconfig, Hashtable<Long, WorkflowResultConnection> oldWfrConn) throws Throwable {
        Map<Long, CfgJobEntry> oldJob = null;
        Map<Long, CfgJSelectEntry> oldJsl = null;
        int active = -1;
        int maxRetry = 4;
        int retryDelay = 10;
        int retry = 0;
        while (active < 0) {
            block6: {
                if (retry > 0) {
                    Logbook.getLogbook().error("wait 10s to retry " + retry);
                    try {
                        Thread.sleep(1000L * (long)retryDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.jobs = new Hashtable<Long, IJob>(this.ediboss.getSizeJobHash());
                }
                try {
                    oldJob = CfgJobEntry.load(this.dataSource, this.cfgTimeWindow, this.getCfgRc());
                    oldJsl = CfgJSelectEntry.load(this.dataSource, this.ediboss, this.cfgTimeWindow, oldJob);
                    log.info((Object)("old cfgjob: " + oldJob.size()));
                    log.info((Object)("old cfgjsl: " + oldJsl.size()));
                    Logbook.getLogbook().info("Loading jobs.");
                    active = Loader.loadJobs(this, oldJsl, this.eventRemoveQueue, oldWfrConn);
                }
                catch (Throwable e) {
                    Logbook.getLogbook().error("load jobs: " + e.getMessage());
                    log.error((Object)"load jobs", e);
                    if (reconfig && retry < maxRetry) break block6;
                    throw e;
                }
            }
            ++retry;
        }
        this.checkAllBusyFc();
        this.groupQueue.start();
        this.jobSeqQueue.start();
        this.jobStepSeqQueue.start();
        this.activateQueue.start();
        this.eventRemoveQueue.start();
        this.jobRemoveQueue.start();
        return this.jobs.size();
    }

    private void updateUsedCfgJob(Map<Long, CfgJSelectEntry> oldJsl) {
        for (Map.Entry<Long, CfgJSelectEntry> entry : oldJsl.entrySet()) {
            CfgJSelectEntry cfgJSelectEntry = entry.getValue();
            CfgJobEntry cfgJobEntry = (CfgJobEntry)cfgJSelectEntry.getCfgJob();
            if (log.isDebugEnabled()) {
                log.debug((Object)("cfgJslEntry with id: " + cfgJSelectEntry.getId() + " is used by: " + cfgJSelectEntry.getUsed() + " job(s)"));
                log.debug((Object)("cfgJobEntry with id: " + cfgJobEntry.getId() + " is used by: " + cfgJobEntry.getUsed() + " jslEntries"));
            }
            if (cfgJSelectEntry.isUsed()) continue;
            cfgJobEntry.setUsed(true);
        }
    }

    @Override
    public boolean newJob(IExecutable job) throws SQLException, LockException {
        return this.newJob(job, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean newJob(IExecutable job, boolean createdFromDB) throws SQLException, LockException {
        if (job instanceof CtrlJob) {
            CtrlJob cjob = (CtrlJob)job;
            LockJob lj = new LockJob(job.getId());
            this.lockDaemon.globalLock((SyncObject)lj);
            try {
                Connection con;
                block31: {
                    IExecutable oldJob = this.jobs.put(job.getId(), cjob);
                    if (oldJob != null) {
                        this.jobs.put(job.getId(), (CtrlJob)oldJob);
                        log.warn((Object)("CtrlDispAppl.newJob: job " + job.getId() + " already in hashtable!!!"));
                        boolean bl = false;
                        return bl;
                    }
                    this.jobList.add(cjob);
                    try {
                        cjob.setFctn(this.cfgFctn, this.dataSource);
                    }
                    catch (CfgException e) {
                        Logbook.getLogbook().error("set fctn: " + e.getMessage());
                        if (cjob.getStatus() == 6) break block31;
                        cjob.setStatus(6);
                        try (Connection con2 = null;){
                            con2 = this.getConnection();
                            cjob.update(con2);
                            con2.commit();
                        }
                    }
                }
                if (cjob.getStatus() != 4) {
                    if (createdFromDB && (cjob.isSeq() || cjob.getSeqSteps().size() > 0) && cjob.getEvt().getAttr() == null) {
                        con = this.getConnection();
                        try {
                            ((CtrlEvent)cjob.getEvt()).reloadAttr(con);
                        }
                        finally {
                            con.close();
                        }
                    }
                    this.jobStepSeqQueue.newSeqJob(cjob);
                }
                if (!createdFromDB) {
                    try {
                        con = this.getConnection();
                        try {
                            con.setReadOnly(true);
                            this.accountingStartMsg(cjob, con);
                        }
                        finally {
                            con.close();
                        }
                    }
                    catch (Throwable e) {
                        log.warn((Object)"error on write accounting start", e);
                    }
                    Map<Long, Appl> map = this.appl;
                    synchronized (map) {
                        for (Appl ap : this.appl.values()) {
                            if (!(ap instanceof JoseAppl)) continue;
                            ((JoseAppl)ap).newJob(cjob);
                        }
                    }
                }
                SetEvtStormWall.doSuspStopJob(cjob, true);
                this.dispatch(cjob, createdFromDB);
            }
            finally {
                this.lockDaemon.globalUnLock((SyncObject)lj);
            }
        }
        if (job instanceof JBpmJob) {
            this.jobs.put(job.getId(), (JBpmJob)job);
            this.jobList.add((IJob)job);
            ((JBpmJob)job).signal();
        } else if (job instanceof JslBuiltin) {
            ((JslBuiltin)job).setSlaves(this.getBicSlaveHandler());
            this.dispatch(job);
        } else {
            Logbook.getLogbook().error("unknown IExecutable: " + job.getClass());
        }
        return true;
    }

    protected void dispatch(Token token) throws InterruptedException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("dispatch start: " + token));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"dispatch start:");
        }
        ProcessInstance pi = token.getProcessInstance();
        IJob job = this.getJob(pi.getId());
        if (job == null) {
            Logbook.getLogbook().error("No job found: " + pi.getId());
        } else {
            this.dispatch(job);
        }
    }

    public void dispatch(IExecutable executable) {
        this.dispatch(executable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(IExecutable executable, boolean createdFromDB) {
        block53: {
            Connection con;
            IJob job;
            block52: {
                if (executable instanceof JslBuiltin) {
                    this.jobSeqQueue.runJob(executable);
                    return;
                }
                job = (IJob)executable;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("dispatch start: job: " + job + ", createdFromDB: " + createdFromDB));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("dispatch start: job: " + job.getName() + "." + job.getId() + ", createdFromDB: " + createdFromDB));
                }
                con = null;
                if (!((CtrlJob)job).isRunJs()) break block52;
                if (!job.isSuspended()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("call runQueue.startJob: " + job.getName() + "." + job.getId()));
                    } else if (log.isTraceEnabled()) {
                        log.trace((Object)("call runQueue.startJob: " + job));
                    }
                    this.runQueue.runJob(job);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"job is suspended -> activateQueue.newJob");
                    }
                    if (createdFromDB && job.isSeq()) {
                        this.jobSeqQueue.newJob(job);
                    }
                    this.activateQueue.newJob(job);
                }
                break block53;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("current job status: " + job.getStatus()));
            }
            switch (job.getStatus()) {
                case 1: 
                case 3: {
                    if (job.isSuspended()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"job is suspended -> activateQueue.newJob");
                        }
                        if (createdFromDB && job.isSeq()) {
                            this.jobSeqQueue.newJob(job);
                        }
                        this.activateQueue.newJob(job);
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("job isn't suspended -> jobSeqQueue.runJob: ID: " + job.getId()));
                    }
                    this.jobSeqQueue.runJob(job);
                    break;
                }
                case 4: {
                    if (this.globals.isClassic()) {
                        ((CtrlJob)job).shrink();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("jobRemoveQueue.newRemoveJob: " + job.getId()));
                    }
                    this.jobRemoveQueue.newRemoveJob(job);
                    break;
                }
                case 5: {
                    if (createdFromDB) {
                        CtrlFunctionCall fc;
                        CtrlJobStep js;
                        if (job.isSeq()) {
                            this.jobSeqQueue.newJob(job);
                        }
                        if ((js = (CtrlJobStep)job.getCurrentStep()).isGrouped()) {
                            this.groupQueue.addActive(job);
                        }
                        if ((fc = js.getLastFc()) == null) {
                            this.stopJob(job, (Exception)((Object)new CfgException("no last fc for " + job.getId() + '.' + job.getActiveStep())));
                        } else {
                            String slave = fc.getSlave();
                            SlaveHandler sh = this.getSlaveHandler(slave);
                            if (sh == null) {
                                this.stopJob(job, (Exception)((Object)new CfgException("no slave for " + job.getId() + '.' + job.getActiveStep())));
                            } else {
                                sh.addActiveJob();
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("dispatch[job=" + executable.getId() + ", slave=" + sh.getName() + "]: locked slave."));
                                }
                                if (js.getMaxExecTime() > 0) {
                                    this.fcKillQueue.watchJob(job, js.getMaxExecTime());
                                }
                                Logbook.getLogbook().warning(job.getId() + "|status active");
                            }
                        }
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("Job is still/current active: " + job.getId()));
                    break;
                }
                case 2: {
                    if (createdFromDB && job.isSeq()) {
                        this.jobSeqQueue.newJob(job);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Job step error, retry full: " + job.getId()));
                    }
                    CtrlFunctionCall fc = (CtrlFunctionCall)job.getLastFc();
                    if (!createdFromDB) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("End job, getJsl: " + job.getJsl()));
                        }
                        try {
                            con = this.getConnection();
                            this.accWriteEnd((CtrlJob)job, con);
                        }
                        catch (Exception e) {
                            Logbook.getLogbook().error("Error creating account entry: " + e.toString());
                            log.error((Object)"Error creating account entry!", (Throwable)e);
                        }
                        finally {
                            try {
                                if (con != null) {
                                    con.close();
                                }
                            }
                            catch (SQLException e) {
                                log.warn((Object)"can not close db connection", (Throwable)e);
                            }
                        }
                    }
                    CtrlSlave slave = fc != null && fc.getSlave() != null ? this.getSlave(fc.getSlave()) : null;
                    Logbook.getLogbook().retryfullJS(job.getName(), job.getId(), job.getCurrentStepName(), fc != null ? fc.getInstanceName4Log() : "", slave != null ? slave.getHostname() : "undefined slave", createdFromDB || fc == null ? "" : fc.getReal());
                    if (createdFromDB) break;
                    this.rcbWriteJobFailure((CtrlJob)job);
                    job.execOnRetryFull(this.ediboss.getMasterExecTimeout());
                    break;
                }
                case 6: {
                    if (createdFromDB && job.isSeq()) {
                        this.jobSeqQueue.newJob(job);
                    }
                    Logbook.getLogbook().stopJob(job);
                    break;
                }
                default: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Job " + job.getId() + "contains invalid status: " + job.getStatus()));
                    }
                    Logbook.getLogbook().warning("Job " + job.getId() + " invalid status " + job.getStatus());
                }
            }
        }
        log.debug((Object)"dispatch end:");
    }

    boolean isAwaitedResult(long jobId, int stepNo, int stepRetry, int stepLevel, int fcSeqNo, int fcSeqRetry, int fcLevel) throws InterruptedException {
        IJob job = this.getJob(jobId);
        return this.isAwaitedResult(job, new Result(jobId, stepNo, stepRetry, stepLevel, fcSeqNo, fcSeqRetry, fcLevel));
    }

    boolean isAwaitedResult(IJob job, Result result) {
        CtrlJobStep step = null;
        CtrlFunctionCall fc = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("fc instance: " + result.getJobId() + "." + result.getStepNo() + "." + result.getStepRetry() + "." + result.getStepLevel() + "." + result.getFcSeqNo() + "." + result.getFcSeqRetry() + "." + result.getFcLevel()));
        }
        try {
            if (job == null) {
                log.trace((Object)("fc: " + result.getJobId() + "." + result.getStepNo() + " return: false because job is unknown."));
                return false;
            }
            if (result.getStepNo() > 0) {
                if (result.getStepNo() != job.getActiveStep()) {
                    step = null;
                    log.warn((Object)("Result ignored for jobid=" + result.getJobId() + " resultStepNr=" + result.getStepNo() + "."));
                } else {
                    step = (CtrlJobStep)job.getStep(result.getStepNo());
                }
            } else {
                step = (CtrlJobStep)job.getCurrentStep();
            }
            if (step == null) {
                log.trace((Object)("fc: " + result.getJobId() + "." + result.getStepNo() + " return: false because current step is null."));
                return false;
            }
            fc = step.getLastFc();
            if (fc == null) {
                log.warn((Object)("fc: " + result.getJobId() + "." + result.getStepNo() + " return: false because last FC is null."));
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("isAwaitedResult Check against last FC: " + (Object)((Object)fc)));
            }
            if (result.getStepNo() >= 0 && result.getStepNo() != step.getStepNo()) {
                log.warn((Object)("fc: " + result.getJobId() + "." + result.getStepNo() + " return: false because current step is " + step.getStepNo() + " != " + result.getStepNo()));
                return false;
            }
            if (result.getStepRetry() >= 0 && result.getStepRetry() != step.getRetry()) {
                log.warn((Object)("fc: " + result.getJobId() + "." + result.getStepNo() + " return: false because current step retry is " + step.getRetry() + " != " + result.getStepRetry()));
                return false;
            }
            if (result.getStepLevel() >= 0 && result.getStepLevel() != step.getLevel()) {
                log.warn((Object)("fc: " + result.getJobId() + "." + result.getStepNo() + " return: false because current step level is " + step.getLevel() + " != " + result.getStepLevel()));
                return false;
            }
            if (result.getFcSeqNo() >= 0 && result.getFcSeqNo() != fc.getSeqNo()) {
                log.warn((Object)("fc: " + result.getJobId() + "." + result.getStepNo() + " return: false because fcSeqNo is " + fc.getSeqNo() + " != " + result.getFcSeqNo()));
                return false;
            }
            if (result.getFcSeqRetry() >= 0 && result.getFcSeqRetry() != fc.getSeqRetry()) {
                log.warn((Object)("fc: " + result.getJobId() + "." + result.getStepNo() + " return: false because fcSeqRetry is " + fc.getSeqRetry() + " != " + result.getFcSeqRetry()));
                return false;
            }
            if (result.getFcLevel() >= 0 && result.getFcLevel() != fc.getLevel()) {
                log.warn((Object)("fc: " + result.getJobId() + "." + result.getStepNo() + " return: false because fcLevel is " + fc.getLevel() + " != " + result.getFcLevel()));
                return false;
            }
            if ((step.getStatus() & 1) == 1 && (step.getStatus() & 2) == 0 && (step.getStatus() & 0x80) == 0) {
                log.warn((Object)("fc: " + result.getJobId() + "." + result.getStepNo() + " return: false because jobstep is readytorun, status: " + step.getStatus()));
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot identify result: " + result.getJobId() + "." + result.getStepNo() + "." + result.getStepRetry() + "." + result.getFcSeqNo() + "." + result.getFcSeqRetry()), (Throwable)e);
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("fc end: true " + result.getJobId() + "." + result.getStepNo() + "." + result.getStepRetry() + "." + result.getStepLevel() + result.getFcSeqNo() + "." + result.getFcSeqRetry() + "." + result.getFcLevel()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUpdateJob(IJob job) {
        Map<Long, Appl> map = this.appl;
        synchronized (map) {
            for (Appl ap : this.appl.values()) {
                if (!(ap instanceof JoseAppl)) continue;
                ((JoseAppl)ap).updateJob(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDisconnectObjBwr() {
        Map<Long, Appl> map = this.appl;
        synchronized (map) {
            if (nbOfDisconnectObjBwrSent < 3) {
                for (Appl ap : this.appl.values()) {
                    if (!(ap instanceof JoseAppl)) continue;
                    ((JoseAppl)ap).disconnectObjBwrDbDown();
                }
                log.info((Object)("Sent " + ++nbOfDisconnectObjBwrSent + " disconnect notifications to ObjectBrowser"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setResult(Result res, Connection con) throws SQLException, InterruptedException, LockException, UnexpectedRuntimeException {
        CtrlFunctionCall fc;
        CtrlJobStep js;
        IJob job;
        boolean isOk;
        block71: {
            boolean jobWasActive;
            isOk = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)("start: result: " + res));
            }
            if (con == null) {
                throw new UnexpectedRuntimeException("Illegal argument: setResult called with con=null.");
            }
            job = this.getJob(res.getJobId());
            if (res.isExtern() || !this.isAwaitedResult(job, res)) {
                if (log.isDebugEnabled()) {
                    if (res.isExtern()) {
                        log.debug((Object)("Got external Result: " + res.getExternId()));
                    } else {
                        log.debug((Object)("Got Result of unknown Job " + res.getJobId()));
                    }
                }
                Logbook.getLogbook().result(res.isExtern() ? res.getExternId() : "", res.getJobId(), "", res.getInstanceNameWOL(), res.getSenderHost() != null ? res.getSenderHost() : "<null host>", "" + res.getRc(), res.getProtfile());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"end: false");
                }
                return false;
            }
            this.fcKillQueue.remove(job.getId());
            js = (CtrlJobStep)job.getStep(res.getStepNo());
            fc = js.getLastFc();
            boolean bl = jobWasActive = fc != null && (fc.isBuiltin() || job.getStatus() == 5);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Function call for result: " + (Object)((Object)fc)));
            }
            if (fc == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"fc is null.");
                }
                Logbook.getLogbook().error("Last fc is null, jobid " + job.getId() + ", active step " + job.getActiveStep());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"setResult end: false");
                }
                return false;
            }
            try {
                if (job instanceof CtrlJob) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Job is a CtrlJob instance.");
                    }
                    CtrlJob org = new CtrlJob((CtrlJob)job);
                    try {
                        try {
                            CtrlSlave newCompSlave;
                            SlaveHandler slave = this.getSlaveHandler(fc.getSlave());
                            if (slave != null) {
                                slave.rePing();
                                newCompSlave = slave.getSlave();
                            } else {
                                newCompSlave = this.getSlave(fc.getSlave());
                            }
                            isOk = ((CtrlJob)job).setResult(res, con, newCompSlave, this);
                        }
                        catch (SQLException e) {
                            try {
                                con.rollback();
                            }
                            catch (SQLException newCompSlave) {
                                // empty catch block
                            }
                            throw e;
                        }
                        catch (Exception e) {
                            log.error((Object)"job.setResult error:", (Throwable)e);
                            Logbook.getLogbook().error(e.toString());
                        }
                        long start = System.currentTimeMillis();
                        con.commit();
                        WorkerThread.addDbTime(System.currentTimeMillis() - start);
                        this.sendUpdateJob(job);
                        break block71;
                    }
                    catch (SQLException e) {
                        jobWasActive = false;
                        this.jobs.put(org.getId(), org);
                        log.error((Object)"setResult: Cannot update DB", (Throwable)e);
                        Logbook.getLogbook().error("Result |" + res.getJobId() + "." + res.getStepNo() + "|" + e);
                        this.sendDisconnectObjBwr();
                        throw e;
                    }
                    finally {
                        if (con != null) {
                            log.trace((Object)"setResult, free DBInterface");
                            con.close();
                            con = null;
                        }
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"job isn't a CtrlJob instance!");
                }
            }
            finally {
                try {
                    if (jobWasActive) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("CtrlDispAppl:setResult[job=" + job.getId() + ", slave=" + this.getSlave(fc.getSlave()).getName() + "]: unlocked slave."));
                        }
                        this.getSlave(fc.getSlave()).delRunningJob();
                    }
                }
                catch (LockException e) {
                    Logbook.getLogbook().error("Cannot unlock slave: " + (Object)((Object)e));
                }
            }
        }
        if (js.isGrouped() || js.getFcGroup() != null) {
            logGrouping.debug((Object)("Will remove jobId=" + js.getJobId() + " step=" + js.getName() + " from grouping list"));
            this.groupQueue.removeJs(js);
        }
        if (js.isSeq()) {
            if (job.getStatus() == 1 || job.getStatus() == 4) {
                this.jobStepSeqQueue.jobStepDone(js);
            } else {
                Logbook.getLogbook().warning("jobstep " + job.getId() + "." + js.getStepNo() + " is in sequence " + js.getSeqName() + " and status is " + job.getStatus() + ", not removed fom sequence");
            }
        }
        if (job.isSeq() && job.getStatus() == 4) {
            this.jobSeqQueue.jobDone(job);
        }
        String action = "undefined";
        action = job.getStatus() == 6 ? "STOP_STOP" : js.getLastRc().toString() + ", RcClass: <" + js.getLastRcName() + ">";
        String protfile = js.getProtfileName();
        if (!new File(protfile).isFile()) {
            protfile = null;
        }
        Logbook.getLogbook().result(job.getName(), job.getId(), js.getName(), res.getInstanceName4Log(), this.getSlave(fc.getSlave()).getHostname(), res.getRc() + " FC: " + action, protfile);
        this.sentinelFcEndMsg(fc);
        if (isOk) {
            if (js.getRcbLog()) {
                this.rcbWriteJsSuccess(fc);
            }
            if (js.getLogicalEndFlag()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Logical end of job found at " + job.getName() + "/" + js.getName()));
                }
                Connection myCon = null;
                try {
                    myCon = this.getConnection();
                    log.debug((Object)"got myCon, call accWriteLogicalEnd");
                    this.accWriteLogicalEnd((CtrlJob)job, myCon);
                    log.debug((Object)"accWriteLogicalEnd ended");
                }
                catch (Exception e) {
                    log.error((Object)"Cannot access db connection for accWriteLogicalEnd!", (Throwable)e);
                }
                finally {
                    if (myCon != null) {
                        try {
                            myCon.close();
                        }
                        catch (Exception e) {
                            log.error((Object)"Cannot close temporary connection: ", (Throwable)e);
                        }
                    }
                }
            }
            if (job.getStatus() != 4 && job.getStatus() != 6 && job.getCurrentStep() != null) {
                this.sentinelJsStartMsg((CtrlJobStep)job.getCurrentStep());
            }
        } else {
            if (js.getRcbLog()) {
                this.rcbWriteJsFailure(fc, protfile);
            }
            job.execOnError(this.ediboss.getMasterExecTimeout());
        }
        if (job.getStatus() == 4) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("End job, ID: " + job.getId()));
                log.debug((Object)("End job, getJsl: " + job.getJsl()));
            }
            Connection accCon = null;
            try {
                accCon = this.getConnection();
                this.accWriteEnd((CtrlJob)job, accCon);
            }
            catch (Exception e) {
                log.error((Object)"Error on writeing accounting record!", (Throwable)e);
            }
            finally {
                if (accCon != null) {
                    accCon.close();
                    accCon = null;
                }
            }
            Logbook.getLogbook().endJob(job.getName(), job.getId(), job.getEvt().getId(), job.getId(), ((CtrlJob)job).getLastRc());
        }
        if (job.getStatus() != 6) {
            this.dispatch(job);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end: true");
        }
        return true;
    }

    private void removeEdiComps(CtrlJob cJob, Set<String> comps2Keep) throws SQLException {
        Collection<EdiComp> comps = cJob.getComps();
        CtrlSlave compSlave = null;
        SlaveHandler slaveHandler = null;
        EdiComp oneComp2 = null;
        try {
            int[] rcs;
            if (log.isTraceEnabled()) {
                log.trace((Object)("removeEdiComps start: job: " + cJob));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("removeEdiComps start: job Id: " + cJob));
            }
            if (comps.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Job " + cJob.getId() + " has no EDI object components to remove."));
                }
                return;
            }
            compSlave = (CtrlSlave)cJob.getCompSlave();
            if (compSlave == null) {
                log.error((Object)("Job " + cJob.getId() + " does not contain EDI Object Slave. Cannot remove  EDI Object components!"));
                return;
            }
            slaveHandler = this.getSlaveHandler(compSlave.getName());
            TreeSet<EdiComp> comps2Remove = new TreeSet<EdiComp>();
            if (comps2Keep == null || comps2Keep.size() == 0) {
                comps2Remove.addAll(comps);
            } else {
                for (EdiComp oneComp2 : comps) {
                    if (comps2Keep.contains(oneComp2.getName())) continue;
                    comps2Remove.add(oneComp2);
                }
            }
            String[] fileNames = new String[comps2Remove.size()];
            String[] compNames = new String[comps2Remove.size()];
            int[] compNums = new int[comps2Remove.size()];
            int i = 0;
            for (EdiComp oneComp2 : comps2Remove) {
                fileNames[i] = oneComp2.getFileName();
                compNames[i] = oneComp2.getName();
                compNums[i] = oneComp2.getNum();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EDI Object component to delete: " + compNums[i] + "): " + compNames[i] + " = " + fileNames[i]));
                }
                ++i;
            }
            if (slaveHandler.getSlave().isLocal()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("EDI Object components are stored locally at: " + slaveHandler.getSlave()));
                }
                rcs = new int[fileNames.length];
                for (i = 0; i < fileNames.length; ++i) {
                    rcs[i] = new File(fileNames[i]).delete() ? 0 : -1;
                }
            } else {
                rcs = slaveHandler.rmFiles(fileNames);
            }
            if (rcs == null) {
                log.warn((Object)"No return codes received for RM_FILE command");
            } else if (rcs.length != compNames.length) {
                log.error((Object)"Error while removed EDI object components!");
                log.error((Object)"Number of RCs don't match number of component");
                Logbook.getLogbook().error("Error while removed EDI object components!");
                Logbook.getLogbook().error("Number of RCs don't match number of component");
                for (i = 0; i < rcs.length; ++i) {
                    log.error((Object)("RM_FILE RC[" + i + "] = " + rcs[i]));
                }
            } else {
                for (i = 0; i < rcs.length; ++i) {
                    Logbook.getLogbook().info(String.format("%10s|%10s|REMOVE EDI file|RC=%d %s|Comp #%d %s=%s|", cJob.getId(), cJob.getId(), rcs[i], rcs[i] == 0 ? "OK" : "ERR", 1 + compNums[i], compNames[i], fileNames[i]));
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("comp[" + i + "] = " + compNames[i] + " = '" + fileNames[i] + "' remove RC:" + rcs[i]));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while remove edi object components!", (Throwable)e);
        }
        log.debug((Object)"removeEdiComps end:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IRemovable job, boolean lock) throws SQLException, IOException {
        block32: {
            LockJob lj = null;
            Set<String> archiveFailed = null;
            HashSet<String> comps2Keep = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove start: ID: " + job.getId()));
            }
            if (lock) {
                lj = new LockJob(job.getId());
                try {
                    this.lockDaemon.globalLock((SyncObject)lj);
                }
                catch (LockException e) {
                    log.error((Object)("Cannot lock job " + job.getId()), (Throwable)e);
                    return false;
                }
            }
            try {
                if (!this.globals.isClassic()) break block32;
                try (Connection con = this.getConnection();){
                    CtrlJob cjob;
                    if (job instanceof CtrlEvent) {
                        CtrlEvent.remove(con, job.getId());
                        con.commit();
                    } else {
                        cjob = (CtrlJob)job;
                        if (this.ediboss.getArchiveOn()) {
                            archiveFailed = cjob.execArchiveCmd(this.ediboss.getMasterExecTimeout());
                        }
                        if (this.ediboss.getAutoRemoveOn()) {
                            comps2Keep = new HashSet<String>();
                            if (cjob.getComps2Keep() != null) {
                                comps2Keep.addAll(cjob.getComps2Keep());
                            }
                            if (archiveFailed != null) {
                                comps2Keep.addAll(archiveFailed);
                            }
                            this.removeEdiComps(cjob, comps2Keep);
                        }
                        int lastRc = cjob.getLastRc();
                        cjob.remove(con);
                        CtrlEvent evt = (CtrlEvent)cjob.getEvt();
                        long removeDate = System.currentTimeMillis() + (long)this.ediboss.getEventRemoveDelay() * 1000L;
                        evt.setRemoveDate(con, removeDate);
                        this.eventRemoveQueue.newRemoveJob(evt);
                        Logbook.getLogbook().removeJob(cjob.getName(), cjob.getId(), cjob.getEvt().getId(), cjob.getId(), lastRc);
                        con.commit();
                    }
                    if (!(job instanceof CtrlJob)) break block32;
                    cjob = (CtrlJob)job;
                    cjob.getEvt().shrink();
                    Map<Long, Appl> map = this.appl;
                    synchronized (map) {
                        for (Appl ap : this.appl.values()) {
                            if (!(ap instanceof JoseAppl)) continue;
                            ((JoseAppl)ap).removeJob(cjob);
                        }
                    }
                }
            }
            finally {
                if (lock) {
                    try {
                        this.lockDaemon.globalUnLock((SyncObject)lj);
                    }
                    catch (LockException e) {
                        log.error((Object)("Cannot unlock job " + job.getId()), (Throwable)e);
                    }
                }
            }
        }
        Map<Long, IJob> map = this.jobs;
        synchronized (map) {
            this.jobs.remove(job.getId());
        }
        this.jobList.remove(job);
        return true;
    }

    public void cleaningUp(Connection con, LockDaemon ld) {
    }

    public void unlockAllSyncObjects(long id) {
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public CfgFctn getCfg() {
        return this.cfgFctn;
    }

    public CfgJSelect getJsl() {
        return this.globals.getJSelect();
    }

    @Override
    public Ediboss getEdiboss() {
        return this.ediboss;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection con = this.dataSource.getConnection();
        try {
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            log.error((Object)("Can not set autocommit to false: " + e));
            con.close();
            throw e;
        }
        return con;
    }

    boolean shutdownPort(String caller) {
        if (this.lpmd == null) {
            log.warn((Object)"LogProtMsgDaemon is not running!");
            return true;
        }
        try {
            this.lpmd.shutdown(60000L, caller);
            this.lpmd = null;
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Cannot shutdown LogProtMsgDaemon!", (Throwable)e);
            return false;
        }
    }

    boolean startPort() throws IOException {
        if (this.lpmd != null) {
            log.warn((Object)"LogProtMsgDaemon already running.");
            return true;
        }
        this.lpmd = new LogProtMsgDaemon(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean location() {
        String filename;
        TreeSet<IdSortedJob> idSortedJobs = new TreeSet<IdSortedJob>();
        StringBuilder stat = new StringBuilder();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start dumping locus data");
        }
        PrintWriter pw = null;
        try {
            filename = this.ediboss.getProtfileDir() + "/hash.job";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opening locus job hash file '" + filename + "'"));
            }
            filename = new ActisFile(filename).toString();
            pw = new PrintWriter(filename);
            Map<Long, IJob> map = this.jobs;
            synchronized (map) {
                Iterator<IJob> it = this.jobs.values().iterator();
                while (it.hasNext()) {
                    idSortedJobs.add(new IdSortedJob((Job)it.next()));
                }
            }
            pw.println("Dump of global job hash table: " + new Date());
            pw.println("size: " + idSortedJobs.size());
            pw.println("job id     |                         job name |       creation time |     status | obj status |");
            pw.println("-----------+----------------------------------+---------------------+------------+------------+");
            for (IdSortedJob job : idSortedJobs) {
                pw.println(String.format("%10.10s | %32s | %3$tF %3$tT | %4$10.10s | %5$10.10s |", job.getJob().getId(), job.getJob().getName(), new Date(job.getJob().getCreationDate()), job.getJob().getStatus() + "/" + job.getJob().getStatusText(), job.getJob().getObjStatusText()));
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot create locus dump output!", (Throwable)e);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                    pw = null;
                }
                catch (Exception shit) {
                    log.error((Object)"Cannot close locus hash dump stream!", (Throwable)shit);
                }
            }
        }
        pw = null;
        try {
            filename = this.ediboss.getProtfileDir() + "/status.master";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opening locus master status file '" + filename + "'"));
            }
            filename = new ActisFile(filename).toString();
            pw = new PrintWriter(filename);
            pw.println("****************************************************************");
            pw.println("* Dump of Java Master Status data: " + new Date());
            pw.println("****************************************************************\n");
            this.addUptimeStatus(stat);
            this.addMemStatus(stat);
            stat.append("\n");
            this.addDBStatus(stat);
            stat.append("\n");
            this.addThreadsStatus(stat);
            this.addMasterPortStatus(stat);
            this.slaves.addSlavesStatus(stat);
            this.addApplicationsStatus(stat);
            stat.append(this.lockDaemon.getStatus());
            pw.println(stat.toString());
        }
        catch (Exception e) {
            log.error((Object)"Cannot create locus master status output!", (Throwable)e);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                    pw = null;
                }
                catch (Exception shit) {
                    log.error((Object)"Cannot close locus master dump stream!", (Throwable)shit);
                }
            }
        }
        for (String queueName : this.queues.keySet()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will create dump of queue <" + queueName + ">: " + new Date()));
            }
            DumpableQueue queue = this.queues.get(queueName);
            pw = null;
            try {
                filename = this.ediboss.getProtfileDir() + "/queue." + queueName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Opening locus dump file '" + filename + "'"));
                }
                filename = new ActisFile(filename).toString();
                pw = new PrintWriter(filename);
                pw.println("Dump of queue '" + queueName + "', Time: " + new Date());
                pw.print(queue.getStatus(true));
            }
            catch (Exception e) {
                log.error((Object)"Cannot create locus dump output!", (Throwable)e);
            }
            finally {
                if (pw == null) continue;
                try {
                    pw.close();
                    pw = null;
                }
                catch (Exception shit) {
                    log.error((Object)"Cannot close locus dump stream!", (Throwable)shit);
                }
            }
        }
        Logbook.getLogbook().info("LOCATION data dumped.");
        if (log.isDebugEnabled()) {
            log.debug((Object)"Start dumping locus data");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rmJoeStatTable(int table, int hours) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("rmJoeStatTable start: " + STAT_TABLES[table] + ", tmo: " + hours + " hours"));
        }
        boolean done = false;
        Connection con = null;
        DebPrepStmt delete = null;
        int nowTimeT = 0;
        try {
            nowTimeT = (int)(System.currentTimeMillis() / 1000L);
            con = this.getConnection();
            delete = new DebPrepStmt(con, STAT_RM_STMT[table], dbLog);
            delete.setInt(1, nowTimeT - 3600 * hours);
            delete.executeUpdate();
            con.commit();
            done = true;
        }
        catch (Exception e) {
            if (con != null) {
                try {
                    con.rollback();
                }
                catch (SQLException ex) {
                    log.warn((Object)"can not rollback", (Throwable)e);
                }
            }
            log.error((Object)("Cannot remove old entries from " + STAT_TABLES[table] + "."), (Throwable)e);
            Logbook.getLogbook().error("Cannot remove old entries from " + STAT_TABLES[table] + ": " + e);
        }
        finally {
            if (delete != null) {
                try {
                    delete.close();
                }
                catch (Exception e) {
                    log.error((Object)"Cannot close delete statement.", (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"can not close db connection", (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("rmJoeStatTable end: " + done));
        }
        return done;
    }

    private void clearStatTables() {
        log.debug((Object)"clearStatTables start:");
        long now = System.currentTimeMillis();
        Calendar tomorrow = null;
        if (now >= this.statClearTime) {
            if (this.rmJoeStatTable(1, 24)) {
                Logbook.getLogbook().info("Cleared Java Master busy time statistics.");
            } else {
                Logbook.getLogbook().error("Cannot clear Java Master busy time statistics.");
            }
            if (this.rmJoeStatTable(0, 24)) {
                Logbook.getLogbook().info("Cleared Java Master function call statistics.");
            } else {
                Logbook.getLogbook().error("Cannot clear Java Master function call statistics.");
            }
            tomorrow = Calendar.getInstance();
            tomorrow.setTimeInMillis(now);
            tomorrow.set(5, tomorrow.get(5) + 1);
            tomorrow.set(11, 1);
            tomorrow.set(12, 44);
            tomorrow.set(13, 55);
            tomorrow.set(14, 0);
            this.statClearTime = tomorrow.getTimeInMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)("run clearStatTable again at: " + new Date(this.statClearTime)));
            }
        }
        log.debug((Object)"clearStatTables end:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeJoeStat() {
        log.debug((Object)"writeJoeStat start:");
        Connection con = null;
        String sqlFc = "insert into CTRL_STAT_FC (REAL_TIME, FLOW_RATE) values (?, ?)";
        String sqlBusy = "insert into CTRL_STAT_BUSY (REAL_TIME, BUSY_RATE) values (?, ?)";
        DebPrepStmt insertFc = null;
        DebPrepStmt insertBusy = null;
        Date now = null;
        int nowTimeT = 0;
        int fcs = 0;
        long runtime5 = 0L;
        long maxRuntime = 0L;
        int busyRate = 0;
        int updates = 0;
        this.clearStatTables();
        if (this.maxJoeStatTime == 0) {
            this.maxJoeStatTime = this.getMaxJoeStatTime();
        }
        if ((nowTimeT = (int)((now = new Date()).getTime() / 300000L * 300000L / 1000L)) <= this.maxJoeStatTime) {
            if (!this.dontWriteStatMsg) {
                log.info((Object)"Don't write JOE statistics because of time repetition.");
                this.dontWriteStatMsg = true;
            }
            return true;
        }
        if (this.dontWriteStatMsg) {
            log.info((Object)"Continue writing JOE statistics.");
            this.dontWriteStatMsg = false;
        }
        this.maxJoeStatTime = nowTimeT;
        try {
            con = this.getConnection();
        }
        catch (Exception e) {
            log.error((Object)"Cannot get DB interface!", (Throwable)e);
            return false;
        }
        try {
            try {
                insertFc = new DebPrepStmt(con, sqlFc, dbLog);
                fcs = SlaveHandler.getClearFcCount();
                insertFc.setInt(1, nowTimeT);
                insertFc.setInt(2, fcs);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("writeJoeStat fc data: " + nowTimeT + ", " + fcs));
                }
                insertFc.executeUpdate();
                con.commit();
                ++updates;
            }
            catch (Exception e) {
                log.error((Object)"Cannot update CTRL_STAT_FC.", (Throwable)e);
                Logbook.getLogbook().error("Cannot uptdate CTRL_STAT_FC: " + e.toString());
            }
            finally {
                if (insertFc != null) {
                    try {
                        insertFc.close();
                    }
                    catch (Exception e) {
                        log.error((Object)"Cannot close insertFc statement.", (Throwable)e);
                    }
                }
            }
            try {
                insertBusy = new DebPrepStmt(con, sqlBusy, dbLog);
                runtime5 = WorkerThread.readClearRuntime();
                maxRuntime = 300000L * (long)this.ediboss.getThreadPool();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("writeJoeStat busy: runtime5: " + runtime5 + ", maxRuntime: " + maxRuntime));
                }
                busyRate = Math.min(100, (int)(runtime5 * 100L / maxRuntime));
                insertBusy.setInt(1, nowTimeT);
                insertBusy.setInt(2, busyRate);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("writeJoeStat busy data: " + nowTimeT + ", " + busyRate));
                }
                insertBusy.executeUpdate();
                con.commit();
                ++updates;
            }
            catch (Exception e) {
                log.error((Object)"Cannot update CTRL_STAT_BUSY.", (Throwable)e);
                Logbook.getLogbook().error("Cannot uptdate CTRL_STAT_BUSY: " + e.toString());
                if (con != null) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException ex) {
                        log.warn((Object)"can not rollback", (Throwable)e);
                    }
                }
            }
            finally {
                if (insertBusy != null) {
                    try {
                        insertBusy.close();
                    }
                    catch (Exception e) {
                        log.error((Object)"Cannot close insertBusy statement.", (Throwable)e);
                    }
                }
            }
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                log.warn((Object)"can not close db connection", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeJoeStat end: " + (updates == 2)));
        }
        return updates == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxJoeStatTime() {
        Connection con = null;
        DebPrepStmt stmt = null;
        ResultSet rs = null;
        int maxTimes = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start:");
        }
        String sql = "select max(CTRL_STAT_BUSY.REAL_TIME), max(CTRL_STAT_FC.REAL_TIME) from CTRL_STAT_BUSY, CTRL_STAT_FC";
        try {
            con = this.getConnection();
            stmt = new DebPrepStmt(con, sql, dbLog);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + stmt));
            }
            if ((rs = stmt.executeQuery()).next()) {
                maxTimes = Math.max(rs.getInt(1), rs.getInt(2));
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot query JOE statistic max times: ", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    log.error((Object)"Cannot close JOE stat max times query ResultSet!", (Throwable)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    log.error((Object)"Cannot close JOE stat max times query Statement!", (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    log.warn((Object)"can not close db connection", (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end: " + maxTimes));
        }
        return maxTimes;
    }

    public IAccounting getStdAccount() {
        return this.fileAccounting;
    }

    public boolean accWriteBegin(CtrlJob job, Connection con) throws SQLException {
        boolean okFlag = false;
        long start = System.currentTimeMillis();
        log.debug((Object)"accWriteBegin start:");
        if (job.getAccountingOn()) {
            if (this.fileAccounting == null) {
                this.openFileAccounting();
            }
            if (this.fileAccounting != null && this.fileAccounting.isActive()) {
                okFlag = this.fileAccounting.writeBegin(job, con);
            }
            if (this.dbAccounting == null) {
                this.openDbAccounting();
            }
            if (this.dbAccounting != null && this.dbAccounting.isActive()) {
                okFlag = this.dbAccounting.writeBegin(job, con);
            }
        } else {
            okFlag = true;
        }
        WorkerThread.addAccTime(System.currentTimeMillis() - start);
        return okFlag;
    }

    public boolean accWriteLogicalEnd(CtrlJob job, Connection con) throws SQLException {
        boolean okFlag = true;
        long start = System.currentTimeMillis();
        log.debug((Object)"accWriteLogicalEnd start:");
        if (job.getAccountingOn()) {
            if (this.fileAccounting == null) {
                this.openFileAccounting();
            }
            if (this.fileAccounting != null && this.fileAccounting.isActive()) {
                okFlag = this.fileAccounting.writeLogicalEnd(job, con);
            }
            if (this.dbAccounting == null) {
                this.openDbAccounting();
            }
            if (this.dbAccounting != null && this.dbAccounting.isActive()) {
                okFlag = okFlag && this.dbAccounting.writeLogicalEnd(job, con);
            }
        } else {
            okFlag = true;
        }
        WorkerThread.addAccTime(System.currentTimeMillis() - start);
        return okFlag;
    }

    public boolean accWriteEnd(CtrlJob job, Connection con) {
        boolean okFlag = false;
        long start = System.currentTimeMillis();
        log.debug((Object)"accWriteEnd start: ");
        if (job.getAccountingOn()) {
            log.debug((Object)"Accounting active.");
            if (this.fileAccounting == null) {
                this.openFileAccounting();
            }
            if (this.fileAccounting != null && this.fileAccounting.isActive()) {
                okFlag = this.fileAccounting.writeEnd(job, con);
            }
            if (this.dbAccounting == null) {
                this.openDbAccounting();
            }
            if (this.dbAccounting != null && this.dbAccounting.isActive()) {
                okFlag = this.dbAccounting.writeEnd(job, con);
            }
        } else {
            log.debug((Object)"Accounting NOT active.");
            okFlag = true;
        }
        WorkerThread.addAccTime(System.currentTimeMillis() - start);
        return okFlag;
    }

    public boolean sentinelJobStartMsg(CtrlJob job) {
        boolean okFlag = false;
        long start = System.currentTimeMillis();
        if (this.sentinelConn != null) {
            okFlag = this.sentinelConn.sendJobStartMsg(job);
        }
        WorkerThread.addSenTime(System.currentTimeMillis() - start);
        return okFlag;
    }

    public boolean sentinelJsStartMsg(CtrlJobStep step) {
        boolean okFlag = false;
        long start = System.currentTimeMillis();
        if (this.sentinelConn != null) {
            okFlag = this.sentinelConn.sendJobStepStartMsg(step);
        }
        WorkerThread.addSenTime(System.currentTimeMillis() - start);
        return okFlag;
    }

    public boolean sentinelFcStartMsg(CtrlFunctionCall fc) {
        boolean okFlag = false;
        long start = System.currentTimeMillis();
        if (this.sentinelConn != null) {
            okFlag = this.sentinelConn.sendFcStartMsg(fc);
        }
        WorkerThread.addSenTime(System.currentTimeMillis() - start);
        return okFlag;
    }

    public boolean sentinelFcEndMsg(CtrlFunctionCall fc) {
        boolean okFlag = false;
        long start = System.currentTimeMillis();
        if (this.sentinelConn != null) {
            okFlag = this.sentinelConn.sendFcEndMsg(fc);
        }
        WorkerThread.addSenTime(System.currentTimeMillis() - start);
        return okFlag;
    }

    public Tsim2Sentinel getSentinelConn() {
        return this.sentinelConn;
    }

    public RcbAccount getRcbAccount() {
        return this.rcbAccounting;
    }

    public boolean rcbIsActive() {
        return this.rcbAccounting != null && this.rcbAccounting.isActive();
    }

    public boolean rcbWriteJobStart(CtrlJob job) {
        boolean okFlag = false;
        long start = System.currentTimeMillis();
        if (this.rcbAccounting != null) {
            okFlag = this.rcbAccounting.writeJobStart(job);
        }
        WorkerThread.addRcbTime(System.currentTimeMillis() - start);
        return okFlag;
    }

    public boolean rcbWriteJobFailure(CtrlJob job) {
        boolean okFlag = false;
        long start = System.currentTimeMillis();
        if (this.rcbAccounting != null) {
            okFlag = this.rcbAccounting.writeJobFailure(job);
        }
        WorkerThread.addRcbTime(System.currentTimeMillis() - start);
        return okFlag;
    }

    public boolean rcbWriteJsSuccess(CtrlFunctionCall fc) {
        boolean okFlag = false;
        long start = System.currentTimeMillis();
        if (this.rcbAccounting != null) {
            okFlag = this.rcbAccounting.writeJsSuccess(fc);
        }
        WorkerThread.addRcbTime(System.currentTimeMillis() - start);
        return okFlag;
    }

    public boolean rcbWriteJsFailure(CtrlFunctionCall fc, String protfile) {
        boolean okFlag = false;
        long start = System.currentTimeMillis();
        if (this.rcbAccounting != null) {
            okFlag = this.rcbAccounting.writeJsFailure(fc, protfile);
        }
        WorkerThread.addRcbTime(System.currentTimeMillis() - start);
        return okFlag;
    }

    public void watchJob(IJob job, int maxExecTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("watchJob start: " + job.getId() + ", maxExecTime: " + maxExecTime));
        }
        if (this.fcKillQueue != null) {
            this.fcKillQueue.watchJob(job, maxExecTime);
        }
    }

    public void sleepAgain(CtrlJob job) {
        CtrlJobStep js;
        if (log.isDebugEnabled()) {
            log.debug((Object)("sleepAgain: It's not yet time to run for Job ID: " + job.getId() + ", status: " + job.getStatus()));
        }
        if (!job.isRunJs() && (js = job.getCurrentStep()).isGrouped()) {
            this.groupQueue.removeJs(js);
        }
        this.sleepQueue.runJob(job);
    }

    @Override
    public void accountingStartMsg(IExecutable job, Connection con) throws SQLException {
        if (!(job instanceof CtrlJob)) {
            return;
        }
        this.accWriteBegin((CtrlJob)job, con);
        this.rcbWriteJobStart((CtrlJob)job);
        this.sentinelJobStartMsg((CtrlJob)job);
    }

    public String getLocks() {
        return this.lockDaemon.getLockStacks();
    }

    public HealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    public boolean isDerby() {
        return this.isDerby;
    }

    public static Log getLogGrouping() {
        return logGrouping;
    }

    public void handleEvent(LockDaemonEventObject event) {
        log.info((Object)"handle event triggered");
        if (event.getType().equals((Object)EventType.DATABASE_DOWN)) {
            log.info((Object)"handle event triggered, start reconfig master");
            this.reconfig();
        }
    }

    public static enum PrioChType {
        DECREASE,
        SET,
        INCREASE;

    }

    public static enum Status {
        STARTING,
        RUNNING,
        DOWN;

    }
}

