/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Slave;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.Globals;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.IId;
import de.axway.aim.controller.master.IStarter;
import de.axway.aim.controller.master.ThreadTop;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.common.api.IDBIPool;
import de.axway.lib.jeif.Jeif;
import de.axway.lib.jeif.JeifParam;
import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;

public class CtrlEvtAppl {
    private Log log = LogFactory.getLog((String)"master.CtrlEvtAppl");
    private DataSource dataSource = null;
    private CtrlDispAppl dispatcher;
    private Globals globals;
    private JbpmConfiguration jbpmConf = null;

    public CtrlEvtAppl(IDBIPool dbiPool, IStarter starter) throws Throwable {
        this.dispatcher = new CtrlDispAppl(dbiPool, starter);
        this.globals = this.dispatcher.getGlobals();
        if (!this.globals.isClassic()) {
            this.jbpmConf = JbpmConfiguration.parseXmlString((String)"<jbpm-configuration><jbpm-context><service name='tx' factory='org.jbpm.tx.TxServiceFactory' /><service name='persistence' factory='org.jbpm.persistence.db.DbPersistenceServiceFactory'/></jbpm-context><string name='resource.hibernate.cfg.xml' value='hibernate.cfg.xml' /></jbpm-configuration>");
            if (this.jbpmConf == null) {
                throw new CfgException("no graphSession");
            }
        }
    }

    private JbpmContext getContext() {
        if (!this.globals.isClassic()) {
            return this.jbpmConf.createJbpmContext();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execCommand(Map param) {
        IId job;
        String command;
        String ret;
        block41: {
            ret = "";
            command = (String)param.get("command");
            if (command == null) {
                this.log.error((Object)"ASCII: no command");
                return "-1: no command";
            }
            job = null;
            try {
                CtrlEvent event;
                if (command.equals("stopport")) {
                    this.log.info((Object)"stopport command received");
                    if (this.dispatcher.shutdownPort("shutdown by ASCII interface")) {
                        this.log.info((Object)"listen port stopped.");
                        ret = "0: Master listen port stopped";
                    } else {
                        this.log.error((Object)"Listen port DID NOT stop!");
                        ret = "-1: Master listen port DID NOT stop!";
                    }
                    break block41;
                }
                if (command.equals("jeif")) {
                    Jeif jeif = null;
                    try {
                        jeif = new Jeif();
                        JeifParam jparam = new JeifParam();
                        jparam.add("sender", "otto");
                        jparam.add("receiver", "walter");
                        jparam.add("obj_class", "data");
                        jparam.add("file", "/tmp/shit");
                        jeif.create("SEND_EVENT", jparam);
                        ret = "0: Event created using Jeif";
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Jeif send error!", (Throwable)e);
                        ret = "42: Cannot create Event created using Jeif:" + e;
                    }
                    break block41;
                }
                if (command.equals("startport")) {
                    this.log.info((Object)"startport command received");
                    if (this.dispatcher.startPort()) {
                        this.log.info((Object)"listen port started.");
                        ret = "0: Master listen port started";
                    } else {
                        this.log.error((Object)"Listen port DID NOT start.");
                        ret = "-1: Master listen port DID NOT start!";
                    }
                    break block41;
                }
                if (command.equals("test")) {
                    String attrStr = (String)param.get("attr");
                    if (attrStr == null) {
                        attrStr = "SENDER=snd RECEIVER=rcv OBJ_CLASS=test";
                    }
                    event = new CtrlEvent(this.dispatcher.getNextEventId(), attrStr);
                    job = this.globals.getJSelect().createJob(event, this.jbpmConf);
                    try (Connection con = this.dataSource.getConnection();){
                        con.setAutoCommit(false);
                        event.insert(con);
                        con.commit();
                        break block41;
                    }
                }
                if (command.equals("longtest")) {
                    String fileName;
                    String attrStr = (String)param.get("attr");
                    if (attrStr == null) {
                        attrStr = "SENDER=bla RECEIVER=fasel OBJ_CLASS=test";
                    }
                    if ((fileName = (String)param.get("file")) == null) {
                        fileName = "/home/cbi/ediman/blubber";
                    }
                    event = new CtrlEvent(this.dispatcher.getNextEventId(), attrStr);
                    job = this.globals.getJSelect().createJob(event, this.jbpmConf);
                    if (!(job instanceof CtrlJob)) break block41;
                    try (Connection con = this.dataSource.getConnection();){
                        con.setAutoCommit(false);
                        ((CtrlJob)job).setCompSlave(new Slave("edislave", "localhost", 9125, 128));
                        ((CtrlJob)job).newComp("COMP", fileName);
                        event.insert(con);
                        con.commit();
                        break block41;
                    }
                }
                if (command.equals("reconfig")) {
                    ret = this.dispatcher.reconfig() ? "0:Reconfiguration of Java Master done." : "1:Reconfiguration of Java Master FAILED!";
                } else if (command.equals("rcf")) {
                    event = new CtrlEvent(this.dispatcher.getNextEventId(), "ACTION=RECONFIG_EDIMAN");
                    job = this.globals.getJSelect().createJob(event, this.jbpmConf);
                } else if (command.equals("status") || command.equals("jstat")) {
                    ret = "0: \n" + this.dispatcher.getStatus();
                } else if (command.equals("vstatus") || command.equals("vjstat")) {
                    ret = "0: \n" + this.dispatcher.getStatus(true);
                } else if (command.equals("threads")) {
                    String size = (String)param.get("size");
                    if (size == null) {
                        size = "20";
                    }
                    ret = "0: \n" + ThreadTop.get(Integer.parseInt(size));
                } else if (command.equals("dumpjsl")) {
                    ret = "0: \n" + this.globals.getJSelect().toString();
                } else if (command.equals("locks")) {
                    ret = "0: \n" + this.dispatcher.getLocks();
                } else {
                    this.log.error((Object)("ASCII: unknown command: " + command));
                    ret = "-1: unknown command " + command;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error((Object)("Command " + command + " failed."), (Throwable)e);
                ret = "-1: " + e.getMessage();
            }
        }
        if (job != null) {
            try {
                this.dispatcher.newJob((IExecutable)job);
                ret = "0: " + job.getId();
            }
            catch (Exception e) {
                this.log.error((Object)command, (Throwable)e);
                ret = "-2: " + e.getMessage();
            }
        }
        return ret;
    }

    public void shutdown() {
        if (this.dispatcher != null) {
            this.dispatcher.shutdown(false);
            this.dispatcher = null;
        }
    }
}

