/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Event;
import de.axway.aim.controller.master.CtrlVar;
import de.axway.aim.controller.master.DebPrepStmt;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CtrlJobVar
extends CtrlVar {
    private static Log log = LogFactory.getLog((String)"master.CtrlJobVar");
    private static Log dbLog = LogFactory.getLog((String)"master.DB.CtrlJobVar");

    public CtrlJobVar(String value, String name, long jobid, int num) {
        this(value, name, jobid, num, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created: " + (Object)((Object)this)));
        }
    }

    public CtrlJobVar(String value, String name, long jobid, int num, boolean saved) {
        super(value, name, jobid, num, saved);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created: " + (Object)((Object)this)));
        }
    }

    protected boolean update(Connection con) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"start: ");
        }
        String sql = "update ctrl_jobvar set value = ? where jobid = ? and num = ?";
        DebPrepStmt stmt = null;
        String valueTruncated = Event.truncateByIndex((String)((String)this.getValue()), (int)2000);
        if (valueTruncated.length() > 2000) {
            log.warn((Object)("An attribute value will be trucated for jobid: " + this.jobid));
            valueTruncated = Event.truncateByIndex((String)valueTruncated, (int)2000);
        }
        try {
            stmt = new DebPrepStmt(con, sql, dbLog);
            stmt.setString(1, valueTruncated);
            stmt.setLong(2, this.jobid);
            stmt.setInt(3, this.num);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + stmt));
            }
            if (stmt.executeUpdate() != 1) {
                log.error((Object)("Jobvar " + this.name + " not found in db for update"));
                throw new IOException("Jobvar " + this.name + " not found in db for update");
            }
        }
        catch (SQLException e) {
            log.error((Object)("Cannot update jobvar " + this.name), (Throwable)e);
            throw new IOException("can not update jobvar " + this.name + ": " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end: return true");
        }
        return true;
    }

    protected boolean insert(Connection con) throws IOException {
        String nameTruncated;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start:");
        }
        String sql = "insert into ctrl_jobvar (jobid, name, value, num) values (?,?,?,?)";
        DebPrepStmt stmt = null;
        String valueTruncated = (String)this.getValue();
        if (valueTruncated.length() > 2000) {
            log.warn((Object)("An attribute value will be trucated for jobid: " + this.jobid));
            valueTruncated = Event.truncateByIndex((String)valueTruncated, (int)2000);
        }
        if ((nameTruncated = this.name).length() > 32) {
            log.warn((Object)("An attribute name will be trucated for jobid: " + this.jobid));
            nameTruncated = Event.truncateByIndex((String)this.name, (int)32);
        }
        try {
            stmt = new DebPrepStmt(con, sql, dbLog);
            stmt.setLong(1, this.jobid);
            stmt.setString(2, nameTruncated);
            stmt.setString(3, valueTruncated);
            stmt.setInt(4, this.num);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeInsert: " + stmt));
            }
            stmt.executeUpdate();
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeInsert Ok for: " + stmt));
            }
        }
        catch (SQLException e) {
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeInsert Error: " + e.getMessage()));
            }
            IOException ie = new IOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end: return true");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection con, long jobid) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: job ID:" + jobid));
        }
        if (con == null) {
            log.error((Object)"No dbinterface");
            throw new SQLException("No dbinterface");
        }
        String sql = "delete from ctrl_jobvar where jobid = ?";
        DebPrepStmt stmt = null;
        stmt = new DebPrepStmt(con, sql, dbLog);
        try {
            stmt.setLong(1, jobid);
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeUpdate: " + stmt));
            }
            stmt.executeUpdate();
        }
        finally {
            stmt.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end: return true");
        }
    }
}

