/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;

public class DebPrepStmt {
    private PreparedStatement ps;
    private Log log;
    private String sql;
    private int varsCount = 0;
    private Object[] vars = null;
    private String filteredSql;
    private boolean doDebug = false;

    public DebPrepStmt(Connection con, String sql, Log log) throws SQLException {
        this.ps = con.prepareStatement(sql);
        this.log = log;
        this.sql = sql;
        if (log != null && log.isDebugEnabled()) {
            this.doDebug = true;
            this.prepareToString();
        }
    }

    private void prepareToString() {
        boolean inString = false;
        char[] sqlArr = this.sql.toCharArray();
        block4: for (int i = 0; i < sqlArr.length; ++i) {
            switch (sqlArr[i]) {
                case '\'': {
                    inString = !inString;
                    continue block4;
                }
                case '?': {
                    if (inString) {
                        sqlArr[i] = '\u0001';
                        continue block4;
                    }
                    ++this.varsCount;
                    continue block4;
                }
            }
        }
        this.vars = new Object[this.varsCount];
        this.filteredSql = new String(sqlArr);
    }

    private void storeVar(int i, Object o) throws SQLException {
        if (i < 1 || i > this.varsCount) {
            throw new SQLException("Variable at position " + i + " exceeds maximum number of variables: " + this.varsCount);
        }
        this.vars[i - 1] = o;
    }

    public void addBatch() throws SQLException {
        this.ps.addBatch();
    }

    public void addBatch(String sql) throws SQLException {
        this.ps.addBatch(sql);
    }

    public void cancel() throws SQLException {
        this.ps.cancel();
    }

    public void clearBatch() throws SQLException {
        this.ps.clearBatch();
    }

    public void clearParameters() throws SQLException {
        this.ps.clearParameters();
    }

    public void clearWarnings() throws SQLException {
        this.ps.clearWarnings();
    }

    public void close() throws SQLException {
        this.ps.close();
    }

    public boolean execute() throws SQLException {
        return this.ps.execute();
    }

    public boolean execute(String sql) throws SQLException {
        return this.ps.execute(sql);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.ps.execute(sql, columnNames);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.ps.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.execute(sql, columnIndexes);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.ps.executeUpdate(sql, columnIndexes);
    }

    public boolean execute(String sql, int autoGenerateKeys) throws SQLException {
        return this.ps.execute(sql, autoGenerateKeys);
    }

    public int executeUpdate(String sql, int autoGenerateKeys) throws SQLException {
        return this.ps.executeUpdate(sql, autoGenerateKeys);
    }

    public int[] executeBatch() throws SQLException {
        return this.ps.executeBatch();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.ps.executeQuery();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.ps.executeQuery(sql);
    }

    public int executeUpdate() throws SQLException {
        return this.ps.executeUpdate();
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.ps.executeUpdate(sql);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.ps.getGeneratedKeys();
    }

    public Connection getConnection() throws SQLException {
        return this.ps.getConnection();
    }

    public int getFetchDirection() throws SQLException {
        return this.ps.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.ps.getFetchSize();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.ps.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.ps.getMaxRows();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.ps.getParameterMetaData();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ps.getMetaData();
    }

    public int getQueryTimeout() throws SQLException {
        return this.ps.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.ps.getResultSet();
    }

    public boolean getMoreResults() throws SQLException {
        return this.ps.getMoreResults();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.ps.getMoreResults(current);
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.ps.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.ps.getResultSetType();
    }

    public String getStatement() {
        return this.sql;
    }

    public int getUpdateCount() throws SQLException {
        return this.ps.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.ps.getWarnings();
    }

    public void setAsciiStream(int idx, InputStream x, int length) throws SQLException {
        this.ps.setAsciiStream(idx, x, length);
    }

    public void setBigDecimal(int idx, BigDecimal x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setBigDecimal(idx, x);
    }

    public void setBinaryStream(int idx, InputStream x, int length) throws SQLException {
        this.ps.setBinaryStream(idx, x, length);
    }

    public void setBlob(int idx, Blob x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setBlob(idx, x);
    }

    public void setBoolean(int idx, boolean x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setBoolean(idx, x);
    }

    public void setByte(int idx, byte x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setByte(idx, x);
    }

    public void setBytes(int idx, byte[] x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setBytes(idx, x);
    }

    public void setCharacterStream(int idx, Reader reader, int length) throws SQLException {
        this.ps.setCharacterStream(idx, reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(i, x);
        }
        this.ps.setClob(i, x);
    }

    public void setCursorName(String name) throws SQLException {
        this.ps.setCursorName(name);
    }

    public void setDate(int idx, Date x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setDate(idx, x);
    }

    public void setDate(int idx, Date x, Calendar cal) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setDate(idx, x, cal);
    }

    public void setDouble(int idx, double x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setDouble(idx, x);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.ps.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.ps.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.ps.setFetchSize(rows);
    }

    public void setFloat(int idx, float x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, Float.valueOf(x));
        }
        this.ps.setFloat(idx, x);
    }

    public void setInt(int idx, int x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setInt(idx, x);
    }

    public void setLong(int idx, long x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setLong(idx, x);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.ps.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.ps.setMaxRows(max);
    }

    public void setNull(int idx, int sqlType) throws SQLException {
        this.ps.setNull(idx, sqlType);
    }

    public void setNull(int idx, int sqlType, String typeName) throws SQLException {
        this.ps.setNull(idx, sqlType, typeName);
    }

    public void setObject(int idx, Object x) throws SQLException {
        this.ps.setObject(idx, x);
    }

    public void setObject(int idx, Object x, int targetSqlType) throws SQLException {
        this.ps.setObject(idx, x, targetSqlType);
    }

    public void setObject(int idx, Object x, int targetSqlType, int scale) throws SQLException {
        this.ps.setObject(idx, x, targetSqlType, scale);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.ps.setQueryTimeout(seconds);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.ps.setRef(i, x);
    }

    public void setShort(int idx, short x) throws SQLException {
        this.ps.setShort(idx, x);
    }

    public void setString(int idx, String x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setString(idx, x);
    }

    public void setTime(int idx, Time x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setTime(idx, x);
    }

    public void setTime(int idx, Time x, Calendar cal) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setTime(idx, x, cal);
    }

    public void setTimestamp(int idx, Timestamp x) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setTimestamp(idx, x);
    }

    public void setTimestamp(int idx, Timestamp x, Calendar cal) throws SQLException {
        if (this.doDebug) {
            this.storeVar(idx, x);
        }
        this.ps.setTimestamp(idx, x, cal);
    }

    public void setUnicodeStream(int idx, InputStream x, int length) throws SQLException {
        this.ps.setUnicodeStream(idx, x, length);
    }

    public void setArray(int idx, Array array) throws SQLException {
        this.ps.setArray(idx, array);
    }

    public void setURL(int idx, URL url) throws SQLException {
        this.ps.setURL(idx, url);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.ps.getResultSetHoldability();
    }

    private void varAppend(StringBuilder sb, Object o) {
        if (o instanceof String) {
            sb.append('\'');
            sb.append(o);
            sb.append('\'');
        } else {
            sb.append(o);
        }
    }

    public String toString() {
        if (!this.doDebug || this.vars == null) {
            return this.sql;
        }
        int currVar = 0;
        StringBuilder sb = new StringBuilder();
        StringTokenizer tok = new StringTokenizer(this.filteredSql, "?");
        while (tok.hasMoreTokens()) {
            sb.append(tok.nextToken());
            if (currVar >= this.vars.length) continue;
            this.varAppend(sb, this.vars[currVar]);
            ++currVar;
        }
        return sb.toString();
    }
}

