/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.RecoverableRuntimeException;
import de.axway.aim.controller.master.log.Logbook;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HealthStatus {
    private static Log log = LogFactory.getLog((String)"master.HealthStatus");
    private boolean processingSuspended = false;
    private long processingSuspendedSince = -1L;
    private long lastErrorReportedTime = -1L;
    private long processingEnabledTime = -1L;
    private CtrlDispAppl dispatcher = null;

    public void signalRecoverableRuntimeException(RecoverableRuntimeException ex) {
        this.processingSuspended = true;
        log.debug((Object)"HealthStatus:signalRecoverableRuntimeException.", (Throwable)ex);
        Logbook.getLogbook().warning("HealthStatus: Suspend processing due to recoverable system error: " + ex + " - " + ex.getCause());
        this.lastErrorReportedTime = System.currentTimeMillis();
        if (this.processingSuspendedSince == -1L) {
            this.processingSuspendedSince = this.lastErrorReportedTime;
            this.processingEnabledTime = -1L;
        }
    }

    private String convertTime(long time) {
        Date date = new Date(time);
        SimpleDateFormat format = new SimpleDateFormat("yyyy MM dd HH:mm:ss");
        return format.format((Object)date);
    }

    public boolean proceed(boolean tryToRecover) {
        long timePassedSinceLastRetry;
        log.debug((Object)("HealthStatus:proceed[processingSuspended=" + this.processingSuspended + "]"));
        if (this.processingSuspended()) {
            log.debug((Object)("HealthStatus:proceed[Number of locks=" + this.dispatcher.getLockDaemon().getLocks() + "]"));
            log.debug((Object)("HealthStatus:proceed[LockDaemonStatus=" + this.dispatcher.getLockDaemon().getStatus() + "]"));
            log.debug((Object)("HealthStatus:proceed[Database unavailable since=" + this.convertTime(this.processingSuspendedSince) + "]"));
            log.debug((Object)("HealthStatus:proceed[LockStacks=" + this.dispatcher.getLockDaemon().getLockStacks() + "]"));
            log.debug((Object)("HealthStatus:proceed[ManagerStatus=" + this.dispatcher.getStatus(true) + "]"));
            if (tryToRecover) {
                if (System.currentTimeMillis() - this.lastErrorReportedTime > 30000L && (this.dispatcher.getLockDaemon().isRunning() || this.dispatcher.getLockDaemon().getLocks() == 0)) {
                    log.debug((Object)"HealthStatus:proceed - resume processing.");
                    Logbook.getLogbook().warning("HealthStatus: Try to resume processing.");
                    this.processingSuspended = false;
                    this.processingSuspendedSince = -1L;
                    this.lastErrorReportedTime = -1L;
                    this.processingEnabledTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.lastErrorReportedTime > 30000L) {
                    log.debug((Object)("HealthStatus:proceed - waiting to resume processing [Number of locks=" + this.dispatcher.getLockDaemon().getLocks() + ", LockDaemonStatus=" + this.dispatcher.getLockDaemon().getStatus() + "]"));
                    Logbook.getLogbook().warning("HealthStatus: Waiting to resume processing [Number of locks=" + this.dispatcher.getLockDaemon().getLocks() + ", LockDaemonStatus=" + this.dispatcher.getLockDaemon().getStatus() + "]");
                }
            }
        } else if (this.processingEnabledTime > -1L && (timePassedSinceLastRetry = System.currentTimeMillis() - this.processingEnabledTime) > 30000L) {
            log.debug((Object)("HealthStatus:proceed - No errors for " + timePassedSinceLastRetry + " ms. Processing is back to normal."));
            Logbook.getLogbook().warning("HealthStatus: No errors for " + timePassedSinceLastRetry + " ms. Processing is back to normal.");
            this.processingEnabledTime = -1L;
        }
        return !this.processingSuspended();
    }

    private boolean processingSuspended() {
        return this.processingSuspended;
    }

    public HealthStatus(CtrlDispAppl dispatcher) {
        this.dispatcher = dispatcher;
    }
}

