/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Value;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.MasterUpdate;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.lib.connection.ConnectionStream;
import java.io.IOException;
import java.util.List;

class JobUpdate
extends MasterUpdate {
    private final int NO_OF_USERDATA = 5;
    private int objectId;
    private int status;
    private String jsName;
    private String refNo;
    private String groupName;
    private int maxCalls;
    private int slaveId;
    private String[] userField;

    public JobUpdate(IJob job) {
        block14: {
            int i;
            this.NO_OF_USERDATA = 5;
            this.jsName = "";
            this.refNo = "";
            this.groupName = "";
            this.maxCalls = -1;
            this.slaveId = 0;
            this.userField = new String[5];
            for (i = 0; i < 5; ++i) {
                this.userField[i] = "";
            }
            this.status = job.getObjectStatus();
            this.objectId = (int)job.getId();
            if (job.getCurrentStepName() != null) {
                this.jsName = job.getCurrentStepName();
            }
            if (job.getEvt().getRefNo() != null) {
                this.refNo = job.getEvt().getRefNo();
            }
            for (i = 0; i < 5; ++i) {
                String udName = "USER_DATA" + (i + 1);
                this.userField[i] = this.getVal((Value<String>)job.getVar(udName));
                if (this.userField[i] != null && this.userField[i].length() != 0) continue;
                this.userField[i] = job.getEvt().getVar(udName);
                if (this.userField[i] != null) continue;
                this.userField[i] = "";
            }
            IJobStep js = (IJobStep)job.getCurrentStep();
            try {
                if (js != null) {
                    this.groupName = js.getGroupName();
                    if (this.groupName != null && this.groupName.length() > 0) {
                        this.maxCalls = js.getMaxGroupCalls();
                    } else {
                        this.groupName = "";
                    }
                }
            }
            catch (Exception e) {
                this.groupName = "";
            }
            if (js != null) {
                try {
                    List<SlaveHandler> s = js.getSlaves();
                    if (s != null && s.size() > 0) {
                        this.slaveId = (int)s.get(0).getId();
                        if (s.size() <= 1) break block14;
                        for (SlaveHandler slaveHandler : s) {
                            if (slaveHandler.getSlave().getName() == null || !slaveHandler.getSlave().getName().equals(js.getSlaveExecution())) continue;
                            this.slaveId = (int)slaveHandler.getId();
                            break block14;
                        }
                        break block14;
                    }
                    this.slaveId = -1;
                }
                catch (CfgException e) {
                    log.error((Object)("getSlaves(" + job.getId() + "): " + e.getMessage()));
                }
            }
        }
    }

    private String getVal(Value<String> val) {
        return val == null || val.get() == null ? "" : (String)val.get();
    }

    @Override
    protected byte getType() {
        return 2;
    }

    @Override
    public int getLength() {
        return 24 + this.refNo.length() + this.jsName.length() + this.groupName.length() + this.userField[0].length() + this.userField[1].length() + this.userField[2].length() + this.userField[3].length() + this.userField[4].length();
    }

    @Override
    public void send(ConnectionStream cs) throws IOException {
        super.send(cs);
        cs.writeInt(this.objectId);
        cs.writeInt(this.status);
        cs.writeCString(this.jsName);
        cs.writeCString(this.refNo);
        cs.writeCString(this.groupName);
        cs.writeInt(this.maxCalls);
        cs.writeInt(this.slaveId);
        for (int i = 0; i < 5; ++i) {
            cs.writeCString(this.userField[i]);
        }
    }
}

