/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.lib.IdSortedJob;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.DataBaseDown;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.JobNew;
import de.axway.aim.controller.master.JobRemove;
import de.axway.aim.controller.master.JobUpdate;
import de.axway.aim.controller.master.JoseLoader;
import de.axway.aim.controller.master.LogProtApp;
import de.axway.aim.controller.master.MasterUpdate;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.SlaveNew;
import de.axway.aim.controller.master.SlaveRemoved;
import de.axway.aim.controller.master.SlaveUpdate;
import de.axway.lib.connection.ConnectionStream;
import de.axway.lib.util.runner.ManagedRunnableImpl;
import de.axway.lockDaemon.LockException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JoseAppl
extends LogProtApp {
    private Log log = LogFactory.getLog((String)"master.JoseAppl");
    private static Object startSync = new Object();
    private JoseLoader loader = null;
    private Status status = Status.START;
    private LinkedList<MasterUpdate> updates = new LinkedList();
    private Set<IdSortedJob> initUpdates = null;
    private ConnectionStream cs = null;
    private Socket socket;
    private ManagedRunnableImpl thread = new ManagedRunnableImpl(){

        public void doRun() {
            this.setName("appl " + JoseAppl.this.getId());
            JoseAppl.this.joseRun();
        }
    };

    public JoseAppl(CtrlDispAppl dispatcher, Socket socket, String name) throws LockException, IOException {
        super(dispatcher, 0, null, name);
        this.socket = socket;
        socket.setSoTimeout(dispatcher.getEdiboss().getIpcRwTimeout());
        this.cs = new ConnectionStream(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPing() throws IOException {
        ConnectionStream connectionStream = this.cs;
        synchronized (connectionStream) {
            this.cs.writeInt(5);
            this.cs.writeByte(0);
            this.cs.writeInt(0);
            this.cs.send();
        }
    }

    public void start() {
        if (this.status == Status.START) {
            this.thread.start();
        }
    }

    @Override
    public String getStatus() {
        String parent = super.getStatus();
        return parent + '/' + ((InetSocketAddress)this.socket.getRemoteSocketAddress()).getHostName() + '/' + this.updates.size() + " updates/" + (Object)((Object)this.status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newJob(Set<IdSortedJob> jobs) {
        this.log.info((Object)"jose init start");
        Object object = startSync;
        synchronized (object) {
            this.loader = new JoseLoader(this.dispatcher);
        }
        this.initUpdates = jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newJob(CtrlJob job) {
        Object object = this.updates;
        synchronized (object) {
            this.updates.add(new JobNew(this.dispatcher, job, null, null, null, null));
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJob(IJob job) {
        Object object = this.updates;
        synchronized (object) {
            this.updates.add(new JobUpdate(job));
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(IJob job) {
        Object object = this.updates;
        synchronized (object) {
            this.updates.add(new JobRemove(job));
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSlave(SlaveHandler slave) {
        if (slave.getId() == -1L) {
            return;
        }
        Object object = this.updates;
        synchronized (object) {
            this.updates.add(new SlaveNew(slave));
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSlave(SlaveHandler slave) {
        Object object = this.updates;
        synchronized (object) {
            this.updates.add(new SlaveUpdate(slave));
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSlave(SlaveHandler slave) {
        Object object = this.updates;
        synchronized (object) {
            this.updates.add(new SlaveRemoved(slave));
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectObjBwrDbDown() {
        Object object = this.updates;
        synchronized (object) {
            this.updates.add(new DataBaseDown());
        }
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        JoseAppl joseAppl;
        this.log.debug((Object)"shutdown called");
        if (this.status != Status.DOWN) {
            this.status = Status.STOPPING;
            joseAppl = this;
            synchronized (joseAppl) {
                this.notify();
            }
        }
        while (this.status != Status.DOWN) {
            joseAppl = this;
            synchronized (joseAppl) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.log.debug((Object)"shutdown end.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void joseRun() {
        this.log.debug((Object)"thread started");
        this.status = Status.RUNNING;
        try {
            List<SlaveHandler> sh;
            List<SlaveHandler> list = sh = this.dispatcher.getSlaveList();
            synchronized (list) {
                Iterator<SlaveHandler> it = this.dispatcher.getSlaveList().iterator();
                while (it.hasNext() && this.status == Status.RUNNING) {
                    new SlaveNew(it.next()).send(this.cs);
                    this.cs.send();
                }
            }
            Object it = this.initUpdates.iterator();
            while (it.hasNext() && this.status == Status.RUNNING) {
                CtrlJob job = (CtrlJob)it.next().getJob();
                long id = job.getId();
                Attributes evtAttr = this.loader.getEventAttr(id);
                if (evtAttr == null) {
                    evtAttr = new Attributes();
                    this.log.warn((Object)("job " + id + " has no event attributes"));
                }
                JobNew update = new JobNew(this.dispatcher, job, (Attributes<String>)evtAttr, (Attributes<String>)this.loader.getEventPar(id), (Attributes<String>)this.loader.getJobVar(id), this.loader.getRefNo(id));
                ConnectionStream connectionStream = this.cs;
                synchronized (connectionStream) {
                    ((MasterUpdate)update).send(this.cs);
                    this.cs.send();
                }
            }
            this.initUpdates = null;
            this.loader.stop();
            this.loader = null;
            this.log.info((Object)"jose init end");
            while (this.status == Status.RUNNING) {
                while (this.status == Status.RUNNING && this.updates.size() == 0) {
                    it = this;
                    synchronized (it) {
                        this.wait(60000L);
                    }
                }
                MasterUpdate update = null;
                ConnectionStream connectionStream = this.updates;
                synchronized (connectionStream) {
                    if (this.updates.size() > 0) {
                        update = this.updates.removeFirst();
                    }
                    if (update == null) continue;
                }
                connectionStream = this.cs;
                synchronized (connectionStream) {
                    update.send(this.cs);
                    this.cs.send();
                }
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"killed", t);
        }
        try {
            super.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.cs.close();
        this.status = Status.DOWN;
        this.dispatcher.removeAppl(this.getId());
        JoseAppl joseAppl = this;
        synchronized (joseAppl) {
            this.notifyAll();
        }
        this.log.debug((Object)"thread stopped");
    }

    private static enum Status {
        START,
        RUNNING,
        STOPPING,
        DOWN;

    }
}

