/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.master.ActivateAttrLoader;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.EventLoader;
import de.axway.aim.controller.master.JobStepId;
import de.axway.aim.controller.master.JobStepLoad;
import de.axway.aim.controller.master.StarterThreads;
import de.axway.aim.controller.master.WorkflowResultConnection;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.CfgJobEntry;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.aim.controller.master.queue.RemoveQueue;
import de.axway.lockDaemon.LockException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class Loader {
    private static Log log = LogFactory.getLog((String)"master.Loader");
    private static Log dbLog = LogFactory.getLog((String)"master.DB.Loader");

    Loader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadJobs(CtrlDispAppl dispatcher, Map<Long, CfgJSelectEntry> jsl, RemoveQueue evtRemQueue, Hashtable<Long, WorkflowResultConnection> oldWfrConn) throws SQLException, LockException, InterruptedException {
        Hashtable<Long, CtrlJob> jobs = new Hashtable<Long, CtrlJob>();
        ArrayList<CtrlJob> joblist = new ArrayList<CtrlJob>();
        JobStepLoad jsLoad = new JobStepLoad(dispatcher, jobs);
        EventLoader evtLoad = new EventLoader(dispatcher, oldWfrConn);
        ActivateAttrLoader activateAttrLoader = new ActivateAttrLoader(dispatcher);
        Connection con = dispatcher.getConnection();
        long start = System.currentTimeMillis();
        long sleep = 0L;
        try {
            PreparedStatement stmt = con.prepareStatement(CtrlJob.getSql());
            stmt.setFetchSize(dispatcher.getEdiboss().getLoadFetchSize());
            if (dbLog.isDebugEnabled()) {
                dbLog.debug((Object)("executeQuery: " + CtrlJob.getSql()));
            }
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        long jslid = rs.getLong(12);
                        long jobid = rs.getLong(1);
                        CfgJSelectEntry jslEntry = jsl.get(jslid);
                        long sleepStart = System.currentTimeMillis();
                        CtrlEvent event = evtLoad.get(jobid);
                        sleep += System.currentTimeMillis() - sleepStart;
                        CtrlJob job = new CtrlJob(event, rs, jslEntry, dispatcher);
                        event.setJob(job);
                        if (job.isSuspended()) {
                            Attributes activateAttr = activateAttrLoader.get(job.getId());
                            job.setActivateAttr((Attributes<String>)activateAttr);
                        }
                        jobs.put(job.getId(), job);
                        Hashtable<Long, CtrlJob> hashtable = jobs;
                        synchronized (hashtable) {
                            jobs.notify();
                        }
                        joblist.add(job);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            con.close();
        }
        long total = System.currentTimeMillis() - start;
        log.info((Object)("JobLoader time: " + (total - sleep) + "/" + total + " msec"));
        int count = 0;
        start = System.currentTimeMillis();
        sleep = 0L;
        StarterThreads st = new StarterThreads(dispatcher);
        for (CtrlJob job : joblist) {
            CfgJobEntry jobEntry = (CfgJobEntry)job.getJsl().getCfgJob();
            JobStepId js = jsLoad.getFirst();
            boolean needNext = true;
            for (int x = 0; x < job.getStepCount(); ++x) {
                while (js != null && (js.getJobId() < job.getId() || js.getJobId() == job.getId() && js.get().getStepNo() <= x)) {
                    if (!needNext) {
                        log.warn((Object)("unused step " + js.getJobId() + "." + js.get().getStepNo()));
                    }
                    long sleepStart = System.currentTimeMillis();
                    js = jsLoad.getFirst();
                    sleep += System.currentTimeMillis() - sleepStart;
                    needNext = false;
                }
                if (js == null || js.getJobId() != job.getId() || js.get().getStepNo() != x + 1) {
                    Logbook.getLogbook().error("no step: " + job.getId() + "." + (x + 1));
                    log.error((Object)("invalid step: " + job.getId() + "." + (x + 1) + " <=> " + (js == null ? "null" : Long.valueOf(js.getJobId())) + "." + (js == null ? "null" : Integer.valueOf(js.get().getStepNo()))));
                    try (Connection c = dispatcher.getConnection();){
                        job.stopJob(c);
                        c.commit();
                    }
                    needNext = false;
                    continue;
                }
                job.addStep(js.get());
                needNext = true;
            }
            if (job.getCurrentStep() != null) {
                job.getCurrentStep().setNextExecTime(job.getLastReady());
            }
            if (job.getStatus() == 5) {
                ++count;
            }
            st.newJob(job);
        }
        st.wait4ready();
        total = System.currentTimeMillis() - start;
        log.info((Object)("JobLoader dispatch: " + (total - sleep) + "/" + total + " msec"));
        try {
            JobStepId js;
            while ((js = jsLoad.getFirst()) != null) {
                log.warn((Object)("unused step: " + js.getJobId() + "." + js.get().getStepNo()));
            }
        }
        catch (Exception e) {
            log.warn((Object)"getFirst", (Throwable)e);
        }
        evtLoad.waitEnd();
        Map<Long, CtrlEvent> events = evtLoad.getAll();
        for (CtrlEvent evt : events.values()) {
            if (evt.getRemoveDate() > 0L) {
                evtRemQueue.newRemoveJob(evt);
                continue;
            }
            log.warn((Object)("unused event " + evt.getId()));
        }
        return count;
    }
}

