/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.lib.EdiComp;
import de.axway.aim.controller.lib.JslEntry;
import de.axway.aim.controller.lib.ParameterException;
import de.axway.aim.controller.lib.Result;
import de.axway.aim.controller.lib.Value;
import de.axway.aim.controller.lib.Variable;
import de.axway.aim.controller.master.AnwBoss;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.CtrlJobStep;
import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.EventLock;
import de.axway.aim.controller.master.Globals;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.LockJob;
import de.axway.aim.controller.master.UnexpectedRuntimeException;
import de.axway.aim.controller.master.WorkerThread;
import de.axway.aim.controller.master.WorkflowResultConnection;
import de.axway.aim.controller.master.cfg.CfgJSelect;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.command.Cmd;
import de.axway.aim.controller.master.command.CmdAnswer;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.lib.logprot.LogProtData;
import de.axway.lib.logprot.LogProtRecvPort;
import de.axway.lib.logprot.LogProtVersion;
import de.axway.lib.message.Message;
import de.axway.lib.message.MessageController;
import de.axway.lib.message.Port;
import de.axway.lib.util.ActisFile;
import de.axway.lib.util.runner.ManagedRunnableImpl;
import de.axway.lockDaemon.LockException;
import de.axway.lockDaemon.LockTimeoutException;
import de.axway.lockDaemon.SyncObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogProtMsgDaemon
extends ManagedRunnableImpl {
    private static final String VERSION = "$Header$";
    private Log log = LogFactory.getLog((String)"master.LogProtMsgDaemon");
    private static final int ANSWERPOWER2 = 1764;
    public static final String LET_LINE_OPEN = "letLineOpen";
    protected static Log logReceivedEvent = LogFactory.getLog((String)"master.receive.event");
    protected static Log logReceivedResult = LogFactory.getLog((String)"master.receive.result");
    protected static Log logReceivedObjectExchange = LogFactory.getLog((String)"master.receive.objectexchange");
    private CtrlDispAppl dispatcher;
    private Globals globals;
    private Ediboss parEdiboss;
    private int masterPort;
    private int ipcRwTimeout;
    private boolean ipcTcpNoDelay;
    private int maxLines;
    private ServerSocket listenSocket;
    private boolean running = false;
    private int backlog = 255;
    private LogProtVersion lpv;
    private static int portNo = 0;
    private Set<LogProtHandler> runningHandler = new HashSet<LogProtHandler>();
    private String protpoolExt = null;
    private boolean stopped = true;
    private Object stopSync = new Object();
    private HashMap<String, Boolean> markSlaveForUnlock = new HashMap();

    private String[] addResult4KillCmd(CmdAnswer cAnswer, String[] anyData) {
        if (this.isResult4KillCmd(cAnswer)) {
            if (anyData == null) {
                return new String[]{cAnswer.getLogData()[0]};
            }
            String[] anyDataRet = new String[anyData.length + 1];
            System.arraycopy(anyData, 0, anyDataRet, 0, anyData.length);
            anyDataRet[anyDataRet.length - 1] = cAnswer.getLogData()[0];
            return anyDataRet;
        }
        return anyData;
    }

    private boolean isResult4KillCmd(CmdAnswer cAnswer) {
        return cAnswer.getLogData() != null && cAnswer.getLogData().length > 0 && cAnswer.getLogData()[0].contains("Jobs or Edi-Objects matched/deleted: ");
    }

    public LogProtMsgDaemon(CtrlDispAppl dispatcher) throws IOException {
        int lpvNo = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"create start:");
            String[] keys = LogFactory.getFactory().getAttributeNames();
            for (int i = 0; i < keys.length; ++i) {
                this.log.debug((Object)("log.attr[" + i + "] = '" + LogFactory.getFactory().getAttribute(keys[i]) + "'"));
            }
        }
        this.globals = dispatcher.getGlobals();
        this.parEdiboss = this.globals.getParEdiboss();
        LogProtMsgDaemon logProtMsgDaemon = this;
        lpvNo = logProtMsgDaemon.globals.getLogProtVersion();
        this.lpv = new LogProtVersion(lpvNo);
        this.dispatcher = dispatcher;
        this.masterPort = this.parEdiboss.getServerPort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("masterService value: " + this.masterPort));
        }
        this.protpoolExt = this.parEdiboss.getProtpoolPath();
        this.protpoolExt = new ActisFile(this.protpoolExt).toString();
        this.backlog = this.parEdiboss.getBacklog();
        this.ipcRwTimeout = 1000 * this.parEdiboss.getIpcRwTimeout();
        this.ipcTcpNoDelay = this.parEdiboss.getIpcNoDelay();
        this.maxLines = this.parEdiboss.getMaxLogprotLines();
        this.log.info((Object)("listen port: " + this.masterPort + ", backlog: " + this.backlog + ", protpoolExt: " + this.protpoolExt + ", ipcRwTimeout: " + this.ipcRwTimeout + ", ipcTcpNoDelay: " + this.ipcTcpNoDelay));
        try {
            this.listenSocket = new ServerSocket();
            this.listenSocket.bind(new InetSocketAddress(this.masterPort), this.backlog);
            Logbook.getLogbook().info("Master service port '" + this.masterPort + "' activated.");
        }
        catch (IOException e) {
            this.log.error((Object)("Cannot open master service port '" + this.masterPort + "'"), (Throwable)e);
            throw e;
        }
        this.start();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("LogProtMsgDaemon started on port " + this.masterPort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun() {
        this.log.debug((Object)"start thread loop:");
        this.running = true;
        try {
            this.setName("LogProtMsgDaemon-" + this.masterPort);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        while (this.running) {
            Object object;
            boolean error;
            LogProtHandler lph;
            boolean toRemove;
            Socket line;
            block33: {
                line = null;
                try {
                    line = this.listenSocket.accept();
                }
                catch (Throwable e) {
                    if (!this.running) {
                        this.log.info((Object)"Socket closed by shutdown command.");
                    }
                    this.log.error((Object)"Error while accept master port.", e);
                }
                if (line == null) continue;
                toRemove = false;
                lph = null;
                error = false;
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Accepted call: " + line.getRemoteSocketAddress() + ", local port: " + line.getLocalPort()));
                        this.log.debug((Object)("ipcRwTimeout: " + this.ipcRwTimeout + ", ipcTcpNoDelay: " + this.ipcTcpNoDelay));
                    }
                    line.setTcpNoDelay(this.ipcTcpNoDelay);
                    line.setSoTimeout(this.ipcRwTimeout);
                    object = this.stopSync;
                    synchronized (object) {
                        while (this.running && (this.stopped || this.runningHandler.size() + 1 > this.maxLines)) {
                            try {
                                this.stopSync.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (this.running) {
                        lph = new LogProtHandler(++portNo, this.runningHandler, line, this.lpv);
                        object = this.stopSync;
                        synchronized (object) {
                            this.runningHandler.add(lph);
                        }
                        toRemove = true;
                        this.dispatcher.getThreadPool().execute(lph);
                        break block33;
                    }
                    try {
                        line.close();
                    }
                    catch (Throwable throwable) {}
                }
                catch (SocketException e) {
                    if (!this.running) {
                        this.log.info((Object)"Socket closed by shutdown command.");
                    } else {
                        this.log.error((Object)"Error while processing master port.", (Throwable)e);
                    }
                    error = true;
                }
                catch (Throwable e) {
                    if (this.running) {
                        this.log.error((Object)"Error while processing master port.", e);
                    }
                    error = true;
                }
            }
            if (!error) continue;
            try {
                line.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!toRemove) continue;
            object = this.stopSync;
            synchronized (object) {
                this.runningHandler.remove(lph);
            }
        }
        this.log.debug((Object)"Left thread loop, ending LogProtMsgDaemon");
        if (this.listenSocket != null) {
            try {
                this.listenSocket.close();
            }
            catch (Exception e) {
                this.log.warn((Object)"Error while closing master listen port.", (Throwable)e);
            }
            this.listenSocket = null;
        }
        this.log.debug((Object)"end:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStopped(boolean stopped) {
        Object object = this.stopSync;
        synchronized (object) {
            if (this.stopped == stopped) {
                return;
            }
            this.stopped = stopped;
            if (!stopped) {
                this.stopSync.notify();
            }
        }
        this.waitOnHandler(60000L);
        if (stopped) {
            this.log.info((Object)"Master service port stopped");
        } else {
            this.log.info((Object)"Master service port is started");
        }
    }

    public void shutdown(String caller) throws Exception {
        this.shutdown(60000L, caller);
    }

    public void shutdown(long timeOut, String caller) throws Exception {
        int cnt = 100;
        Logbook.getLogbook().info("Shutdown Master service port by '" + caller + "'");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start: timeOut: " + timeOut));
        }
        if (!this.running && this.runningHandler.size() == 0) {
            this.log.warn((Object)"LogProtMsgDaemon already dead!");
            return;
        }
        this.running = false;
        if (this.listenSocket != null) {
            try {
                this.listenSocket.close();
            }
            catch (Exception ignore) {
                this.log.error((Object)"Listen socket close error:", (Throwable)ignore);
            }
        }
        this.log.debug((Object)"LogProtMsgDaemon listen socket closed.");
        while (cnt-- > 0 && this.listenSocket != null) {
            try {
                this.log.debug((Object)"Waiting for listen socket shutdown...");
                Thread.sleep(100L);
            }
            catch (Exception ignore) {
                this.log.error((Object)"Sleep error in shutdown:", (Throwable)ignore);
            }
        }
        if (cnt == -1 && this.listenSocket != null) {
            this.log.error((Object)"LogProtMsgDaemon doRun DID NOT end / listen socket shutdown failed!");
            throw new Exception("Cannot stop LogProtMsgDaemon: listen socket shutdown failed.");
        }
        this.waitOnHandler(timeOut);
        this.log.debug((Object)"end OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnHandler(long timeOut) {
        boolean timeOuted = false;
        long startTime = System.currentTimeMillis();
        while (!timeOuted && this.runningHandler.size() > 0) {
            if (System.currentTimeMillis() - startTime > timeOut) {
                timeOuted = true;
                try {
                    Object object = this.stopSync;
                    synchronized (object) {
                        if (this.runningHandler.size() > 0) {
                            Logbook.getLogbook().warning("LogProtHandler shutdown timeout! Still running: " + this.runningHandler.size());
                            this.log.warn((Object)("LogProtHandler shutdown timeout! Still running: " + this.runningHandler.size()));
                            for (LogProtHandler lph : this.runningHandler) {
                                Logbook.getLogbook().warning("Killing LogProtHandler: " + lph);
                                this.log.warn((Object)("Killing LogProtHandler: " + lph));
                                Object[] st = lph.getStackTrace();
                                if (st != null) {
                                    this.log.warn((Object)Arrays.toString(st));
                                } else {
                                    this.log.warn((Object)"no stacktrace, thread is ready?");
                                }
                                try {
                                    lph.interrupt();
                                }
                                catch (Exception soWhat) {
                                    this.log.error((Object)("Cannot kill LogProtHandler: " + lph), (Throwable)soWhat);
                                }
                            }
                        }
                        continue;
                    }
                }
                catch (Exception e) {
                    this.log.warn((Object)"Cannot stop LogProtMsgDaemon: LogProtHandler termination failed.", (Throwable)e);
                    continue;
                }
            }
            try {
                this.log.debug((Object)"Waiting for LogProtHandler termination ...");
                Thread.sleep(100L);
            }
            catch (Exception ignore) {
                this.log.error((Object)"LogProtHandler sleep error in shutdown:", (Throwable)ignore);
            }
        }
    }

    public boolean isAlive() {
        boolean answer;
        boolean bl = answer = this.running && this.listenSocket != null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Query answer; " + answer));
        }
        return answer;
    }

    public String getStatus() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName());
        buf.append(this.running ? ": running" : ": not running");
        buf.append(", active lines: ");
        buf.append(this.runningHandler.size());
        buf.append(" (max " + this.maxLines + ')');
        buf.append("\n    Port: ");
        buf.append(this.listenSocket);
        buf.append("\n    ");
        buf.append(this.lpv);
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("LogProtMsgDaemon: ");
        buf.append(this.getName());
        buf.append(", ");
        buf.append(this.listenSocket);
        buf.append(this.running ? ", running, " : ", not running, ");
        buf.append(this.lpv);
        buf.append(", active lines: ");
        buf.append(this.runningHandler.size());
        return buf.toString();
    }

    static /* synthetic */ String access$200(LogProtMsgDaemon x0) {
        return x0.protpoolExt;
    }

    private class LogProtHandler
    extends WorkerThread
    implements LogProtData,
    MessageController {
        private LogProtVersion lpv;
        private Socket line;
        private InputStream in;
        private OutputStream out;
        private int myPortNo;
        private Set<LogProtHandler> runningHandler;
        private Message myMsg;
        private boolean handlerIsRunning;
        private long startTime;

        public LogProtHandler(int portNo, Set<LogProtHandler> runningHandler, Socket line, LogProtVersion lpv) throws IOException {
            super(0);
            this.in = null;
            this.out = null;
            this.myPortNo = 0;
            this.handlerIsRunning = false;
            this.startTime = 0L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("line: " + line + " LogProtVersion: " + lpv + " myport: " + portNo));
            }
            this.myPortNo = portNo;
            this.runningHandler = runningHandler;
            this.lpv = lpv;
            this.line = line;
            this.in = line.getInputStream();
            this.out = line.getOutputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            this.startTime = System.currentTimeMillis();
            this.handlerIsRunning = true;
            try {
                try {
                    this.setName("LogProtHandler-" + this.myPortNo + " / " + this.line.getRemoteSocketAddress());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    LogProtRecvPort lprp = new LogProtRecvPort("MasterPort." + this.myPortNo, (MessageController)this, this.lpv, (Object)this.line, this.in, this.out);
                    lprp.startPort();
                    lprp.doRun();
                }
                catch (Exception ie) {
                    log.error((Object)"LogProtHandler was killed.", (Throwable)ie);
                }
            }
            finally {
                this.handlerIsRunning = false;
                Object object = LogProtMsgDaemon.this.stopSync;
                synchronized (object) {
                    this.runningHandler.remove(this);
                    LogProtMsgDaemon.this.stopSync.notify();
                }
                Thread.currentThread();
                if (Thread.interrupted()) {
                    log.warn((Object)("LogProthandler " + this.getName() + " was interrupted."));
                }
            }
        }

        public void interrupt() {
            if (this.handlerIsRunning) {
                Thread.currentThread().interrupt();
            }
        }

        public void registerPort(Port newPort) {
        }

        public void deregisterPort(Port oldPort) {
        }

        public Port getPort(String portName) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public Message inject(Message msg, Port port) {
            signal = msg.getSignal();
            answer = null;
            result = null;
            jobId = -1L;
            jsNo = -1;
            jsRetry = -1;
            jsLevel = -1;
            fcSeqNo = -1;
            fcSeqRetry = -1;
            fcLevel = -1;
            oldId = "";
            rest = "";
            eventID = -1;
            logfileDir = null;
            logfileName = null;
            lprp = null;
            closePort = true;
            internal = false;
            i = 0;
            LogProtHandler.addTcpTime(System.currentTimeMillis() - this.startTime);
            if (LogProtHandler.log.isDebugEnabled()) {
                LogProtHandler.log.debug((Object)msg);
            }
            this.myMsg = msg;
            if (port instanceof LogProtRecvPort) {
                lprp = (LogProtRecvPort)port;
            }
            try {
                block89: {
                    if (signal.equals("EventCheck")) {
                        eventID = (Integer)msg.get("eventId");
                        answer = new Message("EventCheckAnswer");
                        answer.set("eventId", msg.get("eventId"));
                        answer.set("answer", (Object)1);
                        if (LogProtHandler.log.isDebugEnabled()) {
                            LogProtHandler.log.debug((Object)("EVENT_CHECK request eventID: " + eventID));
                        }
                        if (eventID == 0) {
                            try {
                                eventID = (int)LogProtMsgDaemon.access$100(LogProtMsgDaemon.this).getNextEventId();
                                if (LogProtHandler.log.isDebugEnabled()) {
                                    LogProtHandler.log.debug((Object)("EVENT_CHECK eventID created: " + eventID));
                                }
                                answer.set("eventId", (Object)eventID);
                                answer.set("answer", (Object)0);
                            }
                            catch (Exception ee) {
                                LogProtHandler.log.error((Object)"Cannot obtain new event ID", (Throwable)ee);
                            }
                        } else if (LogProtMsgDaemon.access$100(LogProtMsgDaemon.this).eventExists(eventID)) {
                            if (LogProtHandler.log.isDebugEnabled()) {
                                LogProtHandler.log.debug((Object)("EVENT_CHECK eventID already exists: " + eventID));
                            }
                            answer.set("answer", (Object)23);
                        } else {
                            if (LogProtHandler.log.isDebugEnabled()) {
                                LogProtHandler.log.debug((Object)("EVENT_CHECK eventID unknown OK: " + eventID));
                            }
                            answer.set("answer", (Object)0);
                        }
                    } else if (signal.equals("Event")) {
                        if (LogProtMsgDaemon.logReceivedEvent.isDebugEnabled()) {
                            LogProtMsgDaemon.logReceivedEvent.debug((Object)("receiving event:" + msg));
                        }
                        answer = null;
                        if (this.handleEvent(lprp != null ? lprp.getCallingSocket() : null, msg, (LogProtRecvPort)port)) {
                            closePort = false;
                        }
                    } else {
                        if (signal.equals("SendCommand")) {
                            try {
                                answer = this.handleCommand(lprp != null ? lprp.getCallingSocket() : null, msg);
                            }
                            catch (Exception ex) {
                                answer = new Message("SendCommandAnswer");
                                throw ex;
                            }
                        }
                        if (signal.equals("ObjectExchange")) {
                            if (LogProtMsgDaemon.logReceivedObjectExchange.isDebugEnabled()) {
                                LogProtMsgDaemon.logReceivedObjectExchange.debug((Object)("receiving object exchange:" + msg));
                            }
                            answer = this.handleFXP(msg);
                        } else {
                            if (signal.equals("Result")) {
                                if (LogProtMsgDaemon.logReceivedResult.isDebugEnabled()) {
                                    LogProtMsgDaemon.logReceivedResult.debug((Object)("receiving result:" + msg));
                                }
                                try {
                                    answer = this.handleResult(lprp != null ? lprp.getCallingSocket() : null, msg, (LogProtRecvPort)port);
                                }
                                catch (Exception ex) {
                                    answer = null;
                                    throw ex;
                                }
                            }
                            if (signal.equals("LogfQuery")) {
                                result = (Message)msg.get("result");
                                answer = new Message("LogfQueryAnswer");
                                if (result != null) {
                                    internal = (Integer)result.get("internal", (Object)0) != 0;
                                    oldId = (String)result.get("identification", (Object)"");
                                    if (internal) {
                                        if (LogProtHandler.log.isDebugEnabled()) {
                                            LogProtHandler.log.debug((Object)("Got internal result: oldId: " + oldId));
                                        }
                                        jobId = ((Integer)result.get("jobId")).intValue();
                                        jsNo = (Integer)result.get("jsSequenceNo");
                                        jsRetry = (Integer)result.get("jsCurrRetry");
                                        fcSeqNo = (Integer)result.get("fcSequenceNo");
                                        fcSeqRetry = (Integer)result.get("fcCurrRetry");
                                        if (jsNo == 0 && jsRetry == 0) {
                                            i = oldId.indexOf(46);
                                            if (i != -1) {
                                                jobId = Integer.parseInt(oldId.substring(0, i));
                                                rest = oldId.substring(i + 1);
                                                jsNo = (i = rest.indexOf(46)) == -1 ? Integer.parseInt(rest) : Integer.parseInt(rest.substring(i + 1));
                                            } else {
                                                LogProtHandler.log.error((Object)("Can't identify Result: " + msg));
                                            }
                                        }
                                    } else if (LogProtHandler.log.isDebugEnabled()) {
                                        LogProtHandler.log.debug((Object)("Got external result: " + oldId));
                                    }
                                    try {
                                        if (LogProtHandler.log.isDebugEnabled()) {
                                            if (internal) {
                                                LogProtHandler.log.debug((Object)("Get protfile directory for job: " + jobId));
                                            } else {
                                                LogProtHandler.log.debug((Object)"Get protfile external result.");
                                            }
                                        }
                                        if (internal && LogProtMsgDaemon.access$100(LogProtMsgDaemon.this).isAwaitedResult(jobId, jsNo, jsRetry, jsLevel, fcSeqNo, fcSeqRetry, fcLevel)) {
                                            logfileName = CtrlJobStep.getProtfileName(jobId, jsNo, jsRetry);
                                            if (logfileName == null) {
                                                logfileName = LogProtMsgDaemon.access$200(LogProtMsgDaemon.this);
                                            }
                                        } else {
                                            logfileName = LogProtMsgDaemon.access$200(LogProtMsgDaemon.this);
                                        }
                                        if (LogProtHandler.log.isDebugEnabled()) {
                                            LogProtHandler.log.debug((Object)("protfile for " + jobId + "." + jsNo + "." + jsRetry + "." + fcSeqNo + "." + fcSeqRetry + " is: " + logfileDir));
                                        }
                                        if (logfileName == null) ** GOTO lbl182
                                        answer.set("logFilename", (Object)logfileName.replace('\\', '/'));
                                    }
                                    catch (Exception ex) {
                                        answer = new Message("errorMessage");
                                        answer.set("error", (Object)ex.toString());
                                        throw ex;
                                    }
                                }
                            } else {
                                if (signal.equals("Ping")) {
                                    try {
                                        answer = new Message("PingAnswer");
                                        answer.set("answer", (Object)0);
                                        answer.set("applId", (Object)1764);
                                        answer.set("identification", (Object)"LogProtMsgDaemon");
                                    }
                                    catch (Exception ex) {
                                        answer = new Message("PingAnswer");
                                        answer.set("answer", (Object)1);
                                        answer.set("applId", (Object)1764);
                                        answer.set("identification", (Object)"LogProtMsgDaemon");
                                        throw ex;
                                    }
                                }
                                if (signal.equals("EventCheckAnswer")) {
                                    if (LogProtHandler.log.isTraceEnabled()) {
                                        LogProtHandler.log.trace((Object)("Event check answer received:" + msg));
                                    }
                                } else {
                                    if (signal.equals("ConnectMaster")) {
                                        try {
                                            answer = new AnwBoss(LogProtMsgDaemon.access$100(LogProtMsgDaemon.this)).handleApplConnect(lprp, msg);
                                            if (answer != null && 1 == (Integer)answer.get("letLineOpen")) {
                                                closePort = false;
                                                if (LogProtHandler.log.isDebugEnabled()) {
                                                    LogProtHandler.log.debug((Object)("inject returns: " + answer));
                                                }
                                                ex = answer;
                                                return ex;
                                            }
                                            break block89;
                                        }
                                        catch (Exception ex) {
                                            LogProtHandler.log.error((Object)"Exception caught on handleApplConnect", (Throwable)ex);
                                            answer = new Message("ConnectMasterAnswer");
                                            throw ex;
                                        }
                                    }
                                    if (signal.equals("DisconnectMaster")) {
                                        try {
                                            answer = new AnwBoss(LogProtMsgDaemon.access$100(LogProtMsgDaemon.this)).handleApplDisconnect(lprp, msg);
                                        }
                                        catch (Exception ex) {
                                            LogProtHandler.log.error((Object)"Exception caught on handleApplDisconnect", (Throwable)ex);
                                            answer = new Message("DisconnectMasterAnswer");
                                            throw ex;
                                        }
                                    } else if (signal.equals("JobData")) {
                                        try {
                                            answer = new AnwBoss(LogProtMsgDaemon.access$100(LogProtMsgDaemon.this)).handleJobInfoProtocol(lprp, msg);
                                        }
                                        catch (Exception ex) {
                                            LogProtHandler.log.error((Object)"Exception caught on handleJobInfoProtocol", (Throwable)ex);
                                            answer = new Message("JobDataAnswer");
                                            throw ex;
                                        }
                                    } else if (signal.equals("errorMessage")) {
                                        LogProtHandler.log.error((Object)("Cannot receive LogProt message from:" + msg.get("internClient") + ", cause: " + msg.get("error")));
                                    } else {
                                        answer = new Message("errorMessage");
                                        answer.set("error", (Object)("LogProtMsgHandler got unknown message: " + msg));
                                        LogProtHandler.log.error((Object)("Unknown message read: " + msg));
                                    }
                                }
                            }
                        }
                    }
                }
                if (port != null && answer != null) {
                    if (LogProtHandler.log.isTraceEnabled()) {
                        LogProtHandler.log.trace((Object)("Sending answer message to port: " + answer));
                    } else if (LogProtHandler.log.isDebugEnabled()) {
                        LogProtHandler.log.debug((Object)("Sending answer message to port: " + answer.getSignal()));
                    }
                    start = System.currentTimeMillis();
                    port.send(answer);
                    WorkerThread.addTcpTime(System.currentTimeMillis() - start);
                }
            }
            catch (Throwable e) {
                LogProtHandler.log.error((Object)("Error in MessageController.inject:" + e), e);
                if (port != null && answer != null) {
                    answer.set("answer", (Object)1);
                    try {
                        port.send(answer);
                    }
                    catch (Exception shit) {
                        shit.initCause(e);
                        LogProtHandler.log.error((Object)("Cannot send a fatal error answer" + shit), (Throwable)shit);
                    }
                }
            }
            finally {
                if (closePort && port != null) {
                    LogProtHandler.log.debug((Object)"finally stop port");
                    port.stopPort();
                }
            }
            if (LogProtHandler.log.isTraceEnabled()) {
                if (answer == null) {
                    LogProtHandler.log.trace((Object)("answer is <null>, msg: " + msg));
                } else {
                    LogProtHandler.log.trace((Object)("end: " + answer));
                }
            } else if (LogProtHandler.log.isDebugEnabled()) {
                if (answer == null) {
                    LogProtHandler.log.debug((Object)("answer is <null>, msg: " + msg));
                } else {
                    LogProtHandler.log.debug((Object)("end: answer: " + answer.getSignal() + ", answer: " + answer.get("answer")));
                }
            }
            return answer;
        }

        private Message handleFXP(Message msg) {
            File file;
            Message answer = new Message("ObjectExchangeAnswer");
            String filename = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("start: Message:" + msg));
            }
            if ((file = new File(filename = (String)msg.get("path"))).exists() && file.isFile()) {
                if (file.canRead()) {
                    answer.set("fileLen", (Object)((int)file.length()));
                    answer.set("answer", (Object)0);
                    answer.set("path", (Object)filename);
                } else {
                    answer.set("answer", (Object)6);
                }
            } else {
                answer.set("answer", (Object)5);
            }
            if ((Integer)answer.get("answer") == 0) {
                log.info((Object)("Send File Exchange Answer: " + filename));
            } else {
                log.error((Object)("Send File Exchange failed: " + answer.get("answer") + ", file: " + filename));
            }
            log.debug((Object)("end: " + answer));
            return answer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Message handleResult(Socket socket, Message msg, LogProtRecvPort lprp) throws SQLException, InterruptedException, LockException, UnexpectedRuntimeException {
            Message answer;
            block54: {
                answer = new Message("ResultAnswer");
                Message account = null;
                long jobId = 0L;
                int jobStepNo = 0;
                int jobStepRetry = 0;
                int jobStepLevel = 0;
                int fcSeqNo = 0;
                int fcSeqRetry = 0;
                int fcLevel = 0;
                Result result = null;
                int isRc = 0;
                int rc = -1;
                boolean isCfRc = false;
                int cfRc = -1;
                int rcType = 0;
                String protfile = null;
                String[] comps = null;
                String[] vars = null;
                String oldStyleId = null;
                int i = 0;
                CtrlSlave slave = null;
                String senderHost = null;
                boolean internal = false;
                boolean localSlave = false;
                Integer jsLevelInt = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("start: Message:" + msg));
                }
                String unique = null;
                try {
                    Connection con;
                    block53: {
                        internal = (Integer)msg.get("internal", (Object)0) != 0;
                        jobId = ((Integer)msg.get("jobId")).intValue();
                        jobStepNo = (Integer)msg.get("jsSequenceNo");
                        jobStepRetry = (Integer)msg.get("jsCurrRetry");
                        jsLevelInt = (Integer)msg.get("jsExceptLevel");
                        if (jsLevelInt != null) {
                            jobStepLevel = jsLevelInt;
                        }
                        fcSeqNo = (Integer)msg.get("fcSequenceNo");
                        fcSeqRetry = (Integer)msg.get("fcCurrRetry");
                        fcLevel = (Integer)msg.get("fctnCallLevel");
                        oldStyleId = (String)msg.get("identification");
                        if (internal && (jobId == 0L || jobStepNo == 0)) {
                            try {
                                i = oldStyleId.indexOf(46);
                                if (i != -1) {
                                    jobId = Long.parseLong(oldStyleId.substring(0, i));
                                    String rest = oldStyleId.substring(i + 1);
                                    jobStepNo = (i = rest.indexOf(46)) == -1 ? Integer.parseInt(rest) : Integer.parseInt(rest.substring(0, i));
                                }
                            }
                            catch (Exception ee) {
                                log.error((Object)("Cannot parse jobstep identification: '" + oldStyleId + "'"), (Throwable)ee);
                                log.error((Object)("Result : " + msg + "\nfrom: " + socket + "\nport: " + lprp));
                            }
                        }
                        isRc = (Integer)msg.get("isRc");
                        rc = (Integer)msg.get("rc");
                        isCfRc = (Integer)msg.get("isCfRc") != 0;
                        cfRc = (Integer)msg.get("cfRc");
                        account = (Message)msg.get("account");
                        if (account != null) {
                            protfile = (String)account.get("logFilename");
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("Result data does not contain account data: " + msg));
                        }
                        vars = (String[])msg.get("assigns");
                        comps = (String[])msg.get("objExchComp");
                        if (log.isDebugEnabled()) {
                            if (protfile != null) {
                                File logfile = new File(protfile);
                                log.debug((Object)("result protfile: " + protfile + ", size: " + logfile.length()));
                            } else {
                                log.debug((Object)"result protfile is <null>");
                            }
                        }
                        if (isCfRc) {
                            rc = cfRc;
                            rcType = 5;
                        } else if (isRc == 2) {
                            rcType = 3;
                        } else if (isRc == 1) {
                            rcType = 4;
                        }
                        slave = this.getCallingSlave(socket);
                        if (slave == null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Cannot identify slave: " + socket));
                            }
                            senderHost = socket == null ? "unknown host" : socket.getInetAddress().getHostAddress();
                        } else {
                            senderHost = slave.getHostname();
                            localSlave = slave.isLocal();
                        }
                        result = internal ? new Result(jobId, jobStepNo, jobStepRetry, jobStepLevel, fcSeqNo, fcSeqRetry, fcLevel, rcType, rc, protfile, senderHost) : new Result(oldStyleId, rcType, rc, protfile, senderHost);
                        this.setVars(result, vars);
                        this.addComps(result, comps, localSlave);
                        con = null;
                        LockJob lj = null;
                        unique = jobId + "/" + jobStepNo + "/" + jobStepRetry + "/" + slave.getName();
                        boolean cannotLockJob = false;
                        try {
                            try {
                                con = LogProtMsgDaemon.this.dispatcher.getConnection();
                            }
                            catch (SQLException ee) {
                                log.error((Object)"Error processing result. Slave should retry to resend the result.", (Throwable)ee);
                                if (unique != null && LogProtMsgDaemon.this.markSlaveForUnlock.get(unique) == null || !((Boolean)LogProtMsgDaemon.this.markSlaveForUnlock.get(unique)).booleanValue()) {
                                    LogProtMsgDaemon.this.markSlaveForUnlock.put(unique, true);
                                    log.error((Object)("Will unlock slave=" + slave.getName() + ". jobId/jobStepNo/jobStepRetry/slaveName = " + unique + "]"), (Throwable)ee);
                                    slave.delRunningJob();
                                }
                                LogProtMsgDaemon.this.dispatcher.sendDisconnectObjBwr();
                            }
                            try {
                                if (result.getJobId() != 0L) {
                                    lj = new LockJob(result.getJobId());
                                    if (!LogProtMsgDaemon.this.dispatcher.getLockDaemon().globalLock((SyncObject)lj, 120000L)) {
                                        throw new LockException("no lock");
                                    }
                                }
                            }
                            catch (LockTimeoutException e) {
                                cannotLockJob = true;
                                Logbook.getLogbook().error("Cannot lock job " + result.getJobId() + ": timeout");
                                log.error((Object)e.getBlockingStackTrace());
                                throw e;
                            }
                            catch (LockException e) {
                                cannotLockJob = true;
                                Logbook.getLogbook().error("Cannot lock job " + result.getJobId() + ": " + (Object)((Object)e));
                                throw e;
                            }
                            if (LogProtMsgDaemon.this.dispatcher.setResult(result, con)) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("result set: " + result));
                                }
                                LogProtMsgDaemon.this.markSlaveForUnlock.remove(unique);
                                answer.set("answer", (Object)0);
                            } else {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("cannot set result: " + result + " map to RC 0"));
                                }
                                LogProtMsgDaemon.this.markSlaveForUnlock.remove(unique);
                                answer.set("answer", (Object)0);
                            }
                            if (lj == null) break block53;
                        }
                        catch (Throwable throwable) {
                            if (lj != null) {
                                try {
                                    if (!cannotLockJob) {
                                        LogProtMsgDaemon.this.dispatcher.getLockDaemon().globalUnLock(lj);
                                    }
                                }
                                catch (LockException e) {
                                    Logbook.getLogbook().error("Cannot unlock job: " + (Object)((Object)e));
                                }
                            }
                            if (con != null) {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)"setResult, free DBInterface");
                                }
                                try {
                                    con.close();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                con = null;
                            }
                            throw throwable;
                        }
                        try {
                            if (!cannotLockJob) {
                                LogProtMsgDaemon.this.dispatcher.getLockDaemon().globalUnLock((SyncObject)lj);
                            }
                        }
                        catch (LockException e) {
                            Logbook.getLogbook().error("Cannot unlock job: " + (Object)((Object)e));
                        }
                    }
                    if (con == null) break block54;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"setResult, free DBInterface");
                    }
                    try {
                        con.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    con = null;
                }
                catch (LockException e) {
                    log.error((Object)("LockException. Error processing result for jobid=" + jobId + ".  Slave=" + slave.getName() + " should retry to resend the result."), (Throwable)e);
                    if (unique != null && LogProtMsgDaemon.this.markSlaveForUnlock.get(unique) == null || !((Boolean)LogProtMsgDaemon.this.markSlaveForUnlock.get(unique)).booleanValue()) {
                        LogProtMsgDaemon.this.markSlaveForUnlock.put(unique, true);
                        log.error((Object)("Will unlock slave=" + slave.getName() + ". jobId/jobStepNo/jobStepRetry/slaveName = " + unique + "]"), (Throwable)e);
                        slave.delRunningJob();
                    }
                    throw e;
                }
                catch (SQLException e) {
                    log.error((Object)("SQLException.  Error processing result for jobid=" + jobId + ".  Slave=" + slave.getName() + " should retry to resend the result."), (Throwable)e);
                    if (unique != null && LogProtMsgDaemon.this.markSlaveForUnlock.get(unique) == null || !((Boolean)LogProtMsgDaemon.this.markSlaveForUnlock.get(unique)).booleanValue()) {
                        LogProtMsgDaemon.this.markSlaveForUnlock.put(unique, true);
                        log.error((Object)("Will unlock slave=" + slave.getName() + ". jobId/jobStepNo/jobStepRetry/slaveName = " + unique + "]"), (Throwable)e);
                        slave.delRunningJob();
                    }
                    throw e;
                }
            }
            log.debug((Object)("end: " + answer));
            return answer;
        }

        private void setVars(Result result, String[] vars) {
            String name = null;
            String val = "";
            for (int i = 0; vars != null && i < vars.length; ++i) {
                int idx = vars[i].indexOf(61);
                if (idx != -1) {
                    name = vars[i].substring(0, idx);
                    val = vars[i].substring(idx + 1);
                } else {
                    name = null;
                }
                if (name != null && name.length() > 0) {
                    result.setVar(name, (Value)new Variable((Object)val));
                    continue;
                }
                log.error((Object)("Error in assign: <" + vars[i] + ">, ignored, job " + result.getJobId()));
            }
        }

        private Set<EdiComp> getComps(String[] comps, boolean localSlave) {
            Hashtable<String, EdiComp> compsTab = new Hashtable<String, EdiComp>();
            for (int i = 0; i < comps.length; ++i) {
                int idx = comps[i].indexOf(61);
                String val = comps[i].substring(idx + 1);
                StringTokenizer tok = new StringTokenizer(comps[i].substring(0, idx), ".");
                tok.nextToken();
                String name = tok.nextToken();
                String attr = tok.hasMoreTokens() ? tok.nextToken() : null;
                EdiComp comp = (EdiComp)compsTab.get(name);
                if (comp == null) {
                    comp = new EdiComp(null, -1, name, "", i);
                    compsTab.put(name, comp);
                }
                if (attr == null || attr.length() == 0 || attr.equalsIgnoreCase("FN")) {
                    val = val.replace('\\', '/');
                    if (localSlave && comp.getSize() < 1L) {
                        comp.setSize(new File(val).length());
                    }
                    comp.setFileName(val);
                    continue;
                }
                if (attr.equalsIgnoreCase("size")) {
                    if (val != null) {
                        val = val.trim();
                    }
                    if (val != null && val.length() > 0) {
                        comp.setSize(Long.valueOf(val).longValue());
                        continue;
                    }
                    comp.setSize(0L);
                    continue;
                }
                if (attr.equalsIgnoreCase("compNumber")) {
                    comp.setNum(Integer.valueOf(val).intValue());
                    continue;
                }
                log.warn((Object)("Unknown EDI object component attribute <" + attr + "> in component specification <" + comps[i] + ">"));
            }
            return new TreeSet<EdiComp>(compsTab.values());
        }

        private void addComps(Result result, String[] comps, boolean localSlave) {
            Set<EdiComp> compsList = this.getComps(comps, localSlave);
            Iterator<EdiComp> it = compsList.iterator();
            while (it.hasNext()) {
                result.addEdiComp(it.next());
            }
        }

        private String getEventAttr(Message msg) {
            StringBuffer buf = new StringBuffer();
            String[] attr = (String[])msg.get("attributes");
            if (attr != null) {
                for (int i = 0; i < attr.length; ++i) {
                    if (i > 0) {
                        buf.append(" ");
                    }
                    buf.append(attr[i]);
                }
            }
            return buf.toString();
        }

        private CtrlSlave getCallingSlave(Socket socket) {
            InetAddress inetAddr = null;
            CtrlSlave slave = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("start: " + socket));
                log.debug((Object)("InetAddress: " + socket.getInetAddress()));
            }
            if (socket != null) {
                inetAddr = socket.getInetAddress();
                slave = LogProtMsgDaemon.this.dispatcher.getSlave(inetAddr);
                if (slave == null) {
                    log.error((Object)("dispatcher.getSlave() did not identify:" + inetAddr));
                }
            } else {
                log.error((Object)"No socket object to check.", (Throwable)new Exception("Empty socket parameter."));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("end: " + slave));
            }
            return slave;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleEvent(Socket socket, Message msg, LogProtRecvPort lprp) throws Throwable {
            boolean eventAlreadyExists;
            IExecutable iexec;
            boolean sendAnswer;
            boolean letPortOpen;
            boolean syncFlag;
            Message answer;
            block60: {
                answer = new Message("EventAnswer");
                CtrlEvent event = null;
                int eventID = -1;
                Message ediObj = null;
                EdiComp comp = null;
                Message[] ediComp = null;
                String[] paramNames = null;
                String[] paramVals = null;
                String evAttrStr = null;
                CfgJSelect jselect = null;
                CtrlSlave slave = null;
                int eventType = 0;
                syncFlag = false;
                String initiator = null;
                String cfID = null;
                String refNo = null;
                String eventHost = null;
                ILogbook logbook = Logbook.getLogbook();
                letPortOpen = false;
                sendAnswer = false;
                iexec = null;
                eventAlreadyExists = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("start: " + msg));
                }
                eventHost = socket != null ? socket.getInetAddress().getHostName() : "";
                eventID = (Integer)msg.get("eventId");
                paramNames = (String[])msg.get("eventParamLeft");
                paramVals = (String[])msg.get("eventParamRight");
                ediObj = (Message)msg.get("ediObjects");
                initiator = (String)msg.get("initiator");
                if (ediObj != null) {
                    refNo = (String)ediObj.get("referenzNo");
                }
                if (refNo == null) {
                    refNo = "";
                }
                if (((eventType = ((Integer)msg.get("eventType")).intValue()) & 7) == 0) {
                    eventType |= 4;
                }
                syncFlag = (Integer)msg.get("EventSyncFlag") != 0;
                cfID = (String)msg.get("coreFunctionId");
                if (cfID == null) {
                    cfID = "";
                }
                if (ediObj != null) {
                    ediComp = (Message[])ediObj.get("components");
                }
                answer.set("answer", (Object)1);
                answer.set("eventId", (Object)eventID);
                answer.set("jobId", (Object)0);
                answer.set("objectId", (Object)0);
                try {
                    Object con;
                    block57: {
                        int i;
                        evAttrStr = this.getEventAttr(msg);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Event attr: " + evAttrStr));
                        }
                        if ((slave = this.getCallingSlave(socket)) == null) {
                            throw new Exception("Cannot identify slave: " + socket);
                        }
                        event = new CtrlEvent((long)eventID, evAttrStr);
                        event.setType(eventType);
                        event.setInitiator(initiator);
                        event.setCorefuncId(cfID);
                        event.setRefNo(refNo);
                        event.setInitiatorHost(eventHost);
                        if (syncFlag) {
                            event.setWFRConnection(new WorkflowResultConnection(logbook, lprp, eventID));
                        }
                        log.debug((Object)("event.type: " + event.getType()));
                        jselect = LogProtMsgDaemon.this.dispatcher.getGlobals().getJSelect();
                        for (i = 0; i < paramNames.length; ++i) {
                            if (paramNames[i] == null || paramNames[i].length() <= 0 || paramVals[i] == null || paramVals[i].length() <= 0) continue;
                            event.addParam(paramNames[i], paramVals[i]);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("add parameter: " + paramNames[i] + "=" + paramVals[i]));
                        }
                        logbook.eventStart(event, eventHost, cfID);
                        iexec = jselect.createJob(event, null);
                        EventLock el = new EventLock(event.getId());
                        LogProtMsgDaemon.this.dispatcher.getLockDaemon().globalLock((SyncObject)el);
                        try {
                            con = LogProtMsgDaemon.this.dispatcher.getConnection();
                            con.setReadOnly(true);
                            boolean exists = false;
                            try {
                                exists = CtrlEvent.exists(event.getId(), (Connection)con);
                            }
                            finally {
                                con.close();
                            }
                            if (exists) {
                                eventAlreadyExists = true;
                                sendAnswer = true;
                                break block57;
                            }
                            if (iexec instanceof CtrlJob) {
                                CtrlJob job = (CtrlJob)iexec;
                                job.setCompSlave(slave);
                                logbook.createJob(job.getName(), job.getId(), event.getId(), job.getId());
                                if (ediComp != null) {
                                    for (i = 0; i < ediComp.length; ++i) {
                                        String compName = (String)ediComp[i].get("name");
                                        String pathName = (String)ediComp[i].get("path");
                                        pathName = pathName.replace('\\', '/');
                                        try {
                                            comp = job.newComp(compName, pathName);
                                            comp.setSize((long)((Integer)ediComp[i].get("size")).intValue());
                                        }
                                        catch (ParameterException e) {
                                            Logbook.getLogbook().error("new comp for job " + job.getId() + ": " + e.getMessage());
                                            comp = null;
                                        }
                                        if (!log.isDebugEnabled()) continue;
                                        log.debug((Object)("Component added: " + comp));
                                    }
                                }
                                if (job.getCompSize() > 0) {
                                    logbook.object(job.getCompSlave().getHostname(), job.getId(), job.getId(), refNo, job.getComps4log());
                                }
                                con = LogProtMsgDaemon.this.dispatcher.getConnection();
                                try {
                                    long start = System.currentTimeMillis();
                                    JslEntry jslEntry = job.getJsl();
                                    synchronized (jslEntry) {
                                        ((CfgJSelectEntry)job.getJsl()).save(log, (Connection)con);
                                    }
                                    event.insert((Connection)con);
                                    con.commit();
                                    WorkerThread.addDbTime(System.currentTimeMillis() - start);
                                }
                                catch (SQLException e) {
                                    try {
                                        con.rollback();
                                    }
                                    catch (SQLException sQLException) {
                                        // empty catch block
                                    }
                                    throw e;
                                }
                                finally {
                                    con.close();
                                }
                                sendAnswer = true;
                                break block57;
                            }
                            sendAnswer = true;
                        }
                        finally {
                            LogProtMsgDaemon.this.dispatcher.getLockDaemon().globalUnLock((SyncObject)el);
                        }
                    }
                    con = LogProtMsgDaemon.this.stopSync;
                    synchronized (con) {
                        this.runningHandler.remove(this);
                        LogProtMsgDaemon.this.stopSync.notify();
                    }
                    if (eventAlreadyExists) {
                        logbook.error("event " + eventID + " already exists");
                        logbook.eventEnd(event, eventHost, cfID);
                        answer.set("answer", (Object)0);
                        answer.set("eventId", (Object)eventID);
                        answer.set("jobId", (Object)eventID);
                        answer.set("objectId", (Object)eventID);
                    } else if (iexec == null) {
                        event.setType(eventType |= 0x10);
                        logbook.createJob("NIL !", 0L, 0L, 0L);
                        logbook.eventEnd(event, eventHost, cfID);
                        answer.set("answer", (Object)2);
                    } else {
                        logbook.eventEnd(event, eventHost, cfID);
                        answer.set("answer", (Object)0);
                        answer.set("eventId", (Object)eventID);
                        answer.set("jobId", (Object)eventID);
                        answer.set("objectId", (Object)eventID);
                    }
                }
                catch (Throwable e) {
                    logbook.error("Cannot handle event: " + e);
                    log.error((Object)"error in handleEvent", e);
                    try (Connection connection1 = null;){
                        connection1 = LogProtMsgDaemon.this.dispatcher.getConnection();
                    }
                    if (sendAnswer) break block60;
                    throw e;
                }
            }
            try {
                if (sendAnswer) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("send answer: " + answer));
                    }
                    lprp.send(answer);
                }
            }
            catch (Exception e) {
                log.error((Object)("Cannot send event answer: " + e));
                letPortOpen = false;
            }
            if (!eventAlreadyExists && iexec != null && sendAnswer) {
                try {
                    LogProtMsgDaemon.this.dispatcher.newJob(iexec);
                    if (syncFlag) {
                        letPortOpen = true;
                    }
                    if (iexec instanceof CtrlJob) {
                        LogProtMsgDaemon.this.dispatcher.sentinelJsStartMsg(((CtrlJob)iexec).getCurrentStep());
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Cannot start new job: " + e));
                    letPortOpen = false;
                }
            }
            return letPortOpen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Message handleCommand(Socket socket, Message cmdMsg) {
            Message answer = new Message("SendCommandAnswer");
            int cmdType = -1;
            int cmdNo = -1;
            String cmdName = null;
            String initiator = null;
            String user = null;
            String[] argv = null;
            String[] anyData = null;
            Cmd cmd = null;
            CmdAnswer cAnswer = null;
            CtrlSlave slave = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("start: " + cmdMsg));
            }
            cmdType = (Integer)cmdMsg.get("cmdType");
            cmdNo = (Integer)cmdMsg.get("currUbtnr");
            cmdName = (String)cmdMsg.get("cmdName");
            initiator = (String)cmdMsg.get("initiator");
            user = (String)cmdMsg.get("ediUser");
            argv = (String[])cmdMsg.get("args");
            answer.set("answer", (Object)1);
            answer.set("currUbtnr", (Object)cmdNo);
            answer.set("noOfEntries", (Object)0);
            answer.set("typeOfAnyData", (Object)cmdType);
            try {
                slave = this.getCallingSlave(socket);
                if (slave == null) {
                    throw new Exception("Cannot identify slave: " + socket);
                }
                cmd = Cmd.create(slave.getHostname(), cmdType, cmdName, cmdNo, initiator, user, argv, LogProtMsgDaemon.this.dispatcher);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cmd created: " + cmd));
                }
                if (!cmd.waitForEnd()) {
                    Object object = LogProtMsgDaemon.this.stopSync;
                    synchronized (object) {
                        this.runningHandler.remove(this);
                        LogProtMsgDaemon.this.stopSync.notify();
                    }
                }
                cAnswer = cmd.executeAndLog();
                answer.set("answer", (Object)cAnswer.getAnswer());
                answer.set("currUbtnr", (Object)((int)cAnswer.getCmdNo()));
                answer.set("noOfEntries", (Object)cAnswer.getNoOfEntries());
                answer.set("typeOfAnyData", (Object)cAnswer.getTypeOfAnyData());
                anyData = cAnswer.getAnyData();
                anyData = LogProtMsgDaemon.this.addResult4KillCmd(cAnswer, anyData);
                if (anyData != null) {
                    answer.set("anyData", (Object)anyData);
                }
            }
            catch (Exception e) {
                answer.set("answer", (Object)1);
                anyData = new String[]{e.toString()};
                anyData = LogProtMsgDaemon.this.addResult4KillCmd(cAnswer, anyData);
                answer.set("anyData", (Object)anyData);
                log.error((Object)"error: ", (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("end answer: " + answer));
            }
            return answer;
        }

        @Override
        public String toString() {
            return "LogProtHandler: " + this.getName() + ", msg: " + this.myMsg;
        }
    }
}

