/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.master.Appl;
import de.axway.aim.controller.master.CtrlDispAppl;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.JobRunner;
import de.axway.aim.controller.master.JslBuiltin;
import de.axway.aim.controller.master.LockJob;
import de.axway.aim.controller.master.RecoverableRuntimeException;
import de.axway.aim.controller.master.RunJobException;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.aim.controller.master.queue.RunQueue;
import de.axway.aim.controller.master.slave.BuiltinSlaveHandler;
import de.axway.aim.controller.master.slave.LogprotSlaveHandler;
import de.axway.lib.util.runner.ManagedRunnableImpl;
import de.axway.lockDaemon.DBLockException;
import de.axway.lockDaemon.LockDaemon;
import de.axway.lockDaemon.LockException;
import de.axway.lockDaemon.SyncObject;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SlaveHandler
extends Appl
implements Comparable<SlaveHandler> {
    private static Log log = LogFactory.getLog((String)"master.SlaveHandler");
    private boolean shutdown = true;
    private boolean down = true;
    private boolean started = false;
    private Object downSync = new Object();
    protected CtrlSlave slave;
    private RunQueue queue = null;
    private Object waitJob = new Object();
    private boolean newJob = false;
    private boolean wait4Job = false;
    private Object waitConnect = new Object();
    private boolean connected = true;
    private boolean firstError = true;
    private LockDaemon ld = null;
    private static int fcsPer5Minutes = 0;
    private HashMap<Long, JobRunner> runningJobs = new HashMap();
    private Executor threadPool;
    private ManagedRunnableImpl thread = new ManagedRunnableImpl(){

        public void doRun() {
            log.info((Object)("SlaveHandler " + SlaveHandler.this.slave.getName() + " start"));
            SlaveHandler.this.started = true;
            try {
                SlaveHandler.this.slaveRun();
            }
            finally {
                log.info((Object)("SlaveHandler " + SlaveHandler.this.slave.getName() + " end"));
            }
        }

        public void stopIt() {
        }
    };

    protected SlaveHandler() {
        super("SLAVE");
    }

    protected void logError(String msg) {
        this.connected = false;
        if (this.firstError) {
            this.firstError = false;
            Logbook.getLogbook().error(this.getSlave().getName() + ": " + msg);
        }
    }

    @Override
    public int compareTo(SlaveHandler sh) {
        return this.slave.compareTo(sh.slave);
    }

    public static SlaveHandler createSlaveHandler(CtrlSlave slave, RunQueue queue, CtrlDispAppl dispatcher) {
        SlaveHandler sh;
        switch (slave.getConnectionType()) {
            case LOGPROT: {
                sh = new LogprotSlaveHandler();
                break;
            }
            case BUILTIN: {
                sh = new BuiltinSlaveHandler();
                break;
            }
            default: {
                return null;
            }
        }
        sh.slave = slave;
        sh.queue = queue;
        sh.setDispatcher(dispatcher);
        sh.threadPool = dispatcher.getThreadPool();
        sh.ld = dispatcher.getLockDaemon();
        return sh;
    }

    public synchronized void restart(RunQueue queue) throws Exception {
        if (!this.shutdown) {
            throw new Exception("Slavehandler ist not down");
        }
        this.queue = queue;
        this.threadPool = this.dispatcher.getThreadPool();
        this.shutdown = false;
        this.down = false;
        this.firstError = true;
        this.thread.start();
        while (!this.started) {
            log.warn((Object)"not started, sleeping");
            Thread.sleep(100L);
        }
    }

    protected abstract void runJob(CtrlFunctionCall var1, Connection var2) throws RunJobException;

    public abstract FcStat checkFc(CtrlFunctionCall var1);

    public abstract FcStat killFc(CtrlFunctionCall var1);

    public abstract int[] rmFiles(String[] var1);

    public abstract boolean ping();

    protected void execBuiltin(JslBuiltin builtin) throws CfgException {
        throw new CfgException("not implemented");
    }

    public File getRemoteFile(String filename) throws Exception {
        throw new IOException("not implemented");
    }

    public String getName() {
        return this.thread.getName();
    }

    public void setName(String name) {
        this.thread.setName(name);
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public String getStatus() {
        if (this.down) {
            return this.slave.getName() + " down";
        }
        int rj = -1;
        rj = this.slave.size();
        Object[] objectArray = new Object[4];
        objectArray[0] = this.getId();
        objectArray[1] = this.slave.toString().replace("\n", "\n     ");
        Object object = objectArray[2] = rj >= 0 ? Integer.valueOf(rj) : "Info not available!";
        objectArray[3] = this.wait4Job ? "No jobs waiting." : (this.connected ? "Slave is running." : "Slave is NOT connected.");
        return String.format("%03d) %s\n     running FCs: %s, Status: %s", objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.shutdown = true;
        this.started = false;
        HashMap<Long, JobRunner> hashMap = this.waitJob;
        synchronized (hashMap) {
            this.thread.interrupt();
        }
        hashMap = this.downSync;
        synchronized (hashMap) {
            while (!this.down) {
                try {
                    this.downSync.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        long startTime = System.currentTimeMillis();
        while (this.runningJobs.size() > 0) {
            hashMap = this.runningJobs;
            synchronized (hashMap) {
                if (System.currentTimeMillis() - startTime > 60000L) {
                    log.warn((Object)("Waiting for " + this.runningJobs.size() + " function calls"));
                    try {
                        for (JobRunner jr : this.runningJobs.values()) {
                            log.warn((Object)("Waiting for " + jr.getName()));
                        }
                    }
                    catch (Exception xx) {
                        log.error((Object)"Cannot dump running JobRunner!", (Throwable)xx);
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.slave.removeAllJobLocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newJob() {
        Object object = this.waitJob;
        synchronized (object) {
            if (this.wait4Job) {
                this.newJob = true;
                this.waitJob.notify();
            }
        }
    }

    public void addActiveJob() {
        this.slave.addActiveJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newConnect() {
        Object object = this.waitConnect;
        synchronized (object) {
            this.connected = true;
            this.firstError = true;
            this.waitConnect.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rePing() {
        Object object = this.waitConnect;
        synchronized (object) {
            this.waitConnect.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void slaveRun() {
        try {
            this.setName("SlaveHandler " + this.slave.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (this.getId() == -1L) {
            try {
                this.setId();
            }
            catch (Exception e) {
                log.error((Object)"set slave id", (Throwable)e);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.dispatcher.getEdiboss().getMaxJsDispatch() <= 0) {
            Logbook.getLogbook().warning("max_js_dispatch=" + this.dispatcher.getEdiboss().getMaxJsDispatch() + " slaveHandler " + this.slave.getName() + " exit");
            this.down = true;
            return;
        }
        while (!this.shutdown) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("SlaveHandler:slaveRun[slave=" + this.slave.getName() + "]"));
            }
            if (!this.dispatcher.getHealthStatus().proceed(true)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("SlaveHandler:slaveRun[slave=" + this.slave.getName() + "]: stopped processing. Waiting to recover from recoverable error."));
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            while (!this.connected && !this.shutdown) {
                this.connected = this.ping();
                if (!this.connected && !this.shutdown) {
                    Object e = this.waitConnect;
                    synchronized (e) {
                        block26: {
                            try {
                                this.waitConnect.wait(60000L);
                            }
                            catch (InterruptedException e2) {
                                if (!log.isTraceEnabled()) break block26;
                                log.trace((Object)("SlaveHandler:slaveRun[slave=" + this.slave.getName() + "]: stopped processing. Waiting to recover from recoverable error."));
                            }
                        }
                        continue;
                    }
                }
                if (!this.connected) continue;
                this.firstError = true;
            }
            try {
                this.processNextJob();
            }
            catch (RecoverableRuntimeException rex) {
                log.error((Object)("SlaveHandler:slaveRun[slave=" + this.slave.getName() + "]"), (Throwable)rex);
                this.dispatcher.getHealthStatus().signalRecoverableRuntimeException(rex);
            }
        }
        this.down = true;
        Object object = this.downSync;
        synchronized (object) {
            this.downSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextJob() throws RecoverableRuntimeException {
        block45: {
            IExecutable job = null;
            boolean haveSlot = false;
            String jobId = "no job";
            boolean jobSuccessfullyPassedToThreadPool = false;
            try {
                this.slave.addRunningJob();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("SlaveHandler:slaveRun[slave=" + this.slave.getName() + "]: locked slave."));
                }
                haveSlot = true;
            }
            catch (DBLockException dbex) {
                log.error((Object)("Error slaveHandler, slave=" + this.slave.getName() + ". Failed to lock SlaveHandler."), (Throwable)dbex);
                throw new RecoverableRuntimeException("SlaveHandler:slaveRun[slave=" + this.slave.getName() + "]: Failed to lock SlaveHandler.", dbex);
            }
            catch (LockException e) {
                log.error((Object)"get slave slot", (Throwable)e);
                Logbook.getLogbook().error("get slave slot: " + (Object)((Object)e));
            }
            if (haveSlot) {
                try {
                    try {
                        job = this.queue.getNext(this);
                        if (job != null) {
                            jobId = "" + job.getId();
                        }
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("SlaveHandler:slaveRun[job=" + jobId + ", slave=" + this.slave.getName() + "]: Got next job."));
                        }
                    }
                    catch (DBLockException dbex) {
                        log.error((Object)("Error slaveHandler, slave=" + this.slave.getName() + ". Failed to get next job."), (Throwable)dbex);
                        throw new RecoverableRuntimeException("SlaveHandler:slaveRun[slave=" + this.slave.getName() + "]: Failed to get next job.", dbex);
                    }
                    catch (LockException e) {
                        log.error((Object)"get next job", (Throwable)e);
                        Logbook.getLogbook().error("get next job: " + (Object)((Object)e));
                    }
                    try {
                        if (job != null && job instanceof CtrlJob && this.dispatcher.getJob(job.getId()) == null) {
                            try {
                                this.ld.globalUnLock((SyncObject)new LockJob(job.getId()));
                            }
                            catch (LockException e) {
                                log.error((Object)("unlock job=" + jobId), (Throwable)e);
                                Logbook.getLogbook().error("unlock job: " + (Object)((Object)e));
                            }
                            break block45;
                        }
                        if (job == null) {
                            try {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("SlaveHandler:slaveRun[job=" + job + ", slave=" + this.slave.getName() + "]: unlocked slave."));
                                }
                                this.slave.delRunningJob();
                            }
                            catch (LockException e) {
                                log.error((Object)"remove slave slot", (Throwable)e);
                                Logbook.getLogbook().error("remove slave slot: " + (Object)((Object)e));
                            }
                            Object e = this.waitJob;
                            synchronized (e) {
                                while (!this.newJob && !this.shutdown && this.queue.getSize(this) == 0) {
                                    this.wait4Job = true;
                                    try {
                                        this.waitJob.wait();
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    continue;
                                    finally {
                                        this.wait4Job = false;
                                    }
                                }
                                this.newJob = false;
                                break block45;
                            }
                        }
                        try {
                            JobRunner jr = new JobRunner(this, job);
                            HashMap<Long, JobRunner> hashMap = this.runningJobs;
                            synchronized (hashMap) {
                                this.runningJobs.put(job.getId(), jr);
                            }
                            this.threadPool.execute(jr);
                            jobSuccessfullyPassedToThreadPool = true;
                            this.ld.globalUnLock((SyncObject)new LockJob(job.getId()));
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("SlaveHandler:slaveRun[job=" + job + ", slave=" + this.slave.getName() + "]: unlocked job."));
                                log.trace((Object)("SlaveHandler:slaveRun[job=" + job + ", slave=" + this.slave.getName() + "]: Job added to the threadPool."));
                                log.trace((Object)("Started running job ID: " + job.getId() + " by " + jr));
                            }
                        }
                        catch (Throwable e) {
                            log.error((Object)"Error starting new JobRunner", e);
                            Logbook.getLogbook().error("Cannot execute: " + e);
                            try {
                                this.ld.globalUnLock((SyncObject)new LockJob(job.getId()));
                            }
                            catch (LockException le) {
                                log.error((Object)"unlock job", (Throwable)le);
                                Logbook.getLogbook().error("unlock job: " + (Object)((Object)le));
                            }
                            this.dispatcher.dispatch(job);
                        }
                    }
                    catch (InterruptedException e) {
                        Logbook.getLogbook().warning("slave " + this.getName() + " interrupted, shutdown?");
                    }
                }
                finally {
                    if (!jobSuccessfullyPassedToThreadPool && job != null) {
                        try {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("SlaveHandler:slaveRun[job=" + jobId + ", slave=" + this.slave.getName() + "]: unlocked slave."));
                            }
                            this.slave.delRunningJob();
                        }
                        catch (Exception le) {
                            log.error((Object)"", (Throwable)le);
                            Logbook.getLogbook().error("remove: " + le);
                        }
                    }
                }
            }
        }
    }

    public CtrlSlave getSlave() {
        return this.slave;
    }

    protected RunQueue getQueue() {
        return this.queue;
    }

    protected Ediboss getEdiboss() {
        return this.dispatcher.getEdiboss();
    }

    protected LockDaemon getLockDaemon() {
        return this.dispatcher.getLockDaemon();
    }

    protected CtrlDispAppl getDispatcher() {
        return this.dispatcher;
    }

    protected Connection getConnection() throws SQLException {
        return this.dispatcher.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getClearFcCount() {
        Class<SlaveHandler> clazz = SlaveHandler.class;
        synchronized (SlaveHandler.class) {
            int cnt = fcsPer5Minutes;
            fcsPer5Minutes = 0;
            // ** MonitorExit[var1] (shouldn't be in output)
            return cnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incFcCount() {
        Class<SlaveHandler> clazz = SlaveHandler.class;
        synchronized (SlaveHandler.class) {
            ++fcsPer5Minutes;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runningJobsContains(long jobid, JobRunner jr) {
        HashMap<Long, JobRunner> hashMap = this.runningJobs;
        synchronized (hashMap) {
            JobRunner cjr = this.runningJobs.get(jobid);
            if (cjr != null && cjr == jr) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delQueuedJob(long jobid) {
        HashMap<Long, JobRunner> hashMap = this.runningJobs;
        synchronized (hashMap) {
            JobRunner cjr = this.runningJobs.get(jobid);
            if (cjr != null && !cjr.isRunning) {
                this.runningJobs.remove(jobid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delQueuedJob(long jobid, JobRunner jr) {
        HashMap<Long, JobRunner> hashMap = this.runningJobs;
        synchronized (hashMap) {
            JobRunner cjr = this.runningJobs.get(jobid);
            if (cjr != null && cjr == jr) {
                this.runningJobs.remove(jobid);
            }
        }
    }

    public SlaveHandler modifySlaveHandler(CtrlSlave slave) {
        return SlaveHandler.createSlaveHandler(slave, this.queue, this.dispatcher);
    }

    public static enum FcStat {
        WAIT4RESULT,
        EMERGENCY,
        ZOMBIE,
        KILLED;

    }
}

