/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master;

import de.axway.aim.controller.master.log.ILogbook;
import de.axway.lib.logprot.LogProtRecvPort;
import de.axway.lib.message.Message;
import de.axway.lib.message.MessageEncodingException;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WorkflowResultConnection {
    private static Log log = LogFactory.getLog((String)"master.WorkflowResultConnection");
    private LogProtRecvPort lprp;
    private long eventId;
    private ILogbook logbook;

    public WorkflowResultConnection(ILogbook logbook, LogProtRecvPort lprp, long eventId) {
        this.lprp = lprp;
        this.eventId = eventId;
        this.logbook = logbook;
    }

    private Message getWFHead(boolean doClose, int rc) {
        Message wfr = new Message("WorkflowResult");
        wfr.set("eventId", (Object)((int)this.eventId));
        wfr.set("jobId", (Object)((int)this.eventId));
        wfr.set("objectId", (Object)((int)this.eventId));
        wfr.set("answer", (Object)rc);
        wfr.set("closeConnection", (Object)(doClose ? 1 : 0));
        return wfr;
    }

    private Message getWfrForComp(boolean close, int rc, String path, String compname) {
        log.debug((Object)"start:");
        Message wfr = this.getWfrForFile(close, rc, path);
        wfr.set("components", (Object)compname);
        log.debug((Object)"end:");
        return wfr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getWfrForFile(boolean doClose, int rc, String filename) {
        FileInputStream in = null;
        byte[] buf = null;
        Message wfr = this.getWFHead(doClose, rc);
        log.debug((Object)"start:");
        wfr.set("path", (Object)(filename != null ? filename : ""));
        try {
            in = new FileInputStream(filename);
            buf = new byte[in.available()];
            in.read(buf);
            in.close();
            in = null;
            wfr.set("data", (Object)buf);
        }
        catch (IOException e) {
            this.logbook.warning("Cannot send workflow result file data from '" + filename + "', " + e);
            if (log.isDebugEnabled()) {
                log.error((Object)("Cannot send workflow result file data from '" + filename + "' in Workflow Result!"), (Throwable)e);
            } else {
                log.warn((Object)("Cannot send workflow result file data from '" + filename + "', " + e));
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        log.debug((Object)"end:");
        return wfr;
    }

    private Message getWfrForText(boolean doClose, int rc, String text) throws MessageEncodingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: doClose: " + doClose + ", rc: " + rc + ", text: " + text));
        }
        Message wfr = this.getWFHead(doClose, rc);
        if (text != null) {
            wfr.set("data", (Object)text.getBytes());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("end: " + wfr));
        }
        return wfr;
    }

    private Message getWfr(boolean doClose, int rc) throws IOException, MessageEncodingException {
        return this.getWfrForText(doClose, rc, null);
    }

    public void sendWfrComp(boolean doClose, int rc, String path, String comp) throws MessageEncodingException {
        log.debug((Object)"start:");
        if (this.isConnected()) {
            Message msg = this.getWfrForComp(doClose, rc, path, comp);
            this.lprp.send(msg);
            if (doClose) {
                this.close();
            }
        } else {
            log.debug((Object)"Cannot send component. Connection already closed.");
        }
        log.debug((Object)"end:");
    }

    public void sendWfrFile(boolean doClose, int rc, String filename) throws MessageEncodingException {
        log.debug((Object)"start:");
        if (this.isConnected()) {
            Message msg = this.getWfrForFile(doClose, rc, filename);
            if (log.isTraceEnabled()) {
                log.trace((Object)("do send WF file: " + msg));
            } else if (log.isTraceEnabled()) {
                log.debug((Object)("do send WF file: " + filename));
            }
            this.lprp.send(msg);
            if (doClose) {
                this.close();
            }
        } else {
            log.debug((Object)"Cannot send file. Connection already closed.");
        }
        log.debug((Object)"end:");
    }

    public void sendWfrText(boolean doClose, int rc, String text) throws MessageEncodingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: doClose: " + doClose + ", rc: " + rc + ", text: " + text));
        }
        if (this.isConnected()) {
            Message msg = this.getWfrForText(doClose, rc, text);
            if (log.isDebugEnabled()) {
                log.debug((Object)("do send WF text: " + msg));
            }
            this.lprp.send(msg);
            if (doClose) {
                this.close();
            }
        } else {
            log.debug((Object)"Cannot send text. Connection already closed.");
        }
        log.debug((Object)"end:");
    }

    public void sendWfr(boolean doClose, int rc) throws IOException, MessageEncodingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: doClose: " + doClose + ", rc: " + rc));
        }
        if (this.isConnected()) {
            Message msg = this.getWfr(doClose, rc);
            if (log.isDebugEnabled()) {
                log.debug((Object)("do send Workflow Result: " + msg));
            }
            this.lprp.send(msg);
            if (doClose) {
                this.close();
            }
        } else {
            log.debug((Object)"Cannot send text. Connection already closed.");
        }
        log.debug((Object)"end:");
    }

    public boolean isConnected() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: " + (this.lprp != null)));
        }
        return this.lprp != null;
    }

    public void close() {
        log.debug((Object)"start: ");
        if (this.lprp != null) {
            log.debug((Object)"stopping port.");
            this.lprp.stopPort();
        }
        this.lprp = null;
        log.debug((Object)"end: ");
    }
}

