/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.account;

import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.CtrlJobStep;
import de.axway.aim.controller.master.account.RcbErrRec;
import de.axway.aim.controller.master.account.RcbHeadRec;
import de.axway.aim.controller.master.account.RcbRecord;
import de.axway.aim.controller.master.account.RcbStatRec;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.lib.util.ActisFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RcbAccount {
    private static Log log = LogFactory.getLog((String)"master.account.Rcb");
    private static final String VERSION = "$Header$";
    private boolean rcbAccOn = false;
    private static final String FMT_ERR_OPEN = "Cannot open file: <%s>, excep=%s\n";
    private static final String FMT_ERR_WRIT = "Cannot write %c-Record. File: <%s>, excep=%d\n";
    private static final String FMT_ERR_SEEK = "Cannot seek to %c-Record. File: <%s>, excep=%d\n";
    private static final int RCBACC_RECLEN = 256;
    private static final int ABS_POS_RESET_FLAG = 2;
    private static final boolean DO_BUILD_HASH = true;
    private static final boolean DONT_BUILD_HASH = false;
    private String rcbAccPath;
    private String currAccFilename = null;
    private RandomAccessFile fp = null;
    private static byte[] eol = new byte[2];
    private ILogbook logbook = null;
    private static Hashtable<String, RcbRecord> rcbHash = new Hashtable();

    public RcbAccount(ILogbook logbook, boolean rcbAccOn, String rcbAccPath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("RcbAccount: start: rcbAccOn: " + rcbAccOn + ", rcbAccPath: " + rcbAccPath));
        }
        this.logbook = logbook;
        RcbAccount.eol[0] = 32;
        RcbAccount.eol[1] = 10;
        if (RcbAccount.isWindows()) {
            RcbAccount.eol[0] = 13;
        }
        this.rcbAccOn = rcbAccOn;
        this.rcbAccPath = rcbAccPath;
        this.currAccFilename = new ActisFile(rcbAccPath).toString();
        if (rcbAccOn && !this.openFile()) {
            if (logbook != null) {
                logbook.warning("RCB accounting turned off to avoid loss of performance.");
            }
            log.error((Object)("Cannot open file : <" + this.currAccFilename + ">"));
            log.warn((Object)"RCB accounting turned off to avoid loss of performance.");
            this.rcbAccOn = false;
        } else {
            log.debug((Object)("RCB accounting active: " + rcbAccOn));
        }
    }

    private boolean createHash() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createHash start:");
        }
        if (this.fp == null) {
            log.debug((Object)"createHash end: file not open");
            return false;
        }
        try {
            String line;
            this.fp.seek(0L);
            long pos = 0L;
            while ((line = this.fp.readLine()) != null) {
                try {
                    RcbRecord rec = RcbHeadRec.createFromString(line);
                    if (rec != null) {
                        rcbHash.put(rec.getHashVal(), rec);
                    } else {
                        rec = RcbStatRec.createFromString(line);
                        if (rec != null) {
                            rec.setPos(pos);
                            rcbHash.put(rec.getHashVal(), rec);
                        } else {
                            rec = RcbErrRec.createFromString(line);
                            if (rec != null) {
                                rec.setPos(pos);
                                rcbHash.put(rec.getHashVal(), rec);
                            } else if (log.isDebugEnabled()) {
                                log.debug((Object)("Line found '" + line + "' isn't a RCB account file line!"));
                            }
                        }
                    }
                }
                catch (Exception ee) {
                    if (this.logbook != null) {
                        this.logbook.warning("Ignore invalid RCB accounting line '" + line + "', cause: " + ee);
                    }
                    log.warn((Object)("Ignore invalid RCB accounting line '" + line + "', cause: " + ee));
                }
                pos = this.fp.getFilePointer();
            }
        }
        catch (Exception e) {
            if (this.logbook != null) {
                this.logbook.error("Cannot build hash from RCB accounting file " + this.currAccFilename + ", " + e);
            }
            log.error((Object)("Cannot build hash from RCB accounting file " + this.currAccFilename), (Throwable)e);
            log.debug((Object)"createHash end: false");
            return false;
        }
        log.debug((Object)"createHash end: true");
        return true;
    }

    private boolean openFile() {
        return this.openFile(true);
    }

    private boolean openFile(boolean buildHash) {
        block15: {
            block14: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"openFile start: ");
                }
                if (this.fp != null) {
                    log.warn((Object)"RCB account file is still open. Don't re-open it!");
                    return true;
                }
                try {
                    this.fp = new RandomAccessFile(this.currAccFilename, "rw");
                }
                catch (Exception openErr) {
                    log.error((Object)("Cannot open RCB accounting file '" + this.currAccFilename + "'"), (Throwable)openErr);
                    if (this.logbook == null) break block14;
                    this.logbook.error(String.format(FMT_ERR_OPEN, this.currAccFilename, openErr));
                }
            }
            try {
                if (this.fp == null) break block15;
                if (this.fp.length() == 0L) {
                    log.debug((Object)"RCB accounting file is new.");
                    if (this.writeHead()) break block15;
                    log.error((Object)"Cannot write header record into RCB accounting file!");
                    try {
                        this.fp.close();
                    }
                    catch (Exception ee) {
                        log.error((Object)"Cannot close RCB accounting file!", (Throwable)ee);
                    }
                    this.fp = null;
                    break block15;
                }
                log.debug((Object)"RCB accounting file is old.");
                if (!buildHash || this.createHash()) break block15;
                try {
                    this.fp.close();
                }
                catch (Exception ee) {
                    log.error((Object)"Cannot close RCB accounting file!", (Throwable)ee);
                }
                this.fp = null;
            }
            catch (Exception e) {
                log.error((Object)("Error while opening RCB accounting file " + this.currAccFilename), (Throwable)e);
                if (this.fp == null) break block15;
                try {
                    this.fp.close();
                    this.fp = null;
                }
                catch (Exception ee) {
                    log.error((Object)"Cannot close RCB accounting file.", (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("openFile end: file open: " + (this.fp != null)));
        }
        return this.fp != null;
    }

    private boolean resetFileIfRequested() {
        boolean result = false;
        log.debug((Object)"resetFileIfRequested: start");
        if (this.fp == null) {
            log.debug((Object)"resetFileIfRequested: end file not open");
            this.rcbAccOn = false;
            log.debug((Object)"Disable RCB accounting due to I/O error!");
            if (this.logbook != null) {
                this.logbook.error("Disable RCB accounting due to I/O error!");
            }
            return false;
        }
        try {
            try {
                this.fp.seek(2L);
            }
            catch (Exception seekErr) {
                if (this.logbook != null) {
                    this.logbook.error(String.format(FMT_ERR_SEEK, Character.valueOf('H'), this.currAccFilename, seekErr));
                }
                throw seekErr;
            }
            if (this.fp.read() == 89) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Execute resetting of RCB account file: " + this.currAccFilename));
                }
                this.close();
                rcbHash.clear();
                if (!new File(this.currAccFilename).delete()) {
                    if (this.logbook != null) {
                        this.logbook.error("Cannot remove outdated RCB accounting file: " + this.currAccFilename);
                    }
                    log.error((Object)("Cannot delete outdated RCB accounting file: " + this.currAccFilename));
                }
                if (this.openFile()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RCB account file: " + this.currAccFilename + " resetted!"));
                    }
                    result = true;
                }
            } else {
                log.debug((Object)"resetFileIfRequested: reset not required");
                result = true;
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot reset RCB accounting file: " + this.currAccFilename), (Throwable)e);
            result = false;
        }
        if (!result) {
            log.debug((Object)"Disable RCB accounting due to I/O error!");
            if (this.logbook != null) {
                this.logbook.error("Disable RCB accounting due to I/O error!");
            }
        }
        log.debug((Object)("resetFileIfRequested: end: " + result));
        return result;
    }

    private void writeToStorage(RcbRecord rec) throws IOException {
        try {
            this.fp.seek(rec.getPos());
        }
        catch (IOException seekErr) {
            if (this.logbook != null) {
                this.logbook.error(String.format(FMT_ERR_SEEK, Character.valueOf(rec.getType()), this.currAccFilename, seekErr));
            }
            log.error((Object)("Cannot seek in RCB account file " + this.currAccFilename), (Throwable)seekErr);
            throw seekErr;
        }
        try {
            String phyRec = String.format("%s%256.256s", rec.getData(), "");
            this.fp.write(phyRec.getBytes(), 0, 254);
            this.fp.write(eol);
            if (log.isTraceEnabled()) {
                log.trace((Object)("writeToStorage: pos: " + rec.getPos() + " write: " + phyRec + "'"));
            }
        }
        catch (IOException writeErr) {
            if (this.logbook != null) {
                this.logbook.error(String.format(FMT_ERR_WRIT, Character.valueOf(rec.getType()), this.currAccFilename, writeErr));
            }
            throw writeErr;
        }
    }

    private boolean writeHead() {
        boolean result = false;
        log.debug((Object)"writeHead: start");
        try {
            RcbHeadRec head = new RcbHeadRec();
            this.writeToStorage(head);
            rcbHash.put(head.getHashVal(), head);
            result = true;
        }
        catch (IOException e) {
            if (this.logbook != null) {
                this.logbook.error(String.format(FMT_ERR_WRIT, Character.valueOf('H'), this.currAccFilename, e));
            }
            log.error((Object)"Cannot write RCB accounting header record.", (Throwable)e);
            result = false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeHead: end: " + result));
        }
        return result;
    }

    private boolean updateHead(boolean jobIncr, boolean failIncr) {
        RcbHeadRec head = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateHead: start: jobIncr:" + jobIncr + ", failIncr: " + failIncr));
        }
        if (!jobIncr && !failIncr) {
            log.debug((Object)"No increments required! Abort nonsense OP.");
            return true;
        }
        try {
            head = (RcbHeadRec)rcbHash.get(RcbHeadRec.buildHashVal());
            if (head == null) {
                log.error((Object)"No header record found for RCB accounting file.");
                return false;
            }
            if (jobIncr) {
                head.incrJobs();
            }
            if (failIncr) {
                head.incrFailed();
            }
            this.writeToStorage(head);
        }
        catch (IOException e) {
            if (this.logbook != null) {
                this.logbook.error(String.format(FMT_ERR_WRIT, Character.valueOf(head.getType()), this.currAccFilename, e));
            }
            log.error((Object)"Cannot update RCB header record!", (Throwable)e);
        }
        if (!this.isActive()) {
            return true;
        }
        return true;
    }

    private boolean updateStatus(String sender, String receiver, boolean jobIncr, boolean failIncr) {
        RcbStatRec stat = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateStatus: start: sender: " + sender + ", receiver: " + receiver + ", jobIncr:" + jobIncr + ", failIncr: " + failIncr));
        }
        if (sender == null || receiver == null) {
            log.warn((Object)"writeStatus: Sender and receiver must be defined for RCB status record.");
            log.debug((Object)"updateStatus: end FAIL");
            return false;
        }
        if (!jobIncr && !failIncr) {
            log.warn((Object)"No increments required! Abort nonsense OP.");
            log.debug((Object)"updateStatus: end FAIL");
            return false;
        }
        try {
            stat = (RcbStatRec)rcbHash.get(RcbStatRec.buildHashVal(sender, receiver));
            if (stat == null) {
                stat = new RcbStatRec(sender, receiver);
                stat.setPos(this.fp.length());
                rcbHash.put(stat.getHashVal(), stat);
            }
            if (jobIncr) {
                stat.incrJobs();
                stat.setJobCreateTime(new Date());
            }
            if (failIncr) {
                stat.incrFailed();
            }
            this.writeToStorage(stat);
        }
        catch (IOException e) {
            log.error((Object)"Cannot update RCB header record!", (Throwable)e);
            log.debug((Object)"updateStatus: end FAIL");
            return false;
        }
        log.debug((Object)"updateStatus: end OK");
        return true;
    }

    private boolean updateErrClass(String sender, String receiver, String errClass, boolean okSignal, String jsName, long jobId, int rc, long time, String logfileName) {
        RcbErrRec err = null;
        boolean result = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateErrClass: start: sender: " + sender + ", receiver: " + receiver + ", errClass: " + errClass + ", okSignal:" + okSignal));
        }
        if (sender == null || receiver == null || errClass == null) {
            log.warn((Object)"Sender, receiver and error class must be defined for RCB error record.");
            log.debug((Object)("updateErrClass: end " + result));
            return result;
        }
        try {
            err = (RcbErrRec)rcbHash.get(RcbErrRec.buildHashVal(sender, receiver, errClass));
            if (err == null) {
                err = new RcbErrRec(sender, receiver, errClass);
                err.setPos(this.fp.length());
                rcbHash.put(err.getHashVal(), err);
            }
            err.setRc(rc);
            err.setJsName(jsName);
            err.setJobId(jobId);
            if (okSignal) {
                err.resetContErrCnt();
                err.setLastOkTime(time);
            } else {
                err.incrErrCnt();
                err.incrContErrCnt();
                err.setLastFailTime(time);
                err.setLastErrLog(logfileName);
            }
            this.writeToStorage(err);
            result = true;
        }
        catch (Exception e) {
            log.error((Object)"Cannot update RCB header record!", (Throwable)e);
            log.debug((Object)"updateErrClass: end FAIL");
            result = false;
        }
        log.debug((Object)("updateErrClass: end " + result));
        return result;
    }

    public synchronized void close() {
        log.debug((Object)"close: start");
        if (this.fp != null) {
            try {
                this.fp.close();
                log.debug((Object)"close: RCB accounting file closed.");
            }
            catch (IOException soWhat) {
                log.error((Object)("close:Cannot close RCB accounting file: " + this.currAccFilename), (Throwable)soWhat);
            }
            this.fp = null;
        }
        log.debug((Object)"close: end");
    }

    public synchronized boolean isActive() {
        return this.rcbAccOn;
    }

    public synchronized String getCurrAccFilename() {
        return this.currAccFilename;
    }

    public String toString() {
        return "RcbAccout:  rcbAccOn: " + this.rcbAccOn + ", rcbAccPath: " + this.rcbAccPath + ", currAccFilename: " + this.currAccFilename;
    }

    private static boolean isWindows() {
        String s = System.getProperty("os.name");
        if (s != null) {
            s = System.getenv("OS");
        }
        return s != null && s.toUpperCase().contains("WIN");
    }

    public synchronized boolean writeJobStart(CtrlJob job) {
        boolean result = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeJobStart start: job: " + job));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("writeJobStart start: job: " + job.getId()));
        }
        if (!this.isActive()) {
            log.debug((Object)"writeJobStart end: RcbAccount inactive");
            return true;
        }
        if (!this.resetFileIfRequested()) {
            log.debug((Object)"writeJobStart end: false");
            return false;
        }
        if (job == null) {
            log.error((Object)"writeJobStart: job is null");
            log.debug((Object)"writeJobStart end: false");
            return false;
        }
        result = this.updateHead(true, false);
        if (result) {
            CtrlEvent event = (CtrlEvent)job.getEvt();
            if (event != null) {
                String senderOrNull = event.getAttr("SENDER");
                String receiverOrNull = event.getAttr("RECEIVER");
                result = this.updateStatus(senderOrNull == null ? "" : senderOrNull, receiverOrNull == null ? "" : receiverOrNull, true, false);
            } else {
                log.error((Object)("writeJobSTart: Event of job " + job.getId() + " is null"));
                result = false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeJobStart end: " + result));
        }
        return result;
    }

    public synchronized boolean writeJobFailure(CtrlJob job) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeJobFailure start: job: " + job));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("writeJobFailure start: job: " + job.getId()));
        }
        if (!this.isActive()) {
            log.debug((Object)"writeJobFailure end: RcbAccount inactive");
            return true;
        }
        if (!this.resetFileIfRequested()) {
            log.debug((Object)"writeJobFailure end: false");
            return false;
        }
        if (job == null) {
            log.error((Object)"writeJobFailure: job is null");
            log.debug((Object)"writeJobFailure end: false");
            return false;
        }
        boolean result = this.updateHead(false, true);
        if (result) {
            CtrlEvent event = (CtrlEvent)job.getEvt();
            if (event != null) {
                String senderOrNull = event.getAttr("SENDER");
                String receiverOrNull = event.getAttr("RECEIVER");
                result = this.updateStatus(senderOrNull == null ? "" : senderOrNull, receiverOrNull == null ? "" : receiverOrNull, false, true);
            } else {
                log.error((Object)("writeJobFailure: Event of job " + job.getId() + " is null"));
                result = false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeJobFailure end: " + result));
        }
        return result;
    }

    public synchronized boolean writeJsSuccess(CtrlFunctionCall fc) {
        boolean result = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeJsSucess start: fc: " + fc.getInstanceName()));
        }
        result = this.writeJsResult(fc, true, null);
        log.debug((Object)("writeJsSuccess end: " + result));
        return result;
    }

    public synchronized boolean writeJsFailure(CtrlFunctionCall fc, String protfile) {
        boolean result = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeJsFailure start: fc: " + fc.getInstanceName()));
        }
        result = this.writeJsResult(fc, false, protfile);
        log.debug((Object)("writeJsFailure end: " + result));
        return result;
    }

    private synchronized boolean writeJsResult(CtrlFunctionCall fc, boolean successFlag, String protfile) {
        boolean result;
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeJsResult start: fc: " + (Object)((Object)fc)));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("writeJsResult start: fc: " + fc.getInstanceName()));
        }
        if (!this.isActive()) {
            log.debug((Object)"writeJsResult end: RcbAccount inactive");
            return true;
        }
        if (!this.resetFileIfRequested()) {
            log.debug((Object)"writejsSucess end: false");
            return false;
        }
        CtrlJob job = (CtrlJob)fc.getJob();
        CtrlEvent event = (CtrlEvent)job.getEvt();
        CtrlJobStep step = (CtrlJobStep)fc.getJobStep();
        if (fc != null && job != null && event != null) {
            String senderOrNull = event.getAttr("SENDER");
            String receiverOrNull = event.getAttr("RECEIVER");
            String errClassOrNull = step.getErrorClass();
            result = this.updateErrClass(senderOrNull == null ? "" : senderOrNull, receiverOrNull == null ? "" : receiverOrNull, errClassOrNull == null ? "" : errClassOrNull, successFlag, step.getName(), job.getId(), fc.getRc(), fc.getReadyDate(), protfile == null ? "" : protfile);
        } else {
            if (job == null) {
                log.error((Object)"writeJsResult job of function call is null");
            }
            if (event == null) {
                log.error((Object)"writeJsResult event of job is null");
            }
            if (event == null) {
                log.error((Object)"writeJsResult job step of function call is null");
            }
            result = false;
        }
        log.debug((Object)("writeJsResult end: " + result));
        return result;
    }
}

