/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.account;

import de.axway.aim.controller.master.account.RcbRecord;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RcbHeadRec
extends RcbRecord {
    private static final String VERSION = "$Header$";
    private static Log log = LogFactory.getLog((String)"master.account.RcbHeadRec");
    public static final char TYPE_HEAD = 'H';
    public static final char FLAG_RESET_ON = 'Y';
    public static final char FLAG_RESET_NO = 'N';
    private String createTime;
    private char resetFlag;
    private int noOfJobs;
    private int noOfFailedJobs;

    RcbHeadRec() {
        super('H');
        this.resetFlag = (char)78;
        this.noOfJobs = 0;
        this.noOfFailedJobs = 0;
        this.createTime = DATE_FORMAT.format(new Date());
    }

    RcbHeadRec(byte[] data) {
        this(String.valueOf(data));
    }

    RcbHeadRec(String data) {
        super('H');
        String[] token = data.split("\\|");
        if (log.isDebugEnabled()) {
            for (int i = 0; i < token.length; ++i) {
                log.debug((Object)("RCB header record token " + i + " = '" + token[i] + "'"));
            }
        }
        this.resetFlag = token[1].charAt(0);
        this.createTime = token[2];
        this.noOfJobs = Integer.parseInt(token[3]);
        this.noOfFailedJobs = Integer.parseInt(token[4]);
    }

    public static RcbHeadRec createFromString(String str) {
        if (str != null && str.length() > 0 && str.charAt(0) == 'H') {
            return new RcbHeadRec(str);
        }
        return null;
    }

    @Override
    public String getHashVal() {
        return "H|";
    }

    public static String buildHashVal() {
        return "H|";
    }

    @Override
    public String getData() {
        return "H|" + this.resetFlag + "|" + this.createTime + "|" + this.noOfJobs + "|" + this.noOfFailedJobs + "|";
    }

    public void incrJobs() {
        ++this.noOfJobs;
    }

    public void incrFailed() {
        ++this.noOfFailedJobs;
    }
}

