/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.account;

import de.axway.aim.controller.lib.JMasterUtil;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.account.IAccounting;
import de.axway.aim.controller.master.account.JobAccountSums;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.lib.util.ActisFile;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StdAccount
implements IAccounting {
    private static final String VERSION = "$Id: StdAccount.java 226041 2015-07-15 11:20:38Z mgwalter $";
    private static Log log = LogFactory.getLog((String)"master.account.StdAccount");
    private boolean accOn = false;
    private String accDir = null;
    private String currAccFilename = null;
    private Formatter accFormatter;
    long nextOpenDate = 0L;
    private static final char ACCOUNT_START = 'B';
    private static final char ACCOUNT_END = 'E';
    private static final String FFU = "-";
    private static final String STAT_UK = "--";
    private static final String STAT_OK = "OK";
    private static final String STAT_ERR = "ER";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private static final DateFormat ACCOUNT_BASENAME = new SimpleDateFormat("yyyyMMdd_DDD");
    private static final String ACCOUNT_LAYOUT = "%c|%s|%s|%s|%s|%s|%d|%s|%d|%d.%06d|%d|%d|%d|%d|%s|%s|%s|%s|%s|%s|%s|%s|%s";
    private static final String[] ACCOUNT_HEADER = new String[]{"# Version: %s from %s (Revision: %s)\n", "# 1:Typ(B,E,#)|2:Date-Time|3:Status|4:Sender|5:ObjClass|6:Receiver|7:JobID|8:Jobname|9:Dur|10:FCsec.usec|11:FCs#|12:Rtry#|13:ObjID|14:Comp#|15:SuSZ|16:SZ[+SZ]*|17:..22:ffu|[23:userdef#1...userdef#255|]\n"};
    private String[] cvsHeadToken = null;
    private static final int TOK_FIL = 1;
    private static final int TOK_VER = 2;
    private static final int TOK_DAT = 3;
    private static final int TOK_TIM = 4;
    private static final int TOK_USR = 5;
    private static final int TOK_STA = 6;

    public StdAccount(ILogbook logbook, boolean accOn, String accDir, String cvsHeader) {
        this.accOn = accOn;
        this.accDir = accDir;
        if (cvsHeader != null) {
            this.cvsHeadToken = cvsHeader.split(" ");
        }
        if (accOn && !this.checkAndOpenFormatter()) {
            logbook.error("cannot open file : <" + this.currAccFilename + ">");
            logbook.warning("Account turned off to avoid loss of performance.");
            this.accOn = false;
        }
    }

    private boolean openFile(Date now) {
        boolean success = false;
        boolean writeHeader = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("openFile start: " + now));
        }
        if (this.accFormatter != null) {
            try {
                this.accFormatter.close();
            }
            catch (Exception e) {
                log.error((Object)"Cannot close accounting output stream!", (Throwable)e);
            }
        }
        this.accFormatter = null;
        try {
            this.currAccFilename = this.accDir + "/" + ACCOUNT_BASENAME.format(now) + ".acc";
            this.currAccFilename = new ActisFile(this.currAccFilename).toString();
            if (!new File(this.currAccFilename).exists()) {
                writeHeader = true;
            }
            this.accFormatter = new Formatter(new FileOutputStream(new ActisFile(this.currAccFilename).toString(), true));
            if (writeHeader) {
                for (int i = 0; i < ACCOUNT_HEADER.length; ++i) {
                    if (this.cvsHeadToken != null && this.cvsHeadToken.length > 6) {
                        this.accFormatter.format(ACCOUNT_HEADER[i], this.cvsHeadToken[6], this.cvsHeadToken[3] + " " + this.cvsHeadToken[4], this.cvsHeadToken[2]);
                        continue;
                    }
                    this.accFormatter.format("%s\n", ACCOUNT_HEADER[i]);
                }
                this.accFormatter.flush();
            }
            success = true;
        }
        catch (Exception e) {
            log.error((Object)("Cannot open accounting file '" + this.currAccFilename + "'"), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("openFile end: " + success));
        }
        return success;
    }

    private boolean checkAndOpenFormatter() {
        Date now = new Date();
        if (log.isDebugEnabled()) {
            log.debug((Object)"checkAndOpenFormatter start: ");
        }
        if (now.getTime() >= this.nextOpenDate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"checkAndOpenFormatter end: DO open new Formatter");
            }
            if (this.openFile(now)) {
                Calendar nextOpen = GregorianCalendar.getInstance();
                nextOpen.setTime(now);
                nextOpen.set(11, 24);
                nextOpen.set(12, 0);
                nextOpen.set(13, 0);
                nextOpen.set(14, 0);
                this.nextOpenDate = nextOpen.getTimeInMillis();
                return true;
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"checkAndOpenFormatter end: DO NOT open new formatter");
        }
        return this.accFormatter != null;
    }

    private boolean printAccount(char recType, CtrlJob job, Connection con) {
        String status = STAT_UK;
        String[] accUserFields = null;
        StringBuilder userDefAccAttr = new StringBuilder();
        long now = new Date().getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("printAccount: " + recType + ", job:" + job.getName()));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("printAccount: job: " + job));
        }
        if (this.accFormatter == null) {
            return false;
        }
        try {
            JobAccountSums jas = job.getJobAccounting(con);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created: " + jas));
            }
            if (recType == 'E') {
                status = job.getStatus() == 4 ? STAT_OK : STAT_ERR;
            }
            accUserFields = ((CfgJSelectEntry)job.getJsl()).getAccUsrCol();
            if (log.isDebugEnabled()) {
                log.debug((Object)("accUserFields: " + accUserFields));
                if (accUserFields != null) {
                    log.debug((Object)("accUserFields.length: " + accUserFields.length));
                }
            }
            if (accUserFields != null && accUserFields.length > 0) {
                for (int i = 0; i < accUserFields.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("accUserField[" + i + "] = '" + accUserFields[i] + "'"));
                    }
                    if (accUserFields[i] != null && accUserFields[i].length() > 0) {
                        userDefAccAttr.append(job.evalPar(accUserFields[i], false, true));
                    }
                    userDefAccAttr.append('|');
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("userDefAccAttr: " + userDefAccAttr));
                }
            }
            this.accFormatter.format(ACCOUNT_LAYOUT, Character.valueOf(recType), DATE_FORMAT.format(new Date()), status, JMasterUtil.null2Empty((String)job.getEvt().getAttr("SENDER")), JMasterUtil.null2Empty((String)job.getEvt().getAttr("OBJ_CLASS")), JMasterUtil.null2Empty((String)job.getEvt().getAttr("RECEIVER")), job.getId(), job.getName(), (now - job.getCreationDate()) / 1000L, jas.getFcTime() / 1000L, jas.getFcTime() * 1000L, jas.getFcCount(), jas.getFailedFcCount(), job.getId(), jas.getNoOfComps(), jas.getTotalCompSize(), jas.getCompsSizesStr(), FFU, FFU, FFU, FFU, FFU, FFU, userDefAccAttr.toString());
            this.accFormatter.format("\n", new Object[0]);
            this.accFormatter.flush();
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Cannot print/format accounting entry.", (Throwable)e);
            return false;
        }
    }

    @Override
    public synchronized boolean writeBegin(CtrlJob job, Connection con) {
        if (!this.accOn) {
            return true;
        }
        try {
            if (this.checkAndOpenFormatter()) {
                return this.printAccount('B', job, con);
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Cannot write accounting record!", (Throwable)e);
            return false;
        }
    }

    @Override
    public synchronized boolean writeLogicalEnd(CtrlJob job, Connection con) {
        return true;
    }

    @Override
    public synchronized boolean writeEnd(CtrlJob job, Connection con) {
        if (!this.accOn) {
            return true;
        }
        try {
            if (this.checkAndOpenFormatter()) {
                return this.printAccount('E', job, con);
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)"Cannot write accounting record!", (Throwable)e);
            return false;
        }
    }

    @Override
    public synchronized void close() {
        if (this.accFormatter != null) {
            this.accFormatter.close();
            this.accFormatter = null;
        }
        this.currAccFilename = null;
        this.nextOpenDate = 0L;
    }

    @Override
    public boolean isActive() {
        return this.accOn;
    }

    @Override
    public String getCurrAccFilename() {
        return this.currAccFilename;
    }

    @Override
    public String toString() {
        return "StdAccout:  accOn: " + this.accOn + ", accDir: " + this.accDir + ", currAccFilename: " + this.currAccFilename + ", nextOpenDate: " + (this.nextOpenDate == 0L ? "" : new Date(this.nextOpenDate));
    }
}

