/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.builtin;

import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.master.CtrlBuiltin;
import de.axway.aim.controller.master.builtin.ActivateJob;
import de.axway.aim.controller.master.builtin.CtrlJob;
import de.axway.aim.controller.master.builtin.DeleteApplic;
import de.axway.aim.controller.master.builtin.HandleDbi;
import de.axway.aim.controller.master.builtin.IfJsRetryFull;
import de.axway.aim.controller.master.builtin.JobChangeSequ;
import de.axway.aim.controller.master.builtin.JobExit;
import de.axway.aim.controller.master.builtin.JobStepChangeSequ;
import de.axway.aim.controller.master.builtin.KillJob;
import de.axway.aim.controller.master.builtin.Location;
import de.axway.aim.controller.master.builtin.NewLogbook;
import de.axway.aim.controller.master.builtin.Reconfig;
import de.axway.aim.controller.master.builtin.RunJs;
import de.axway.aim.controller.master.builtin.Shutdown;
import de.axway.aim.controller.master.builtin.Status;
import de.axway.aim.controller.master.builtin.StopJob;
import de.axway.aim.controller.master.builtin.SuspendJob;
import de.axway.aim.controller.master.builtin.TermJs;
import de.axway.aim.controller.master.builtin.UnknownBuiltinException;
import de.axway.aim.controller.master.builtin.WorkflowResult;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Builtin {
    protected static Log log = LogFactory.getLog((String)"master.builtin.Builtin");
    private static Hashtable<String, Builtins> ident = new Hashtable();
    private String name = null;

    public static Builtin create(String cmd) throws UnknownBuiltinException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("new Builtin: " + cmd));
        }
        Attributes attr = new Attributes(cmd, Attributes.Type.POS);
        return Builtin.create((Attributes<String>)attr);
    }

    public static Builtin create(Attributes<String> attr) throws UnknownBuiltinException {
        String name = (String)attr.elementAt(0).get();
        if (log.isDebugEnabled()) {
            log.debug((Object)("create start: " + name + ", attr: " + attr));
        }
        Builtins builtin = null;
        if (name != null) {
            builtin = ident.get(name);
        }
        if (builtin == null) {
            throw new UnknownBuiltinException(name);
        }
        if (attr.remove(0) == null) {
            throw new UnknownBuiltinException("cannot remove arg");
        }
        Builtin b = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)(" create Builtin command: " + (Object)((Object)builtin)));
        }
        switch (builtin) {
            case STOP_EDIMAN: 
            case SHUTDOWN: {
                b = new Shutdown();
                break;
            }
            case RECONFIG: {
                b = new Reconfig();
                break;
            }
            case KILL_JOB: {
                b = new KillJob(attr, true);
                break;
            }
            case DELETE_JOB: {
                b = new KillJob(attr, false);
                break;
            }
            case DELETE_APPLIC: {
                b = new DeleteApplic(attr);
                break;
            }
            case CTRL_JOB: {
                b = new CtrlJob(attr);
                break;
            }
            case SUSPEND_JOB: {
                b = new SuspendJob(attr);
                break;
            }
            case ACTIVATE_JOB: {
                b = new ActivateJob(attr);
                break;
            }
            case SET_JS_RDY_TO_RUN: {
                b = new RunJs(attr);
                break;
            }
            case SET_JS_TERMINATE: {
                b = new TermJs(attr);
                break;
            }
            case JOB_EXIT: {
                b = new JobExit(attr);
                break;
            }
            case STOP_JOB: {
                b = new StopJob(attr);
                break;
            }
            case NEW_LOGBOOK: {
                b = new NewLogbook();
                break;
            }
            case STATUS: {
                b = new Status();
                break;
            }
            case LOCATION_EDIMAN: {
                b = new Location(attr);
                break;
            }
            case WORKFLOW_RESULT: {
                b = new WorkflowResult(attr);
                break;
            }
            case JOB_CHANGE_SEQU: {
                b = new JobChangeSequ(attr);
                break;
            }
            case JS_CHANGE_SEQU: {
                b = new JobStepChangeSequ(attr);
                break;
            }
            case IF_JS_RETRY_FULL: {
                b = new IfJsRetryFull(attr);
                break;
            }
            case HANDLE_DBI: {
                b = new HandleDbi(attr);
                break;
            }
            default: {
                log.error((Object)("Unknown builtin: " + name));
                throw new UnknownBuiltinException(name + " not implemented");
            }
        }
        b.setName(name);
        if (log.isDebugEnabled()) {
            if (attr.size() != 0) {
                log.debug((Object)("rest: " + attr.get(0)));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("end: " + b));
            }
        }
        return b;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "Builtin: " + this.getName();
    }

    public boolean isHidden() {
        return false;
    }

    public abstract String getRealFc();

    public abstract boolean exec(CtrlBuiltin var1) throws Exception;

    static {
        ident.put("CTRL_JOB", Builtins.CTRL_JOB);
        ident.put("KILL_JOB", Builtins.KILL_JOB);
        ident.put("DELETE_JOB", Builtins.DELETE_JOB);
        ident.put("DELETE_APPLIC", Builtins.DELETE_APPLIC);
        ident.put("SUSPEND_JOB", Builtins.SUSPEND_JOB);
        ident.put("ACTIVATE_JOB", Builtins.ACTIVATE_JOB);
        ident.put("JS_READY_TO_RUN", Builtins.SET_JS_RDY_TO_RUN);
        ident.put("JS_TERMINATE", Builtins.SET_JS_TERMINATE);
        ident.put("JOB_EXIT", Builtins.JOB_EXIT);
        ident.put("STOP_JOB", Builtins.STOP_JOB);
        ident.put("NEW_LOGBOOK", Builtins.NEW_LOGBOOK);
        ident.put("STATUS", Builtins.STATUS);
        ident.put("SHUTDOWN", Builtins.SHUTDOWN);
        ident.put("RECONFIG_EDIMAN", Builtins.RECONFIG);
        ident.put("STOP_EDIMAN", Builtins.STOP_EDIMAN);
        ident.put("WORKFLOW_RESULT", Builtins.WORKFLOW_RESULT);
        ident.put("JOB_CHANGE_SEQU", Builtins.JOB_CHANGE_SEQU);
        ident.put("JS_CHANGE_SEQU", Builtins.JS_CHANGE_SEQU);
        ident.put("LOCATION_EDIMAN", Builtins.LOCATION_EDIMAN);
        ident.put("IF_JS_RETRY_FULL", Builtins.IF_JS_RETRY_FULL);
        ident.put("HANDLE_DBI", Builtins.HANDLE_DBI);
    }

    private static enum Builtins {
        SHUTDOWN,
        RECONFIG,
        RESTART_EDIMAN,
        STOP_EDIMAN,
        START_SLAVE,
        STOP_SLAVE,
        SUSPEND_JOB,
        ACTIVATE_JOB,
        JOB_CHANGE_SEQU,
        JS_CHANGE_SEQU,
        SET_JS_RDY_TO_RUN,
        SET_JS_TERMINATE,
        KILL_JOB,
        KILL_EVENT,
        DELETE_JOB,
        DELETE_EVENT,
        DELETE_OBJECT,
        DELETE_APPLIC,
        NEW_LOGBOOK,
        IF_EXIST,
        IF_ULOCK_MSGFILE,
        DBI_TO_ASCII,
        STATUS_EDIMAN,
        CTRL_JOB,
        IF_JS_RETRY_FULL,
        JOB_EXIT,
        HANDLE_DBI,
        LOCATION_EDIMAN,
        MALLOC_INFO,
        CALL_SYSTEM,
        PROCESS_INFO,
        CHECK_FHANDLER,
        CREATE_JOB,
        KILL_PROCESS,
        CHECK_FCALL,
        RM_FILE,
        TIME_TEST,
        STOP_JOB,
        WORKFLOW_RESULT,
        EDIMAN_TRACE,
        SET_EVTSTORMWALL,
        CLR_EVTSTORMWALL,
        JOB_CHANGE_PRIO,
        STATUS,
        UNKNOWN;

    }
}

