/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.builtin;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.master.CtrlBuiltin;
import de.axway.aim.controller.master.builtin.Addition;
import de.axway.aim.controller.master.builtin.Assign;
import de.axway.aim.controller.master.builtin.Div;
import de.axway.aim.controller.master.builtin.IfEq;
import de.axway.aim.controller.master.builtin.IfGe;
import de.axway.aim.controller.master.builtin.IfGt;
import de.axway.aim.controller.master.builtin.IfLe;
import de.axway.aim.controller.master.builtin.IfLt;
import de.axway.aim.controller.master.builtin.IfNe;
import de.axway.aim.controller.master.builtin.Modulo;
import de.axway.aim.controller.master.builtin.Mul;
import de.axway.aim.controller.master.builtin.RedirectException;
import de.axway.aim.controller.master.builtin.Sub;
import de.axway.aim.controller.master.builtin.UnknownBuiltinException;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class CtrlJobBuiltin {
    protected static final Log LOG = LogFactory.getLog((String)"master.builtin.CtrlJobBuiltin");
    private static Hashtable<String, Builtins> ident = new Hashtable();

    CtrlJobBuiltin() {
    }

    protected static CtrlJobBuiltin create(Attributes<String> attr) throws UnknownBuiltinException, RedirectException {
        Attribute a = attr.elementAt(0);
        String name = a.getName();
        Builtins builtin = null;
        if (name != null) {
            builtin = ident.get(name);
        }
        if (builtin == null) {
            if (name.contains(">")) {
                throw new RedirectException(name);
            }
            throw new UnknownBuiltinException(name);
        }
        switch (builtin) {
            case ADDITION: {
                return new Addition(attr);
            }
            case SUBTRACTION: {
                return new Sub(attr);
            }
            case MULTIPLICATION: {
                return new Mul(attr);
            }
            case DIVISION: {
                return new Div(attr);
            }
            case MODULO: {
                return new Modulo(attr);
            }
            case BIC_ASSIGN: {
                attr.remove(0);
                return new Assign((String)a.get());
            }
            case IF_EQ: {
                return new IfEq(attr);
            }
            case IF_NE: {
                return new IfNe(attr);
            }
            case IF_LT: {
                return new IfLt(attr);
            }
            case IF_LE: {
                return new IfLe(attr);
            }
            case IF_GT: {
                return new IfGt(attr);
            }
            case IF_GE: {
                return new IfGe(attr);
            }
        }
        throw new UnknownBuiltinException(name + " not implemented CtrlJobBuiltin");
    }

    public abstract String getRealFc();

    public abstract boolean exec(long var1, CtrlBuiltin var3) throws Exception;

    static {
        ident.put("ASSIGN", Builtins.BIC_ASSIGN);
        ident.put("ADD", Builtins.ADDITION);
        ident.put("SUB", Builtins.SUBTRACTION);
        ident.put("MUL", Builtins.MULTIPLICATION);
        ident.put("DIV", Builtins.DIVISION);
        ident.put("MOD", Builtins.MODULO);
        ident.put("IF_EQ", Builtins.IF_EQ);
        ident.put("IF_NE", Builtins.IF_NE);
        ident.put("IF_LT", Builtins.IF_LT);
        ident.put("IF_LE", Builtins.IF_LE);
        ident.put("IF_GT", Builtins.IF_GT);
        ident.put("IF_GE", Builtins.IF_GE);
    }

    private static enum Builtins {
        BIC_ASSIGN,
        ADDITION,
        SUBTRACTION,
        MULTIPLICATION,
        DIVISION,
        MODULO,
        IF_EQ,
        IF_NE,
        IF_LT,
        IF_LE,
        IF_GT,
        IF_GE;

    }
}

