/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.builtin;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.master.CtrlBuiltin;
import de.axway.aim.controller.master.builtin.CtrlJobBuiltin;
import de.axway.aim.controller.master.builtin.UnknownBuiltinException;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.lockDaemon.LockException;
import java.sql.SQLException;

abstract class NumOp
extends CtrlJobBuiltin {
    String dest;
    String val;
    String opName;

    protected NumOp(Attributes<String> attr) throws UnknownBuiltinException {
        Attribute a = attr.elementAt(0);
        this.opName = a.getName();
        String[] par = ((String)a.get()).split(" *, *");
        if (par.length != 2) {
            throw new UnknownBuiltinException(a.getName() + '=' + (String)a.get());
        }
        this.dest = par[0];
        this.val = par[1];
        attr.remove(0);
    }

    protected abstract long numOp(long var1, long var3);

    @Override
    public boolean exec(long jobid, CtrlBuiltin handler) throws InterruptedException, LockException, CfgException, SQLException {
        long lval;
        long ldest = 0L;
        try {
            String evalDest = handler.evalPar(jobid, "$(" + this.dest + ')');
            if (evalDest != null && evalDest.length() > 0 && !evalDest.trim().startsWith("$")) {
                ldest = Long.parseLong(evalDest);
            }
            lval = this.val == null || this.val.length() == 0 ? 0L : Long.parseLong(this.val);
        }
        catch (NumberFormatException e) {
            throw new CfgException(e.getMessage());
        }
        long ret = this.numOp(ldest, lval);
        return handler.assign(jobid, this.dest, "" + ret);
    }

    @Override
    public String getRealFc() {
        return '(' + this.opName + '=' + this.dest + ',' + this.val + ')';
    }
}

