/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.builtin;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.Attributes;
import de.axway.aim.controller.master.CtrlBuiltin;
import de.axway.aim.controller.master.builtin.Builtin;
import de.axway.aim.controller.master.cfg.CfgException;
import java.util.Iterator;

class WorkflowResult
extends Builtin {
    private String ids = null;
    public boolean close = false;
    public int answer = -1;
    public Attributes<String> attr = new Attributes(Attributes.Type.POS);

    protected WorkflowResult(Attributes<String> attr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("start: " + attr));
        }
        if (attr.size() > 0) {
            this.ids = (String)attr.elementAt(0).get();
            attr.remove(0);
        }
        boolean end = false;
        while (!end && attr.size() > 0) {
            Attribute next = attr.elementAt(0);
            String uName = next.getName().toUpperCase();
            if (uName.equals("FILE") || uName.equals("TEXT")) {
                this.attr.put(next);
                attr.remove(0);
                continue;
            }
            if (uName.equals("ANSWER")) {
                this.answer = Integer.parseInt((String)next.get());
                attr.remove(0);
                continue;
            }
            if (uName.equals("CLOSE")) {
                this.close = ((String)next.get()).toUpperCase().equals("Y");
                attr.remove(0);
                continue;
            }
            end = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"end:");
        }
    }

    @Override
    public boolean exec(CtrlBuiltin handler) throws InterruptedException, CfgException {
        return handler.workflowResult(this.ids, this.close, this.answer == -1 ? 0 : this.answer, this.attr);
    }

    @Override
    public String getRealFc() {
        StringBuilder ret = new StringBuilder("(WORKFLOW_RESULT=");
        ret.append(this.ids);
        ret.append(") (close=" + (this.close ? "y)" : "n)"));
        if (this.answer != -1) {
            ret.append(" (answer=" + this.answer + ")");
        }
        Iterator it = this.attr.get().iterator();
        while (it.hasNext()) {
            ret.append(" (");
            Attribute attr = (Attribute)it.next();
            ret.append(attr.getName());
            ret.append('=');
            ret.append((String)attr.get());
            ret.append(')');
        }
        return ret.toString();
    }
}

