/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.CfgRcEntry;
import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.CtrlSlave;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.TreeSlave;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgFctnRcReaction;
import de.axway.aim.controller.master.cfg.CfgFctnSequence;
import de.axway.aim.controller.master.cfg.CfgRc;
import de.axway.aim.controller.master.cfg.CfgSlaveEntry;
import de.axway.aim.controller.master.log.Logbook;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CfgFctnEntry {
    public static List<SlaveHandler> bics = new ArrayList<SlaveHandler>();
    private List<CfgFctnSequence> seq = new ArrayList<CfgFctnSequence>();
    private TreeSlave slaves;
    private CfgRc cfgRc;
    private String name;

    public List<CfgFctnSequence> getSeq() {
        return this.seq;
    }

    public CfgFctnEntry(ClusterStream ois, CfgRc cfgRc, TreeSlave slaves) throws IOException {
        this.cfgRc = cfgRc;
        this.slaves = slaves;
        int count = ois.readInt();
        for (int x = 0; x < count; ++x) {
            this.seq.add(new CfgFctnSequence(ois, cfgRc, slaves));
        }
        this.name = ois.readUTF();
    }

    public void write(ClusterStream oos) throws IOException {
        oos.writeInt(this.seq.size());
        Iterator<CfgFctnSequence> it = this.seq.iterator();
        while (it.hasNext()) {
            it.next().write(oos);
        }
        oos.writeUTF(this.name);
    }

    public CfgFctnEntry(String name, TreeSlave slaves, CfgRc cfgRc) {
        this.name = name;
        this.slaves = slaves;
        this.cfgRc = cfgRc;
    }

    public String getName() {
        return this.name;
    }

    public int getPrio(int seqNo) {
        if (this.seq.size() < seqNo) {
            return 0;
        }
        return this.seq.get(seqNo - 1).getPrio();
    }

    public int getLevel(int seqNo, int rc) {
        if (this.seq.size() < seqNo) {
            return 0;
        }
        return this.seq.get(seqNo - 1).getLevel(rc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBics() {
        List<SlaveHandler> list = bics;
        synchronized (list) {
            bics.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBic(SlaveHandler bic) {
        List<SlaveHandler> list = bics;
        synchronized (list) {
            bics.add(bic);
        }
    }

    public boolean isBomSlave(int seq) {
        if (this.seq.size() < seq) {
            return false;
        }
        return this.seq.get(seq - 1).isBomSlave();
    }

    public List<SlaveHandler> getSlaves(int seq, String hostname) {
        if (this.seq.size() < seq) {
            return null;
        }
        if (this.isBomSlave(seq)) {
            InetAddress[] addr;
            ArrayList<SlaveHandler> sl = new ArrayList<SlaveHandler>();
            try {
                addr = InetAddress.getAllByName(hostname);
            }
            catch (UnknownHostException e) {
                Logbook.getLogbook().warning("unknown host <" + hostname + "> for BOMSLAVE");
                return sl;
            }
            for (SlaveHandler slaveHandler : this.slaves) {
                CtrlSlave slave = slaveHandler.getSlave();
                for (int x = 0; x < addr.length; ++x) {
                    if (slave.getType() != CtrlSlave.Type.BOMSLAVE || !slave.containsIp(addr[x])) continue;
                    sl.add(slaveHandler);
                    return sl;
                }
            }
            return sl;
        }
        return this.seq.get(seq - 1).getSlaves();
    }

    public List<CfgSlaveEntry> getSlaveEntryList(int seq) {
        if (this.seq.size() < seq) {
            return null;
        }
        return this.seq.get(seq - 1).getSlaveEntryList();
    }

    public boolean isGrouped(int seq) {
        if (this.seq.size() < seq) {
            return false;
        }
        return this.seq.get(seq - 1).isGrouped();
    }

    public boolean groupNameMustEval(int seq) {
        if (this.seq.size() < seq) {
            return false;
        }
        return this.seq.get(seq - 1).groupNameMustEval();
    }

    public String getGroupName(int seq) {
        if (this.seq.size() < seq) {
            return null;
        }
        return this.seq.get(seq - 1).getGroupName();
    }

    public int getMaxCalls(int seq) {
        if (this.seq.size() < seq) {
            return 0;
        }
        return this.seq.get(seq - 1).getMaxCalls();
    }

    public CtrlFunctionCall createFc(IJobStep parent, int seqNo, int seqRetry, int level) throws CfgException, SQLException {
        if (this.seq.size() < seqNo) {
            throw new CfgException("invalid sequence: " + seqNo);
        }
        return this.seq.get(seqNo - 1).createFc(parent, seqNo, seqRetry, level);
    }

    public void newSeq(CfgFctnSequence seq) {
        this.seq.add(seq);
    }

    public CfgFctnSequence getSeq(int seq) {
        if (this.seq.size() < seq) {
            return null;
        }
        return this.seq.get(seq - 1);
    }

    public int getMaxSeqRetry(int seqNr) {
        if (this.seq.size() < seqNr) {
            return 0;
        }
        return this.seq.get(seqNr - 1).getMaxRetry();
    }

    public int getSeqCount() {
        return this.seq.size();
    }

    public String getRcName(int seqNr, int retValue, int level) {
        if (this.seq.size() < seqNr) {
            return null;
        }
        CfgFctnSequence aseq = this.seq.get(seqNr - 1);
        return aseq.getRcName(retValue, level);
    }

    public CfgRcEntry getCfgRcEntry(int seqNr, int retValue, int level) {
        if (this.seq.size() < seqNr) {
            return null;
        }
        CfgFctnSequence aseq = this.seq.get(seqNr - 1);
        return aseq.getCfgRcEntry(retValue, level);
    }

    public CfgFctnRcReaction getRcReaction(int seqNr, int rc, int level) {
        if (this.seq.size() < seqNr) {
            CfgRcEntry rcEntry = this.cfgRc.getEntry(rc);
            if (rcEntry == null) {
                if (rc == 0) {
                    return CfgFctnRcReaction.RcReturn;
                }
                return CfgFctnRcReaction.RcRetry;
            }
            if (rcEntry.getName().equals("OK")) {
                return CfgFctnRcReaction.RcReturn;
            }
            return CfgFctnRcReaction.RcRetry;
        }
        CfgFctnSequence aseq = this.seq.get(seqNr - 1);
        return aseq.getRcReaction(rc, level);
    }

    public String getCmdLine(int seqNr) {
        if (this.seq.size() < seqNr) {
            return null;
        }
        return this.seq.get(seqNr - 1).getCmdLine();
    }
}

