/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.CfgRcEntry;
import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgRc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class CfgFctnRcReaction {
    public static final String S_RETURN = "RETURN";
    public static final String S_RETRY = "RETRY";
    public static final String S_FAIL = "FAIL";
    public static final String S_SKIP = "SKIP";
    public static final String S_STOP_JOB = "STOP_JOB";
    public static final String S_SUSPEND_JOB = "SUSPEND_JOB";
    private static Map<String, Action> id = new Hashtable<String, Action>();
    private String sException = null;
    private Action action = Action.UNKNOWN;
    private boolean isBuiltin = false;
    private List<CfgRcEntry> rclist = new ArrayList<CfgRcEntry>();
    private Hashtable<CfgRcEntry, CfgFctnRcReaction> reaction = new Hashtable();
    public static final CfgFctnRcReaction RcReturn;
    public static final CfgFctnRcReaction RcRetry;
    public static final CfgFctnRcReaction RcFail;
    public static final CfgFctnRcReaction RcSkip;
    public static final CfgFctnRcReaction RcStopJob;
    public static final CfgFctnRcReaction RcSuspendJob;

    public CfgFctnRcReaction(ClusterStream ois, CfgRc cfgRc) throws IOException {
        this.sException = ois.readString();
        this.isBuiltin = ois.readBoolean();
        byte a = ois.readByte();
        switch (a) {
            case 0: {
                this.action = Action.RETURN;
                break;
            }
            case 1: {
                this.action = Action.RETRY;
                break;
            }
            case 2: {
                this.action = Action.FAIL;
                break;
            }
            case 3: {
                this.action = Action.SKIP;
                break;
            }
            case 4: {
                this.action = Action.STOP_JOB;
                break;
            }
            case 5: {
                this.action = Action.SUSPEND_JOB;
                break;
            }
            case 6: {
                this.action = Action.EXCEPTION;
                break;
            }
            case 7: {
                this.action = Action.UNKNOWN;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown action code: " + a);
            }
        }
        CfgFctnRcReaction.readRcList(ois, this.rclist, this.reaction, cfgRc);
    }

    public void write(ClusterStream oos) throws IOException {
        oos.writeString(this.sException);
        oos.writeBoolean(this.isBuiltin);
        switch (this.action) {
            case RETURN: {
                oos.writeByte(0);
                break;
            }
            case RETRY: {
                oos.writeByte(1);
                break;
            }
            case FAIL: {
                oos.writeByte(2);
                break;
            }
            case SKIP: {
                oos.writeByte(3);
                break;
            }
            case STOP_JOB: {
                oos.writeByte(4);
                break;
            }
            case SUSPEND_JOB: {
                oos.writeByte(5);
                break;
            }
            case EXCEPTION: {
                oos.writeByte(6);
                break;
            }
            case UNKNOWN: {
                oos.writeByte(7);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown action: " + (Object)((Object)this.action));
            }
        }
        CfgFctnRcReaction.writeRcList(oos, this.rclist, this.reaction);
    }

    public static void readRcList(ClusterStream ois, List<CfgRcEntry> rclist, Hashtable<CfgRcEntry, CfgFctnRcReaction> reaction, CfgRc cfgRc) throws IOException {
        int count = ois.readInt();
        for (int x = 0; x < count; ++x) {
            String name = ois.readUTF();
            CfgRcEntry rce = cfgRc.getValue(name);
            if (rce == null) {
                throw new IllegalArgumentException("rc entry " + name + " not found");
            }
            rclist.add(rce);
            reaction.put(rce, new CfgFctnRcReaction(ois, cfgRc));
        }
    }

    public static void writeRcList(ClusterStream oos, List<CfgRcEntry> rclist, Hashtable<CfgRcEntry, CfgFctnRcReaction> reaction) throws IOException {
        oos.writeInt(rclist.size());
        for (CfgRcEntry rce : rclist) {
            oos.writeUTF(rce.getName());
            reaction.get(rce).write(oos);
        }
    }

    private CfgFctnRcReaction(Action action) {
        this.action = action;
    }

    public CfgFctnRcReaction(String sAction) throws CfgException {
        this(id.get(sAction));
        if (this.action == null) {
            this.sException = sAction;
            this.action = Action.EXCEPTION;
            if (sAction.toUpperCase().startsWith("BUILT_IN=")) {
                this.isBuiltin = true;
            }
        }
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }

    public String getException() {
        if (this.action != Action.EXCEPTION) {
            return null;
        }
        return this.sException;
    }

    public void addReaction(CfgRcEntry cfgRc, String action) throws CfgException {
        CfgFctnRcReaction old = this.reaction.put(cfgRc, new CfgFctnRcReaction(action));
        if (old != null) {
            this.reaction.put(cfgRc, old);
            throw new CfgException(cfgRc.getName() + " already in list, ignored");
        }
        this.rclist.add(cfgRc);
    }

    public List<CfgRcEntry> getRcList() {
        return this.rclist;
    }

    public Hashtable<CfgRcEntry, CfgFctnRcReaction> getRcClass() {
        return this.reaction;
    }

    public Action getAction() {
        return this.action;
    }

    public String toString() {
        return this.getAction().toString();
    }

    static {
        id.put(S_RETURN, Action.RETURN);
        id.put(S_RETRY, Action.RETRY);
        id.put(S_FAIL, Action.FAIL);
        id.put(S_SKIP, Action.SKIP);
        id.put(S_STOP_JOB, Action.STOP_JOB);
        id.put(S_SUSPEND_JOB, Action.SUSPEND_JOB);
        RcReturn = new CfgFctnRcReaction(Action.RETURN);
        RcRetry = new CfgFctnRcReaction(Action.RETRY);
        RcFail = new CfgFctnRcReaction(Action.FAIL);
        RcSkip = new CfgFctnRcReaction(Action.SKIP);
        RcStopJob = new CfgFctnRcReaction(Action.STOP_JOB);
        RcSuspendJob = new CfgFctnRcReaction(Action.SUSPEND_JOB);
    }

    public static enum Action {
        RETURN,
        RETRY,
        FAIL,
        SKIP,
        STOP_JOB,
        SUSPEND_JOB,
        EXCEPTION,
        UNKNOWN;

    }
}

