/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.CfgRcEntry;
import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.CtrlFunctionCall;
import de.axway.aim.controller.master.IJobStep;
import de.axway.aim.controller.master.SlaveHandler;
import de.axway.aim.controller.master.TreeSlave;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgFctnEntry;
import de.axway.aim.controller.master.cfg.CfgFctnRcReaction;
import de.axway.aim.controller.master.cfg.CfgRc;
import de.axway.aim.controller.master.cfg.CfgSlaveEntry;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CfgFctnSequence {
    private static Log log = LogFactory.getLog((String)"master.cfg.CfgFctnSequence");
    private List<SlaveHandler> slaves = new ArrayList<SlaveHandler>(1);
    private String name;
    private String cmd = null;
    private String groupName = null;
    private boolean groupNameMustEval = false;
    private int maxCalls = 1;
    private int maxRetry = 1;
    private boolean bomSlave = false;
    private boolean isBuiltin = false;
    private int prio = 0;
    private List<CfgRcEntry> rclist = new ArrayList<CfgRcEntry>();
    private Hashtable<CfgRcEntry, CfgFctnRcReaction> rcclass = new Hashtable(0);
    private CfgRc cfgRc;
    private List<CfgSlaveEntry> slaveEntryList = new ArrayList<CfgSlaveEntry>(1);

    public Hashtable<CfgRcEntry, CfgFctnRcReaction> getRcclass() {
        return this.rcclass;
    }

    public CfgFctnSequence(ClusterStream ois, CfgRc cfgRc, TreeSlave slaves) throws IOException {
        this.cfgRc = cfgRc;
        int count = ois.readInt();
        for (int x = 0; x < count; ++x) {
            String name = ois.readUTF();
            SlaveHandler s = slaves.get(name);
            if (s == null) {
                throw new IllegalArgumentException("slave " + name + " not found");
            }
            this.slaves.add(s);
        }
        this.name = ois.readUTF();
        this.cmd = ois.readUTF();
        this.groupName = ois.readString();
        this.groupNameMustEval = this.groupName.contains("$(");
        this.maxCalls = ois.readInt();
        this.maxRetry = ois.readInt();
        this.bomSlave = ois.readBoolean();
        this.isBuiltin = ois.readBoolean();
        this.prio = ois.readInt();
        CfgFctnRcReaction.readRcList(ois, this.rclist, this.rcclass, cfgRc);
    }

    public void write(ClusterStream oos) throws IOException {
        oos.writeInt(this.slaves.size());
        Iterator<SlaveHandler> it = this.slaves.iterator();
        while (it.hasNext()) {
            oos.writeUTF(it.next().getSlave().getName());
        }
        oos.writeUTF(this.name);
        oos.writeUTF(this.cmd);
        oos.writeString(this.groupName);
        oos.writeInt(this.maxCalls);
        oos.writeInt(this.maxRetry);
        oos.writeBoolean(this.bomSlave);
        oos.writeBoolean(this.isBuiltin);
        oos.writeInt(this.prio);
        CfgFctnRcReaction.writeRcList(oos, this.rclist, this.rcclass);
    }

    public CfgFctnSequence(String name, CfgRc cfgRc) {
        this.name = name;
        this.cfgRc = cfgRc;
    }

    public CtrlFunctionCall createFc(IJobStep jobStep, int seqNo, int seqRetry, int level) throws CfgException, SQLException {
        switch (level) {
            case 0: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("cmd(" + jobStep.getJobId() + "." + jobStep.getStepNo() + "): " + this.cmd));
                }
                return new CtrlFunctionCall(jobStep.evalPar(this.cmd, true, this.isBuiltin), jobStep, seqNo, seqRetry, level);
            }
        }
        CfgFctnRcReaction rcr = jobStep.getLastRc();
        String cmd = rcr.getException();
        if (cmd == null) {
            throw new CfgException("no exception");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("cmd(" + jobStep.getJobId() + "." + jobStep.getStepNo() + "): " + cmd));
        }
        return new CtrlFunctionCall(jobStep.evalPar(cmd, true, this.isBuiltin), jobStep, seqNo, seqRetry, level);
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }

    public String getCmdLine() {
        if (this.cmd == null) {
            return "";
        }
        return this.cmd;
    }

    public void addSlave(SlaveHandler sh) {
        this.slaves.add(sh);
    }

    public void setBomSlave() {
        this.bomSlave = true;
    }

    public boolean isBomSlave() {
        return this.bomSlave;
    }

    public void addSlaveEntry(CfgSlaveEntry slaveEntry) {
        this.slaveEntryList.add(slaveEntry);
    }

    public List<SlaveHandler> getSlaves() {
        if (this.isBuiltin()) {
            return CfgFctnEntry.bics;
        }
        return this.slaves;
    }

    public List<CfgSlaveEntry> getSlaveEntryList() {
        return this.slaveEntryList;
    }

    public void setCmd(String cmd) throws CfgException {
        this.cmd = cmd;
        if (cmd.toUpperCase().startsWith("BUILT_IN=")) {
            this.isBuiltin = true;
        }
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
        this.groupNameMustEval = groupName.contains("$(");
    }

    public void setMaxCalls(int maxCalls) {
        this.maxCalls = maxCalls;
    }

    public boolean groupNameMustEval() {
        return this.groupNameMustEval;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getMaxCalls() {
        return this.maxCalls;
    }

    public int getLevel(int rc) {
        int x = 1;
        for (CfgRcEntry rcEntry : this.rclist) {
            if (rcEntry.match(rc)) {
                return x;
            }
            ++x;
        }
        return -1;
    }

    public void addRcClass(CfgRcEntry cfgRc, CfgFctnRcReaction r) throws CfgException {
        if (r == null) {
            throw new CfgException("no RcReaction defined");
        }
        CfgFctnRcReaction old = this.rcclass.put(cfgRc, r);
        if (old != null) {
            this.rcclass.put(cfgRc, old);
            throw new CfgException(cfgRc.getName() + " already in list, ignored");
        }
        this.rclist.add(cfgRc);
    }

    private static CfgRcEntry getRcReaction(List<CfgRcEntry> cfgRcList, int rc) {
        for (CfgRcEntry rcEntry : cfgRcList) {
            if (!rcEntry.match(rc)) continue;
            return rcEntry;
        }
        return null;
    }

    public CfgFctnRcReaction getRcReaction(int rc, int level) {
        CfgFctnRcReaction rcr;
        if (log.isTraceEnabled()) {
            log.trace((Object)("getRcReaction rc=" + rc + ", level=" + level));
        }
        CfgRcEntry entry = null;
        List<CfgRcEntry> cfgRcList = this.rclist;
        Hashtable<CfgRcEntry, CfgFctnRcReaction> rcClass = this.rcclass;
        if (level > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"exception, other rcList");
            }
            if (this.rclist.size() < level) {
                return null;
            }
            rcr = this.rcclass.get(this.rclist.get(level - 1));
            cfgRcList = rcr.getRcList();
            rcClass = rcr.getRcClass();
        }
        if ((entry = CfgFctnSequence.getRcReaction(cfgRcList, rc)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("no entry for " + rc + ", using default"));
            }
            if (level != 0) {
                return CfgFctnRcReaction.RcRetry;
            }
            CfgRcEntry rcEntry = this.cfgRc.getEntry(rc);
            if (rcEntry == null) {
                return null;
            }
            String name = rcEntry.getName();
            if (name.equals("OK")) {
                return CfgFctnRcReaction.RcReturn;
            }
            return CfgFctnRcReaction.RcRetry;
        }
        if (log.isTraceEnabled()) {
            rcr = this.rcclass.get(entry);
            if (rcr == null) {
                log.trace((Object)"rc: null");
            } else {
                log.trace((Object)("rc: " + rcr.toString()));
            }
        }
        return (CfgFctnRcReaction)rcClass.get(entry);
    }

    public String getRcName(int rc, int level) {
        CfgRcEntry entry = this.getCfgRcEntry(rc, level);
        if (entry == null) {
            return "undefined";
        }
        return entry.getName();
    }

    public CfgRcEntry getCfgRcEntry(int rc, int level) {
        CfgRcEntry entry = null;
        Iterator<CfgRcEntry> it = this.rclist.iterator();
        while (it.hasNext() && entry == null) {
            CfgRcEntry rcEntry = it.next();
            if (!rcEntry.match(rc)) continue;
            entry = rcEntry;
        }
        if (entry == null) {
            CfgRcEntry rcEntry;
            entry = rcEntry = this.cfgRc.getEntry(rc);
        }
        return entry;
    }

    public void setMaxRetry(int retry) {
        this.maxRetry = retry;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public boolean isGrouped() {
        return this.groupName != null && this.groupName.length() > 0;
    }

    public void setPrio(int prio) {
        this.prio = prio;
    }

    public int getPrio() {
        return this.prio;
    }
}

