/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.Attribute;
import de.axway.aim.controller.lib.JobDcl;
import de.axway.aim.controller.lib.JslEntry;
import de.axway.aim.controller.lib.ParameterException;
import de.axway.aim.controller.master.CtrlBuiltin;
import de.axway.aim.controller.master.CtrlEvent;
import de.axway.aim.controller.master.CtrlJob;
import de.axway.aim.controller.master.CtrlVar;
import de.axway.aim.controller.master.DebPrepStmt;
import de.axway.aim.controller.master.IExecutable;
import de.axway.aim.controller.master.IJob;
import de.axway.aim.controller.master.ISequence;
import de.axway.aim.controller.master.JBpmJob;
import de.axway.aim.controller.master.JslBuiltin;
import de.axway.aim.controller.master.builtin.Builtin;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgJob;
import de.axway.aim.controller.master.cfg.CfgJobEntry;
import de.axway.aim.controller.master.cfg.CfgRc;
import de.axway.aim.controller.master.cfg.CfgTimeWindow;
import de.axway.aim.controller.master.cfg.CfgTimeWindowEntry;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.command.MatchCmdParam;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.aim.controller.master.tcontrol.IDispatcher;
import de.axway.aim.controller.master.tcontrol.NormTimeWindow;
import de.axway.aim.controller.master.tcontrol.NormalizedTimewindow;
import de.axway.lockDaemon.LockException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;

public class CfgJSelectEntry
extends JslEntry {
    private static Log log = LogFactory.getLog((String)"master.cfg.CfgJSelectEntry");
    private static final int ACC_UNSET = 0;
    private static final int ACC_FALSE = 1;
    private static final int ACC_TRUE = 2;
    private int index = -1;
    private long id = -1L;
    private boolean seq = false;
    private int prio = 0;
    private CfgTimeWindowEntry timeWindow = null;
    private NormalizedTimewindow normalizedTimewindow = null;
    private String timeWindowName = null;
    private int tPeriode = 0;
    private boolean isTimeEvent = false;
    private String accUsrColStr = null;
    private String[] accUsrCol = null;
    private String archCompStr = null;
    private Set<String> archComps = null;
    private String keepCompStr = null;
    private Set keepComps = null;
    private String attr = null;
    private int num = 0;
    private int jslLine = -1;
    private Ediboss ediboss = null;
    private int used = 0;
    private ISequence jslSeq = null;
    private String builtin = null;
    private CfgTimeWindowEntry normalizedRefTimewindow = null;
    private Builtin realBuiltin = null;
    private DataSource dataSource = null;
    private Object usedSync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, CfgJSelectEntry> load(DataSource dataSource, Ediboss ediboss, CfgTimeWindow cfgTimeWindow, Map<Long, CfgJobEntry> cfgJobs) throws SQLException {
        Hashtable<Long, CfgJSelectEntry> ret = new Hashtable<Long, CfgJSelectEntry>();
        try (Connection con = dataSource.getConnection();){
            con.setReadOnly(true);
            try (PreparedStatement stmt = con.prepareStatement(CfgJSelectEntry.getSql());
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    CfgJobEntry cfgJob = cfgJobs.get(rs.getLong(6));
                    CfgJSelectEntry entry = new CfgJSelectEntry(cfgJob, rs, ediboss, null, cfgTimeWindow, dataSource);
                    ret.put(entry.getId(), entry);
                    CfgJSelectEntry.addPar(con, entry);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CfgJSelectEntry load(DataSource dataSource, int id, CfgRc cfgRc, CfgTimeWindow cfgTimeWindow) throws SQLException, ParameterException {
        CfgJSelectEntry ret;
        block10: {
            ret = null;
            try (Connection con = dataSource.getConnection();){
                con.setReadOnly(true);
                try (PreparedStatement stmt = con.prepareStatement(CfgJSelectEntry.getSql() + " where id = ?");){
                    stmt.setInt(1, id);
                    try (ResultSet rs = stmt.executeQuery();){
                        if (rs.next()) {
                            CfgJobEntry jobEntry = CfgJobEntry.load(con, cfgRc, cfgTimeWindow, rs.getLong(6));
                            ret = new CfgJSelectEntry(jobEntry, rs, null, null, cfgTimeWindow, dataSource);
                            CfgJSelectEntry.addPar(con, ret);
                            break block10;
                        }
                        throw new SQLException("jsl entry " + id + " not found in db");
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPar(Connection con, CfgJSelectEntry entry) throws SQLException {
        PreparedStatement stmt = con.prepareStatement("select name, value from ctrl_cfgjobpar where jslid = ? order by nr");
        ResultSet rs = null;
        try {
            stmt.setLong(1, entry.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String val = rs.getString(2);
                entry.addPar(new Attribute(rs.getString(1), (Object)(val == null ? "" : val.intern())));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
        }
    }

    public CfgJSelectEntry(CfgJobEntry cfgJob, Ediboss ediboss, int line, ISequence seq, DataSource dataSource) {
        this(cfgJob, ediboss, line, seq, dataSource, -1);
    }

    public CfgJSelectEntry(CfgJobEntry cfgJob, Ediboss ediboss, int line, ISequence seq, DataSource dataSource, int index) {
        super((JobDcl)cfgJob);
        this.ediboss = ediboss;
        this.jslLine = line;
        this.jslSeq = seq;
        this.dataSource = dataSource;
        this.index = index;
    }

    public CfgJSelectEntry(CfgJobEntry cfgJob, ResultSet rs, Ediboss ediboss, ISequence seq, CfgTimeWindow cfgTw, DataSource dataSource) throws SQLException {
        this(cfgJob, ediboss, -1, seq, dataSource);
        this.id = rs.getInt(1);
        this.setOnError(rs.getString(2));
        this.setOnRetryFull(rs.getString(3));
        this.setEaSignific(rs.getInt(4));
        if (cfgTw != null) {
            this.timeWindowName = rs.getString(5);
            if (this.timeWindowName != null && this.timeWindowName.length() > 0) {
                this.setTimeWindow(cfgTw.get(this.timeWindowName), this.timeWindowName);
            }
        }
        this.setAccUsrColStr(rs.getString(7));
        this.setArchCompStr(rs.getString(8));
        this.setKeepCompStr(rs.getString(9));
        int accOnVal = rs.getInt(10);
        if (accOnVal != 0) {
            this.setAccountingOn(accOnVal == 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsed(boolean used) {
        Object object = this.usedSync;
        synchronized (object) {
            if (used) {
                ++this.used;
                if (this.used == 1) {
                    this.getJobEntry().setUsed(true);
                }
            } else {
                --this.used;
                if (this.used < 0) {
                    throw new IllegalArgumentException("used is now: " + this.used);
                }
                if (this.used == 0) {
                    this.getJobEntry().setUsed(false);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("set used(" + this.id + ") " + used + ", now " + this.used));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsed() {
        Object object = this.usedSync;
        synchronized (object) {
            return this.used > 0;
        }
    }

    public void setOld() {
        this.jslLine = -1;
        if (this.getJobEntry() != null) {
            this.getJobEntry().setOld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Connection con) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cfg_jsl to remove: used=" + this.used + ", jslLine=" + this.jslLine + ", id=" + this.id));
        }
        if (this.isUsed() || this.jslLine >= 0 || this.id < 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cfg_jsl not removed: used: " + this.used + ", jslLine: " + this.jslLine + ", id: " + this.id));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("trying to remove cfg_jsl with id: " + this.id));
        }
        try {
            CfgJobEntry.removeId("delete from ctrl_cfgjobpar where jslid = ?", con, this.id, log);
            CfgJobEntry.removeId("delete from ctrl_cfgjsl where id = ?", con, this.id, log);
            con.commit();
        }
        catch (SQLException e) {
            con.rollback();
            log.error((Object)("error on cfgjsl remove id " + this.id));
            throw e;
        }
        CfgJobEntry cfgJobEntry = this.getJobEntry();
        synchronized (cfgJobEntry) {
            this.getJobEntry().remove(con);
        }
        this.id = -1L;
        return true;
    }

    public static String getSql() {
        return "select id, on_error, on_retryfull, easignific, timewindow, jsid, acc_usrcol, arch_comp_names, keep_comp_names, accounting_on from ctrl_cfgjsl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<Long> matchName(MatchCmdParam jobNameSpec, Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        HashSet<Long> jobIds = null;
        StringBuilder selectCmd = new StringBuilder();
        if (jobNameSpec == null || !jobNameSpec.hasValues()) {
            return null;
        }
        selectCmd.append("select ctrl_job.id from ctrl_job, ctrl_cfgjsl, ctrl_cfgjob where ");
        selectCmd.append((CharSequence)CtrlJob.getCriterias(jobNameSpec, "ctrl_cfgjob.name"));
        selectCmd.append(" and ctrl_cfgjob.id=ctrl_cfgjsl.jsid");
        selectCmd.append(" and ctrl_cfgjsl.id=ctrl_job.jslid");
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(selectCmd.toString());
            jobIds = new HashSet<Long>();
            while (rs.next()) {
                jobIds.add(rs.getLong(1));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return jobIds;
    }

    public long getId() {
        return this.id;
    }

    public CfgJobEntry getJobEntry() {
        return (CfgJobEntry)this.getCfgJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(Log dbLog, Connection con) throws SQLException, LockException, ParameterException {
        if (this.id > 0L) {
            return false;
        }
        if (this.getJobEntry() == null) {
            throw new SQLException("no CfgJobEntry");
        }
        CfgJobEntry cfgJobEntry = this.getJobEntry();
        synchronized (cfgJobEntry) {
            this.getJobEntry().save(dbLog, con);
        }
        String sql = "insert into ctrl_cfgjsl (id, on_error, on_retryfull, easignific, timewindow, jsid, acc_usrcol, arch_comp_names, keep_comp_names, accounting_on) values (?,?,?,?,?,?,?,?,?,?)";
        DebPrepStmt insert = null;
        this.id = this.jslSeq.getNextId(this.dataSource);
        try {
            insert = new DebPrepStmt(con, sql, dbLog);
            try {
                insert.setLong(1, this.id);
                insert.setString(2, super.getOnError());
                insert.setString(3, super.getOnRetryFull());
                insert.setInt(4, this.getEaSignific());
                if (this.timeWindowName != null) {
                    insert.setString(5, this.timeWindowName);
                } else {
                    insert.setString(5, "");
                }
                insert.setLong(6, this.getJobEntry().getId());
                insert.setString(7, this.accUsrColStr);
                insert.setString(8, this.archCompStr);
                insert.setString(9, this.keepCompStr);
                if (super.isAccountingOnSet()) {
                    insert.setInt(10, super.getAccountingOn() ? 2 : 1);
                } else {
                    insert.setInt(10, 0);
                }
                insert.executeUpdate();
                try (DebPrepStmt insertPar = new DebPrepStmt(con, "insert into ctrl_cfgjobpar (jslid, name, value, nr) values (?,?,?,?)", dbLog);){
                    int x = 0;
                    String parName = null;
                    String parVal = null;
                    Iterator it = this.getPar().iterator(0);
                    while (it.hasNext()) {
                        String warningMsg;
                        Attribute a = (Attribute)it.next();
                        insertPar.setLong(1, this.id);
                        parName = a.getName();
                        parVal = (String)a.get();
                        if (parName != null && parName.length() > 32) {
                            warningMsg = String.format("Parameter Name truncation occured for  jslid = %d, name = %s", this.id, parName);
                            parName = parName.substring(0, 32);
                            log.warn((Object)warningMsg);
                            Logbook.getLogbook().warning(warningMsg);
                        }
                        if (parVal != null && parVal.length() > 2000) {
                            parVal = parVal.substring(0, 2000);
                            warningMsg = String.format("Parameter Value truncation occured for  jslid = %d", this.id);
                            log.warn((Object)warningMsg);
                            Logbook.getLogbook().warning(warningMsg);
                        }
                        insertPar.setString(2, parName);
                        insertPar.setString(3, parVal);
                        insertPar.setInt(4, x);
                        insertPar.executeUpdate();
                        ++x;
                    }
                }
            }
            catch (SQLException e) {
                dbLog.error((Object)("sql: " + insert));
                throw e;
            }
            finally {
                insert.close();
            }
            con.commit();
        }
        catch (SQLException e) {
            con.rollback();
            this.id = -1L;
            throw e;
        }
        return true;
    }

    private static String[] getUsrColVarArr(String accUsrColStr) {
        int i;
        String[] posAndVar = null;
        String[] accUsrCol = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUsrColVarArr start: '" + accUsrColStr + "'"));
        }
        if (accUsrColStr != null && accUsrColStr.length() > 0) {
            ArrayList<String> al = new ArrayList<String>();
            posAndVar = accUsrColStr.split("\\s");
            for (i = 0; i < posAndVar.length; ++i) {
                try {
                    int idx = posAndVar[i].indexOf(61);
                    if (idx == -1) continue;
                    int pos = Integer.parseInt(posAndVar[i].substring(0, idx).trim());
                    String var = posAndVar[i].substring(idx + 1);
                    if (pos <= 0 || pos >= 256) continue;
                    int elem2Fill = pos - al.size();
                    while (elem2Fill-- > 0) {
                        al.add(null);
                    }
                    al.set(pos - 1, "$(" + var + ")");
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Invalid ACC_USRCOL specification: " + posAndVar[i]), (Throwable)e);
                }
            }
            if (al.size() > 0) {
                accUsrCol = new String[al.size()];
                al.toArray(accUsrCol);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUsrColVarArr end: " + accUsrCol));
            if (accUsrCol != null) {
                for (i = 0; i < accUsrCol.length; ++i) {
                    log.debug((Object)("user account colum[" + i + "]=" + accUsrCol[i] + "'"));
                }
            }
        }
        return accUsrCol;
    }

    public void setAccUsrColStr(String accUsrColStr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAccUsrColStr start: " + accUsrColStr));
        }
        this.accUsrColStr = accUsrColStr;
        this.accUsrCol = CfgJSelectEntry.getUsrColVarArr(accUsrColStr);
    }

    public String getAccUsrColStr() {
        return this.accUsrColStr;
    }

    public String[] getAccUsrCol() {
        return this.accUsrCol;
    }

    private static Set<String> splitCompStr(String what, String compNamesStr) {
        String[] compArr;
        HashSet<String> comps = new HashSet<String>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("splitCompStr " + what + " start: '" + compNamesStr + "'"));
        }
        if ((compArr = compNamesStr.split("\\s")) != null) {
            for (int i = 0; i < compArr.length; ++i) {
                comps.add(compArr[i]);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(what + " component[" + i + "]=" + compArr[i] + "'"));
            }
        }
        return comps;
    }

    public void setArchCompStr(String archCompStr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setArchCompStr start: " + archCompStr));
        }
        if (archCompStr == null) {
            log.debug((Object)"setArchCompStr end: nothin to do");
            return;
        }
        String str2Split = this.archCompStr == null ? archCompStr : this.archCompStr + " " + archCompStr;
        this.archCompStr = str2Split;
        this.archComps = CfgJSelectEntry.splitCompStr("ARCHIVE", str2Split);
    }

    public String getArchCompStr() {
        return this.archCompStr;
    }

    public Set<String> getComps2Arch() {
        return this.archComps;
    }

    public void setKeepCompStr(String keepCompStr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setArchCompStr start: " + this.archCompStr));
        }
        if (keepCompStr == null) {
            log.debug((Object)"setKeepCompStr end: nothin to do");
            return;
        }
        String str2Split = this.keepCompStr == null ? keepCompStr : this.keepCompStr + " " + keepCompStr;
        this.keepCompStr = str2Split;
        this.keepComps = CfgJSelectEntry.splitCompStr("KEEP", str2Split);
    }

    public String getKeepCompStr() {
        return this.keepCompStr;
    }

    public Set<String> getComps2Keep() {
        return this.keepComps;
    }

    public CfgTimeWindowEntry getTimeWindow() {
        return this.timeWindow;
    }

    public NormalizedTimewindow getNormalizedTimewindow() {
        if (this.timeWindow == null) {
            this.normalizedRefTimewindow = null;
            this.normalizedTimewindow = null;
        } else if (this.normalizedRefTimewindow != this.timeWindow) {
            this.normalizedRefTimewindow = this.timeWindow;
            this.normalizedTimewindow = NormTimeWindow.normalizeTimewindowEntry(this.timeWindow);
        }
        return this.normalizedTimewindow;
    }

    public String getOnError() {
        String ret = super.getOnError();
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        return this.ediboss.getOnError();
    }

    public String getArchiveCmd() {
        return this.ediboss.getArchiveCmd();
    }

    public String getOnRetryFull() {
        String ret = super.getOnRetryFull();
        if (ret != null && ret.length() > 0) {
            return ret;
        }
        return this.ediboss.getOnRetryFull();
    }

    public boolean getAccountingOn() {
        if (super.isAccountingOnSet()) {
            return super.getAccountingOn();
        }
        return this.ediboss.getAccountingOn();
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public String getAttr() {
        return this.attr;
    }

    public void setAttr(String attrString) {
        this.attr = attrString;
    }

    public void setTimeEvent(boolean time) {
        this.isTimeEvent = time;
    }

    public boolean isTimeEvent() {
        return this.isTimeEvent;
    }

    public void setBuiltin(Builtin builtin) {
        this.realBuiltin = builtin;
    }

    public void setBuiltin(String cmd) {
        this.builtin = cmd;
    }

    public boolean isBuiltIn() {
        return this.builtin != null || this.realBuiltin != null;
    }

    public void setPrio(int prio) {
        this.prio = prio;
    }

    public void setSeq(boolean seq) {
        this.seq = seq;
    }

    public void setTimeWindow(CfgTimeWindowEntry timeWindow, String name) {
        this.timeWindow = timeWindow;
        this.timeWindowName = name;
    }

    public void updateTwCfg(CfgTimeWindow tw) throws CfgException {
        if (this.timeWindowName == null || this.timeWindowName.length() <= 0) {
            return;
        }
        CfgTimeWindowEntry twe = tw.get(this.timeWindowName);
        if (twe == null) {
            this.timeWindow = null;
            throw new CfgException("timewindow " + this.timeWindowName + " not found");
        }
        this.timeWindow = twe;
    }

    public JBpmJob createJob(CtrlEvent evt, JbpmConfiguration conf) throws CfgException {
        JbpmContext context = conf.createJbpmContext();
        ProcessDefinition pd = context.getGraphSession().findLatestProcessDefinition(this.getName());
        if (pd == null) {
            throw new CfgException("job definition " + this.getName() + " not found");
        }
        JBpmJob job = new JBpmJob(conf, evt, this);
        this.setJob(job);
        evt.setJob(job);
        evt.setJslLine(this.jslLine);
        return job;
    }

    public IExecutable createJob(CtrlEvent evt, CfgJob cfgJob) throws CfgException, SQLException {
        evt.setJslLine(this.jslLine);
        if (this.builtin != null) {
            String evalBuiltin = CtrlVar.eval(this.builtin, true, false, null, new Map[]{evt.getAttr(), evt.getParams()});
            return new JslBuiltin(Builtin.create(evalBuiltin), evt, this);
        }
        if (this.realBuiltin != null) {
            return new JslBuiltin(this.realBuiltin, evt, this);
        }
        CtrlJob job = cfgJob.createJob(this.getName(), evt, this);
        this.setJob(job);
        evt.setJob(job);
        return job;
    }

    private void setJob(IJob job) {
        job.setSeq(this.seq);
        job.setPrio(this.prio);
    }

    public void setTPeriode(int tPeriode) {
        this.tPeriode = tPeriode;
    }

    public int getTPeriode() {
        return this.tPeriode;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CfgJSelectEntry: ");
        buf.append(super.toString());
        buf.append("\n");
        buf.append("timeWindow: ");
        buf.append(this.timeWindow);
        buf.append("\nseq: ");
        buf.append(this.seq);
        buf.append(", prio: ");
        buf.append(this.prio);
        buf.append(", tPeriode: ");
        buf.append(this.tPeriode);
        buf.append("\naccUsrColStr: ");
        buf.append(this.accUsrColStr);
        buf.append("\narchCompStr: ");
        buf.append(this.archCompStr);
        buf.append("\nkeepCompStr: ");
        buf.append(this.keepCompStr);
        buf.append("\nisTimeEvent: ");
        buf.append(this.isTimeEvent);
        buf.append("\nattr: ");
        buf.append(this.attr);
        buf.append("\njslLine: ");
        buf.append(this.jslLine);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJob(IDispatcher dispatcher, CfgJob cfgJob) {
        try {
            long evtId = dispatcher.getNextEventId();
            try {
                CtrlEvent evt = new CtrlEvent(evtId, this.getAttr());
                evt.setTimeEvent(true);
                evt.setInitiator("CLOCK." + this.getNum());
                boolean doLog = true;
                IExecutable job = this.createJob(evt, cfgJob);
                if (job instanceof JslBuiltin && ((JslBuiltin)job).isHidden()) {
                    doLog = false;
                }
                if (doLog) {
                    Logbook.getLogbook().eventStart(evt, "localhost", "EDIMAN");
                    Logbook.getLogbook().createJob(job.getName(), job.getId(), evt.getId(), job.getId());
                }
                if (!(job instanceof CtrlBuiltin)) {
                    try (Connection con = dispatcher.getConnection();){
                        CfgJSelectEntry cfgJSelectEntry = this;
                        synchronized (cfgJSelectEntry) {
                            this.save(log, con);
                        }
                        evt.insert(con);
                        con.commit();
                    }
                }
                if (doLog && !job.isHidden()) {
                    Logbook.getLogbook().eventEnd(evt, "localhost", "EDIMAN");
                }
                dispatcher.newJob(job);
            }
            catch (CfgException exception) {
                Logbook.getLogbook().eventError("create job", 0L, evtId, "no jsl found: " + exception.getMessage(), "localhost", "pid");
            }
        }
        catch (Exception e) {
            log.error((Object)"create job", (Throwable)e);
            Logbook.getLogbook().error(e.getMessage());
        }
    }

    public int getUsed() {
        return this.used;
    }
}

