/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.CtrlSlave;
import java.io.IOException;

public class CfgSlaveEntry {
    private String name;
    private String host = null;
    private int port = -1;
    private int max = 4;
    private CtrlSlave.ConnectionType ct = CtrlSlave.ConnectionType.LOGPROT;
    private CtrlSlave.Type type = CtrlSlave.Type.SLAVE;
    private boolean fhPermanent = false;
    private String srcAddress = null;

    public CfgSlaveEntry(ClusterStream ois) throws IOException {
        this.name = ois.readUTF();
        this.host = ois.readUTF();
        this.port = ois.readInt();
        this.max = ois.readInt();
        this.srcAddress = ois.readString();
        byte x = ois.readByte();
        switch (x) {
            case 1: {
                this.ct = CtrlSlave.ConnectionType.LOGPROT;
                break;
            }
            case 2: {
                this.ct = CtrlSlave.ConnectionType.CLIENTCONNECTION;
                break;
            }
            case 3: {
                this.ct = CtrlSlave.ConnectionType.BUILTIN;
                break;
            }
            default: {
                throw new IllegalArgumentException("unkown slave connection type: " + x);
            }
        }
        x = ois.readByte();
        switch (x) {
            case 1: {
                this.type = CtrlSlave.Type.SLAVE;
                break;
            }
            case 2: {
                this.type = CtrlSlave.Type.BOMSLAVE;
                break;
            }
            default: {
                throw new IllegalArgumentException("unkown slave type: " + x);
            }
        }
    }

    public void write(ClusterStream oos) throws IOException {
        oos.writeUTF(this.name);
        oos.writeUTF(this.host);
        oos.writeInt(this.port);
        oos.writeInt(this.max);
        oos.writeString(this.srcAddress);
        switch (this.ct) {
            case LOGPROT: {
                oos.writeByte(1);
                break;
            }
            case CLIENTCONNECTION: {
                oos.writeByte(2);
                break;
            }
            case BUILTIN: {
                oos.writeByte(3);
                break;
            }
            default: {
                throw new IllegalArgumentException("unkown slave connection type: " + (Object)((Object)this.ct));
            }
        }
        switch (this.type) {
            case SLAVE: {
                oos.writeByte(1);
                break;
            }
            case BOMSLAVE: {
                oos.writeByte(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("unkown slave type: " + (Object)((Object)this.type));
            }
        }
    }

    public CfgSlaveEntry(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMax() {
        return this.max;
    }

    public void setConnection(CtrlSlave.ConnectionType ct) {
        this.ct = ct;
    }

    public CtrlSlave.ConnectionType getConnection() {
        return this.ct;
    }

    public void setType(CtrlSlave.Type type) {
        this.type = type;
    }

    public CtrlSlave.Type getType() {
        return this.type;
    }

    public void setFhPermanent(boolean perm) {
        this.fhPermanent = perm;
    }

    public boolean fhPermanent() {
        return this.fhPermanent;
    }

    public void setSrcAddress(String addr) {
        this.srcAddress = addr;
    }

    public String getSrcAddress() {
        return this.srcAddress;
    }
}

