/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.TextCfg;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;

public class CfgTimeOneDate {
    private boolean isAllowed = true;
    private Date from = null;
    private Date to = null;

    public CfgTimeOneDate(ClusterStream ois) throws IOException {
        this.isAllowed = ois.readBoolean();
        this.from = ois.readDate();
        this.to = ois.readDate();
    }

    public void write(ClusterStream oos) throws IOException {
        oos.writeBoolean(this.isAllowed);
        oos.writeDate(this.from);
        oos.writeDate(this.to);
    }

    public boolean isAllowed() {
        return this.isAllowed;
    }

    public Date getFrom() {
        return this.from;
    }

    public CfgTimeOneDate(String param) throws CfgException {
        String[] ft;
        if (param.length() < 1) {
            throw new CfgException("empty param not allowed");
        }
        String p = param.trim();
        if (p.charAt(0) == '!') {
            this.isAllowed = false;
            p = p.substring(1).trim();
        }
        if ((ft = p.split("-")).length < 1 || ft.length > 2) {
            throw new CfgException("unknown format for DATE: " + param);
        }
        this.from = CfgTimeOneDate.getVal(ft[0]);
        if (ft.length > 1) {
            this.to = CfgTimeOneDate.getVal(ft[1]);
            if (this.to.before(this.from)) {
                throw new CfgException("from is not before to: " + param);
            }
        }
    }

    private static Date getVal(String val) throws CfgException {
        String[] d = val.split("\\.");
        if (d.length != 3) {
            throw new CfgException("unknown format for day: " + val);
        }
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.set(TextCfg.getInt(d[2]), TextCfg.getInt(d[1]) - 1, TextCfg.getInt(d[0]));
        return c.getTime();
    }

    public String toString() {
        return (!this.isAllowed ? "!" : "") + CfgTimeOneDate.two(this.from.getDate()) + "." + CfgTimeOneDate.two(1 + this.from.getMonth()) + "." + (1900 + this.from.getYear()) + "-" + CfgTimeOneDate.two(this.to.getDate()) + "." + CfgTimeOneDate.two(1 + this.to.getMonth()) + "." + (1900 + this.to.getYear());
    }

    private static String two(int no) {
        return (no < 10 ? "0" : "") + no;
    }

    public Date getTo() {
        return this.to;
    }
}

