/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ClusterStream;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgTimeDate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;

public class CfgTimeWindowEntry {
    private static final Date DEFAULT_FIRST_ENABLED;
    private String name;
    private List<CfgTimeDate> date = new ArrayList<CfgTimeDate>();

    public List<CfgTimeDate> getDate() {
        return this.date;
    }

    public CfgTimeWindowEntry(ClusterStream ois) throws IOException {
        this.name = ois.readUTF();
        if (this.name == null || this.name.length() <= 0) {
            throw new IllegalArgumentException("no timewindow name");
        }
        int count = ois.readInt();
        for (int x = 0; x < count; ++x) {
            this.date.add(new CfgTimeDate(ois));
        }
    }

    public void write(ClusterStream oos) throws IOException {
        oos.writeUTF(this.name);
        oos.writeInt(this.date.size());
        Iterator<CfgTimeDate> it = this.date.iterator();
        while (it.hasNext()) {
            it.next().write(oos);
        }
    }

    public CfgTimeWindowEntry(String name) throws CfgException {
        if (name == null || name.length() <= 0) {
            throw new CfgException("no timewindow name");
        }
        if (name.length() > 32) {
            throw new CfgException("timewindow name <" + name + "> too long, max 32 chars allowd");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addDate(CfgTimeDate date) {
        this.date.add(date);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("WINDOWNAME=" + this.name + '\n');
        Iterator<CfgTimeDate> it = this.date.iterator();
        while (it.hasNext()) {
            ret.append('\t');
            ret.append(it.next().toString());
            ret.append('\n');
        }
        return ret.toString();
    }

    static {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.clear();
        calendar.set(1, 1980);
        calendar.set(2, 0);
        calendar.set(5, 1);
        DEFAULT_FIRST_ENABLED = calendar.getTime();
    }
}

