/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ParameterException;

public class Parameter {
    public static final int UNKNOWN = -1;
    public static final int STRING = 0;
    public static final int INT = 1;
    public static final int BOOL = 2;
    private int type = -1;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    public Parameter(int type, int min, int max) {
        this(type, max);
        this.min = min;
    }

    public Parameter(int type, int max) {
        this.type = type;
        this.max = max;
    }

    public Parameter(int type) {
        this.type = type;
    }

    public void test(boolean value) throws ParameterException {
        this.test((Object)value);
    }

    public void test(int value) throws ParameterException {
        this.test((Object)value);
    }

    public void test(Object value) throws ParameterException {
        switch (this.type) {
            case 0: {
                if (value instanceof String) {
                    String v = (String)value;
                    if (v.length() > this.max) {
                        throw new ParameterException("string too long: " + v.length() + ", max " + this.max);
                    }
                    if (v.length() >= this.min) break;
                    throw new ParameterException("string too short: " + v.length() + ", min " + this.min);
                }
                throw new ParameterException("value is not a string");
            }
            case 1: {
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    if (i > this.max) {
                        throw new ParameterException("int too big: " + i + ", max " + this.max);
                    }
                    if (i >= this.min) break;
                    throw new ParameterException("int too small: " + i + ", min " + this.min);
                }
                throw new ParameterException("value is not an int");
            }
            case 2: {
                if (value instanceof Boolean) break;
                throw new ParameterException("value is not an bool");
            }
            default: {
                throw new ParameterException("Unknown type: " + this.type);
            }
        }
    }
}

