/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.lib.util.ActisFile;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;

public final class TextCfg {
    private TextCfg() {
    }

    public static String getParamName(String line) {
        int i = line.indexOf(61);
        if (i <= 0) {
            return null;
        }
        return line.substring(0, i).trim().toUpperCase();
    }

    public static String trimCutComment(String val) {
        int i = val.indexOf(35);
        if (i != -1) {
            val = val.substring(0, i);
        }
        return val.trim();
    }

    public static int getInt(String param) {
        int ret = 0;
        boolean neg = false;
        int x = 0;
        if (param == null || param.length() <= 0) {
            return 0;
        }
        char c = param.charAt(0);
        switch (c) {
            case '-': {
                neg = true;
                ++x;
                break;
            }
            case '+': {
                ++x;
            }
        }
        while (x < param.length() && param.charAt(x) >= '0' && param.charAt(x) <= '9') {
            ret = ret * 10 + (param.charAt(x) - 48);
            ++x;
        }
        if (neg) {
            return ret * -1;
        }
        return ret;
    }

    public static boolean getBool(String param) throws CfgException {
        if (param.charAt(0) == 'Y' || param.charAt(0) == 'y' || param.charAt(0) == '1') {
            return true;
        }
        if (param.charAt(0) == 'N' || param.charAt(0) == 'n' || param.charAt(0) == '0') {
            return false;
        }
        throw new CfgException("Invalid boolean value: '" + param.charAt(0) + "' (valid: y/n)");
    }

    public static String getParam(String line) throws CfgException {
        int start = line.indexOf(61);
        if (start < 0) {
            throw new CfgException("no value in " + line);
        }
        return line.substring(start + 1).trim();
    }

    public static String getTime(int time) {
        StringBuffer out = new StringBuffer();
        int timeS = time % 60;
        int timeM = time / 60 % 60;
        int timeH = time / 3600 % 24;
        int timeD = time / 3600 / 24;
        out.append(timeD > 0 ? timeD + ":" : "");
        out.append((timeH > 9 ? "" + timeH : "0" + timeH) + '.');
        out.append((timeM > 9 ? "" + timeM : "0" + timeM) + '.');
        out.append(timeS > 9 ? Integer.valueOf(timeS) : "0" + timeS);
        return out.toString();
    }

    public static int getTime(String param) throws CfgException {
        int sec = 0;
        int i = param.indexOf(35);
        String p = param;
        if (i > 0) {
            p = param.substring(0, i).trim();
        }
        String[] day = p.split("[:\\.]");
        int index = 0;
        if (day.length > 4) {
            throw new CfgException("unknown format for time: " + p);
        }
        if (day.length > 3) {
            sec = 86400 * TextCfg.getInt(day[index]);
            ++index;
        }
        if (day.length > 2) {
            sec += 3600 * TextCfg.getInt(day[index]);
            ++index;
        }
        if (day.length > 1) {
            sec += 60 * TextCfg.getInt(day[index]);
            ++index;
        }
        if (day.length > 0) {
            sec += TextCfg.getInt(day[index]);
            ++index;
        }
        return sec;
    }

    public static File checkSetLock(ILogbook logbook, Log log, String path) throws IOException {
        int count = 1;
        File lockFile = null;
        while (count <= 60) {
            lockFile = new File(ActisFile.getACTISEDI() + "/" + path);
            if (!lockFile.exists()) {
                lockFile.createNewFile();
                if (log == null || !log.isDebugEnabled()) break;
                log.debug((Object)("lock file " + path + " not found; create it and continue reading file"));
                break;
            }
            try {
                if (log != null && log.isDebugEnabled()) {
                    log.debug((Object)("lock file " + path + " found at attempt number:" + count + "; waiting for it to be removed"));
                }
                Thread.currentThread();
                Thread.sleep(2000L);
                ++count;
            }
            catch (InterruptedException e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug((Object)("Error while thread.sleep: " + e.getMessage()));
            }
        }
        if (count == 61) {
            logbook.warning("lock file: " + path + " is still there after 2 min; will continue reading the file anyway.");
            if (log != null) {
                log.warn((Object)("lock file: " + path + " is still there after 2 min; will continue reading the file anyway."));
            }
        }
        return lockFile;
    }
}

