/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.ParameterException;
import de.axway.aim.controller.master.ISequence;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgJSelect;
import de.axway.aim.controller.master.cfg.CfgJSelectEntry;
import de.axway.aim.controller.master.cfg.CfgRc;
import de.axway.aim.controller.master.cfg.CfgTimeWindow;
import de.axway.aim.controller.master.cfg.CfgTimeWindowEntry;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.aim.controller.master.cfg.TextCfgJob;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.aim.controller.master.log.Logbook;
import de.axway.lockDaemon.LockException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.DataSource;

public class TextCfgJSelect
extends CfgJSelect {
    private static Map<String, Ident> identifier = new Hashtable<String, Ident>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextCfgJSelect(File jselect, File jobsdcl, CfgTimeWindow timeWindow, CfgRc cfgRc, boolean classic, Ediboss ediboss, ISequence jslSequence, DataSource dataSource, ISequence jsSequence) throws IOException, SQLException, LockException {
        File jSelectLock;
        int count;
        ILogbook logbook;
        block66: {
            super(timeWindow, ediboss);
            this.cfgJob = null;
            if (classic) {
                this.cfgJob = new TextCfgJob(jobsdcl, timeWindow, cfgRc, ediboss.getJobRemoveDelay(), dataSource, jsSequence);
            }
            logbook = Logbook.getLogbook();
            count = 0;
            jSelectLock = TextCfg.checkSetLock(logbook, log, Ediboss.jslPath + ".lock");
            logbook.info("reading " + jselect.getAbsolutePath());
            if (!jselect.canRead()) {
                if (jSelectLock.exists()) {
                    jSelectLock.delete();
                }
                throw new IOException("Can not read " + jselect.getAbsolutePath());
            }
            String attr = null;
            CfgJSelectEntry entry = null;
            int lineNo = 0;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(jselect)));){
                String line = br.readLine();
                while (line != null) {
                    ++lineNo;
                    String tLine = line.trim();
                    if (tLine.length() > 0 && !tLine.startsWith("#")) {
                        String paramName = TextCfg.getParamName(tLine);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("paramName: " + paramName));
                        }
                        if (paramName == null) {
                            logbook.error("No parameter found, line " + lineNo);
                        } else {
                            Ident id = identifier.get(TextCfg.getParamName(tLine));
                            String param = null;
                            String uParam = null;
                            try {
                                param = TextCfg.getParam(tLine);
                                uParam = param.toUpperCase();
                            }
                            catch (CfgException e) {
                                logbook.warning(e.getMessage() + " in line " + lineNo + ", ignored");
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("param: " + param));
                            }
                            if (id == null) {
                                logbook.warning("Unknown parameter " + tLine + " in line " + lineNo);
                            } else if (param != null && (id == Ident.EV_ATTRI || param.length() > 0)) {
                                if (id != Ident.EV_ATTRI && entry == null) {
                                    log.error((Object)("No EV_ATTRI defined, line: " + lineNo));
                                } else {
                                    switch (id) {
                                        case EV_ATTRI: {
                                            if (entry != null) {
                                                try {
                                                    this.newEntry(attr, entry);
                                                }
                                                catch (CfgException e) {
                                                    logbook.error(e.getMessage() + " in line: " + lineNo);
                                                }
                                            }
                                            attr = param;
                                            entry = new CfgJSelectEntry(null, this.getEdiboss(), lineNo, jslSequence, dataSource, ++count);
                                            break;
                                        }
                                        case EA_SIGNIFIC: {
                                            entry.setEaSignific(TextCfg.getInt(param));
                                            break;
                                        }
                                        case JOBN_PAR: {
                                            try {
                                                entry.setJobNPar(this.cfgJob.getEntries(), param);
                                            }
                                            catch (ParameterException e) {
                                                logbook.error(e.getMessage() + ", ignored, line " + lineNo);
                                            }
                                            break;
                                        }
                                        case JOB_SEQU: {
                                            boolean seq = uParam.equals("Y");
                                            entry.setSeq(seq);
                                            break;
                                        }
                                        case EVN_TYPE: {
                                            entry.setTimeEvent(uParam.equals("TIME"));
                                            break;
                                        }
                                        case JOB_PRIO: {
                                            entry.setPrio(TextCfg.getInt(param));
                                            break;
                                        }
                                        case TIME_WINDOW: {
                                            CfgTimeWindowEntry tw = timeWindow.get(uParam);
                                            if (tw == null) {
                                                logbook.error("timewindow " + uParam + " not found");
                                            }
                                            entry.setTimeWindow(tw, uParam);
                                            break;
                                        }
                                        case BUILT_IN: {
                                            entry.setBuiltin("BUILT_IN=" + param);
                                            break;
                                        }
                                        case TPERIODE: {
                                            try {
                                                entry.setTPeriode(TextCfg.getTime(param));
                                            }
                                            catch (CfgException e) {
                                                logbook.error(e.getMessage() + " in line " + lineNo);
                                            }
                                            break;
                                        }
                                        case ON_ERROR: {
                                            if (log.isDebugEnabled()) {
                                                log.debug((Object)("set ON_ERROR: '" + param + "'"));
                                            }
                                            if (param.length() > 1000) {
                                                logbook.error("ON_ERROR param too long in line " + lineNo);
                                                break;
                                            }
                                            entry.setOnError(param);
                                            break;
                                        }
                                        case ON_RETRY_FULL: {
                                            if (log.isDebugEnabled()) {
                                                log.debug((Object)("set ON_RETRY_FULL: '" + param + "'"));
                                            }
                                            if (param.length() > 1000) {
                                                logbook.error("ON_RETRY_FULL param too long in line " + lineNo);
                                                break;
                                            }
                                            entry.setOnRetryFull(param);
                                            break;
                                        }
                                        case ACC_USRCOL: {
                                            if (param.length() > 1000) {
                                                logbook.error("ACC_USRCOL param too long in line " + lineNo);
                                                break;
                                            }
                                            entry.setAccUsrColStr(param);
                                            break;
                                        }
                                        case ARCHIVE: {
                                            if (param.length() > 1000) {
                                                log.error((Object)("ARCHIVE param too long in line " + lineNo));
                                                break;
                                            }
                                            entry.setArchCompStr(param);
                                            break;
                                        }
                                        case KEEP: {
                                            if (param.length() > 1000) {
                                                logbook.error("ARCHIVE param too long in line " + lineNo);
                                                break;
                                            }
                                            entry.setKeepCompStr(param);
                                            break;
                                        }
                                        case ARCHIVE_KEEP: {
                                            if (param.length() > 1000) {
                                                logbook.error("ARCHIVE_KEEP param too long in line " + lineNo);
                                                break;
                                            }
                                            entry.setArchCompStr(param);
                                            entry.setKeepCompStr(param);
                                            break;
                                        }
                                        case ACCOUNTING_ON: {
                                            try {
                                                entry.setAccountingOn(TextCfg.getBool(param));
                                            }
                                            catch (CfgException e) {
                                                logbook.error("ACCOUNTING_ON param has invalid value in line " + lineNo + ", msg: " + e.getMessage());
                                            }
                                            break;
                                        }
                                        case ACCEPT_P: 
                                        case COMMENT: 
                                        case HC_DIRECTION: 
                                        case POP_ENABLE: {
                                            break;
                                        }
                                        default: {
                                            logbook.warning("parameter " + tLine + " in line " + lineNo + " not implemented");
                                        }
                                    }
                                }
                            }
                        }
                    }
                    line = br.readLine();
                }
                if (entry == null) break block66;
                try {
                    this.newEntry(attr, entry);
                    try {
                        if (!this.getJselectEntries().contains(".*")) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"EV_ATTRI=.* does not exist in j_select.cfg; will add it with JOBN_PAR=WARNING");
                            }
                            entry = this.createWarningEntry(jslSequence, dataSource, ++count, lineNo);
                            this.newEntry(".*", entry);
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)"EV_ATTRI=.* already exists in j_select.cfg; will not add it again");
                        }
                    }
                    catch (ParameterException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Exception: " + e.getMessage() + " while creating new WARNING cfgJselect entry"));
                        }
                    }
                }
                catch (CfgException e) {
                    logbook.error(e.getMessage() + " in line: " + lineNo);
                }
            }
        }
        if (jSelectLock.exists()) {
            jSelectLock.delete();
        }
        logbook.info(jselect.getName() + ": " + count + " entries");
    }

    private CfgJSelectEntry createWarningEntry(ISequence jslSequence, DataSource dataSource, int count, int lineNo) throws ParameterException {
        CfgJSelectEntry entry = new CfgJSelectEntry(null, this.getEdiboss(), lineNo, jslSequence, dataSource, count);
        entry.setEaSignific(1);
        entry.setJobNPar(this.cfgJob.getEntries(), "WARNING");
        entry.setTimeEvent(false);
        entry.setPrio(500);
        entry.setSeq(false);
        return entry;
    }

    static {
        identifier.put("EV_ATTRI", Ident.EV_ATTRI);
        identifier.put("JOBN_PAR", Ident.JOBN_PAR);
        identifier.put("EA_SIGNIFIC", Ident.EA_SIGNIFIC);
        identifier.put("JOB_SEQU", Ident.JOB_SEQU);
        identifier.put("JOB_PRIO", Ident.JOB_PRIO);
        identifier.put("ACCEPT_P", Ident.ACCEPT_P);
        identifier.put("EVN_TYPE", Ident.EVN_TYPE);
        identifier.put("TIME_WINDOW", Ident.TIME_WINDOW);
        identifier.put("TPERIODE", Ident.TPERIODE);
        identifier.put("HOSTID", Ident.HOSTID);
        identifier.put("ON_ERROR", Ident.ON_ERROR);
        identifier.put("ON_RETRY_FULL", Ident.ON_RETRY_FULL);
        identifier.put("ACCOUNTING_ON", Ident.ACCOUNTING_ON);
        identifier.put("ACC_USRCOL", Ident.ACC_USRCOL);
        identifier.put("ARCHIVE", Ident.ARCHIVE);
        identifier.put("ARCHIVE_KEEP", Ident.ARCHIVE_KEEP);
        identifier.put("KEEP", Ident.KEEP);
        identifier.put("COMMENT", Ident.COMMENT);
        identifier.put("WS_OPERATION", Ident.WS_OPERATION);
        identifier.put("BUILT_IN", Ident.BUILT_IN);
        identifier.put("HC_DIRECTION", Ident.HC_DIRECTION);
        identifier.put("POP_ENABLE", Ident.POP_ENABLE);
    }

    private static enum Ident {
        EV_ATTRI,
        JOBN_PAR,
        EA_SIGNIFIC,
        JOB_SEQU,
        JOB_PRIO,
        ACCEPT_P,
        EVN_TYPE,
        TIME_WINDOW,
        TPERIODE,
        HOSTID,
        ON_ERROR,
        ON_RETRY_FULL,
        ACCOUNTING_ON,
        ACC_USRCOL,
        ARCHIVE,
        ARCHIVE_KEEP,
        KEEP,
        COMMENT,
        WS_OPERATION,
        BUILT_IN,
        HC_DIRECTION,
        POP_ENABLE;

    }
}

