/*
 * Decompiled with CFR 0.152.
 */
package de.axway.aim.controller.master.cfg;

import de.axway.aim.controller.lib.CfgRcEntry;
import de.axway.aim.controller.lib.ParameterException;
import de.axway.aim.controller.master.cfg.CfgException;
import de.axway.aim.controller.master.cfg.CfgRc;
import de.axway.aim.controller.master.cfg.Ediboss;
import de.axway.aim.controller.master.cfg.TextCfg;
import de.axway.aim.controller.master.log.ILogbook;
import de.axway.aim.controller.master.log.Logbook;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextCfgRc
extends CfgRc {
    private static Log log = LogFactory.getLog((String)"master.cfg.TextCfgRc");
    private static Map<String, Ident> identifier = new Hashtable<String, Ident>();
    private File file;

    public TextCfgRc(File file) throws IOException {
        this.file = file;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        ILogbook logbook = Logbook.getLogbook();
        File rcLock = TextCfg.checkSetLock(logbook, log, Ediboss.rccPath + ".lock");
        logbook.info("reading " + this.file.getAbsolutePath());
        if (!this.file.canRead()) {
            if (rcLock.exists()) {
                rcLock.delete();
            }
            throw new IOException("Can not read " + this.file.getAbsolutePath());
        }
        int count = 0;
        int lineNo = 0;
        String name = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));){
            String line = br.readLine();
            while (line != null) {
                ++lineNo;
                String tLine = line.trim();
                if (tLine.length() > 0 && !tLine.startsWith("#")) {
                    String paramName = TextCfg.getParamName(tLine);
                    if (paramName == null) {
                        logbook.error("no parameter found, line " + lineNo);
                    } else {
                        Ident id = identifier.get(TextCfg.getParamName(tLine));
                        String param = null;
                        String uParam = null;
                        try {
                            param = TextCfg.getParam(tLine);
                            uParam = param.toUpperCase();
                        }
                        catch (CfgException e) {
                            logbook.warning(e.getMessage() + " in line " + lineNo + ", ignored");
                        }
                        if (id == null) {
                            logbook.warning("unknown parameter " + tLine + " in line " + lineNo);
                        } else if (param != null) {
                            switch (id) {
                                case RCC_NAME: {
                                    name = uParam;
                                    break;
                                }
                                case RC_VALUE: {
                                    if (name == null) {
                                        logbook.error("no rcc_name defined, line " + lineNo);
                                        break;
                                    }
                                    try {
                                        this.newEntry(name, new CfgRcEntry(name, param));
                                        ++count;
                                    }
                                    catch (ParameterException e) {
                                        logbook.error(e.getMessage() + ", ignored, line " + lineNo);
                                    }
                                    name = null;
                                    break;
                                }
                                default: {
                                    logbook.warning("parameter " + tLine + " in line " + lineNo + " not implemented");
                                }
                            }
                        }
                    }
                }
                line = br.readLine();
            }
        }
        if (rcLock.exists()) {
            rcLock.delete();
        }
        logbook.info(this.file.getName() + ": " + count + " entries");
    }

    static {
        identifier.put("RCC_NAME", Ident.RCC_NAME);
        identifier.put("RC_VALUE", Ident.RC_VALUE);
    }

    private static enum Ident {
        RCC_NAME,
        RC_VALUE;

    }
}

